/* # site_url: https://kumabenkyou.com */;
/* # home_url: https://kumabenkyou.com */;
/* # content_url: https://kumabenkyou.com/wp-content */;
/* # upload_url: https://kumabenkyou.com/wp-content/uploads */;
/* # table_prefix: wpbl_ */;


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `wpbl_mlw_quiz_output_templates`
--

DROP TABLE IF EXISTS `wpbl_mlw_quiz_output_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_mlw_quiz_output_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `template_name` varchar(255) DEFAULT NULL,
  `template_type` varchar(50) DEFAULT 'result',
  `template_content` longtext DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_mlw_quiz_output_templates`
--

LOCK TABLES `wpbl_mlw_quiz_output_templates` WRITE;
/*!40000 ALTER TABLE `wpbl_mlw_quiz_output_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_mlw_quiz_output_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_lifterlms_events_open_sessions`
--

DROP TABLE IF EXISTS `wpbl_lifterlms_events_open_sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_lifterlms_events_open_sessions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_lifterlms_events_open_sessions`
--

LOCK TABLES `wpbl_lifterlms_events_open_sessions` WRITE;
/*!40000 ALTER TABLE `wpbl_lifterlms_events_open_sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_lifterlms_events_open_sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_stm_lms_user_answers`
--

DROP TABLE IF EXISTS `wpbl_stm_lms_user_answers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_stm_lms_user_answers` (
  `user_answer_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `course_id` int(11) NOT NULL,
  `quiz_id` int(11) NOT NULL,
  `question_id` int(11) NOT NULL,
  `user_answer` text NOT NULL DEFAULT '',
  `correct_answer` tinyint(1) NOT NULL,
  `attempt_number` mediumint(9) NOT NULL,
  PRIMARY KEY (`user_answer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_stm_lms_user_answers`
--

LOCK TABLES `wpbl_stm_lms_user_answers` WRITE;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_answers` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_answers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_stm_lms_user_cart`
--

DROP TABLE IF EXISTS `wpbl_stm_lms_user_cart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_stm_lms_user_cart` (
  `user_cart_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `item_id` int(11) NOT NULL,
  `quantity` mediumint(9) NOT NULL,
  `price` float NOT NULL,
  `enterprise` float DEFAULT 0,
  `bundle` float DEFAULT 0,
  PRIMARY KEY (`user_cart_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_stm_lms_user_cart`
--

LOCK TABLES `wpbl_stm_lms_user_cart` WRITE;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_cart` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_cart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_stm_lms_user_chat`
--

DROP TABLE IF EXISTS `wpbl_stm_lms_user_chat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_stm_lms_user_chat` (
  `message_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_to` bigint(20) NOT NULL,
  `user_from` bigint(20) NOT NULL,
  `timestamp` int(11) NOT NULL,
  `message` text NOT NULL,
  `status` tinytext NOT NULL,
  `conversation_id` int(11) NOT NULL,
  PRIMARY KEY (`message_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_stm_lms_user_chat`
--

LOCK TABLES `wpbl_stm_lms_user_chat` WRITE;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_chat` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_chat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_mlw_themes`
--

DROP TABLE IF EXISTS `wpbl_mlw_themes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_mlw_themes` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `theme` text NOT NULL,
  `theme_name` text NOT NULL,
  `default_settings` text NOT NULL,
  `theme_active` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_mlw_themes`
--

LOCK TABLES `wpbl_mlw_themes` WRITE;
/*!40000 ALTER TABLE `wpbl_mlw_themes` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_mlw_themes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_stm_lms_user_conversation`
--

DROP TABLE IF EXISTS `wpbl_stm_lms_user_conversation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_stm_lms_user_conversation` (
  `conversation_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_to` int(11) NOT NULL,
  `user_from` int(11) NOT NULL,
  `timestamp` int(11) NOT NULL,
  `messages_number` int(11) NOT NULL,
  `ut_new_messages` int(11) NOT NULL,
  `uf_new_messages` int(11) NOT NULL,
  PRIMARY KEY (`conversation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_stm_lms_user_conversation`
--

LOCK TABLES `wpbl_stm_lms_user_conversation` WRITE;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_conversation` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_conversation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_mlw_quiz_theme_settings`
--

DROP TABLE IF EXISTS `wpbl_mlw_quiz_theme_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_mlw_quiz_theme_settings` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `theme_id` mediumint(9) NOT NULL,
  `quiz_id` mediumint(9) NOT NULL,
  `quiz_theme_settings` text NOT NULL,
  `active_theme` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_mlw_quiz_theme_settings`
--

LOCK TABLES `wpbl_mlw_quiz_theme_settings` WRITE;
/*!40000 ALTER TABLE `wpbl_mlw_quiz_theme_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_mlw_quiz_theme_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_stm_lms_user_quizzes`
--

DROP TABLE IF EXISTS `wpbl_stm_lms_user_quizzes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_stm_lms_user_quizzes` (
  `user_quiz_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `course_id` int(11) NOT NULL,
  `quiz_id` int(11) NOT NULL,
  `progress` mediumint(9) NOT NULL,
  `status` varchar(45) NOT NULL DEFAULT '',
  `sequency` text NOT NULL DEFAULT '',
  PRIMARY KEY (`user_quiz_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_stm_lms_user_quizzes`
--

LOCK TABLES `wpbl_stm_lms_user_quizzes` WRITE;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_quizzes` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_quizzes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_stm_lms_user_quizzes_times`
--

DROP TABLE IF EXISTS `wpbl_stm_lms_user_quizzes_times`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_stm_lms_user_quizzes_times` (
  `user_quiz_time_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `quiz_id` int(11) NOT NULL,
  `start_time` int(11) NOT NULL,
  `end_time` int(11) NOT NULL,
  PRIMARY KEY (`user_quiz_time_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_stm_lms_user_quizzes_times`
--

LOCK TABLES `wpbl_stm_lms_user_quizzes_times` WRITE;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_quizzes_times` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_quizzes_times` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_stm_lms_user_searches`
--

DROP TABLE IF EXISTS `wpbl_stm_lms_user_searches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_stm_lms_user_searches` (
  `user_search_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `search` text NOT NULL,
  PRIMARY KEY (`user_search_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_stm_lms_user_searches`
--

LOCK TABLES `wpbl_stm_lms_user_searches` WRITE;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_searches` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_searches` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_stm_lms_curriculum_sections`
--

DROP TABLE IF EXISTS `wpbl_stm_lms_curriculum_sections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_stm_lms_curriculum_sections` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `course_id` bigint(20) NOT NULL,
  `order` smallint(6) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_stm_lms_curriculum_sections`
--

LOCK TABLES `wpbl_stm_lms_curriculum_sections` WRITE;
/*!40000 ALTER TABLE `wpbl_stm_lms_curriculum_sections` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_stm_lms_curriculum_sections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_stm_lms_user_searches_stats`
--

DROP TABLE IF EXISTS `wpbl_stm_lms_user_searches_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_stm_lms_user_searches_stats` (
  `user_search_stat_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `search` text NOT NULL,
  `stat` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`user_search_stat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_stm_lms_user_searches_stats`
--

LOCK TABLES `wpbl_stm_lms_user_searches_stats` WRITE;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_searches_stats` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_searches_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_stm_lms_curriculum_materials`
--

DROP TABLE IF EXISTS `wpbl_stm_lms_curriculum_materials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_stm_lms_curriculum_materials` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) NOT NULL,
  `post_type` varchar(50) NOT NULL DEFAULT '',
  `section_id` mediumint(9) NOT NULL DEFAULT 0,
  `order` smallint(6) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_stm_lms_curriculum_materials`
--

LOCK TABLES `wpbl_stm_lms_curriculum_materials` WRITE;
/*!40000 ALTER TABLE `wpbl_stm_lms_curriculum_materials` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_stm_lms_curriculum_materials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_lifterlms_sessions`
--

DROP TABLE IF EXISTS `wpbl_lifterlms_sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_lifterlms_sessions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `data` longtext NOT NULL,
  `expires` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_lifterlms_sessions`
--

LOCK TABLES `wpbl_lifterlms_sessions` WRITE;
/*!40000 ALTER TABLE `wpbl_lifterlms_sessions` DISABLE KEYS */;
INSERT INTO `wpbl_lifterlms_sessions` VALUES (1,'1','a:0:{}',1732159474);
/*!40000 ALTER TABLE `wpbl_lifterlms_sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_actionscheduler_claims`
--

DROP TABLE IF EXISTS `wpbl_actionscheduler_claims`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_actionscheduler_claims`
--

LOCK TABLES `wpbl_actionscheduler_claims` WRITE;
/*!40000 ALTER TABLE `wpbl_actionscheduler_claims` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_actionscheduler_claims` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_actionscheduler_groups`
--

DROP TABLE IF EXISTS `wpbl_actionscheduler_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_actionscheduler_groups`
--

LOCK TABLES `wpbl_actionscheduler_groups` WRITE;
/*!40000 ALTER TABLE `wpbl_actionscheduler_groups` DISABLE KEYS */;
INSERT INTO `wpbl_actionscheduler_groups` VALUES (1,'action-scheduler-migration');
/*!40000 ALTER TABLE `wpbl_actionscheduler_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_e_events`
--

DROP TABLE IF EXISTS `wpbl_e_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_e_events`
--

LOCK TABLES `wpbl_e_events` WRITE;
/*!40000 ALTER TABLE `wpbl_e_events` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_e_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_stm_lms_user_lessons`
--

DROP TABLE IF EXISTS `wpbl_stm_lms_user_lessons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_stm_lms_user_lessons` (
  `user_lesson_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `course_id` int(11) NOT NULL,
  `lesson_id` int(11) NOT NULL,
  `start_time` int(11) DEFAULT NULL,
  `end_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`user_lesson_id`),
  KEY `ix_user_course_lesson` (`user_id`,`course_id`,`lesson_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_stm_lms_user_lessons`
--

LOCK TABLES `wpbl_stm_lms_user_lessons` WRITE;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_lessons` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_lessons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_lifterlms_webhooks`
--

DROP TABLE IF EXISTS `wpbl_lifterlms_webhooks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_lifterlms_webhooks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(20) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(255) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `failure_count` smallint(3) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_lifterlms_webhooks`
--

LOCK TABLES `wpbl_lifterlms_webhooks` WRITE;
/*!40000 ALTER TABLE `wpbl_lifterlms_webhooks` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_lifterlms_webhooks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_links`
--

DROP TABLE IF EXISTS `wpbl_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_links`
--

LOCK TABLES `wpbl_links` WRITE;
/*!40000 ALTER TABLE `wpbl_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_term_relationships`
--

DROP TABLE IF EXISTS `wpbl_term_relationships`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_term_relationships`
--

LOCK TABLES `wpbl_term_relationships` WRITE;
/*!40000 ALTER TABLE `wpbl_term_relationships` DISABLE KEYS */;
INSERT INTO `wpbl_term_relationships` VALUES (1,1,0);
INSERT INTO `wpbl_term_relationships` VALUES (9,2,0);
INSERT INTO `wpbl_term_relationships` VALUES (13,3,0);
INSERT INTO `wpbl_term_relationships` VALUES (19,4,0);
INSERT INTO `wpbl_term_relationships` VALUES (25,5,0);
INSERT INTO `wpbl_term_relationships` VALUES (143,8,0);
INSERT INTO `wpbl_term_relationships` VALUES (218,1,0);
INSERT INTO `wpbl_term_relationships` VALUES (242,1,0);
INSERT INTO `wpbl_term_relationships` VALUES (298,21,0);
INSERT INTO `wpbl_term_relationships` VALUES (299,21,0);
INSERT INTO `wpbl_term_relationships` VALUES (300,21,0);
/*!40000 ALTER TABLE `wpbl_term_relationships` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_actionscheduler_logs`
--

DROP TABLE IF EXISTS `wpbl_actionscheduler_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_actionscheduler_logs`
--

LOCK TABLES `wpbl_actionscheduler_logs` WRITE;
/*!40000 ALTER TABLE `wpbl_actionscheduler_logs` DISABLE KEYS */;
INSERT INTO `wpbl_actionscheduler_logs` VALUES (1,193,'action created','2024-11-20 21:24:31','2024-11-20 21:24:31');
INSERT INTO `wpbl_actionscheduler_logs` VALUES (2,193,'action started via Async Request','2024-11-20 21:25:31','2024-11-20 21:25:31');
INSERT INTO `wpbl_actionscheduler_logs` VALUES (3,193,'action complete via Async Request','2024-11-20 21:25:31','2024-11-20 21:25:31');
/*!40000 ALTER TABLE `wpbl_actionscheduler_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_commentmeta`
--

DROP TABLE IF EXISTS `wpbl_commentmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_commentmeta`
--

LOCK TABLES `wpbl_commentmeta` WRITE;
/*!40000 ALTER TABLE `wpbl_commentmeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_commentmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_usermeta`
--

DROP TABLE IF EXISTS `wpbl_usermeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_usermeta`
--

LOCK TABLES `wpbl_usermeta` WRITE;
/*!40000 ALTER TABLE `wpbl_usermeta` DISABLE KEYS */;
INSERT INTO `wpbl_usermeta` VALUES (1,1,'nickname','arfi');
INSERT INTO `wpbl_usermeta` VALUES (2,1,'first_name','');
INSERT INTO `wpbl_usermeta` VALUES (3,1,'last_name','');
INSERT INTO `wpbl_usermeta` VALUES (4,1,'description','');
INSERT INTO `wpbl_usermeta` VALUES (5,1,'rich_editing','true');
INSERT INTO `wpbl_usermeta` VALUES (6,1,'syntax_highlighting','true');
INSERT INTO `wpbl_usermeta` VALUES (7,1,'comment_shortcuts','false');
INSERT INTO `wpbl_usermeta` VALUES (8,1,'admin_color','fresh');
INSERT INTO `wpbl_usermeta` VALUES (9,1,'use_ssl','0');
INSERT INTO `wpbl_usermeta` VALUES (10,1,'show_admin_bar_front','true');
INSERT INTO `wpbl_usermeta` VALUES (11,1,'locale','');
INSERT INTO `wpbl_usermeta` VALUES (12,1,'wpbl_capabilities','a:1:{s:13:"administrator";b:1;}');
INSERT INTO `wpbl_usermeta` VALUES (13,1,'wpbl_user_level','10');
INSERT INTO `wpbl_usermeta` VALUES (14,1,'dismissed_wp_pointers','theme_editor_notice');
INSERT INTO `wpbl_usermeta` VALUES (15,1,'show_welcome_panel','1');
INSERT INTO `wpbl_usermeta` VALUES (16,1,'session_tokens','a:3:{s:64:"1a013a08e0e9837569864a36e5887d3a0472ef9bd3de5287dd919298366c2b57";a:4:{s:10:"expiration";i:1742905406;s:2:"ip";s:14:"130.62.216.110";s:2:"ua";s:125:"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0";s:5:"login";i:1742732606;}s:64:"fd2c4bd8e0f10690dc9777024c8b007b54923e2253957123a90d8dda0232cff6";a:4:{s:10:"expiration";i:1742909619;s:2:"ip";s:14:"130.62.216.110";s:2:"ua";s:125:"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0";s:5:"login";i:1742736819;}s:64:"95a9b19cc352569e4d772de0ab48cd23dc6c7692d344de7c6a10e2fd699f8fec";a:4:{s:10:"expiration";i:1742938797;s:2:"ip";s:14:"130.62.216.110";s:2:"ua";s:125:"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0";s:5:"login";i:1742765997;}}');
INSERT INTO `wpbl_usermeta` VALUES (17,1,'wpbl_user-settings','editor=tinymce&libraryContent=browse');
INSERT INTO `wpbl_usermeta` VALUES (18,1,'wpbl_user-settings-time','1735213443');
INSERT INTO `wpbl_usermeta` VALUES (19,1,'wpbl_dashboard_quick_press_last_post_id','1038');
INSERT INTO `wpbl_usermeta` VALUES (20,1,'community-events-location','a:1:{s:2:"ip";s:12:"130.62.216.0";}');
INSERT INTO `wpbl_usermeta` VALUES (21,1,'elementor_admin_notices','a:1:{s:20:"design_not_appearing";a:2:{s:9:"is_viewed";b:0;s:4:"meta";a:1:{s:7:"version";s:6:"3.25.9";}}}');
INSERT INTO `wpbl_usermeta` VALUES (22,1,'elementor_introduction','a:2:{s:27:"ai-get-started-announcement";b:1;s:20:"globals_introduction";b:1;}');
INSERT INTO `wpbl_usermeta` VALUES (23,1,'wpbl_elementor_connect_common_data','a:7:{s:9:"client_id";s:32:"wUFzLLbuXAuNu6JzdGmJ8izJ5sRxfnaK";s:11:"auth_secret";s:32:"GJkASn27LBdHNrZuBoBLmfbVTnG1BfqO";s:12:"access_token";s:292:"eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxNTUxMTQiLCJhdWQiOiJodHRwczovL2t1bWFiZW5reW91LmNvbS8iLCJjbGllbnRfaWQiOiJ3VUZ6TExidVhBdU51Nkp6ZEdtSjhpeko1c1J4Zm5hSyIsImNvbm5lY3RfdHlwZSI6ImFjdGl2YXRlIiwiaWF0IjoxNzMyMTI5NDE1LCJleHAiOjMxNzI3NjU3MTgxNX0.VyFMsATsB4nxbPFyVgnyZM7KlMpY4L0Y8CeIwggVGc4";s:19:"access_token_secret";s:32:"AHD8SNZfGUffGe7JFB3vn0yGeKq0kQwf";s:10:"token_type";s:6:"bearer";s:4:"user";O:8:"stdClass":1:{s:5:"email";s:22:"abdulqarriem@gmail.com";}s:19:"data_share_opted_in";b:1;}');
INSERT INTO `wpbl_usermeta` VALUES (24,1,'nav_menu_recently_edited','21');
INSERT INTO `wpbl_usermeta` VALUES (25,1,'managenav-menuscolumnshidden','a:5:{i:0;s:11:"link-target";i:1;s:11:"css-classes";i:2;s:3:"xfn";i:3;s:11:"description";i:4;s:15:"title-attribute";}');
INSERT INTO `wpbl_usermeta` VALUES (26,1,'metaboxhidden_nav-menus','a:3:{i:0;s:22:"add-post-type-qsm_quiz";i:1;s:12:"add-post_tag";i:2;s:16:"add-qsm_category";}');
INSERT INTO `wpbl_usermeta` VALUES (27,1,'qsm_show_disabled_contact_fields','true');
INSERT INTO `wpbl_usermeta` VALUES (28,1,'wpbl_persisted_preferences','a:3:{s:4:"core";a:1:{s:26:"isComplementaryAreaVisible";b:1;}s:14:"core/edit-post";a:1:{s:12:"welcomeGuide";b:0;}s:9:"_modified";s:24:"2024-11-23T09:07:55.998Z";}');
INSERT INTO `wpbl_usermeta` VALUES (29,1,'elementor_dismissed_editor_notices','a:1:{i:0;s:20:"image_optimizer_hint";}');
INSERT INTO `wpbl_usermeta` VALUES (30,1,'wpbl_elementor_enable_ai','1');
INSERT INTO `wpbl_usermeta` VALUES (31,1,'wpbl_elementor_pro_enable_notes_notifications','1');
INSERT INTO `wpbl_usermeta` VALUES (32,1,'closedpostboxes_toplevel_page_qsm_dashboard','a:1:{i:0;s:18:"dashboard_chagelog";}');
INSERT INTO `wpbl_usermeta` VALUES (33,1,'metaboxhidden_toplevel_page_qsm_dashboard','a:0:{}');
/*!40000 ALTER TABLE `wpbl_usermeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_terms`
--

DROP TABLE IF EXISTS `wpbl_terms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_terms`
--

LOCK TABLES `wpbl_terms` WRITE;
/*!40000 ALTER TABLE `wpbl_terms` DISABLE KEYS */;
INSERT INTO `wpbl_terms` VALUES (1,'Uncategorized','uncategorized',0);
INSERT INTO `wpbl_terms` VALUES (2,'page','page',0);
INSERT INTO `wpbl_terms` VALUES (3,'error-404','error-404',0);
INSERT INTO `wpbl_terms` VALUES (4,'footer','footer',0);
INSERT INTO `wpbl_terms` VALUES (5,'header','header',0);
INSERT INTO `wpbl_terms` VALUES (8,'loop-item','loop-item',0);
INSERT INTO `wpbl_terms` VALUES (9,'error','error',0);
INSERT INTO `wpbl_terms` VALUES (10,'event','event',0);
INSERT INTO `wpbl_terms` VALUES (11,'Beginner','beginner',0);
INSERT INTO `wpbl_terms` VALUES (12,'Intermediate','intermediate',0);
INSERT INTO `wpbl_terms` VALUES (13,'Advanced','advanced',0);
INSERT INTO `wpbl_terms` VALUES (14,'visible','visible',0);
INSERT INTO `wpbl_terms` VALUES (15,'hidden','hidden',0);
INSERT INTO `wpbl_terms` VALUES (16,'featured','featured',0);
INSERT INTO `wpbl_terms` VALUES (17,'catalog_search','catalog_search',0);
INSERT INTO `wpbl_terms` VALUES (18,'catalog','catalog',0);
INSERT INTO `wpbl_terms` VALUES (19,'search','search',0);
INSERT INTO `wpbl_terms` VALUES (20,'hidden','hidden',0);
INSERT INTO `wpbl_terms` VALUES (21,'menu','menu',0);
/*!40000 ALTER TABLE `wpbl_terms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_lifterlms_events`
--

DROP TABLE IF EXISTS `wpbl_lifterlms_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_lifterlms_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date` datetime DEFAULT NULL,
  `actor_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(55) DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `event_type` varchar(55) DEFAULT NULL,
  `event_action` varchar(55) DEFAULT NULL,
  `meta` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `actor_id` (`actor_id`),
  KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_lifterlms_events`
--

LOCK TABLES `wpbl_lifterlms_events` WRITE;
/*!40000 ALTER TABLE `wpbl_lifterlms_events` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_lifterlms_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_termmeta`
--

DROP TABLE IF EXISTS `wpbl_termmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_termmeta`
--

LOCK TABLES `wpbl_termmeta` WRITE;
/*!40000 ALTER TABLE `wpbl_termmeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_termmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_lifterlms_api_keys`
--

DROP TABLE IF EXISTS `wpbl_lifterlms_api_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_lifterlms_api_keys` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_lifterlms_api_keys`
--

LOCK TABLES `wpbl_lifterlms_api_keys` WRITE;
/*!40000 ALTER TABLE `wpbl_lifterlms_api_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_lifterlms_api_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_lifterlms_vouchers_codes`
--

DROP TABLE IF EXISTS `wpbl_lifterlms_vouchers_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_lifterlms_vouchers_codes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `voucher_id` bigint(20) NOT NULL,
  `code` varchar(20) NOT NULL DEFAULT '',
  `redemption_count` bigint(20) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `code` (`code`),
  KEY `voucher_id` (`voucher_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_lifterlms_vouchers_codes`
--

LOCK TABLES `wpbl_lifterlms_vouchers_codes` WRITE;
/*!40000 ALTER TABLE `wpbl_lifterlms_vouchers_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_lifterlms_vouchers_codes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_lifterlms_voucher_code_redemptions`
--

DROP TABLE IF EXISTS `wpbl_lifterlms_voucher_code_redemptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_lifterlms_voucher_code_redemptions` (
  `id` int(20) unsigned NOT NULL AUTO_INCREMENT,
  `code_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `redemption_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `code_id` (`code_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_lifterlms_voucher_code_redemptions`
--

LOCK TABLES `wpbl_lifterlms_voucher_code_redemptions` WRITE;
/*!40000 ALTER TABLE `wpbl_lifterlms_voucher_code_redemptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_lifterlms_voucher_code_redemptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_lifterlms_user_postmeta`
--

DROP TABLE IF EXISTS `wpbl_lifterlms_user_postmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_lifterlms_user_postmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `post_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  `updated_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`meta_id`),
  KEY `user_id` (`user_id`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_lifterlms_user_postmeta`
--

LOCK TABLES `wpbl_lifterlms_user_postmeta` WRITE;
/*!40000 ALTER TABLE `wpbl_lifterlms_user_postmeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_lifterlms_user_postmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_e_submissions_values`
--

DROP TABLE IF EXISTS `wpbl_e_submissions_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_e_submissions_values`
--

LOCK TABLES `wpbl_e_submissions_values` WRITE;
/*!40000 ALTER TABLE `wpbl_e_submissions_values` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_e_submissions_values` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_lifterlms_quiz_attempts`
--

DROP TABLE IF EXISTS `wpbl_lifterlms_quiz_attempts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_lifterlms_quiz_attempts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `student_id` bigint(20) DEFAULT NULL,
  `quiz_id` bigint(20) DEFAULT NULL,
  `lesson_id` bigint(20) DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `status` varchar(15) DEFAULT '',
  `attempt` bigint(20) DEFAULT NULL,
  `grade` float DEFAULT NULL,
  `can_be_resumed` tinyint(1) DEFAULT 0,
  `current_question_id` bigint(20) DEFAULT NULL,
  `questions` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `student_id` (`student_id`),
  KEY `quiz_id` (`quiz_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_lifterlms_quiz_attempts`
--

LOCK TABLES `wpbl_lifterlms_quiz_attempts` WRITE;
/*!40000 ALTER TABLE `wpbl_lifterlms_quiz_attempts` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_lifterlms_quiz_attempts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_lifterlms_product_to_voucher`
--

DROP TABLE IF EXISTS `wpbl_lifterlms_product_to_voucher`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_lifterlms_product_to_voucher` (
  `product_id` bigint(20) NOT NULL,
  `voucher_id` bigint(20) NOT NULL,
  KEY `product_id` (`product_id`),
  KEY `voucher_id` (`voucher_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_lifterlms_product_to_voucher`
--

LOCK TABLES `wpbl_lifterlms_product_to_voucher` WRITE;
/*!40000 ALTER TABLE `wpbl_lifterlms_product_to_voucher` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_lifterlms_product_to_voucher` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_term_taxonomy`
--

DROP TABLE IF EXISTS `wpbl_term_taxonomy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_term_taxonomy`
--

LOCK TABLES `wpbl_term_taxonomy` WRITE;
/*!40000 ALTER TABLE `wpbl_term_taxonomy` DISABLE KEYS */;
INSERT INTO `wpbl_term_taxonomy` VALUES (1,1,'category','',0,3);
INSERT INTO `wpbl_term_taxonomy` VALUES (2,2,'elementor_library_type','',0,1);
INSERT INTO `wpbl_term_taxonomy` VALUES (3,3,'elementor_library_type','',0,1);
INSERT INTO `wpbl_term_taxonomy` VALUES (4,4,'elementor_library_type','',0,1);
INSERT INTO `wpbl_term_taxonomy` VALUES (5,5,'elementor_library_type','',0,1);
INSERT INTO `wpbl_term_taxonomy` VALUES (8,8,'elementor_library_type','',0,1);
INSERT INTO `wpbl_term_taxonomy` VALUES (9,9,'qmn_log_type','',0,0);
INSERT INTO `wpbl_term_taxonomy` VALUES (10,10,'qmn_log_type','',0,0);
INSERT INTO `wpbl_term_taxonomy` VALUES (11,11,'course_difficulty','',0,0);
INSERT INTO `wpbl_term_taxonomy` VALUES (12,12,'course_difficulty','',0,0);
INSERT INTO `wpbl_term_taxonomy` VALUES (13,13,'course_difficulty','',0,0);
INSERT INTO `wpbl_term_taxonomy` VALUES (14,14,'llms_access_plan_visibility','',0,0);
INSERT INTO `wpbl_term_taxonomy` VALUES (15,15,'llms_access_plan_visibility','',0,0);
INSERT INTO `wpbl_term_taxonomy` VALUES (16,16,'llms_access_plan_visibility','',0,0);
INSERT INTO `wpbl_term_taxonomy` VALUES (17,17,'llms_product_visibility','',0,0);
INSERT INTO `wpbl_term_taxonomy` VALUES (18,18,'llms_product_visibility','',0,0);
INSERT INTO `wpbl_term_taxonomy` VALUES (19,19,'llms_product_visibility','',0,0);
INSERT INTO `wpbl_term_taxonomy` VALUES (20,20,'llms_product_visibility','',0,0);
INSERT INTO `wpbl_term_taxonomy` VALUES (21,21,'nav_menu','',0,3);
/*!40000 ALTER TABLE `wpbl_term_taxonomy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_users`
--

DROP TABLE IF EXISTS `wpbl_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_users`
--

LOCK TABLES `wpbl_users` WRITE;
/*!40000 ALTER TABLE `wpbl_users` DISABLE KEYS */;
INSERT INTO `wpbl_users` VALUES (1,'arfi','$P$BZ7jd7YOCn0pBdNFgMed4GcPhYCiC/0','arfi','admin@kumabenkyou.com','https://kumabenkyou.com','2024-11-20 14:10:52','',0,'arfi');
/*!40000 ALTER TABLE `wpbl_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_stm_lms_order_items`
--

DROP TABLE IF EXISTS `wpbl_stm_lms_order_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_stm_lms_order_items` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL,
  `payout_id` bigint(20) unsigned DEFAULT NULL,
  `quantity` int(11) NOT NULL,
  `price` float(24,2) DEFAULT NULL,
  `transaction` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wpbl_stm_lms_order_items_order_id_index` (`order_id`),
  KEY `wpbl_stm_lms_order_items_object_id_index` (`object_id`),
  KEY `wpbl_stm_lms_order_items_payout_id_index` (`payout_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_stm_lms_order_items`
--

LOCK TABLES `wpbl_stm_lms_order_items` WRITE;
/*!40000 ALTER TABLE `wpbl_stm_lms_order_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_stm_lms_order_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_e_notes_users_relations`
--

DROP TABLE IF EXISTS `wpbl_e_notes_users_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_e_notes_users_relations`
--

LOCK TABLES `wpbl_e_notes_users_relations` WRITE;
/*!40000 ALTER TABLE `wpbl_e_notes_users_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_e_notes_users_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_lifterlms_notifications`
--

DROP TABLE IF EXISTS `wpbl_lifterlms_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_lifterlms_notifications` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `status` varchar(11) DEFAULT '0',
  `type` varchar(75) DEFAULT NULL,
  `subscriber` varchar(255) DEFAULT NULL,
  `trigger_id` varchar(75) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `post_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `type` (`type`),
  KEY `subscriber` (`subscriber`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_lifterlms_notifications`
--

LOCK TABLES `wpbl_lifterlms_notifications` WRITE;
/*!40000 ALTER TABLE `wpbl_lifterlms_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_lifterlms_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_stm_lms_user_courses`
--

DROP TABLE IF EXISTS `wpbl_stm_lms_user_courses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_stm_lms_user_courses` (
  `user_course_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `course_id` int(11) NOT NULL,
  `current_lesson_id` int(11) DEFAULT NULL,
  `progress_percent` mediumint(9) NOT NULL,
  `status` varchar(45) NOT NULL DEFAULT '',
  `lng_code` varchar(45) NOT NULL DEFAULT 'en_US',
  `subscription_id` int(11) DEFAULT NULL,
  `enterprise_id` int(11) DEFAULT 0,
  `bundle_id` int(11) DEFAULT 0,
  `start_time` int(11) NOT NULL,
  `end_time` int(11) DEFAULT 0,
  `for_points` varchar(255) DEFAULT '',
  PRIMARY KEY (`user_course_id`),
  KEY `ix_user_course_current` (`user_id`,`course_id`,`current_lesson_id`),
  KEY `ix_user_course_enterprice` (`user_id`,`course_id`,`enterprise_id`),
  KEY `ix_user_course_bundle` (`user_id`,`course_id`,`bundle_id`),
  KEY `ix_user_course_start_time` (`user_id`,`course_id`,`start_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_stm_lms_user_courses`
--

LOCK TABLES `wpbl_stm_lms_user_courses` WRITE;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_courses` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_stm_lms_user_courses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_mlw_question_terms`
--

DROP TABLE IF EXISTS `wpbl_mlw_question_terms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_mlw_question_terms` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `question_id` int(11) DEFAULT 0,
  `quiz_id` int(11) DEFAULT 0,
  `term_id` int(11) DEFAULT 0,
  `taxonomy` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `question_id` (`question_id`),
  KEY `quiz_id` (`quiz_id`),
  KEY `term_id` (`term_id`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_mlw_question_terms`
--

LOCK TABLES `wpbl_mlw_question_terms` WRITE;
/*!40000 ALTER TABLE `wpbl_mlw_question_terms` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_mlw_question_terms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_comments`
--

DROP TABLE IF EXISTS `wpbl_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_comments`
--

LOCK TABLES `wpbl_comments` WRITE;
/*!40000 ALTER TABLE `wpbl_comments` DISABLE KEYS */;
INSERT INTO `wpbl_comments` VALUES (1,1,'A WordPress Commenter','wapuu@wordpress.example','https://wordpress.org/','','2024-11-20 14:10:52','2024-11-20 14:10:52','Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href="https://gravatar.com/">Gravatar</a>.',0,'1','','comment',0,0);
INSERT INTO `wpbl_comments` VALUES (2,1,'More Information','revawarner@yahoo.com.br','https://main.d1prexrmateizr.amplifyapp.com/rising-concerns-over-calls-from-03453002752-is-it-lloyds-bank-or-a-scam/','156.228.96.45','2025-02-27 02:48:19','2025-02-27 02:48:19','Hello to every one, the contents existing at this web page are in fact remarkable for people knowledge, well, keep up the nice work fellows.',0,'0','Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:114.0) Gecko/20100101 Firefox/114.0','comment',0,0);
/*!40000 ALTER TABLE `wpbl_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_e_submissions_actions_log`
--

DROP TABLE IF EXISTS `wpbl_e_submissions_actions_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_e_submissions_actions_log`
--

LOCK TABLES `wpbl_e_submissions_actions_log` WRITE;
/*!40000 ALTER TABLE `wpbl_e_submissions_actions_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_e_submissions_actions_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_mlw_qm_audit_trail`
--

DROP TABLE IF EXISTS `wpbl_mlw_qm_audit_trail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_mlw_qm_audit_trail` (
  `trail_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `action_user` longtext NOT NULL,
  `action` longtext NOT NULL,
  `quiz_id` longtext NOT NULL,
  `quiz_name` longtext NOT NULL,
  `form_data` longtext NOT NULL,
  `time` longtext NOT NULL,
  PRIMARY KEY (`trail_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1251 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_mlw_qm_audit_trail`
--

LOCK TABLES `wpbl_mlw_qm_audit_trail` WRITE;
/*!40000 ALTER TABLE `wpbl_mlw_qm_audit_trail` DISABLE KEYS */;
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1,'arfi','New Quiz/Survey Has Been Created','1','jlpt n5 coba','','08:52:31 PM 11/20/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (2,'arfi','Quiz/Survey Status Has Been Updated','1','jlpt n5 coba','','09:08:17 PM 11/20/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (3,'arfi','New Quiz/Survey Has Been Created','2','jlpt n5 coba','','04:42:18 AM 11/21/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (4,'arfi','New Quiz/Survey Has Been Created','3','jlpt n5 coba','','05:49:51 AM 11/21/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (5,'arfi','New Quiz/Survey Has Been Created','4','kanji n5 1','','01:45:28 PM 11/21/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (6,'arfi','New Quiz/Survey Has Been Created','5','kanji n5 1','','06:08:24 AM 11/23/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (7,'arfi','Quiz/Survey Status Has Been Updated','5','kanji n5 1','','07:24:07 AM 11/23/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (8,'arfi','Quiz/Survey Has Been Deleted: kanji n5 1','4','kanji n5 1','','08:22:50 AM 11/23/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (9,'arfi','Quiz/Survey Has Been Deleted: jlpt n5 coba','3','jlpt n5 coba','','08:22:57 AM 11/23/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (10,'arfi','Quiz/Survey Has Been Deleted: jlpt n5 coba','2','jlpt n5 coba','','08:23:04 AM 11/23/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (11,'arfi','Quiz/Survey Has Been Deleted: jlpt n5 coba','1','jlpt n5 coba','','08:23:10 AM 11/23/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (12,'arfi','Settings Have Been Edited','5','kanji n5 1','{"require_log_in":"","comment_section":"","select_category_question":"a:2:{s:19:\\"category_select_key\\";s:0:\\"\\";s:18:\\"question_limit_key\\";s:0:\\"\\";}"}','08:44:54 AM 11/23/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (13,'arfi','Settings Have Been Edited','5','kanji n5 1','{"user_name":"1"}','08:46:01 AM 11/23/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (14,'arfi','Settings Have Been Edited','5','kanji n5 1','{"user_name":"2"}','08:59:19 AM 11/23/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (15,'arfi','Settings Have Been Edited','5','kanji n5 1','[]','09:00:17 AM 11/23/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (16,'arfi','Settings Have Been Edited','5','kanji n5 1','{"user_name":"1"}','09:36:33 AM 11/23/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (17,'arfi','New Quiz/Survey Has Been Created','6','Kanji - JLPT N5 #2','','12:07:59 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (18,'arfi','New Quiz/Survey Has Been Created','7','a','','12:08:13 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (19,'arfi','New Quiz/Survey Has Been Created','8','Kanji- JLPT N5 #3','','12:42:38 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (20,'arfi','Quiz/Survey Status Has Been Updated','6','Kanji - JLPT N5 #2','','01:04:56 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (21,'arfi','New Quiz/Survey Has Been Created','9','Kanji - JLPT N5 #4','','01:06:38 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (22,'arfi','Quiz/Survey Status Has Been Updated','8','Kanji- JLPT N5 #3','','01:36:58 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (23,'arfi','Quiz/Survey Status Has Been Updated','9','Kanji - JLPT N5 #4','','01:38:09 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (24,'arfi','New Quiz/Survey Has Been Created','10','Kanji - JLPT N5 #6','','01:39:59 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (25,'arfi','New Quiz/Survey Has Been Created','11','Kanji - JLPT N5 #5','','01:40:52 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (26,'arfi','Quiz/Survey Status Has Been Updated','10','Kanji - JLPT N5 #6','','02:07:53 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (27,'arfi','New Quiz/Survey Has Been Created','12','Kanji - JLPT N5 #8','','02:09:28 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (28,'arfi','Quiz/Survey Status Has Been Updated','11','Kanji - JLPT N5 #5','','02:17:07 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (29,'arfi','New Quiz/Survey Has Been Created','13','Kanji - JLPT N5 #7','','02:19:58 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (30,'arfi','Quiz/Survey Status Has Been Updated','12','Kanji - JLPT N5 #8','','02:41:53 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (31,'arfi','New Quiz/Survey Has Been Created','14','Kanji - JLPT N5 #10','','02:45:38 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (32,'arfi','Quiz/Survey Status Has Been Updated','13','Kanji - JLPT N5 #7','','04:42:52 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (33,'arfi','New Quiz/Survey Has Been Created','15','Kanji - JLPT N5 #9','','04:44:07 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (34,'arfi','Quiz/Survey Status Has Been Updated','15','Kanji - JLPT N5 #9','','05:09:36 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (35,'arfi','Quiz/Survey Status Has Been Updated','14','Kanji - JLPT N5 #10','','05:09:40 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (36,'arfi','New Quiz/Survey Has Been Created','16','Kanji - JLPT N5 #11','','05:10:39 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (37,'arfi','Quiz/Survey Status Has Been Updated','16','Kanji - JLPT N5 #11','','06:31:42 PM 12/26/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (38,'arfi','New Quiz/Survey Has Been Created','17','Kanji - JLPT N5 #13','','04:53:24 AM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (39,'arfi','Quiz/Survey Status Has Been Updated','17','Kanji - JLPT N5 #13','','05:16:36 AM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (40,'arfi','New Quiz/Survey Has Been Created','18','Kanji - JLPT N5 #15','','05:18:34 AM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (41,'arfi','Quiz/Survey Status Has Been Updated','18','Kanji - JLPT N5 #15','','05:33:49 AM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (42,'arfi','New Quiz/Survey Has Been Created','19','Kanji - JLPT N5 #17','','05:34:32 AM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (43,'arfi','Quiz/Survey Status Has Been Updated','19','Kanji - JLPT N5 #17','','06:03:29 AM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (44,'arfi','New Quiz/Survey Has Been Created','20','Kanji - JLPT N5 #19','','06:04:02 AM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (45,'arfi','Quiz/Survey Status Has Been Updated','20','Kanji - JLPT N5 #19','','06:21:15 AM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (46,'arfi','New Quiz/Survey Has Been Created','21','Kanji - JLPT N5 #21','','06:22:07 AM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (47,'arfi','Quiz/Survey Status Has Been Updated','21','Kanji - JLPT N5 #21','','06:54:18 AM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (48,'arfi','New Quiz/Survey Has Been Created','22','Kanji - JLPT N5 #23','','06:54:56 AM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (49,'arfi','Quiz/Survey Status Has Been Updated','22','Kanji - JLPT N5 #23','','07:33:13 AM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (50,'arfi','New Quiz/Survey Has Been Created','23','Kanji - JLPT N4 #1','','12:35:17 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (51,'arfi','Quiz/Survey Status Has Been Updated','23','Kanji - JLPT N4 #1','','01:07:54 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (52,'arfi','New Quiz/Survey Has Been Created','24','Kanji - JLPT N4 #3','','01:09:06 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (53,'arfi','Quiz/Survey Status Has Been Updated','24','Kanji - JLPT N4 #3','','01:41:22 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (54,'arfi','New Quiz/Survey Has Been Created','25','Kanji - JLPT N4 #5','','01:45:22 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (55,'arfi','New Quiz/Survey Has Been Created','26','Kanji - JLPT N5 #12','','02:42:25 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (56,'arfi','Quiz/Survey Status Has Been Updated','25','Kanji - JLPT N4 #5','','03:15:40 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (57,'arfi','New Quiz/Survey Has Been Created','27','Kanji - JLPT N4 #7','','03:18:13 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (58,'arfi','Quiz/Survey Status Has Been Updated','27','Kanji - JLPT N4 #7','','03:57:34 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (59,'arfi','New Quiz/Survey Has Been Created','28','Kanji - JLPT N4 #9','','04:02:24 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (60,'arfi','Quiz/Survey Status Has Been Updated','28','Kanji - JLPT N4 #9','','04:47:03 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (61,'arfi','Quiz/Survey Status Has Been Updated','26','Kanji - JLPT N5 #12','','05:40:56 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (62,'arfi','New Quiz/Survey Has Been Created','29','Kanji - JLPT N5 #14','','05:43:12 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (63,'arfi','Quiz/Survey Status Has Been Updated','29','Kanji - JLPT N5 #14','','07:24:02 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (64,'arfi','New Quiz/Survey Has Been Created','30','Kanji - JLPT N5 #16','','07:26:00 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (65,'arfi','Quiz/Survey Status Has Been Updated','30','Kanji - JLPT N5 #16','','07:50:58 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (66,'arfi','New Quiz/Survey Has Been Created','31','Kanji - JLPT N5 #18','','07:52:20 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (67,'arfi','Quiz/Survey Status Has Been Updated','31','Kanji - JLPT N5 #18','','10:03:36 PM 12/27/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (68,'arfi','New Quiz/Survey Has Been Created','32','Kanji - JLPT N4 #11','','03:11:48 AM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (69,'arfi','Quiz/Survey Status Has Been Updated','32','Kanji - JLPT N4 #11','','03:38:09 AM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (70,'arfi','New Quiz/Survey Has Been Created','33','Kanji - JLPT N4 #13','','03:39:09 AM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (71,'arfi','Quiz/Survey Status Has Been Updated','33','Kanji - JLPT N4 #13','','04:40:38 AM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (72,'arfi','New Quiz/Survey Has Been Created','34','Kanji - JLPT N4 #15','','04:42:02 AM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (73,'arfi','Quiz/Survey Status Has Been Updated','34','Kanji - JLPT N4 #15','','05:15:46 AM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (74,'arfi','New Quiz/Survey Has Been Created','35','Kanji - JLPT N4 #17','','05:17:56 AM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (75,'arfi','Quiz/Survey Status Has Been Updated','35','Kanji - JLPT N4 #17','','06:52:05 AM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (76,'arfi','New Quiz/Survey Has Been Created','36','Kanji - JLPT N4 #19','','06:53:08 AM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (77,'arfi','Quiz/Survey Status Has Been Updated','36','Kanji - JLPT N4 #19','','07:21:27 AM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (78,'arfi','New Quiz/Survey Has Been Created','37','Kanji - JLPT N4 #21','','07:22:17 AM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (79,'arfi','Quiz/Survey Status Has Been Updated','37','Kanji - JLPT N4 #21','','07:44:12 AM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (80,'arfi','New Quiz/Survey Has Been Created','38','Kanji - JLPT N4 #23','','07:45:13 AM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (81,'arfi','Quiz/Survey Status Has Been Updated','38','Kanji - JLPT N4 #23','','10:14:16 AM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (82,'arfi','New Quiz/Survey Has Been Created','39','Kanji - JLPT N4 #25','','10:15:28 AM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (83,'arfi','Quiz/Survey Status Has Been Updated','39','Kanji - JLPT N4 #25','','11:33:36 AM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (84,'arfi','New Quiz/Survey Has Been Created','40','Kanji - JLPT N4 #27','','11:39:20 AM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (85,'arfi','Quiz/Survey Status Has Been Updated','40','Kanji - JLPT N4 #27','','12:56:39 PM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (86,'arfi','New Quiz/Survey Has Been Created','41','Kanji - JLPT N4 #29','','12:57:55 PM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (87,'arfi','Quiz/Survey Status Has Been Updated','41','Kanji - JLPT N4 #29','','01:36:19 PM 12/28/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (88,'arfi','New Quiz/Survey Has Been Created','42','Kanji - JLPT N3 #1','','05:06:18 AM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (89,'arfi','Quiz/Survey Status Has Been Updated','42','Kanji - JLPT N3 #1','','05:29:19 AM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (90,'arfi','New Quiz/Survey Has Been Created','43','Kanji - JLPT N3 #3','','05:30:10 AM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (91,'arfi','Quiz/Survey Status Has Been Updated','43','Kanji - JLPT N3 #3','','06:05:20 AM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (92,'arfi','New Quiz/Survey Has Been Created','44','Kanji - JLPT N3 #5','','06:06:03 AM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (93,'arfi','Quiz/Survey Status Has Been Updated','44','Kanji - JLPT N3 #5','','07:56:14 AM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (94,'arfi','New Quiz/Survey Has Been Created','45','Kanji - JLPT N3 #7','','07:57:48 AM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (95,'arfi','Quiz/Survey Status Has Been Updated','45','Kanji - JLPT N3 #7','','11:11:20 AM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (96,'arfi','New Quiz/Survey Has Been Created','46','Kanji - JLPT N3 #9','','11:12:07 AM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (97,'arfi','New Quiz/Survey Has Been Created','47','Kanji - JLPT N5 #20','','11:48:57 AM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (98,'arfi','Quiz/Survey Status Has Been Updated','46','Kanji - JLPT N3 #9','','12:10:54 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (99,'arfi','Quiz/Survey Status Has Been Updated','47','Kanji - JLPT N5 #20','','12:11:45 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (100,'arfi','New Quiz/Survey Has Been Created','48','Kanji - JLPT N3 #11','','12:12:06 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (101,'arfi','New Quiz/Survey Has Been Created','49','Kanji - JLPT N5 #22','','12:12:26 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (102,'arfi','Quiz/Survey Status Has Been Updated','49','Kanji - JLPT N5 #22','','12:30:33 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (103,'arfi','New Quiz/Survey Has Been Created','50','Kanji - JLPT N4 #2','','12:31:38 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (104,'arfi','Quiz/Survey Status Has Been Updated','50','Kanji - JLPT N4 #2','','12:59:59 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (105,'arfi','New Quiz/Survey Has Been Created','51','Kanji - JLPT N4 #4','','01:01:07 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (106,'arfi','Quiz/Survey Status Has Been Updated','51','Kanji - JLPT N4 #4','','01:28:58 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (107,'arfi','New Quiz/Survey Has Been Created','52','Kanji - JLPT N4 #6','','01:30:00 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (108,'arfi','Quiz/Survey Status Has Been Updated','48','Kanji - JLPT N3 #11','','01:34:34 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (109,'arfi','New Quiz/Survey Has Been Created','53','Kanji - JLPT N3 #13','','01:36:06 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (110,'arfi','Quiz/Survey Status Has Been Updated','53','Kanji - JLPT N3 #13','','02:16:15 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (111,'arfi','New Quiz/Survey Has Been Created','54','Kanji - JLPT N3 #15','','02:18:26 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (112,'arfi','Quiz/Survey Status Has Been Updated','52','Kanji - JLPT N4 #6','','02:20:26 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (113,'arfi','New Quiz/Survey Has Been Created','55','Kanji - JLPT N4 #8','','02:22:53 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (114,'arfi','Quiz/Survey Status Has Been Updated','55','Kanji - JLPT N4 #8','','02:35:28 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (115,'arfi','New Quiz/Survey Has Been Created','56','Kanji - JLPT N4 #10','','02:36:17 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (116,'arfi','Quiz/Survey Status Has Been Updated','54','Kanji - JLPT N3 #15','','02:41:27 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (117,'arfi','New Quiz/Survey Has Been Created','57','Kanji - JLPT N3 #17','','02:42:47 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (118,'arfi','Quiz/Survey Status Has Been Updated','56','Kanji - JLPT N4 #10','','02:59:55 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (119,'arfi','New Quiz/Survey Has Been Created','58','Kanji - JLPT N4 #12','','03:00:59 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (120,'arfi','Quiz/Survey Status Has Been Updated','57','Kanji - JLPT N3 #17','','03:07:26 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (121,'arfi','New Quiz/Survey Has Been Created','59','Kanji - JLPT N3 #19','','03:08:37 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (122,'arfi','Quiz/Survey Status Has Been Updated','58','Kanji - JLPT N4 #12','','03:23:19 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (123,'arfi','New Quiz/Survey Has Been Created','60','Kanji - JLPT N4 #14','','03:24:45 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (124,'arfi','Quiz/Survey Status Has Been Updated','59','Kanji - JLPT N3 #19','','03:34:04 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (125,'arfi','Quiz/Survey Status Has Been Updated','60','Kanji - JLPT N4 #14','','03:50:14 PM 12/29/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (126,'arfi','New Quiz/Survey Has Been Created','61','Kanji - JLPT N3 #21','','03:19:51 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (127,'arfi','Quiz/Survey Status Has Been Updated','61','Kanji - JLPT N3 #21','','04:02:00 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (128,'arfi','New Quiz/Survey Has Been Created','62','Kanji - JLPT N3 #23','','04:02:43 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (129,'arfi','New Quiz/Survey Has Been Created','63','Kanji - JLPT N4 #16','','04:33:28 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (130,'arfi','Quiz/Survey Status Has Been Updated','63','Kanji - JLPT N4 #16','','05:02:17 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (131,'arfi','New Quiz/Survey Has Been Created','64','Kanji - JLPT N4 #18','','05:03:09 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (132,'arfi','Quiz/Survey Status Has Been Updated','64','Kanji - JLPT N4 #18','','05:25:09 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (133,'arfi','New Quiz/Survey Has Been Created','65','Kanji - JLPT N4 #20','','05:26:26 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (134,'arfi','Quiz/Survey Status Has Been Updated','65','Kanji - JLPT N4 #20','','05:51:15 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (135,'arfi','New Quiz/Survey Has Been Created','66','Kanji - JLPT N4 #22','','05:52:15 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (136,'arfi','Quiz/Survey Status Has Been Updated','66','Kanji - JLPT N4 #22','','06:14:50 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (137,'arfi','New Quiz/Survey Has Been Created','67','Kanji - JLPT N4 #24','','06:15:42 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (138,'arfi','Quiz/Survey Status Has Been Updated','67','Kanji - JLPT N4 #24','','06:40:23 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (139,'arfi','New Quiz/Survey Has Been Created','68','Kanji - JLPT N4 #26','','06:41:17 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (140,'arfi','Quiz/Survey Status Has Been Updated','68','Kanji - JLPT N4 #26','','07:03:23 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (141,'arfi','New Quiz/Survey Has Been Created','69','Kanji - JLPT N4 #28','','07:04:59 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (142,'arfi','Quiz/Survey Status Has Been Updated','69','Kanji - JLPT N4 #28','','07:29:02 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (143,'arfi','New Quiz/Survey Has Been Created','70','Kanji - JLPT N4 #30','','07:29:49 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (144,'arfi','Quiz/Survey Status Has Been Updated','62','Kanji - JLPT N3 #23','','07:35:12 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (145,'arfi','New Quiz/Survey Has Been Created','71','Kanji - JLPT N3 #25','','07:36:24 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (146,'arfi','Quiz/Survey Status Has Been Updated','70','Kanji - JLPT N4 #30','','07:51:30 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (147,'arfi','New Quiz/Survey Has Been Created','72','Kanji - JLPT N3 #2','','07:52:59 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (148,'arfi','Quiz/Survey Status Has Been Updated','71','Kanji - JLPT N3 #25','','07:59:13 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (149,'arfi','New Quiz/Survey Has Been Created','73','Kanji - JLPT N3 #27','','08:00:52 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (150,'arfi','Quiz/Survey Status Has Been Updated','73','Kanji - JLPT N3 #27','','08:13:04 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (151,'arfi','New Quiz/Survey Has Been Created','74','Kanji - JLPT N3 #29','','08:14:04 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (152,'arfi','Quiz/Survey Status Has Been Updated','74','Kanji - JLPT N3 #29','','08:44:26 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (153,'arfi','New Quiz/Survey Has Been Created','75','Kanji - JLPT N2 #1','','08:45:40 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (154,'arfi','Quiz/Survey Status Has Been Updated','72','Kanji - JLPT N3 #2','','08:51:57 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (155,'arfi','Quiz/Survey Status Has Been Updated','75','Kanji - JLPT N2 #1','','09:13:27 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (156,'arfi','New Quiz/Survey Has Been Created','76','Kanji - JLPT N2 #3','','09:14:39 AM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (157,'arfi','Quiz/Survey Status Has Been Updated','76','Kanji - JLPT N2 #3','','12:21:41 PM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (158,'arfi','New Quiz/Survey Has Been Created','77','Kanji - JLPT N2 #5','','12:23:06 PM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (159,'arfi','Quiz/Survey Status Has Been Updated','77','Kanji - JLPT N2 #5','','02:11:39 PM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (160,'arfi','New Quiz/Survey Has Been Created','78','Kanji - JLPT N2 #7','','02:12:38 PM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (161,'arfi','Quiz/Survey Status Has Been Updated','78','Kanji - JLPT N2 #7','','02:43:19 PM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (162,'arfi','New Quiz/Survey Has Been Created','79','Kanji - JLPT N2 #9','','02:44:35 PM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (163,'arfi','Quiz/Survey Status Has Been Updated','79','Kanji - JLPT N2 #9','','04:16:50 PM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (164,'arfi','New Quiz/Survey Has Been Created','80','Kanji - JLPT N2 #11','','04:17:57 PM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (165,'arfi','Quiz/Survey Status Has Been Updated','80','Kanji - JLPT N2 #11','','04:36:38 PM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (166,'arfi','New Quiz/Survey Has Been Created','81','Kanji - JLPT N2 #13','','10:04:33 PM 12/30/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (167,'arfi','Quiz/Survey Status Has Been Updated','81','Kanji - JLPT N2 #13','','12:37:31 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (168,'arfi','New Quiz/Survey Has Been Created','82','Kanji - JLPT N3 #4','','04:30:16 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (169,'arfi','Quiz/Survey Status Has Been Updated','82','Kanji - JLPT N3 #4','','04:49:27 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (170,'arfi','New Quiz/Survey Has Been Created','83','Kanji - JLPT N3 #6','','04:49:58 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (171,'arfi','Quiz/Survey Status Has Been Updated','83','Kanji - JLPT N3 #6','','05:09:52 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (172,'arfi','New Quiz/Survey Has Been Created','84','Kanji - JLPT N3 #8','','05:10:42 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (173,'arfi','Quiz/Survey Status Has Been Updated','84','Kanji - JLPT N3 #8','','05:36:03 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (174,'arfi','New Quiz/Survey Has Been Created','85','Kanji - JLPT N3 #10','','05:36:38 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (175,'arfi','Quiz/Survey Status Has Been Updated','85','Kanji - JLPT N3 #10','','05:56:26 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (176,'arfi','New Quiz/Survey Has Been Created','86','Kanji - JLPT N5 #12','','05:57:15 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (177,'arfi','New Quiz/Survey Has Been Created','87','Kanji - JLPT N2 #15','','06:08:51 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (178,'arfi','Quiz/Survey Status Has Been Updated','86','Kanji - JLPT N5 #12','','06:14:35 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (179,'arfi','New Quiz/Survey Has Been Created','88','Kanji - JLPT N3 #14','','06:18:41 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (180,'arfi','Quiz/Survey Status Has Been Updated','87','Kanji - JLPT N2 #15','','06:28:05 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (181,'arfi','New Quiz/Survey Has Been Created','89','Kanji - JLPT N2 #17','','06:29:00 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (182,'arfi','Quiz/Survey Status Has Been Updated','88','Kanji - JLPT N3 #14','','06:30:17 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (183,'arfi','New Quiz/Survey Has Been Created','90','Kanji - JLPT N3 #16','','06:31:47 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (184,'arfi','Quiz/Survey Status Has Been Updated','90','Kanji - JLPT N3 #16','','06:58:43 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (185,'arfi','New Quiz/Survey Has Been Created','91','Kanji - JLPT N3 #18','','06:59:32 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (186,'arfi','Quiz/Survey Status Has Been Updated','89','Kanji - JLPT N2 #17','','07:00:11 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (187,'arfi','New Quiz/Survey Has Been Created','92','Kanji - JLPT N2 #19','','07:01:37 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (188,'arfi','Quiz/Survey Status Has Been Updated','92','Kanji - JLPT N2 #19','','07:17:56 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (189,'arfi','New Quiz/Survey Has Been Created','93','Kanji - JLPT N2 #21','','07:18:43 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (190,'arfi','Quiz/Survey Status Has Been Updated','91','Kanji - JLPT N3 #18','','07:19:06 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (191,'arfi','New Quiz/Survey Has Been Created','94','Kanji - JLPT N3 #20','','07:20:15 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (192,'arfi','Quiz/Survey Status Has Been Updated','93','Kanji - JLPT N2 #21','','07:39:39 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (193,'arfi','New Quiz/Survey Has Been Created','95','Kanji - JLPT N2 #23','','07:42:54 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (194,'arfi','Quiz/Survey Status Has Been Updated','94','Kanji - JLPT N3 #20','','07:44:08 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (195,'arfi','New Quiz/Survey Has Been Created','96','Kanji - JLPT N3 #22','','07:44:49 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (196,'arfi','Quiz/Survey Status Has Been Updated','96','Kanji - JLPT N3 #22','','08:04:34 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (197,'arfi','New Quiz/Survey Has Been Created','97','Kanji - JLPT N3 #24','','08:05:20 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (198,'arfi','Quiz/Survey Status Has Been Updated','97','Kanji - JLPT N3 #24','','08:21:36 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (199,'arfi','New Quiz/Survey Has Been Created','98','Kanji - JLPT N3 #26','','08:22:31 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (200,'arfi','Quiz/Survey Status Has Been Updated','98','Kanji - JLPT N3 #26','','08:35:02 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (201,'arfi','New Quiz/Survey Has Been Created','99','Kanji - JLPT N3 #28','','08:38:22 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (202,'arfi','Quiz/Survey Status Has Been Updated','95','Kanji - JLPT N2 #23','','08:51:32 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (203,'arfi','New Quiz/Survey Has Been Created','100','Kanji - JLPT N2 #25','','08:52:29 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (204,'arfi','Quiz/Survey Status Has Been Updated','100','Kanji - JLPT N2 #25','','09:17:39 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (205,'arfi','New Quiz/Survey Has Been Created','101','Kanji - JLPT N2 #27','','09:18:58 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (206,'arfi','Quiz/Survey Status Has Been Updated','99','Kanji - JLPT N3 #28','','09:30:31 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (207,'arfi','Quiz/Survey Status Has Been Updated','101','Kanji - JLPT N2 #27','','09:35:24 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (208,'arfi','New Quiz/Survey Has Been Created','102','Kanji - JLPT N2 #29','','09:36:04 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (209,'arfi','Quiz/Survey Status Has Been Updated','102','Kanji - JLPT N2 #29','','10:15:33 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (210,'arfi','New Quiz/Survey Has Been Created','103','Kanji - JLPT N1 #1','','10:17:20 AM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (211,'arfi','Quiz/Survey Status Has Been Updated','103','Kanji - JLPT N1 #1','','02:09:24 PM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (212,'arfi','New Quiz/Survey Has Been Created','104','Kanji - JLPT N1 #3','','02:12:33 PM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (213,'arfi','Quiz/Survey Status Has Been Updated','104','Kanji - JLPT N1 #3','','02:33:49 PM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (214,'arfi','New Quiz/Survey Has Been Created','105','Kanji - JLPT N1 #5','','02:34:57 PM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (215,'arfi','Quiz/Survey Status Has Been Updated','105','Kanji - JLPT N1 #5','','03:16:34 PM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (216,'arfi','New Quiz/Survey Has Been Created','106','Kanji - JLPT N1 #7','','03:17:17 PM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (217,'arfi','Quiz/Survey Status Has Been Updated','106','Kanji - JLPT N1 #7','','04:14:29 PM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (218,'arfi','New Quiz/Survey Has Been Created','107','Kanji - JLPT N1 #9','','04:15:27 PM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (219,'arfi','Quiz/Survey Status Has Been Updated','107','Kanji - JLPT N1 #9','','04:41:49 PM 12/31/2024');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (220,'arfi','New Quiz/Survey Has Been Created','108','Kanji - JLPT N1 #11','','04:30:26 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (221,'arfi','Quiz/Survey Status Has Been Updated','108','Kanji - JLPT N1 #11','','05:06:07 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (222,'arfi','New Quiz/Survey Has Been Created','109','Kanji - JLPT N1 #13','','05:06:50 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (223,'arfi','Quiz/Survey Status Has Been Updated','109','Kanji - JLPT N1 #13','','05:34:18 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (224,'arfi','New Quiz/Survey Has Been Created','110','Kanji - JLPT N1 #15','','05:35:03 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (225,'arfi','Quiz/Survey Status Has Been Updated','110','Kanji - JLPT N1 #15','','06:04:34 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (226,'arfi','New Quiz/Survey Has Been Created','111','Kanji - JLPT N1 #17','','06:05:09 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (227,'arfi','Quiz/Survey Status Has Been Updated','111','Kanji - JLPT N1 #17','','06:29:24 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (228,'arfi','New Quiz/Survey Has Been Created','112','Kanji - JLPT N1 #19','','06:30:55 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (229,'arfi','Quiz/Survey Status Has Been Updated','112','Kanji - JLPT N1 #19','','07:58:13 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (230,'arfi','New Quiz/Survey Has Been Created','113','Kanji - JLPT N1 #21','','07:59:10 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (231,'arfi','Quiz/Survey Status Has Been Updated','113','Kanji - JLPT N1 #21','','08:19:33 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (232,'arfi','New Quiz/Survey Has Been Created','114','Kanji - JLPT N1 #23','','08:20:47 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (233,'arfi','Quiz/Survey Status Has Been Updated','114','Kanji - JLPT N1 #23','','09:06:48 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (234,'arfi','New Quiz/Survey Has Been Created','115','Kanji - JLPT N1 #25','','09:07:39 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (235,'arfi','Quiz/Survey Status Has Been Updated','115','Kanji - JLPT N1 #25','','09:39:54 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (236,'arfi','New Quiz/Survey Has Been Created','116','Kanji - JLPT N1 #27','','09:41:17 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (237,'arfi','Quiz/Survey Status Has Been Updated','116','Kanji - JLPT N1 #27','','10:52:46 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (238,'arfi','New Quiz/Survey Has Been Created','117','Kanji - JLPT N1 #29','','10:54:01 AM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (239,'arfi','New Quiz/Survey Has Been Created','118','Kanji - JLPT N3 #30','','12:07:41 PM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (240,'arfi','Quiz/Survey Status Has Been Updated','118','Kanji - JLPT N3 #30','','12:31:30 PM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (241,'arfi','New Quiz/Survey Has Been Created','119','Kanji - JLPT N2 #2','','12:33:51 PM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (242,'arfi','Quiz/Survey Status Has Been Updated','117','Kanji - JLPT N1 #29','','12:57:05 PM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (243,'arfi','Quiz/Survey Status Has Been Updated','119','Kanji - JLPT N2 #2','','01:10:21 PM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (244,'arfi','New Quiz/Survey Has Been Created','120','Kanji - JLPT N2 #4','','01:10:56 PM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (245,'arfi','Quiz/Survey Status Has Been Updated','120','Kanji - JLPT N2 #4','','03:44:28 PM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (246,'arfi','New Quiz/Survey Has Been Created','121','Kanji - JLPT N2 #6','','03:45:05 PM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (247,'arfi','Quiz/Survey Status Has Been Updated','121','Kanji - JLPT N2 #6','','04:11:35 PM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (248,'arfi','New Quiz/Survey Has Been Created','122','Kanji - JLPT N2 #8','','04:12:25 PM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (249,'arfi','Quiz/Survey Status Has Been Updated','122','Kanji - JLPT N2 #8','','04:40:15 PM 01/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (250,'arfi','New Quiz/Survey Has Been Created','123','Kanji - JLPT N2 #10','','11:42:03 AM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (251,'arfi','Quiz/Survey Status Has Been Updated','123','Kanji - JLPT N2 #10','','12:07:46 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (252,'arfi','New Quiz/Survey Has Been Created','124','Kanji - JLPT N2 #12','','12:08:27 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (253,'arfi','New Quiz/Survey Has Been Created','125','Vocabulary - JLPT N5 #1','','12:43:00 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (254,'arfi','New Quiz/Survey Has Been Created','126','Vocabulary - JLPT N5 #1','','12:44:07 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (255,'arfi','Quiz/Survey Status Has Been Updated','124','Kanji - JLPT N2 #12','','03:34:13 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (256,'arfi','New Quiz/Survey Has Been Created','127','Kanji - JLPT N2 #14','','03:35:23 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (257,'arfi','Quiz/Survey Status Has Been Updated','127','Kanji - JLPT N2 #14','','04:08:22 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (258,'arfi','New Quiz/Survey Has Been Created','128','Kanji - JLPT N2 #16','','04:09:58 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (259,'arfi','Quiz/Survey Status Has Been Updated','128','Kanji - JLPT N2 #16','','04:34:19 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (260,'arfi','Quiz/Survey Status Has Been Updated','126','Vocabulary - JLPT N5 #1','','04:37:47 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (261,'arfi','New Quiz/Survey Has Been Created','129','Vocabulary - JLPT N5 #3','','04:38:37 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (262,'arfi','Quiz/Survey Status Has Been Updated','129','Vocabulary - JLPT N5 #3','','04:47:25 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (263,'arfi','New Quiz/Survey Has Been Created','130','Vocabulary - JLPT N5 #5','','04:49:26 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (264,'arfi','Quiz/Survey Status Has Been Updated','130','Vocabulary - JLPT N5 #5','','05:12:48 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (265,'arfi','New Quiz/Survey Has Been Created','131','Vocabulary - JLPT N5 #7','','05:13:40 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (266,'arfi','Quiz/Survey Status Has Been Updated','131','Vocabulary - JLPT N5 #7','','06:41:57 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (267,'arfi','New Quiz/Survey Has Been Created','132','Vocabulary - JLPT N5 #9','','06:43:24 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (268,'arfi','Quiz/Survey Status Has Been Updated','132','Vocabulary - JLPT N5 #9','','07:09:32 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (269,'arfi','New Quiz/Survey Has Been Created','133','Vocabulary - JLPT N5 #11','','07:10:14 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (270,'arfi','Quiz/Survey Status Has Been Updated','133','Vocabulary - JLPT N5 #11','','07:27:51 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (271,'arfi','New Quiz/Survey Has Been Created','134','Vocabulary - JLPT N5 #13','','07:29:03 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (272,'arfi','Quiz/Survey Status Has Been Updated','134','Vocabulary - JLPT N5 #13','','07:37:01 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (273,'arfi','New Quiz/Survey Has Been Created','135','Vocabulary - JLPT N5 #15','','07:37:52 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (274,'arfi','Quiz/Survey Status Has Been Updated','135','Vocabulary - JLPT N5 #15','','07:59:41 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (275,'arfi','New Quiz/Survey Has Been Created','136','Vocabulary - JLPT N5 #17','','08:00:34 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (276,'arfi','Quiz/Survey Status Has Been Updated','136','Vocabulary - JLPT N5 #17','','08:11:58 PM 01/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (277,'arfi','New Quiz/Survey Has Been Created','137','Kanji - JLPT N2 #18','','07:40:55 AM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (278,'arfi','Quiz/Survey Status Has Been Updated','137','Kanji - JLPT N2 #18','','08:03:53 AM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (279,'arfi','New Quiz/Survey Has Been Created','138','Kanji - JLPT N2 #20','','08:04:21 AM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (280,'arfi','Quiz/Survey Status Has Been Updated','138','Kanji - JLPT N2 #20','','08:45:04 AM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (281,'arfi','New Quiz/Survey Has Been Created','139','Kanji - JLPT N2 #22','','08:47:38 AM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (282,'arfi','Quiz/Survey Status Has Been Updated','139','Kanji - JLPT N2 #22','','09:30:10 AM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (283,'arfi','New Quiz/Survey Has Been Created','140','Kanji - JLPT N2 #24','','09:30:59 AM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (284,'arfi','Quiz/Survey Status Has Been Updated','140','Kanji - JLPT N2 #24','','10:00:21 AM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (285,'arfi','New Quiz/Survey Has Been Created','141','Kanji - JLPT N2 #26','','10:02:24 AM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (286,'arfi','Quiz/Survey Status Has Been Updated','141','Kanji - JLPT N2 #26','','11:06:10 AM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (287,'arfi','New Quiz/Survey Has Been Created','142','Kanji - JLPT N2 #28','','11:06:41 AM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (288,'arfi','New Quiz/Survey Has Been Created','143','Vocabulary - JLPT N5 #19','','11:08:46 AM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (289,'arfi','Quiz/Survey Status Has Been Updated','143','Vocabulary - JLPT N5 #19','','11:31:02 AM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (290,'arfi','New Quiz/Survey Has Been Created','144','Vocabulary - JLPT N5 #21','','11:31:39 AM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (291,'arfi','Quiz/Survey Status Has Been Updated','142','Kanji - JLPT N2 #28','','11:41:31 AM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (292,'arfi','New Quiz/Survey Has Been Created','145','Kanji - JLPT N2 #30','','11:44:21 AM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (293,'arfi','Quiz/Survey Status Has Been Updated','144','Vocabulary - JLPT N5 #21','','12:00:53 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (294,'arfi','New Quiz/Survey Has Been Created','146','Vocabulary - JLPT N5 #23','','12:01:36 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (295,'arfi','Quiz/Survey Status Has Been Updated','146','Vocabulary - JLPT N5 #23','','12:24:18 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (296,'arfi','New Quiz/Survey Has Been Created','147','Vocabulary - JLPT N5 #25','','12:25:09 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (297,'arfi','Quiz/Survey Status Has Been Updated','145','Kanji - JLPT N2 #30','','12:39:53 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (298,'arfi','New Quiz/Survey Has Been Created','148','Kanji - JLPT N1 #2','','12:41:26 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (299,'arfi','Quiz/Survey Status Has Been Updated','147','Vocabulary - JLPT N5 #25','','01:00:57 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (300,'arfi','New Quiz/Survey Has Been Created','149','Vocabulary - JLPT N5 #27','','01:01:52 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (301,'arfi','Quiz/Survey Status Has Been Updated','149','Vocabulary - JLPT N5 #27','','01:37:08 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (302,'arfi','New Quiz/Survey Has Been Created','150','Vocabulary - JLPT N5 #29','','01:37:59 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (303,'arfi','Quiz/Survey Status Has Been Updated','150','Vocabulary - JLPT N5 #29','','01:58:45 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (304,'arfi','New Quiz/Survey Has Been Created','151','Vocabulary - JLPT N4 #1','','02:00:18 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (305,'arfi','Quiz/Survey Status Has Been Updated','151','Vocabulary - JLPT N4 #1','','02:25:05 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (306,'arfi','New Quiz/Survey Has Been Created','152','Vocabulary - JLPT N4 #3','','02:25:54 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (307,'arfi','Quiz/Survey Status Has Been Updated','152','Vocabulary - JLPT N4 #3','','02:41:54 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (308,'arfi','New Quiz/Survey Has Been Created','153','Vocabulary - JLPT N4 #5','','02:43:37 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (309,'arfi','Quiz/Survey Status Has Been Updated','153','Vocabulary - JLPT N4 #5','','03:55:41 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (310,'arfi','New Quiz/Survey Has Been Created','154','Vocabulary - JLPT N4 #7','','03:57:16 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (311,'arfi','New Quiz/Survey Has Been Created','155','Vocabulary - JLPT N4 #7','','03:59:31 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (312,'arfi','Quiz/Survey Status Has Been Updated','155','Vocabulary - JLPT N4 #7','','04:11:30 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (313,'arfi','New Quiz/Survey Has Been Created','156','Vocabulary - JLPT N4 #9','','04:12:56 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (314,'arfi','Quiz/Survey Status Has Been Updated','156','Vocabulary - JLPT N4 #9','','04:33:43 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (315,'arfi','New Quiz/Survey Has Been Created','157','Vocabulary - JLPT N4 #11','','04:35:15 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (316,'arfi','Quiz/Survey Status Has Been Updated','148','Kanji - JLPT N1 #2','','04:35:24 PM 01/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (317,'arfi','New Quiz/Survey Has Been Created','158','Kanji - JLPT N1 #4','','04:27:29 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (318,'arfi','Quiz/Survey Status Has Been Updated','157','Vocabulary - JLPT N4 #11','','05:02:58 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (319,'arfi','New Quiz/Survey Has Been Created','159','Vocabulary - JLPT N4 #13','','05:04:10 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (320,'arfi','Quiz/Survey Status Has Been Updated','158','Kanji - JLPT N1 #4','','05:28:54 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (321,'arfi','New Quiz/Survey Has Been Created','160','Kanji - JLPT N1 #6','','05:30:34 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (322,'arfi','Quiz/Survey Status Has Been Updated','159','Vocabulary - JLPT N4 #13','','05:40:41 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (323,'arfi','New Quiz/Survey Has Been Created','161','Vocabulary - JLPT N4 #15','','05:41:39 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (324,'arfi','Quiz/Survey Status Has Been Updated','161','Vocabulary - JLPT N4 #15','','05:51:33 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (325,'arfi','New Quiz/Survey Has Been Created','162','Vocabulary - JLPT N4 #17','','05:55:31 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (326,'arfi','Quiz/Survey Status Has Been Updated','160','Kanji - JLPT N1 #6','','06:05:18 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (327,'arfi','New Quiz/Survey Has Been Created','163','Kanji - JLPT N1 #8','','06:08:44 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (328,'arfi','Quiz/Survey Status Has Been Updated','163','Kanji - JLPT N1 #8','','06:47:43 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (329,'arfi','New Quiz/Survey Has Been Created','164','Kanji - JLPT N1 #10','','06:49:16 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (330,'arfi','Quiz/Survey Status Has Been Updated','162','Vocabulary - JLPT N4 #17','','07:25:07 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (331,'arfi','New Quiz/Survey Has Been Created','165','Vocabulary - JLPT N4 #19','','07:26:04 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (332,'arfi','Quiz/Survey Status Has Been Updated','164','Kanji - JLPT N1 #10','','09:06:55 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (333,'arfi','Quiz/Survey Status Has Been Updated','164','Kanji - JLPT N1 #10','','09:06:55 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (334,'arfi','New Quiz/Survey Has Been Created','166','Kanji - JLPT N1 #12','','09:20:16 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (335,'arfi','Quiz/Survey Status Has Been Updated','166','Kanji - JLPT N1 #12','','09:33:57 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (336,'arfi','New Quiz/Survey Has Been Created','167','Kanji - JLPT N1 #14','','09:34:43 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (337,'arfi','Quiz/Survey Status Has Been Updated','167','Kanji - JLPT N1 #14','','09:54:25 AM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (338,'arfi','Quiz/Survey Status Has Been Updated','165','Vocabulary - JLPT N4 #19','','03:29:42 PM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (339,'arfi','New Quiz/Survey Has Been Created','168','Vocabulary - JLPT N4 #21','','03:30:35 PM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (340,'arfi','Quiz/Survey Status Has Been Updated','168','Vocabulary - JLPT N4 #21','','04:17:14 PM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (341,'arfi','New Quiz/Survey Has Been Created','169','Vocabulary - JLPT N4 #23','','04:20:11 PM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (342,'arfi','Quiz/Survey Status Has Been Updated','169','Vocabulary - JLPT N4 #23','','04:33:53 PM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (343,'arfi','New Quiz/Survey Has Been Created','170','Vocabulary - JLPT N4 #25','','04:34:36 PM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (344,'arfi','Quiz/Survey Status Has Been Updated','170','Vocabulary - JLPT N4 #25','','04:56:03 PM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (345,'arfi','New Quiz/Survey Has Been Created','171','Vocabulary - JLPT N4 #27','','04:57:05 PM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (346,'arfi','Quiz/Survey Status Has Been Updated','171','Vocabulary - JLPT N4 #27','','05:21:28 PM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (347,'arfi','New Quiz/Survey Has Been Created','172','Vocabulary - JLPT N4 #29','','05:22:32 PM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (348,'arfi','Quiz/Survey Status Has Been Updated','172','Vocabulary - JLPT N4 #29','','05:30:43 PM 01/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (349,'arfi','New Quiz/Survey Has Been Created','173','Vocabulary - JLPT N3 #1','','05:36:35 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (350,'arfi','Quiz/Survey Status Has Been Updated','173','Vocabulary - JLPT N3 #1','','05:56:57 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (351,'arfi','New Quiz/Survey Has Been Created','174','Vocabulary - JLPT N3 #3','','05:57:49 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (352,'arfi','Quiz/Survey Status Has Been Updated','174','Vocabulary - JLPT N3 #3','','06:15:56 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (353,'arfi','New Quiz/Survey Has Been Created','175','Vocabulary - JLPT N3 #5','','06:55:06 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (354,'arfi','Quiz/Survey Status Has Been Updated','175','Vocabulary - JLPT N3 #5','','07:15:39 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (355,'arfi','New Quiz/Survey Has Been Created','176','Vocabulary - JLPT N3 #7','','07:16:25 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (356,'arfi','Quiz/Survey Status Has Been Updated','176','Vocabulary - JLPT N3 #7','','07:37:14 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (357,'arfi','New Quiz/Survey Has Been Created','177','Vocabulary - JLPT N3 #9','','07:38:19 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (358,'arfi','Quiz/Survey Status Has Been Updated','177','Vocabulary - JLPT N3 #9','','07:55:16 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (359,'arfi','New Quiz/Survey Has Been Created','178','Vocabulary - JLPT N3 #11','','07:56:19 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (360,'arfi','Quiz/Survey Status Has Been Updated','178','Vocabulary - JLPT N3 #11','','08:18:10 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (361,'arfi','New Quiz/Survey Has Been Created','179','Vocabulary - JLPT N3 #13','','08:19:14 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (362,'arfi','Quiz/Survey Status Has Been Updated','179','Vocabulary - JLPT N3 #13','','10:15:47 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (363,'arfi','New Quiz/Survey Has Been Created','180','Vocabulary - JLPT N3 #15','','10:16:21 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (364,'arfi','Quiz/Survey Status Has Been Updated','180','Vocabulary - JLPT N3 #15','','10:38:53 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (365,'arfi','New Quiz/Survey Has Been Created','181','Vocabulary - JLPT N3 #17','','10:39:43 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (366,'arfi','New Quiz/Survey Has Been Created','182','Kanji - JLPT N1 #16','','11:30:37 AM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (367,'arfi','Quiz/Survey Status Has Been Updated','181','Vocabulary - JLPT N3 #17','','12:18:07 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (368,'arfi','New Quiz/Survey Has Been Created','183','Vocabulary - JLPT N3 #19','','12:18:49 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (369,'arfi','Quiz/Survey Status Has Been Updated','183','Vocabulary - JLPT N3 #19','','12:50:27 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (370,'arfi','New Quiz/Survey Has Been Created','184','Vocabulary - JLPT N3 #21','','12:51:18 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (371,'arfi','Quiz/Survey Status Has Been Updated','184','Vocabulary - JLPT N3 #21','','01:16:19 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (372,'arfi','New Quiz/Survey Has Been Created','185','Vocabulary - JLPT N3 #23','','01:18:07 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (373,'arfi','Quiz/Survey Status Has Been Updated','185','Vocabulary - JLPT N3 #23','','01:30:27 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (374,'arfi','New Quiz/Survey Has Been Created','186','Vocabulary - JLPT N3 #25','','01:33:57 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (375,'arfi','Quiz/Survey Status Has Been Updated','186','Vocabulary - JLPT N3 #25','','01:48:58 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (376,'arfi','New Quiz/Survey Has Been Created','187','Vocabulary - JLPT N3 #27','','01:50:01 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (377,'arfi','Quiz/Survey Status Has Been Updated','182','Kanji - JLPT N1 #16','','02:04:38 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (378,'arfi','New Quiz/Survey Has Been Created','188','Kanji - JLPT N1 #18','','02:05:07 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (379,'arfi','Quiz/Survey Status Has Been Updated','187','Vocabulary - JLPT N3 #27','','02:11:42 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (380,'arfi','New Quiz/Survey Has Been Created','189','Vocabulary - JLPT N3 #29','','02:12:51 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (381,'arfi','Quiz/Survey Status Has Been Updated','189','Vocabulary - JLPT N3 #29','','02:21:23 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (382,'arfi','New Quiz/Survey Has Been Created','190','Kanji - JLPT N1 #20','','02:55:57 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (383,'arfi','Quiz/Survey Status Has Been Updated','190','Kanji - JLPT N1 #20','','03:34:04 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (384,'arfi','New Quiz/Survey Has Been Created','191','Kanji - JLPT N1 #22','','03:34:47 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (385,'arfi','Quiz/Survey Status Has Been Updated','191','Kanji - JLPT N1 #22','','04:45:41 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (386,'arfi','New Quiz/Survey Has Been Created','192','Kanji - JLPT N1 #24','','04:46:22 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (387,'arfi','Quiz/Survey Status Has Been Updated','192','Kanji - JLPT N1 #24','','05:02:47 PM 01/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (388,'arfi','New Quiz/Survey Has Been Created','193','Vocabulary - JLPT N2 #1','','05:18:12 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (389,'arfi','Quiz/Survey Status Has Been Updated','193','Vocabulary - JLPT N2 #1','','05:42:54 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (390,'arfi','New Quiz/Survey Has Been Created','194','Vocabulary - JLPT N2 #3','','05:43:51 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (391,'arfi','Quiz/Survey Status Has Been Updated','194','Vocabulary - JLPT N2 #3','','06:03:32 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (392,'arfi','New Quiz/Survey Has Been Created','195','Vocabulary - JLPT N2 #5','','06:05:04 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (393,'arfi','Quiz/Survey Status Has Been Updated','195','Vocabulary - JLPT N2 #5','','07:27:28 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (394,'arfi','New Quiz/Survey Has Been Created','196','Vocabulary - JLPT N2 #7','','07:28:17 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (395,'arfi','Quiz/Survey Status Has Been Updated','196','Vocabulary - JLPT N2 #7','','07:45:14 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (396,'arfi','New Quiz/Survey Has Been Created','197','Vocabulary - JLPT N2 #9','','07:45:54 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (397,'arfi','Quiz/Survey Status Has Been Updated','197','Vocabulary - JLPT N2 #9','','08:04:26 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (398,'arfi','New Quiz/Survey Has Been Created','198','Vocabulary - JLPT N2 #11','','08:05:11 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (399,'arfi','Quiz/Survey Status Has Been Updated','198','Vocabulary - JLPT N2 #11','','08:49:17 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (400,'arfi','New Quiz/Survey Has Been Created','199','Vocabulary - JLPT N2 #13','','08:50:05 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (401,'arfi','Quiz/Survey Status Has Been Updated','199','Vocabulary - JLPT N2 #13','','09:11:48 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (402,'arfi','New Quiz/Survey Has Been Created','200','Vocabulary - JLPT N2 #15','','09:13:02 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (403,'arfi','Quiz/Survey Status Has Been Updated','200','Vocabulary - JLPT N2 #15','','09:40:55 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (404,'arfi','New Quiz/Survey Has Been Created','201','Vocabulary - JLPT N2 #17','','09:42:49 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (405,'arfi','Quiz/Survey Status Has Been Updated','201','Vocabulary - JLPT N2 #17','','09:59:11 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (406,'arfi','New Quiz/Survey Has Been Created','202','Vocabulary - JLPT N2 #19','','10:00:14 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (407,'arfi','Quiz/Survey Status Has Been Updated','202','Vocabulary - JLPT N2 #19','','11:06:51 AM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (408,'arfi','New Quiz/Survey Has Been Created','203','Vocabulary - JLPT N2 #21','','12:09:19 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (409,'arfi','Quiz/Survey Status Has Been Updated','203','Vocabulary - JLPT N2 #21','','12:36:59 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (410,'arfi','New Quiz/Survey Has Been Created','204','Vocabulary - JLPT N2 #23','','12:37:56 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (411,'arfi','Quiz/Survey Status Has Been Updated','204','Vocabulary - JLPT N2 #23','','01:13:06 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (412,'arfi','New Quiz/Survey Has Been Created','205','Vocabulary - JLPT N2 #25','','01:14:15 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (413,'arfi','Quiz/Survey Status Has Been Updated','205','Vocabulary - JLPT N2 #25','','01:29:47 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (414,'arfi','New Quiz/Survey Has Been Created','206','Vocabulary - JLPT N2 #27','','01:30:34 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (415,'arfi','Quiz/Survey Status Has Been Updated','206','Vocabulary - JLPT N2 #27','','02:00:35 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (416,'arfi','New Quiz/Survey Has Been Created','207','Vocabulary - JLPT N2 #29','','02:01:32 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (417,'arfi','Quiz/Survey Status Has Been Updated','207','Vocabulary - JLPT N2 #29','','02:12:18 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (418,'arfi','New Quiz/Survey Has Been Created','208','Vocabulary - JLPT N1 #1','','02:34:33 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (419,'arfi','Quiz/Survey Status Has Been Updated','208','Vocabulary - JLPT N1 #1','','03:08:36 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (420,'arfi','New Quiz/Survey Has Been Created','209','Vocabulary - JLPT N1 #3','','03:09:54 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (421,'arfi','Quiz/Survey Status Has Been Updated','209','Vocabulary - JLPT N1 #3','','03:22:55 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (422,'arfi','New Quiz/Survey Has Been Created','210','Vocabulary - JLPT N1 #5','','03:23:37 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (423,'arfi','Quiz/Survey Status Has Been Updated','210','Vocabulary - JLPT N1 #5','','03:32:07 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (424,'arfi','New Quiz/Survey Has Been Created','211','Kanji - JLPT N1 #26','','03:39:59 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (425,'arfi','Quiz/Survey Status Has Been Updated','211','Kanji - JLPT N1 #26','','04:25:48 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (426,'arfi','New Quiz/Survey Has Been Created','212','Kanji - JLPT N1 #28','','04:26:34 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (427,'arfi','Quiz/Survey Status Has Been Updated','212','Kanji - JLPT N1 #28','','04:44:42 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (428,'arfi','New Quiz/Survey Has Been Created','213','Kanji - JLPT N1 #30','','04:45:34 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (429,'arfi','Quiz/Survey Status Has Been Updated','213','Kanji - JLPT N1 #30','','05:05:43 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (430,'arfi','New Quiz/Survey Has Been Created','214','Vocabulary - JLPT N5 #2','','05:07:55 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (431,'arfi','Quiz/Survey Status Has Been Updated','214','Vocabulary - JLPT N5 #2','','05:54:47 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (432,'arfi','New Quiz/Survey Has Been Created','215','Vocabulary - JLPT N5 #4','','05:55:24 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (433,'arfi','Quiz/Survey Status Has Been Updated','215','Vocabulary - JLPT N5 #4','','06:39:24 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (434,'arfi','New Quiz/Survey Has Been Created','216','Vocabulary - JLPT N5 #6','','06:40:35 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (435,'arfi','Quiz/Survey Status Has Been Updated','216','Vocabulary - JLPT N5 #6','','07:05:18 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (436,'arfi','New Quiz/Survey Has Been Created','217','Vocabulary - JLPT N5 #8','','07:07:19 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (437,'arfi','Quiz/Survey Status Has Been Updated','217','Vocabulary - JLPT N5 #8','','08:43:53 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (438,'arfi','New Quiz/Survey Has Been Created','218','Vocabulary - JLPT N5 #10','','08:44:44 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (439,'arfi','Quiz/Survey Status Has Been Updated','218','Vocabulary - JLPT N5 #10','','09:04:31 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (440,'arfi','New Quiz/Survey Has Been Created','219','Vocabulary - JLPT N5 #12','','09:05:19 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (441,'arfi','Quiz/Survey Status Has Been Updated','219','Vocabulary - JLPT N5 #12','','09:53:13 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (442,'arfi','New Quiz/Survey Has Been Created','220','Vocabulary - JLPT N5 #14','','10:15:54 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (443,'arfi','Quiz/Survey Status Has Been Updated','220','Vocabulary - JLPT N5 #14','','10:43:37 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (444,'arfi','New Quiz/Survey Has Been Created','221','Vocabulary - JLPT N5 #16','','10:44:30 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (445,'arfi','Quiz/Survey Status Has Been Updated','221','Vocabulary - JLPT N5 #16','','10:52:32 PM 01/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (446,'arfi','New Quiz/Survey Has Been Created','222','Vocabulary - JLPT N1 #7','','07:38:35 AM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (447,'arfi','Quiz/Survey Status Has Been Updated','222','Vocabulary - JLPT N1 #7','','08:02:31 AM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (448,'arfi','New Quiz/Survey Has Been Created','223','Vocabulary - JLPT N1 #9','','08:03:38 AM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (449,'arfi','Quiz/Survey Status Has Been Updated','223','Vocabulary - JLPT N1 #9','','08:51:08 AM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (450,'arfi','New Quiz/Survey Has Been Created','224','Vocabulary - JLPT N1 #11','','08:56:34 AM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (451,'arfi','Quiz/Survey Status Has Been Updated','224','Vocabulary - JLPT N1 #11','','09:26:54 AM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (452,'arfi','New Quiz/Survey Has Been Created','225','Vocabulary - JLPT N1 #13','','09:27:46 AM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (453,'arfi','Quiz/Survey Status Has Been Updated','225','Vocabulary - JLPT N1 #13','','12:07:25 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (454,'arfi','New Quiz/Survey Has Been Created','226','Vocabulary - JLPT N1 #15','','12:08:28 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (455,'arfi','Quiz/Survey Status Has Been Updated','226','Vocabulary - JLPT N1 #15','','12:36:11 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (456,'arfi','New Quiz/Survey Has Been Created','227','Vocabulary - JLPT N1 #17','','12:36:55 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (457,'arfi','Quiz/Survey Status Has Been Updated','227','Vocabulary - JLPT N1 #17','','12:59:20 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (458,'arfi','New Quiz/Survey Has Been Created','228','Vocabulary - JLPT N1 #19','','01:03:12 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (459,'arfi','Quiz/Survey Status Has Been Updated','228','Vocabulary - JLPT N1 #19','','01:27:55 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (460,'arfi','New Quiz/Survey Has Been Created','229','Vocabulary - JLPT N1 #21','','01:28:37 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (461,'arfi','Quiz/Survey Status Has Been Updated','229','Vocabulary - JLPT N1 #21','','01:58:43 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (462,'arfi','New Quiz/Survey Has Been Created','230','Vocabulary - JLPT N1 #23','','01:59:24 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (463,'arfi','Quiz/Survey Status Has Been Updated','230','Vocabulary - JLPT N1 #23','','02:32:04 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (464,'arfi','New Quiz/Survey Has Been Created','231','Vocabulary - JLPT N1 #25','','02:33:11 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (465,'arfi','New Quiz/Survey Has Been Created','232','Vocabulary - JLPT N5 #18','','02:38:01 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (466,'arfi','Quiz/Survey Status Has Been Updated','231','Vocabulary - JLPT N1 #25','','02:45:14 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (467,'arfi','New Quiz/Survey Has Been Created','233','Vocabulary - JLPT N1 #27','','02:46:08 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (468,'arfi','Quiz/Survey Status Has Been Updated','233','Vocabulary - JLPT N1 #27','','02:58:54 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (469,'arfi','New Quiz/Survey Has Been Created','234','Vocabulary - JLPT N1 #29','','02:59:49 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (470,'arfi','Quiz/Survey Status Has Been Updated','232','Vocabulary - JLPT N5 #18','','03:08:03 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (471,'arfi','New Quiz/Survey Has Been Created','235','Vocabulary - JLPT N5 #14','','03:11:41 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (472,'arfi','Quiz/Survey Status Has Been Updated','234','Vocabulary - JLPT N1 #29','','03:19:34 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (473,'arfi','Quiz/Survey Name Has Been Edited','235','Vocabulary - JLPT N5 #20','','03:37:12 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (474,'arfi','Quiz/Survey Has Been Deleted: Vocabulary - JLPT N5 #20','235','','','03:39:43 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (475,'arfi','New Quiz/Survey Has Been Created','236','Vocabulary - JLPT N5 #20','','03:41:41 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (476,'arfi','Quiz/Survey Status Has Been Updated','236','Vocabulary - JLPT N5 #20','','04:05:34 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (477,'arfi','New Quiz/Survey Has Been Created','237','Vocabulary - JLPT N5 #22','','04:06:39 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (478,'arfi','Quiz/Survey Status Has Been Updated','237','Vocabulary - JLPT N5 #22','','04:18:54 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (479,'arfi','New Quiz/Survey Has Been Created','238','Vocabulary - JLPT N5 #24','','04:19:22 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (480,'arfi','Quiz/Survey Status Has Been Updated','238','Vocabulary - JLPT N5 #24','','04:40:09 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (481,'arfi','New Quiz/Survey Has Been Created','239','Vocabulary - JLPT N5 #26','','04:40:53 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (482,'arfi','Quiz/Survey Status Has Been Updated','239','Vocabulary - JLPT N5 #26','','04:48:38 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (483,'arfi','New Quiz/Survey Has Been Created','240','Vocabulary - JLPT N5 #28','','04:49:12 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (484,'arfi','Quiz/Survey Status Has Been Updated','240','Vocabulary - JLPT N5 #28','','05:13:23 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (485,'arfi','New Quiz/Survey Has Been Created','241','Vocabulary - JLPT N5 #30','','05:14:06 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (486,'arfi','Quiz/Survey Status Has Been Updated','241','Vocabulary - JLPT N5 #30','','05:35:06 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (487,'arfi','New Quiz/Survey Has Been Created','242','Vocabulary - JLPT N4 #2','','05:36:12 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (488,'arfi','Quiz/Survey Status Has Been Updated','242','Vocabulary - JLPT N4 #2','','05:53:16 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (489,'arfi','New Quiz/Survey Has Been Created','243','Vocabulary - JLPT N4 #4','','05:54:09 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (490,'arfi','Quiz/Survey Status Has Been Updated','243','Vocabulary - JLPT N4 #4','','06:44:11 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (491,'arfi','New Quiz/Survey Has Been Created','244','Vocabulary - JLPT N4 #6','','06:46:48 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (492,'arfi','Quiz/Survey Status Has Been Updated','244','Vocabulary - JLPT N4 #6','','07:01:25 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (493,'arfi','New Quiz/Survey Has Been Created','245','Vocabulary - JLPT N4 #8','','07:03:22 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (494,'arfi','Quiz/Survey Status Has Been Updated','245','Vocabulary - JLPT N4 #8','','07:42:00 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (495,'arfi','New Quiz/Survey Has Been Created','246','Vocabulary - JLPT N4 #10','','07:43:16 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (496,'arfi','Quiz/Survey Status Has Been Updated','246','Vocabulary - JLPT N4 #10','','08:04:04 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (497,'arfi','New Quiz/Survey Has Been Created','247','Vocabulary - JLPT N4 #12','','08:53:41 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (498,'arfi','Quiz/Survey Status Has Been Updated','247','Vocabulary - JLPT N4 #12','','09:25:01 PM 01/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (499,'arfi','New Quiz/Survey Has Been Created','248','Grammar - JLPT N5 #1','','06:04:35 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (500,'arfi','Quiz/Survey Status Has Been Updated','248','Grammar - JLPT N5 #1','','06:31:36 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (501,'arfi','New Quiz/Survey Has Been Created','249','Grammar - JLPT N5 #3','','06:32:43 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (502,'arfi','Quiz/Survey Status Has Been Updated','249','Grammar - JLPT N5 #3','','06:47:32 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (503,'arfi','New Quiz/Survey Has Been Created','250','Grammar - JLPT N5 #5','','06:49:32 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (504,'arfi','Quiz/Survey Status Has Been Updated','250','Grammar - JLPT N5 #5','','07:06:24 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (505,'arfi','New Quiz/Survey Has Been Created','251','Grammar - JLPT N5 #7','','07:07:02 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (506,'arfi','Quiz/Survey Status Has Been Updated','251','Grammar - JLPT N5 #7','','07:29:03 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (507,'arfi','New Quiz/Survey Has Been Created','252','Grammar - JLPT N5 #9','','07:30:07 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (508,'arfi','Quiz/Survey Status Has Been Updated','252','Grammar - JLPT N5 #9','','07:48:40 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (509,'arfi','New Quiz/Survey Has Been Created','253','Grammar - JLPT N5 #11','','07:49:48 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (510,'arfi','Quiz/Survey Status Has Been Updated','253','Grammar - JLPT N5 #11','','08:03:56 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (511,'arfi','New Quiz/Survey Has Been Created','254','Grammar - JLPT N5 #13','','08:04:55 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (512,'arfi','Quiz/Survey Status Has Been Updated','254','Grammar - JLPT N5 #13','','08:21:20 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (513,'arfi','New Quiz/Survey Has Been Created','255','Grammar - JLPT N5 #15','','08:22:10 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (514,'arfi','Quiz/Survey Status Has Been Updated','255','Grammar - JLPT N5 #15','','08:30:36 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (515,'arfi','New Quiz/Survey Has Been Created','256','Grammar - JLPT N5 #17','','08:31:34 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (516,'arfi','Quiz/Survey Status Has Been Updated','256','Grammar - JLPT N5 #17','','09:13:59 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (517,'arfi','New Quiz/Survey Has Been Created','257','Grammar - JLPT N5 #19','','09:14:38 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (518,'arfi','Quiz/Survey Status Has Been Updated','257','Grammar - JLPT N5 #19','','09:29:04 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (519,'arfi','New Quiz/Survey Has Been Created','258','Grammar - JLPT N5 #21','','09:30:24 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (520,'arfi','Quiz/Survey Status Has Been Updated','258','Grammar - JLPT N5 #21','','10:02:21 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (521,'arfi','New Quiz/Survey Has Been Created','259','Grammar - JLPT N5 #23','','10:03:29 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (522,'arfi','Quiz/Survey Status Has Been Updated','259','Grammar - JLPT N5 #23','','10:11:24 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (523,'arfi','New Quiz/Survey Has Been Created','260','Grammar - JLPT N5 #25','','10:12:20 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (524,'arfi','Quiz/Survey Status Has Been Updated','260','Grammar - JLPT N5 #25','','10:29:06 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (525,'arfi','New Quiz/Survey Has Been Created','261','Grammar - JLPT N5 #27','','10:29:45 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (526,'arfi','Quiz/Survey Status Has Been Updated','261','Grammar - JLPT N5 #27','','10:44:08 AM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (527,'arfi','New Quiz/Survey Has Been Created','262','Grammar - JLPT N4 #1','','12:58:04 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (528,'arfi','Quiz/Survey Status Has Been Updated','262','Grammar - JLPT N4 #1','','01:22:35 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (529,'arfi','New Quiz/Survey Has Been Created','263','Grammar - JLPT N4 #3','','01:23:31 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (530,'arfi','Quiz/Survey Status Has Been Updated','263','Grammar - JLPT N4 #3','','01:31:43 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (531,'arfi','New Quiz/Survey Has Been Created','264','Grammar - JLPT N4 #5','','01:32:45 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (532,'arfi','Quiz/Survey Status Has Been Updated','264','Grammar - JLPT N4 #5','','01:54:28 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (533,'arfi','New Quiz/Survey Has Been Created','265','Grammar - JLPT N4 #7','','01:55:20 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (534,'arfi','Quiz/Survey Status Has Been Updated','265','Grammar - JLPT N4 #7','','02:12:44 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (535,'arfi','New Quiz/Survey Has Been Created','266','Grammar - JLPT N4 #9','','02:13:53 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (536,'arfi','Quiz/Survey Status Has Been Updated','266','Grammar - JLPT N4 #9','','02:31:32 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (537,'arfi','New Quiz/Survey Has Been Created','267','Grammar - JLPT N4 #11','','02:32:22 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (538,'arfi','Quiz/Survey Status Has Been Updated','267','Grammar - JLPT N4 #11','','03:52:59 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (539,'arfi','New Quiz/Survey Has Been Created','268','Grammar - JLPT N4 #13','','03:53:52 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (540,'arfi','Quiz/Survey Status Has Been Updated','268','Grammar - JLPT N4 #13','','04:07:43 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (541,'arfi','New Quiz/Survey Has Been Created','269','Grammar - JLPT N4 #15','','04:08:39 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (542,'arfi','Quiz/Survey Status Has Been Updated','269','Grammar - JLPT N4 #15','','04:24:58 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (543,'arfi','New Quiz/Survey Has Been Created','270','Grammar - JLPT N4 #17','','04:25:37 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (544,'arfi','Quiz/Survey Status Has Been Updated','270','Grammar - JLPT N4 #17','','04:40:07 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (545,'arfi','New Quiz/Survey Has Been Created','271','Grammar - JLPT N4 #19','','04:41:02 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (546,'arfi','Quiz/Survey Status Has Been Updated','271','Grammar - JLPT N4 #19','','04:48:28 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (547,'arfi','New Quiz/Survey Has Been Created','272','Grammar - JLPT N4 #21','','04:50:51 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (548,'arfi','Quiz/Survey Status Has Been Updated','272','Grammar - JLPT N4 #21','','05:18:37 PM 01/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (549,'arfi','New Quiz/Survey Has Been Created','273','Grammar - JLPT N4 #23','','06:53:02 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (550,'arfi','Quiz/Survey Status Has Been Updated','273','Grammar - JLPT N4 #23','','07:05:40 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (551,'arfi','New Quiz/Survey Has Been Created','274','Grammar - JLPT N4 #25','','07:06:25 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (552,'arfi','Quiz/Survey Status Has Been Updated','274','Grammar - JLPT N4 #25','','07:25:33 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (553,'arfi','New Quiz/Survey Has Been Created','275','Grammar - JLPT N4 #27','','07:26:11 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (554,'arfi','Quiz/Survey Status Has Been Updated','275','Grammar - JLPT N4 #27','','07:42:37 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (555,'arfi','New Quiz/Survey Has Been Created','276','Grammar - JLPT N4 #29','','07:43:18 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (556,'arfi','Quiz/Survey Status Has Been Updated','276','Grammar - JLPT N4 #29','','08:01:03 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (557,'arfi','New Quiz/Survey Has Been Created','277','Grammar - JLPT N3 #1','','08:03:32 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (558,'arfi','Quiz/Survey Status Has Been Updated','277','Grammar - JLPT N3 #1','','08:21:47 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (559,'arfi','New Quiz/Survey Has Been Created','278','Grammar - JLPT N3 #3','','08:23:27 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (560,'arfi','Quiz/Survey Status Has Been Updated','278','Grammar - JLPT N3 #3','','08:44:02 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (561,'arfi','New Quiz/Survey Has Been Created','279','Grammar - JLPT N3 #5','','08:45:09 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (562,'arfi','Quiz/Survey Status Has Been Updated','279','Grammar - JLPT N3 #5','','09:05:48 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (563,'arfi','New Quiz/Survey Has Been Created','280','Grammar - JLPT N3 #7','','09:06:27 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (564,'arfi','Quiz/Survey Status Has Been Updated','280','Grammar - JLPT N3 #7','','09:25:46 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (565,'arfi','New Quiz/Survey Has Been Created','281','Grammar - JLPT N3 #9','','09:26:30 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (566,'arfi','Quiz/Survey Status Has Been Updated','281','Grammar - JLPT N3 #9','','09:42:19 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (567,'arfi','New Quiz/Survey Has Been Created','282','Grammar - JLPT N3 #11','','09:43:46 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (568,'arfi','Quiz/Survey Status Has Been Updated','282','Grammar - JLPT N3 #11','','10:00:30 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (569,'arfi','New Quiz/Survey Has Been Created','283','Grammar - JLPT N3 #13','','10:01:20 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (570,'arfi','Quiz/Survey Status Has Been Updated','283','Grammar - JLPT N3 #13','','10:25:07 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (571,'arfi','New Quiz/Survey Has Been Created','284','Grammar - JLPT N3 #15','','10:26:05 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (572,'arfi','Quiz/Survey Status Has Been Updated','284','Grammar - JLPT N3 #15','','11:54:16 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (573,'arfi','New Quiz/Survey Has Been Created','285','Grammar - JLPT N3 #17','','11:55:13 AM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (574,'arfi','New Quiz/Survey Has Been Created','286','Vocabulary - JLPT N4 #14','','12:17:01 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (575,'arfi','Quiz/Survey Status Has Been Updated','286','Vocabulary - JLPT N4 #14','','12:26:51 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (576,'arfi','New Quiz/Survey Has Been Created','287','Vocabulary - JLPT N5=4 #16','','12:27:23 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (577,'arfi','Quiz/Survey Status Has Been Updated','285','Grammar - JLPT N3 #17','','12:49:49 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (578,'arfi','New Quiz/Survey Has Been Created','288','Grammar - JLPT N3 #19','','12:50:45 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (579,'arfi','Quiz/Survey Status Has Been Updated','287','Vocabulary - JLPT N5=4 #16','','12:51:04 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (580,'arfi','New Quiz/Survey Has Been Created','289','Vocabulary - JLPT N4 #18','','12:52:04 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (581,'arfi','Quiz/Survey Status Has Been Updated','288','Grammar - JLPT N3 #19','','01:13:16 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (582,'arfi','New Quiz/Survey Has Been Created','290','Grammar - JLPT N3 #21','','01:14:08 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (583,'arfi','Quiz/Survey Status Has Been Updated','290','Grammar - JLPT N3 #21','','01:39:13 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (584,'arfi','New Quiz/Survey Has Been Created','291','Grammar - JLPT N3 #23','','01:40:02 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (585,'arfi','Quiz/Survey Status Has Been Updated','291','Grammar - JLPT N3 #23','','02:01:14 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (586,'arfi','New Quiz/Survey Has Been Created','292','Grammar - JLPT N3 #25','','02:08:51 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (587,'arfi','Quiz/Survey Status Has Been Updated','292','Grammar - JLPT N3 #25','','02:41:03 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (588,'arfi','New Quiz/Survey Has Been Created','293','Grammar - JLPT N3 #27','','02:42:54 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (589,'arfi','Quiz/Survey Status Has Been Updated','293','Grammar - JLPT N3 #27','','03:06:34 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (590,'arfi','New Quiz/Survey Has Been Created','294','Grammar - JLPT N3 #29','','03:07:38 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (591,'arfi','Quiz/Survey Status Has Been Updated','294','Grammar - JLPT N3 #29','','03:29:17 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (592,'arfi','New Quiz/Survey Has Been Created','295','Grammar - JLPT N2 #1','','03:30:27 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (593,'arfi','Quiz/Survey Status Has Been Updated','295','Grammar - JLPT N2 #1','','03:43:40 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (594,'arfi','New Quiz/Survey Has Been Created','296','Grammar - JLPT N2 #3','','03:44:41 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (595,'arfi','Quiz/Survey Status Has Been Updated','289','Vocabulary - JLPT N4 #18','','03:51:39 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (596,'arfi','New Quiz/Survey Has Been Created','297','Vocabulary - JLPT N4 #20','','03:52:22 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (597,'arfi','Quiz/Survey Status Has Been Updated','296','Grammar - JLPT N2 #3','','04:00:51 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (598,'arfi','New Quiz/Survey Has Been Created','298','Grammar - JLPT N2 #5','','04:02:35 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (599,'arfi','Quiz/Survey Status Has Been Updated','297','Vocabulary - JLPT N4 #20','','04:51:32 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (600,'arfi','Quiz/Survey Status Has Been Updated','298','Grammar - JLPT N2 #5','','04:56:06 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (601,'arfi','New Quiz/Survey Has Been Created','299','Grammar - JLPT N2 #7','','04:59:24 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (602,'arfi','Quiz/Survey Status Has Been Updated','299','Grammar - JLPT N2 #7','','05:27:29 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (603,'arfi','New Quiz/Survey Has Been Created','300','Grammar - JLPT N2 #9','','05:28:33 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (604,'arfi','Quiz/Survey Status Has Been Updated','300','Grammar - JLPT N2 #9','','05:55:23 PM 01/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (605,'arfi','New Quiz/Survey Has Been Created','301','Grammar - JLPT N2 #11','','06:36:43 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (606,'arfi','Quiz/Survey Status Has Been Updated','301','Grammar - JLPT N2 #11','','07:05:47 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (607,'arfi','New Quiz/Survey Has Been Created','302','Grammar - JLPT N2 #13','','07:07:40 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (608,'arfi','Quiz/Survey Status Has Been Updated','302','Grammar - JLPT N2 #13','','07:23:08 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (609,'arfi','New Quiz/Survey Has Been Created','303','Grammar - JLPT N2 #15','','07:24:25 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (610,'arfi','Quiz/Survey Status Has Been Updated','303','Grammar - JLPT N2 #15','','07:41:08 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (611,'arfi','New Quiz/Survey Has Been Created','304','Grammar - JLPT N2 #17','','07:42:25 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (612,'arfi','Quiz/Survey Status Has Been Updated','304','Grammar - JLPT N2 #17','','07:57:04 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (613,'arfi','New Quiz/Survey Has Been Created','305','Grammar - JLPT N2 #19','','07:58:22 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (614,'arfi','Quiz/Survey Status Has Been Updated','305','Grammar - JLPT N2 #19','','08:14:54 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (615,'arfi','New Quiz/Survey Has Been Created','306','Grammar - JLPT N2 #21','','08:18:36 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (616,'arfi','Quiz/Survey Status Has Been Updated','306','Grammar - JLPT N2 #21','','08:31:55 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (617,'arfi','New Quiz/Survey Has Been Created','307','Grammar - JLPT N2 #23','','08:33:13 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (618,'arfi','Quiz/Survey Status Has Been Updated','307','Grammar - JLPT N2 #23','','08:51:51 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (619,'arfi','New Quiz/Survey Has Been Created','308','Grammar - JLPT N2 #25','','08:53:03 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (620,'arfi','Quiz/Survey Status Has Been Updated','308','Grammar - JLPT N2 #25','','09:07:05 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (621,'arfi','New Quiz/Survey Has Been Created','309','Grammar - JLPT N2 #27','','09:12:27 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (622,'arfi','Quiz/Survey Status Has Been Updated','309','Grammar - JLPT N2 #27','','09:24:48 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (623,'arfi','New Quiz/Survey Has Been Created','310','Grammar - JLPT N2 #29','','09:26:06 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (624,'arfi','Quiz/Survey Status Has Been Updated','310','Grammar - JLPT N2 #29','','09:46:54 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (625,'arfi','New Quiz/Survey Has Been Created','311','Grammar - JLPT N1 #1','','09:48:43 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (626,'arfi','Quiz/Survey Status Has Been Updated','311','Grammar - JLPT N1 #1','','10:09:54 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (627,'arfi','New Quiz/Survey Has Been Created','312','Grammar - JLPT N1 #3','','10:15:46 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (628,'arfi','Quiz/Survey Status Has Been Updated','312','Grammar - JLPT N1 #3','','10:28:28 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (629,'arfi','New Quiz/Survey Has Been Created','313','Grammar - JLPT N1 #5','','10:29:40 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (630,'arfi','Quiz/Survey Status Has Been Updated','313','Grammar - JLPT N1 #5','','10:43:30 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (631,'arfi','New Quiz/Survey Has Been Created','314','Grammar - JLPT N1 #7','','10:46:42 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (632,'arfi','Quiz/Survey Status Has Been Updated','314','Grammar - JLPT N1 #7','','11:23:04 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (633,'arfi','New Quiz/Survey Has Been Created','315','Grammar - JLPT N1 #9','','11:24:10 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (634,'arfi','Quiz/Survey Status Has Been Updated','315','Grammar - JLPT N1 #9','','11:45:48 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (635,'arfi','New Quiz/Survey Has Been Created','316','Grammar - JLPT N1 #11','','11:51:18 AM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (636,'arfi','Quiz/Survey Status Has Been Updated','316','Grammar - JLPT N1 #11','','01:58:15 PM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (637,'arfi','New Quiz/Survey Has Been Created','317','Grammar - JLPT N1 #13','','01:59:19 PM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (638,'arfi','Quiz/Survey Status Has Been Updated','317','Grammar - JLPT N1 #13','','02:24:33 PM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (639,'arfi','New Quiz/Survey Has Been Created','318','Grammar - JLPT N1 #15','','02:25:45 PM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (640,'arfi','Quiz/Survey Status Has Been Updated','318','Grammar - JLPT N1 #15','','02:48:29 PM 01/10/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (641,'arfi','Quiz/Survey Name Has Been Edited','287','Vocabulary - JLPT N4 #16','','06:56:36 AM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (642,'arfi','New Quiz/Survey Has Been Created','319','Vocabulary - JLPT N4 #18','','07:07:41 AM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (643,'arfi','Quiz/Survey Status Has Been Updated','319','Vocabulary - JLPT N4 #18','','07:37:54 AM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (644,'arfi','Quiz/Survey Has Been Deleted: Vocabulary - JLPT N4 #18','319','','','07:38:49 AM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (645,'arfi','New Quiz/Survey Has Been Created','320','Vocabulary - JLPT N4 #22','','07:40:13 AM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (646,'arfi','Quiz/Survey Status Has Been Updated','320','Vocabulary - JLPT N4 #22','','07:59:14 AM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (647,'arfi','New Quiz/Survey Has Been Created','321','Vocabulary - JLPT N4 #24','','07:59:56 AM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (648,'arfi','Quiz/Survey Status Has Been Updated','321','Vocabulary - JLPT N4 #24','','08:44:46 AM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (649,'arfi','New Quiz/Survey Has Been Created','322','Vocabulary - JLPT N4 #26','','08:46:45 AM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (650,'arfi','Quiz/Survey Status Has Been Updated','322','Vocabulary - JLPT N4 #26','','09:35:06 AM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (651,'arfi','New Quiz/Survey Has Been Created','323','Vocabulary - JLPT N4 #28','','09:36:16 AM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (652,'arfi','Quiz/Survey Status Has Been Updated','323','Vocabulary - JLPT N4 #28','','10:11:42 AM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (653,'arfi','New Quiz/Survey Has Been Created','324','Vocabulary - JLPT N4 #30','','10:13:21 AM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (654,'arfi','Quiz/Survey Status Has Been Updated','324','Vocabulary - JLPT N4 #30','','10:48:26 AM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (655,'arfi','New Quiz/Survey Has Been Created','325','Reading - JLPT N5 #1','','12:26:23 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (656,'arfi','Quiz/Survey Status Has Been Updated','325','Reading - JLPT N5 #1','','12:43:39 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (657,'arfi','New Quiz/Survey Has Been Created','326','Reading - JLPT N5 #3','','12:44:41 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (658,'arfi','Quiz/Survey Status Has Been Updated','326','Reading - JLPT N5 #3','','12:54:41 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (659,'arfi','New Quiz/Survey Has Been Created','327','Reading - JLPT N5 #5','','01:01:24 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (660,'arfi','Quiz/Survey Status Has Been Updated','327','Reading - JLPT N5 #5','','01:10:19 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (661,'arfi','New Quiz/Survey Has Been Created','328','Reading - JLPT N5 #7','','01:11:43 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (662,'arfi','Quiz/Survey Status Has Been Updated','328','Reading - JLPT N5 #7','','01:18:43 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (663,'arfi','New Quiz/Survey Has Been Created','329','Reading - JLPT N5 #9','','01:19:32 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (664,'arfi','Quiz/Survey Status Has Been Updated','329','Reading - JLPT N5 #9','','01:44:20 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (665,'arfi','New Quiz/Survey Has Been Created','330','Reading - JLPT N5 #11','','01:46:40 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (666,'arfi','Quiz/Survey Status Has Been Updated','330','Reading - JLPT N5 #11','','01:55:20 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (667,'arfi','New Quiz/Survey Has Been Created','331','Reading - JLPT N5 #13','','01:58:08 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (668,'arfi','Quiz/Survey Status Has Been Updated','331','Reading - JLPT N5 #13','','02:21:15 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (669,'arfi','New Quiz/Survey Has Been Created','332','Reading - JLPT N5 #15','','02:22:04 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (670,'arfi','Quiz/Survey Status Has Been Updated','332','Reading - JLPT N5 #15','','02:41:21 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (671,'arfi','New Quiz/Survey Has Been Created','333','Reading - JLPT N4 #1','','02:42:52 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (672,'arfi','Quiz/Survey Status Has Been Updated','333','Reading - JLPT N4 #1','','02:54:24 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (673,'arfi','New Quiz/Survey Has Been Created','334','Reading - JLPT N4 #3','','03:01:09 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (674,'arfi','Quiz/Survey Status Has Been Updated','334','Reading - JLPT N4 #3','','03:11:30 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (675,'arfi','New Quiz/Survey Has Been Created','335','Reading - JLPT N4 #5','','03:12:59 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (676,'arfi','Quiz/Survey Status Has Been Updated','335','Reading - JLPT N4 #5','','03:27:25 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (677,'arfi','New Quiz/Survey Has Been Created','336','Reading - JLPT N4 #7','','03:28:16 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (678,'arfi','Quiz/Survey Status Has Been Updated','336','Reading - JLPT N4 #7','','03:38:30 PM 01/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (679,'arfi','New Quiz/Survey Has Been Created','337','Reading - JLPT N4 #9','','04:54:23 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (680,'arfi','Quiz/Survey Status Has Been Updated','337','Reading - JLPT N4 #9','','05:08:55 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (681,'arfi','New Quiz/Survey Has Been Created','338','Reading - JLPT N4 #11','','05:09:50 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (682,'arfi','Quiz/Survey Status Has Been Updated','338','Reading - JLPT N4 #11','','05:18:58 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (683,'arfi','New Quiz/Survey Has Been Created','339','Reading - JLPT N4 #13','','05:21:29 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (684,'arfi','Quiz/Survey Status Has Been Updated','339','Reading - JLPT N4 #13','','05:32:55 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (685,'arfi','New Quiz/Survey Has Been Created','340','Reading - JLPT N4 #15','','05:35:39 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (686,'arfi','Quiz/Survey Status Has Been Updated','340','Reading - JLPT N4 #15','','06:20:36 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (687,'arfi','New Quiz/Survey Has Been Created','341','Reading - JLPT N3 #1','','06:21:21 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (688,'arfi','Quiz/Survey Status Has Been Updated','341','Reading - JLPT N3 #1','','06:36:45 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (689,'arfi','New Quiz/Survey Has Been Created','342','Reading - JLPT N3 #3','','06:38:03 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (690,'arfi','Quiz/Survey Status Has Been Updated','342','Reading - JLPT N3 #3','','06:54:24 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (691,'arfi','New Quiz/Survey Has Been Created','343','Reading - JLPT N3 #5','','06:56:31 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (692,'arfi','Quiz/Survey Status Has Been Updated','343','Reading - JLPT N3 #5','','07:06:51 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (693,'arfi','New Quiz/Survey Has Been Created','344','Reading - JLPT N3 #7','','07:09:22 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (694,'arfi','Quiz/Survey Status Has Been Updated','344','Reading - JLPT N3 #7','','07:22:45 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (695,'arfi','New Quiz/Survey Has Been Created','345','Reading - JLPT N3 #9','','07:25:20 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (696,'arfi','Quiz/Survey Status Has Been Updated','345','Reading - JLPT N3 #9','','07:38:41 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (697,'arfi','New Quiz/Survey Has Been Created','346','Reading - JLPT N3 #11','','07:43:03 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (698,'arfi','Quiz/Survey Status Has Been Updated','346','Reading - JLPT N3 #11','','07:55:13 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (699,'arfi','New Quiz/Survey Has Been Created','347','Reading - JLPT N3 #13','','08:00:05 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (700,'arfi','Quiz/Survey Status Has Been Updated','347','Reading - JLPT N3 #13','','08:09:28 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (701,'arfi','New Quiz/Survey Has Been Created','348','Reading - JLPT N3 #15','','08:15:32 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (702,'arfi','Quiz/Survey Status Has Been Updated','348','Reading - JLPT N3 #15','','08:25:09 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (703,'arfi','New Quiz/Survey Has Been Created','349','Reading - JLPT N3 #17','','08:25:59 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (704,'arfi','Quiz/Survey Status Has Been Updated','349','Reading - JLPT N3 #17','','08:35:36 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (705,'arfi','New Quiz/Survey Has Been Created','350','Reading - JLPT N3 #19','','08:38:57 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (706,'arfi','Quiz/Survey Status Has Been Updated','350','Reading - JLPT N3 #19','','08:51:09 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (707,'arfi','New Quiz/Survey Has Been Created','351','Reading - JLPT N3 #21','','11:19:42 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (708,'arfi','Quiz/Survey Status Has Been Updated','351','Reading - JLPT N3 #21','','11:40:09 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (709,'arfi','New Quiz/Survey Has Been Created','352','Reading - JLPT N3 #23','','11:40:48 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (710,'arfi','Quiz/Survey Status Has Been Updated','352','Reading - JLPT N3 #23','','11:51:19 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (711,'arfi','New Quiz/Survey Has Been Created','353','Reading - JLPT N3 #25','','11:55:21 AM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (712,'arfi','Quiz/Survey Status Has Been Updated','353','Reading - JLPT N3 #25','','12:07:17 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (713,'arfi','New Quiz/Survey Has Been Created','354','Reading - JLPT N3 #27','','12:09:06 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (714,'arfi','Quiz/Survey Status Has Been Updated','354','Reading - JLPT N3 #27','','12:21:51 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (715,'arfi','New Quiz/Survey Has Been Created','355','Reading - JLPT N3 #29','','12:22:32 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (716,'arfi','Quiz/Survey Status Has Been Updated','355','Reading - JLPT N3 #29','','12:39:05 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (717,'arfi','New Quiz/Survey Has Been Created','356','Reading - JLPT N2 #1','','12:41:00 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (718,'arfi','New Quiz/Survey Has Been Created','357','Vocabulary - JLPT N3 #2','','12:59:55 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (719,'arfi','Quiz/Survey Status Has Been Updated','356','Reading - JLPT N2 #1','','01:05:02 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (720,'arfi','New Quiz/Survey Has Been Created','358','Reading - JLPT N2 #3','','01:07:54 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (721,'arfi','Quiz/Survey Status Has Been Updated','358','Reading - JLPT N2 #3','','01:25:45 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (722,'arfi','New Quiz/Survey Has Been Created','359','Reading - JLPT N2 #5','','01:27:47 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (723,'arfi','Quiz/Survey Status Has Been Updated','359','Reading - JLPT N2 #5','','01:39:12 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (724,'arfi','New Quiz/Survey Has Been Created','360','Reading - JLPT N2 #7','','01:40:38 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (725,'arfi','Quiz/Survey Status Has Been Updated','360','Reading - JLPT N2 #7','','02:06:08 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (726,'arfi','New Quiz/Survey Has Been Created','361','Reading - JLPT N2 #9','','02:07:27 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (727,'arfi','Quiz/Survey Status Has Been Updated','361','Reading - JLPT N2 #9','','02:21:31 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (728,'arfi','New Quiz/Survey Has Been Created','362','Reading - JLPT N2 #11','','03:14:47 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (729,'arfi','Quiz/Survey Status Has Been Updated','362','Reading - JLPT N2 #11','','03:26:02 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (730,'arfi','New Quiz/Survey Has Been Created','363','Reading - JLPT N2 #13','','03:26:47 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (731,'arfi','Quiz/Survey Status Has Been Updated','363','Reading - JLPT N2 #13','','03:36:21 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (732,'arfi','New Quiz/Survey Has Been Created','364','Reading - JLPT N2 #15','','03:36:55 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (733,'arfi','Quiz/Survey Status Has Been Updated','364','Reading - JLPT N2 #15','','03:45:54 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (734,'arfi','New Quiz/Survey Has Been Created','365','Reading - JLPT N2 #17','','03:49:07 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (735,'arfi','Quiz/Survey Status Has Been Updated','365','Reading - JLPT N2 #17','','04:03:07 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (736,'arfi','New Quiz/Survey Has Been Created','366','Reading - JLPT N2 #19','','04:03:43 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (737,'arfi','Quiz/Survey Status Has Been Updated','366','Reading - JLPT N2 #19','','04:11:56 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (738,'arfi','New Quiz/Survey Has Been Created','367','Reading - JLPT N2 #21','','04:13:16 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (739,'arfi','Quiz/Survey Status Has Been Updated','367','Reading - JLPT N2 #21','','04:56:09 PM 01/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (740,'arfi','New Quiz/Survey Has Been Created','368','Reading - JLPT N2 #23','','05:39:29 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (741,'arfi','Quiz/Survey Status Has Been Updated','368','Reading - JLPT N2 #23','','05:48:59 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (742,'arfi','New Quiz/Survey Has Been Created','369','Reading - JLPT N2 #25','','05:50:33 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (743,'arfi','Quiz/Survey Status Has Been Updated','369','Reading - JLPT N2 #25','','06:03:25 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (744,'arfi','New Quiz/Survey Has Been Created','370','Reading - JLPT N2 #27','','06:06:12 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (745,'arfi','Quiz/Survey Status Has Been Updated','370','Reading - JLPT N2 #27','','06:18:03 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (746,'arfi','New Quiz/Survey Has Been Created','371','Reading - JLPT N2 #29','','06:21:25 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (747,'arfi','Quiz/Survey Status Has Been Updated','371','Reading - JLPT N2 #29','','06:31:34 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (748,'arfi','New Quiz/Survey Has Been Created','372','Reading - JLPT N1 #1','','06:34:53 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (749,'arfi','Quiz/Survey Status Has Been Updated','372','Reading - JLPT N1 #1','','06:49:33 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (750,'arfi','New Quiz/Survey Has Been Created','373','Reading - JLPT N1 #3','','06:50:46 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (751,'arfi','Quiz/Survey Status Has Been Updated','373','Reading - JLPT N1 #3','','07:03:54 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (752,'arfi','New Quiz/Survey Has Been Created','374','Reading - JLPT N1 #5','','07:05:03 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (753,'arfi','Quiz/Survey Status Has Been Updated','374','Reading - JLPT N1 #5','','07:18:03 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (754,'arfi','New Quiz/Survey Has Been Created','375','Reading - JLPT N1 #7','','07:19:51 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (755,'arfi','Quiz/Survey Status Has Been Updated','375','Reading - JLPT N1 #7','','07:32:58 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (756,'arfi','New Quiz/Survey Has Been Created','376','Reading - JLPT N1 #9','','07:37:20 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (757,'arfi','Quiz/Survey Status Has Been Updated','376','Reading - JLPT N1 #9','','07:48:08 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (758,'arfi','New Quiz/Survey Has Been Created','377','Reading - JLPT N1 #11','','07:50:23 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (759,'arfi','Quiz/Survey Status Has Been Updated','377','Reading - JLPT N1 #11','','08:03:34 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (760,'arfi','New Quiz/Survey Has Been Created','378','Reading - JLPT N1 #13','','08:05:47 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (761,'arfi','Quiz/Survey Status Has Been Updated','378','Reading - JLPT N1 #13','','08:19:46 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (762,'arfi','New Quiz/Survey Has Been Created','379','Reading - JLPT N1 #15','','08:21:06 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (763,'arfi','Quiz/Survey Status Has Been Updated','379','Reading - JLPT N1 #15','','08:35:18 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (764,'arfi','New Quiz/Survey Has Been Created','380','Reading - JLPT N1 #17','','08:36:17 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (765,'arfi','Quiz/Survey Status Has Been Updated','380','Reading - JLPT N1 #17','','09:01:02 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (766,'arfi','New Quiz/Survey Has Been Created','381','Listening - JLPT N5 #1','','11:34:14 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (767,'arfi','Quiz/Survey Status Has Been Updated','381','Listening - JLPT N5 #1','','11:59:27 AM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (768,'arfi','New Quiz/Survey Has Been Created','382','Listening - JLPT N5 #3','','12:04:19 PM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (769,'arfi','Quiz/Survey Status Has Been Updated','382','Listening - JLPT N5 #3','','12:21:40 PM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (770,'arfi','New Quiz/Survey Has Been Created','383','Listening - JLPT N5 #5','','12:23:16 PM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (771,'arfi','Quiz/Survey Status Has Been Updated','383','Listening - JLPT N5 #5','','12:27:04 PM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (772,'arfi','Quiz/Survey Status Has Been Updated','357','Vocabulary - JLPT N3 #2','','12:30:35 PM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (773,'arfi','New Quiz/Survey Has Been Created','384','Vocabulary - JLPT N3 #4','','12:35:32 PM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (774,'arfi','Quiz/Survey Status Has Been Updated','384','Vocabulary - JLPT N3 #4','','01:48:09 PM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (775,'arfi','New Quiz/Survey Has Been Created','385','Vocabulary - JLPT N3 #6','','02:28:55 PM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (776,'arfi','Quiz/Survey Status Has Been Updated','385','Vocabulary - JLPT N3 #6','','03:48:29 PM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (777,'arfi','New Quiz/Survey Has Been Created','386','Vocabulary - JLPT N3 #8','','03:49:20 PM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (778,'arfi','Quiz/Survey Status Has Been Updated','386','Vocabulary - JLPT N3 #8','','05:08:33 PM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (779,'arfi','New Quiz/Survey Has Been Created','387','Listening - JLPT N5 #7','','05:23:41 PM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (780,'arfi','Quiz/Survey Status Has Been Updated','387','Listening - JLPT N5 #7','','05:46:34 PM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (781,'arfi','New Quiz/Survey Has Been Created','388','Listening - JLPT N5 #9','','05:48:04 PM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (782,'arfi','Quiz/Survey Status Has Been Updated','388','Listening - JLPT N5 #9','','06:16:52 PM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (783,'arfi','New Quiz/Survey Has Been Created','389','Listening - JLPT N5 #11','','06:19:21 PM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (784,'arfi','Quiz/Survey Status Has Been Updated','389','Listening - JLPT N5 #11','','06:31:51 PM 01/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (785,'arfi','New Quiz/Survey Has Been Created','390','Listening - JLPT N5 #13','','09:10:42 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (786,'arfi','Quiz/Survey Status Has Been Updated','390','Listening - JLPT N5 #13','','09:30:43 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (787,'arfi','New Quiz/Survey Has Been Created','391','Listening - JLPT N5 #15','','09:34:36 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (788,'arfi','Quiz/Survey Status Has Been Updated','391','Listening - JLPT N5 #15','','09:45:41 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (789,'arfi','New Quiz/Survey Has Been Created','392','Listening - JLPT N5 #17','','09:48:24 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (790,'arfi','Quiz/Survey Status Has Been Updated','392','Listening - JLPT N5 #17','','09:57:44 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (791,'arfi','New Quiz/Survey Has Been Created','393','Listening - JLPT N5 #19','','09:59:18 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (792,'arfi','Quiz/Survey Status Has Been Updated','393','Listening - JLPT N5 #19','','10:11:09 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (793,'arfi','New Quiz/Survey Has Been Created','394','Listening - JLPT N5 #21','','10:12:35 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (794,'arfi','Quiz/Survey Status Has Been Updated','394','Listening - JLPT N5 #21','','10:25:53 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (795,'arfi','New Quiz/Survey Has Been Created','395','Listening - JLPT N5 #23','','10:26:37 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (796,'arfi','Quiz/Survey Status Has Been Updated','395','Listening - JLPT N5 #23','','10:29:38 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (797,'arfi','New Quiz/Survey Has Been Created','396','Listening - JLPT N5 #25','','10:32:29 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (798,'arfi','Quiz/Survey Status Has Been Updated','396','Listening - JLPT N5 #25','','10:46:36 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (799,'arfi','New Quiz/Survey Has Been Created','397','Listening - JLPT N5 #27','','10:47:33 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (800,'arfi','Quiz/Survey Status Has Been Updated','397','Listening - JLPT N5 #27','','11:00:41 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (801,'arfi','New Quiz/Survey Has Been Created','398','Listening - JLPT N5 #29','','11:02:30 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (802,'arfi','Quiz/Survey Status Has Been Updated','398','Listening - JLPT N5 #29','','11:11:31 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (803,'arfi','New Quiz/Survey Has Been Created','399','Vocabulary - JLPT N3 #10','','11:51:17 AM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (804,'arfi','Quiz/Survey Status Has Been Updated','399','Vocabulary - JLPT N3 #10','','12:27:08 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (805,'arfi','New Quiz/Survey Has Been Created','400','Vocabulary - JLPT N3 #12','','12:27:46 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (806,'arfi','Quiz/Survey Status Has Been Updated','400','Vocabulary - JLPT N3 #12','','12:59:45 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (807,'arfi','New Quiz/Survey Has Been Created','401','Vocabulary - JLPT N3 #14','','01:00:15 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (808,'arfi','Quiz/Survey Status Has Been Updated','401','Vocabulary - JLPT N3 #14','','01:36:14 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (809,'arfi','New Quiz/Survey Has Been Created','402','Vocabulary - JLPT N3 #16','','01:37:22 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (810,'arfi','Quiz/Survey Status Has Been Updated','402','Vocabulary - JLPT N3 #16','','01:57:57 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (811,'arfi','New Quiz/Survey Has Been Created','403','Vocabulary - JLPT N3 #18','','01:58:27 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (812,'arfi','Quiz/Survey Status Has Been Updated','403','Vocabulary - JLPT N3 #18','','02:28:09 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (813,'arfi','New Quiz/Survey Has Been Created','404','Vocabulary - JLPT N3 #20','','02:28:54 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (814,'arfi','Quiz/Survey Status Has Been Updated','404','Vocabulary - JLPT N3 #20','','02:50:24 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (815,'arfi','New Quiz/Survey Has Been Created','405','Vocabulary - JLPT N3 #22','','02:50:53 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (816,'arfi','Quiz/Survey Status Has Been Updated','405','Vocabulary - JLPT N3 #22','','03:20:55 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (817,'arfi','New Quiz/Survey Has Been Created','406','Vocabulary - JLPT N3 #24','','03:22:03 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (818,'arfi','Quiz/Survey Status Has Been Updated','406','Vocabulary - JLPT N3 #24','','03:42:48 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (819,'arfi','New Quiz/Survey Has Been Created','407','Vocabulary - JLPT N3 #26','','03:44:07 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (820,'arfi','Quiz/Survey Status Has Been Updated','407','Vocabulary - JLPT N3 #26','','04:03:07 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (821,'arfi','New Quiz/Survey Has Been Created','408','Vocabulary - JLPT N3 #28','','04:04:36 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (822,'arfi','Quiz/Survey Status Has Been Updated','408','Vocabulary - JLPT N3 #28','','04:29:14 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (823,'arfi','New Quiz/Survey Has Been Created','409','Vocabulary - JLPT N3 #30','','04:30:20 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (824,'arfi','Quiz/Survey Status Has Been Updated','409','Vocabulary - JLPT N3 #30','','04:46:52 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (825,'arfi','New Quiz/Survey Has Been Created','410','Listening - JLPT N4 #1','','05:47:26 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (826,'arfi','Quiz/Survey Status Has Been Updated','410','Listening - JLPT N4 #1','','06:08:37 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (827,'arfi','New Quiz/Survey Has Been Created','411','Listening - JLPT N4 #3','','06:09:29 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (828,'arfi','Quiz/Survey Status Has Been Updated','411','Listening - JLPT N4 #3','','06:24:24 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (829,'arfi','New Quiz/Survey Has Been Created','412','Listening - JLPT N4 #5','','06:25:13 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (830,'arfi','Quiz/Survey Status Has Been Updated','412','Listening - JLPT N4 #5','','06:39:33 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (831,'arfi','New Quiz/Survey Has Been Created','413','Listening - JLPT N4 #7','','06:40:37 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (832,'arfi','Quiz/Survey Status Has Been Updated','413','Listening - JLPT N4 #7','','06:50:39 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (833,'arfi','New Quiz/Survey Has Been Created','414','Listening - JLPT N4 #9','','06:52:23 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (834,'arfi','Quiz/Survey Status Has Been Updated','414','Listening - JLPT N4 #9','','07:06:43 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (835,'arfi','New Quiz/Survey Has Been Created','415','Listening - JLPT N4 #11','','07:10:18 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (836,'arfi','Quiz/Survey Status Has Been Updated','415','Listening - JLPT N4 #11','','07:20:27 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (837,'arfi','New Quiz/Survey Has Been Created','416','Listening - JLPT N4 #13','','07:22:40 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (838,'arfi','Quiz/Survey Status Has Been Updated','416','Listening - JLPT N4 #13','','07:35:47 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (839,'arfi','New Quiz/Survey Has Been Created','417','Listening - JLPT N4 #15','','07:39:08 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (840,'arfi','Quiz/Survey Status Has Been Updated','417','Listening - JLPT N4 #15','','07:58:18 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (841,'arfi','New Quiz/Survey Has Been Created','418','Listening - JLPT N4 #17','','08:00:44 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (842,'arfi','Quiz/Survey Status Has Been Updated','418','Listening - JLPT N4 #17','','08:03:41 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (843,'arfi','New Quiz/Survey Has Been Created','419','Listening - JLPT N4 #19','','08:04:55 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (844,'arfi','Quiz/Survey Status Has Been Updated','419','Listening - JLPT N4 #19','','08:12:59 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (845,'arfi','New Quiz/Survey Has Been Created','420','Listening - JLPT N4 #21','','08:14:49 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (846,'arfi','Quiz/Survey Status Has Been Updated','420','Listening - JLPT N4 #21','','08:29:11 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (847,'arfi','New Quiz/Survey Has Been Created','421','Listening - JLPT N4 #23','','08:30:10 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (848,'arfi','Quiz/Survey Status Has Been Updated','421','Listening - JLPT N4 #23','','08:37:16 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (849,'arfi','New Quiz/Survey Has Been Created','422','Listening - JLPT N4 #25','','08:38:09 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (850,'arfi','Quiz/Survey Status Has Been Updated','422','Listening - JLPT N4 #25','','08:55:06 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (851,'arfi','New Quiz/Survey Has Been Created','423','Listening - JLPT N4 #27','','08:57:11 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (852,'arfi','Quiz/Survey Status Has Been Updated','423','Listening - JLPT N4 #27','','09:05:43 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (853,'arfi','New Quiz/Survey Has Been Created','424','Listening - JLPT N4 #29','','09:06:26 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (854,'arfi','Quiz/Survey Status Has Been Updated','424','Listening - JLPT N4 #29','','09:22:24 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (855,'arfi','New Quiz/Survey Has Been Created','425','Listening - JLPT N3 #1','','09:25:44 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (856,'arfi','Quiz/Survey Status Has Been Updated','425','Listening - JLPT N3 #1','','09:31:02 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (857,'arfi','New Quiz/Survey Has Been Created','426','Listening - JLPT N3 #3','','09:31:58 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (858,'arfi','Quiz/Survey Status Has Been Updated','426','Listening - JLPT N3 #3','','09:35:07 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (859,'arfi','New Quiz/Survey Has Been Created','427','Listening - JLPT N3 #5','','09:36:28 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (860,'arfi','Quiz/Survey Status Has Been Updated','427','Listening - JLPT N3 #5','','09:43:05 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (861,'arfi','New Quiz/Survey Has Been Created','428','Listening - JLPT N3 #7','','09:44:33 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (862,'arfi','Quiz/Survey Status Has Been Updated','428','Listening - JLPT N3 #7','','09:55:10 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (863,'arfi','New Quiz/Survey Has Been Created','429','Listening - JLPT N3 #9','','09:56:48 PM 01/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (864,'arfi','Quiz/Survey Status Has Been Updated','429','Listening - JLPT N3 #9','','02:28:03 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (865,'arfi','New Quiz/Survey Has Been Created','430','Listening - JLPT N3 #11','','02:29:43 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (866,'arfi','Quiz/Survey Status Has Been Updated','430','Listening - JLPT N3 #11','','03:02:21 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (867,'arfi','New Quiz/Survey Has Been Created','431','Listening - JLPT N3 #13','','08:01:25 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (868,'arfi','Quiz/Survey Status Has Been Updated','431','Listening - JLPT N3 #13','','08:18:03 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (869,'arfi','New Quiz/Survey Has Been Created','432','Listening - JLPT N3 #15','','08:19:01 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (870,'arfi','Quiz/Survey Status Has Been Updated','432','Listening - JLPT N3 #15','','08:46:57 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (871,'arfi','New Quiz/Survey Has Been Created','433','Listening - JLPT N3 #17','','08:48:27 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (872,'arfi','Quiz/Survey Status Has Been Updated','433','Listening - JLPT N3 #17','','09:05:36 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (873,'arfi','New Quiz/Survey Has Been Created','434','Listening - JLPT N3 #19','','09:06:43 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (874,'arfi','Quiz/Survey Status Has Been Updated','434','Listening - JLPT N3 #19','','09:22:37 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (875,'arfi','New Quiz/Survey Has Been Created','435','Listening - JLPT N3 #21','','09:23:43 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (876,'arfi','Quiz/Survey Status Has Been Updated','435','Listening - JLPT N3 #21','','09:27:13 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (877,'arfi','New Quiz/Survey Has Been Created','436','Listening - JLPT N3 #23','','09:32:01 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (878,'arfi','Quiz/Survey Status Has Been Updated','436','Listening - JLPT N3 #23','','09:37:48 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (879,'arfi','New Quiz/Survey Has Been Created','437','Listening - JLPT N3 #25','','09:39:47 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (880,'arfi','Quiz/Survey Status Has Been Updated','437','Listening - JLPT N3 #25','','09:55:01 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (881,'arfi','New Quiz/Survey Has Been Created','438','Listening - JLPT N3 #27','','09:55:49 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (882,'arfi','Quiz/Survey Status Has Been Updated','438','Listening - JLPT N3 #27','','09:59:49 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (883,'arfi','New Quiz/Survey Has Been Created','439','Listening - JLPT N3 #29','','10:00:31 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (884,'arfi','Quiz/Survey Status Has Been Updated','439','Listening - JLPT N3 #29','','10:17:41 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (885,'arfi','New Quiz/Survey Has Been Created','440','Listening - JLPT N2 #1','','10:19:53 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (886,'arfi','Quiz/Survey Status Has Been Updated','440','Listening - JLPT N2 #1','','10:39:22 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (887,'arfi','New Quiz/Survey Has Been Created','441','Listening - JLPT N2 #3','','10:40:16 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (888,'arfi','Quiz/Survey Status Has Been Updated','441','Listening - JLPT N2 #3','','10:43:43 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (889,'arfi','New Quiz/Survey Has Been Created','442','Vocabulary - JLPT N2 #2','','11:36:22 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (890,'arfi','New Quiz/Survey Has Been Created','443','Listening - JLPT N2 #5','','11:55:42 AM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (891,'arfi','Quiz/Survey Status Has Been Updated','443','Listening - JLPT N2 #5','','12:03:23 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (892,'arfi','New Quiz/Survey Has Been Created','444','Listening - JLPT N2 #7','','12:06:31 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (893,'arfi','Quiz/Survey Status Has Been Updated','444','Listening - JLPT N2 #7','','12:19:48 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (894,'arfi','New Quiz/Survey Has Been Created','445','Listening - JLPT N2 #9','','12:20:31 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (895,'arfi','Quiz/Survey Status Has Been Updated','445','Listening - JLPT N2 #9','','12:23:34 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (896,'arfi','New Quiz/Survey Has Been Created','446','Listening - JLPT N2 #11','','12:25:17 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (897,'arfi','Quiz/Survey Status Has Been Updated','442','Vocabulary - JLPT N2 #2','','12:26:16 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (898,'arfi','New Quiz/Survey Has Been Created','447','Vocabulary - JLPT N2 #4','','12:27:46 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (899,'arfi','Quiz/Survey Status Has Been Updated','446','Listening - JLPT N2 #11','','12:33:45 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (900,'arfi','New Quiz/Survey Has Been Created','448','Listening - JLPT N2 #13','','12:35:02 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (901,'arfi','Quiz/Survey Status Has Been Updated','448','Listening - JLPT N2 #13','','12:38:37 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (902,'arfi','New Quiz/Survey Has Been Created','449','Listening - JLPT N2 #15','','12:39:26 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (903,'arfi','Quiz/Survey Status Has Been Updated','449','Listening - JLPT N2 #15','','12:47:41 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (904,'arfi','New Quiz/Survey Has Been Created','450','Listening - JLPT N2 #17','','12:49:38 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (905,'arfi','Quiz/Survey Status Has Been Updated','450','Listening - JLPT N2 #17','','01:02:53 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (906,'arfi','New Quiz/Survey Has Been Created','451','Listening - JLPT N2 #19','','01:05:19 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (907,'arfi','Quiz/Survey Status Has Been Updated','447','Vocabulary - JLPT N2 #4','','01:07:00 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (908,'arfi','New Quiz/Survey Has Been Created','452','Vocabulary - JLPT N2 #6','','01:08:56 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (909,'arfi','Quiz/Survey Status Has Been Updated','451','Listening - JLPT N2 #19','','01:16:52 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (910,'arfi','Quiz/Survey Status Has Been Updated','452','Vocabulary - JLPT N2 #6','','01:37:00 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (911,'arfi','New Quiz/Survey Has Been Created','453','Vocabulary - JLPT N2 #8','','01:38:07 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (912,'arfi','Quiz/Survey Status Has Been Updated','453','Vocabulary - JLPT N2 #8','','02:07:43 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (913,'arfi','New Quiz/Survey Has Been Created','454','Vocabulary - JLPT N2 #10','','02:09:38 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (914,'arfi','Quiz/Survey Status Has Been Updated','454','Vocabulary - JLPT N2 #10','','02:41:17 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (915,'arfi','New Quiz/Survey Has Been Created','455','Vocabulary - JLPT N2 #12','','02:42:18 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (916,'arfi','Quiz/Survey Status Has Been Updated','455','Vocabulary - JLPT N2 #12','','03:21:18 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (917,'arfi','New Quiz/Survey Has Been Created','456','Vocabulary - JLPT N2 #14','','03:23:59 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (918,'arfi','Quiz/Survey Status Has Been Updated','456','Vocabulary - JLPT N2 #14','','03:39:37 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (919,'arfi','New Quiz/Survey Has Been Created','457','Vocabulary - JLPT N2 #16','','03:41:44 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (920,'arfi','Quiz/Survey Status Has Been Updated','457','Vocabulary - JLPT N2 #16','','04:13:45 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (921,'arfi','New Quiz/Survey Has Been Created','458','Listening - JLPT N2 #21','','04:18:47 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (922,'arfi','Quiz/Survey Status Has Been Updated','458','Listening - JLPT N2 #21','','04:33:42 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (923,'arfi','New Quiz/Survey Has Been Created','459','Listening - JLPT N2 #23','','04:34:27 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (924,'arfi','Quiz/Survey Status Has Been Updated','459','Listening - JLPT N2 #23','','04:47:50 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (925,'arfi','New Quiz/Survey Has Been Created','460','Listening - JLPT N2 #25','','04:49:35 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (926,'arfi','Quiz/Survey Status Has Been Updated','460','Listening - JLPT N2 #25','','04:57:35 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (927,'arfi','New Quiz/Survey Has Been Created','461','Listening - JLPT N2 #27','','04:59:26 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (928,'arfi','Quiz/Survey Status Has Been Updated','461','Listening - JLPT N2 #27','','05:15:24 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (929,'arfi','New Quiz/Survey Has Been Created','462','Listening - JLPT N2 #29','','05:17:22 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (930,'arfi','Quiz/Survey Status Has Been Updated','462','Listening - JLPT N2 #29','','05:22:01 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (931,'arfi','New Quiz/Survey Has Been Created','463','Listening - JLPT N1 #1','','05:22:56 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (932,'arfi','Quiz/Survey Status Has Been Updated','463','Listening - JLPT N1 #1','','05:48:35 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (933,'arfi','New Quiz/Survey Has Been Created','464','Listening - JLPT N1 #3','','05:54:33 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (934,'arfi','Quiz/Survey Status Has Been Updated','464','Listening - JLPT N1 #3','','06:29:35 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (935,'arfi','New Quiz/Survey Has Been Created','465','Listening - JLPT N1 #5','','06:30:58 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (936,'arfi','Quiz/Survey Status Has Been Updated','465','Listening - JLPT N1 #5','','06:44:26 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (937,'arfi','New Quiz/Survey Has Been Created','466','Listening - JLPT N1 #7','','06:47:52 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (938,'arfi','Quiz/Survey Status Has Been Updated','466','Listening - JLPT N1 #7','','06:52:38 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (939,'arfi','New Quiz/Survey Has Been Created','467','Listening - JLPT N1 #9','','06:58:01 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (940,'arfi','Quiz/Survey Status Has Been Updated','467','Listening - JLPT N1 #9','','07:08:14 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (941,'arfi','New Quiz/Survey Has Been Created','468','Listening - JLPT N1 #11','','07:16:30 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (942,'arfi','Quiz/Survey Status Has Been Updated','468','Listening - JLPT N1 #11','','07:20:12 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (943,'arfi','New Quiz/Survey Has Been Created','469','Listening - JLPT N1 #13','','07:24:31 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (944,'arfi','Quiz/Survey Status Has Been Updated','469','Listening - JLPT N1 #13','','07:34:42 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (945,'arfi','New Quiz/Survey Has Been Created','470','Listening - JLPT N1 #15','','07:35:34 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (946,'arfi','Quiz/Survey Status Has Been Updated','470','Listening - JLPT N1 #15','','07:41:19 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (947,'arfi','New Quiz/Survey Has Been Created','471','Listening - JLPT N1 #17','','07:49:01 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (948,'arfi','Quiz/Survey Status Has Been Updated','471','Listening - JLPT N1 #17','','08:02:15 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (949,'arfi','New Quiz/Survey Has Been Created','472','Listening - JLPT N1 #19','','08:10:28 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (950,'arfi','Quiz/Survey Status Has Been Updated','472','Listening - JLPT N1 #19','','08:32:17 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (951,'arfi','New Quiz/Survey Has Been Created','473','Listening - JLPT N1 #21','','08:36:12 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (952,'arfi','Quiz/Survey Status Has Been Updated','473','Listening - JLPT N1 #21','','08:50:25 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (953,'arfi','New Quiz/Survey Has Been Created','474','Listening - JLPT N1 #23','','09:05:27 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (954,'arfi','Quiz/Survey Status Has Been Updated','474','Listening - JLPT N1 #23','','09:21:11 PM 01/15/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (955,'arfi','New Quiz/Survey Has Been Created','475','Vocabulary - JLPT N2 #18','','04:25:26 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (956,'arfi','Quiz/Survey Status Has Been Updated','475','Vocabulary - JLPT N2 #18','','04:59:18 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (957,'arfi','New Quiz/Survey Has Been Created','476','Vocabulary - JLPT N2 #20','','04:59:49 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (958,'arfi','Quiz/Survey Status Has Been Updated','476','Vocabulary - JLPT N2 #20','','05:29:51 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (959,'arfi','New Quiz/Survey Has Been Created','477','Vocabulary - JLPT N2 #22','','05:30:55 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (960,'arfi','Quiz/Survey Status Has Been Updated','477','Vocabulary - JLPT N2 #22','','05:55:07 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (961,'arfi','New Quiz/Survey Has Been Created','478','Vocabulary - JLPT N2 #24','','06:00:38 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (962,'arfi','Quiz/Survey Status Has Been Updated','478','Vocabulary - JLPT N2 #24','','06:21:06 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (963,'arfi','New Quiz/Survey Has Been Created','479','Vocabulary - JLPT N2 #26','','06:24:00 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (964,'arfi','Quiz/Survey Status Has Been Updated','479','Vocabulary - JLPT N2 #26','','08:00:13 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (965,'arfi','New Quiz/Survey Has Been Created','480','Vocabulary - JLPT N2 #28','','08:08:25 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (966,'arfi','Quiz/Survey Status Has Been Updated','480','Vocabulary - JLPT N2 #28','','09:06:17 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (967,'arfi','New Quiz/Survey Has Been Created','481','Vocabulary - JLPT N2 #30','','09:08:51 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (968,'arfi','Quiz/Survey Status Has Been Updated','481','Vocabulary - JLPT N2 #30','','09:20:25 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (969,'arfi','New Quiz/Survey Has Been Created','482','Vocabulary - JLPT N1 #2','','09:24:29 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (970,'arfi','Quiz/Survey Status Has Been Updated','482','Vocabulary - JLPT N1 #2','','09:51:23 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (971,'arfi','New Quiz/Survey Has Been Created','483','JLPT Test N5 #1','','11:01:29 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (972,'arfi','Quiz/Survey Status Has Been Updated','483','JLPT Test N5 #1','','11:42:52 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (973,'arfi','New Quiz/Survey Has Been Created','484','JLPT Test N5 #3','','11:45:34 AM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (974,'arfi','Quiz/Survey Status Has Been Updated','484','JLPT Test N5 #3','','12:19:50 PM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (975,'arfi','New Quiz/Survey Has Been Created','485','JLPT Test N5 #5','','12:20:31 PM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (976,'arfi','Quiz/Survey Status Has Been Updated','485','JLPT Test N5 #5','','07:20:54 PM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (977,'arfi','New Quiz/Survey Has Been Created','486','JLPT Test N5 #7','','07:22:13 PM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (978,'arfi','Quiz/Survey Status Has Been Updated','486','JLPT Test N5 #7','','07:57:57 PM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (979,'arfi','New Quiz/Survey Has Been Created','487','JLPT Test N5 #9','','07:58:56 PM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (980,'arfi','Quiz/Survey Status Has Been Updated','487','JLPT Test N5 #9','','08:58:23 PM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (981,'arfi','New Quiz/Survey Has Been Created','488','JLPT Test N5 #11','','08:59:43 PM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (982,'arfi','Quiz/Survey Status Has Been Updated','488','JLPT Test N5 #11','','09:32:34 PM 01/16/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (983,'arfi','New Quiz/Survey Has Been Created','489','JLPT Test N5 #13','','06:44:11 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (984,'arfi','Quiz/Survey Status Has Been Updated','489','JLPT Test N5 #13','','08:11:45 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (985,'arfi','New Quiz/Survey Has Been Created','490','JLPT Test N5 #15','','08:12:31 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (986,'arfi','New Quiz/Survey Has Been Created','491','Vocabulary - JLPT N1 #4','','08:25:44 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (987,'arfi','Quiz/Survey Status Has Been Updated','490','JLPT Test N5 #15','','08:46:19 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (988,'arfi','New Quiz/Survey Has Been Created','492','JLPT Test N5 #17','','08:47:11 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (989,'arfi','Quiz/Survey Status Has Been Updated','491','Vocabulary - JLPT N1 #4','','09:14:21 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (990,'arfi','New Quiz/Survey Has Been Created','493','Vocabulary - JLPT N1 #6','','09:16:02 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (991,'arfi','Quiz/Survey Status Has Been Updated','492','JLPT Test N5 #17','','09:46:15 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (992,'arfi','New Quiz/Survey Has Been Created','494','JLPT Test N5 #19','','09:48:36 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (993,'arfi','Quiz/Survey Status Has Been Updated','493','Vocabulary - JLPT N1 #6','','10:12:22 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (994,'arfi','New Quiz/Survey Has Been Created','495','Vocabulary - JLPT N1 #8','','10:13:41 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (995,'arfi','Quiz/Survey Status Has Been Updated','495','Vocabulary - JLPT N1 #8','','10:35:08 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (996,'arfi','New Quiz/Survey Has Been Created','496','Vocabulary - JLPT N1 #10','','10:36:15 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (997,'arfi','Quiz/Survey Status Has Been Updated','496','Vocabulary - JLPT N1 #10','','11:06:57 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (998,'arfi','New Quiz/Survey Has Been Created','497','Vocabulary - JLPT N1 #12','','11:08:27 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (999,'arfi','Quiz/Survey Status Has Been Updated','494','JLPT Test N5 #19','','11:22:12 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1000,'arfi','New Quiz/Survey Has Been Created','498','JLPT Test N5 #21','','11:23:12 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1001,'arfi','Quiz/Survey Status Has Been Updated','497','Vocabulary - JLPT N1 #12','','11:36:04 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1002,'arfi','New Quiz/Survey Has Been Created','499','Vocabulary - JLPT N1 #14','','11:37:46 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1003,'arfi','Quiz/Survey Status Has Been Updated','499','Vocabulary - JLPT N1 #14','','11:47:59 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1004,'arfi','New Quiz/Survey Has Been Created','500','Vocabulary - JLPT N1 #16','','11:48:39 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1005,'arfi','Quiz/Survey Status Has Been Updated','500','Vocabulary - JLPT N1 #16','','11:57:30 AM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1006,'arfi','New Quiz/Survey Has Been Created','501','Vocabulary - JLPT N1 #18','','12:07:01 PM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1007,'arfi','Quiz/Survey Status Has Been Updated','498','JLPT Test N5 #21','','12:07:02 PM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1008,'arfi','New Quiz/Survey Has Been Created','502','JLPT Test N5 #23','','12:08:55 PM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1009,'arfi','Quiz/Survey Status Has Been Updated','501','Vocabulary - JLPT N1 #18','','12:44:21 PM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1010,'arfi','Quiz/Survey Status Has Been Updated','502','JLPT Test N5 #23','','12:59:46 PM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1011,'arfi','New Quiz/Survey Has Been Created','503','JLPT Test N5 #25','','01:00:45 PM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1012,'arfi','Quiz/Survey Status Has Been Updated','503','JLPT Test N5 #25','','01:46:29 PM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1013,'arfi','New Quiz/Survey Has Been Created','504','JLPT Test N5 #27','','01:47:27 PM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1014,'arfi','Quiz/Survey Status Has Been Updated','504','JLPT Test N5 #27','','02:26:18 PM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1015,'arfi','New Quiz/Survey Has Been Created','505','JLPT Test N5 #29','','02:27:35 PM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1016,'arfi','Quiz/Survey Status Has Been Updated','505','JLPT Test N5 #29','','03:10:55 PM 01/17/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1017,'arfi','New Quiz/Survey Has Been Created','506','JLPT Test N1 #1','','06:16:10 AM 01/18/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1018,'arfi','Quiz/Survey Status Has Been Updated','506','JLPT Test N1 #1','','06:59:32 AM 01/18/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1019,'arfi','New Quiz/Survey Has Been Created','507','JLPT Test N1 #3','','07:00:37 AM 01/18/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1020,'arfi','Quiz/Survey Status Has Been Updated','507','JLPT Test N1 #3','','07:37:17 AM 01/18/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1021,'arfi','New Quiz/Survey Has Been Created','508','JLPT Test N1 #5','','07:38:16 AM 01/18/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1022,'arfi','Quiz/Survey Status Has Been Updated','508','JLPT Test N1 #5','','08:20:24 AM 01/18/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1023,'arfi','New Quiz/Survey Has Been Created','509','JLPT Test N1 #7','','08:21:27 AM 01/18/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1024,'arfi','Quiz/Survey Status Has Been Updated','509','JLPT Test N1 #7','','09:02:01 AM 01/18/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1025,'arfi','New Quiz/Survey Has Been Created','510','Vocabulary - JLPT N1 #20','','03:27:33 PM 01/21/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1026,'arfi','Quiz/Survey Status Has Been Updated','510','Vocabulary - JLPT N1 #20','','06:43:48 PM 01/21/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1027,'arfi','New Quiz/Survey Has Been Created','511','Vocabulary - JLPT N1 #22','','06:47:34 PM 01/21/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1028,'arfi','Quiz/Survey Status Has Been Updated','511','Vocabulary - JLPT N1 #22','','08:07:01 PM 01/21/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1029,'arfi','New Quiz/Survey Has Been Created','512','Vocabulary - JLPT N1 #24','','08:07:54 PM 01/21/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1030,'arfi','Quiz/Survey Status Has Been Updated','512','Vocabulary - JLPT N1 #24','','08:58:38 PM 01/21/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1031,'arfi','New Quiz/Survey Has Been Created','513','Vocabulary - JLPT N1 #26','','07:15:40 PM 01/23/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1032,'arfi','Quiz/Survey Status Has Been Updated','513','Vocabulary - JLPT N1 #26','','07:40:29 PM 01/23/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1033,'arfi','New Quiz/Survey Has Been Created','514','Vocabulary - JLPT N1 #28','','07:41:12 PM 01/23/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1034,'arfi','Quiz/Survey Status Has Been Updated','514','Vocabulary - JLPT N1 #28','','08:10:43 PM 01/23/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1035,'arfi','New Quiz/Survey Has Been Created','515','Vocabulary - JLPT N1 #30','','08:11:18 PM 01/23/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1036,'arfi','Quiz/Survey Status Has Been Updated','515','Vocabulary - JLPT N1 #30','','09:48:23 PM 01/23/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1037,'arfi','New Quiz/Survey Has Been Created','516','Grammar - JLPT N5 #2','','11:44:11 AM 01/26/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1038,'arfi','Quiz/Survey Status Has Been Updated','516','Grammar - JLPT N5 #2','','03:04:38 PM 01/26/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1039,'arfi','New Quiz/Survey Has Been Created','517','Grammar - JLPT N5 #4','','03:12:55 PM 01/26/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1040,'arfi','Quiz/Survey Status Has Been Updated','517','Grammar - JLPT N5 #4','','04:05:59 PM 01/26/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1041,'arfi','New Quiz/Survey Has Been Created','518','Grammar - JLPT N5 #6','','04:06:30 PM 01/26/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1042,'arfi','Quiz/Survey Status Has Been Updated','518','Grammar - JLPT N5 #6','','04:53:50 PM 01/26/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1043,'arfi','New Quiz/Survey Has Been Created','519','Grammar - JLPT N5 #8','','11:57:59 AM 01/27/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1044,'arfi','Quiz/Survey Status Has Been Updated','519','Grammar - JLPT N5 #8','','12:22:06 PM 01/27/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1045,'arfi','New Quiz/Survey Has Been Created','520','Grammar - JLPT N5 #10','','12:24:36 PM 01/27/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1046,'arfi','Quiz/Survey Status Has Been Updated','520','Grammar - JLPT N5 #10','','12:37:17 PM 01/27/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1047,'arfi','New Quiz/Survey Has Been Created','521','Grammar - JLPT N5 #12','','12:44:15 PM 01/27/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1048,'arfi','Quiz/Survey Status Has Been Updated','521','Grammar - JLPT N5 #12','','01:28:02 PM 01/27/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1049,'arfi','New Quiz/Survey Has Been Created','522','Grammar - JLPT N5 #14','','01:29:53 PM 01/27/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1050,'arfi','Quiz/Survey Status Has Been Updated','522','Grammar - JLPT N5 #14','','02:10:36 PM 01/27/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1051,'arfi','New Quiz/Survey Has Been Created','523','Grammar - JLPT N5 #16','','02:12:06 PM 01/27/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1052,'arfi','Quiz/Survey Status Has Been Updated','523','Grammar - JLPT N5 #16','','02:38:38 PM 01/27/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1053,'arfi','New Quiz/Survey Has Been Created','524','Grammar - JLPT N5 #18','','02:39:13 PM 01/27/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1054,'arfi','Quiz/Survey Status Has Been Updated','524','Grammar - JLPT N5 #18','','03:07:34 PM 01/27/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1055,'arfi','New Quiz/Survey Has Been Created','525','Grammar - JLPT N5 #20','','03:09:35 PM 01/27/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1056,'arfi','Quiz/Survey Status Has Been Updated','525','Grammar - JLPT N5 #20','','03:50:25 PM 01/27/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1057,'arfi','New Quiz/Survey Has Been Created','526','Grammar - JLPT N5 #22','','03:50:57 PM 01/27/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1058,'arfi','Quiz/Survey Status Has Been Updated','526','Grammar - JLPT N5 #22','','04:37:10 PM 01/27/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1059,'arfi','New Quiz/Survey Has Been Created','527','Grammar - JLPT N5 #24','','04:41:37 PM 01/27/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1060,'arfi','New Quiz/Survey Has Been Created','528','JLPT Test N1 #9','','12:27:02 PM 01/30/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1061,'arfi','Quiz/Survey Status Has Been Updated','527','Grammar - JLPT N5 #24','','01:37:47 PM 01/30/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1062,'arfi','New Quiz/Survey Has Been Created','529','Grammar - JLPT N5 #26','','01:39:37 PM 01/30/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1063,'arfi','Quiz/Survey Status Has Been Updated','528','JLPT Test N1 #9','','01:44:50 PM 01/30/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1064,'arfi','Quiz/Survey Status Has Been Updated','529','Grammar - JLPT N5 #26','','02:04:13 PM 01/30/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1065,'arfi','New Quiz/Survey Has Been Created','530','Grammar - JLPT N5 #28','','02:05:39 PM 01/30/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1066,'arfi','Quiz/Survey Status Has Been Updated','530','Grammar - JLPT N5 #28','','02:37:16 PM 01/30/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1067,'arfi','New Quiz/Survey Has Been Created','531','Grammar - JLPT N4 #2','','02:39:13 PM 01/30/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1068,'arfi','Quiz/Survey Status Has Been Updated','531','Grammar - JLPT N4 #2','','02:59:40 PM 01/30/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1069,'arfi','New Quiz/Survey Has Been Created','532','Grammar - JLPT N4 #4','','03:00:39 PM 01/30/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1070,'arfi','Quiz/Survey Status Has Been Updated','532','Grammar - JLPT N4 #4','','03:24:13 PM 01/30/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1071,'arfi','New Quiz/Survey Has Been Created','533','Grammar - JLPT N4 #6','','03:25:17 PM 01/30/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1072,'arfi','Quiz/Survey Status Has Been Updated','533','Grammar - JLPT N4 #6','','03:47:23 PM 01/30/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1073,'arfi','New Quiz/Survey Has Been Created','534','Grammar - JLPT N4 #8','','03:49:18 PM 01/30/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1074,'arfi','Quiz/Survey Status Has Been Updated','534','Grammar - JLPT N4 #8','','04:14:32 PM 01/30/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1075,'arfi','New Quiz/Survey Has Been Created','535','JLPT Test N1 #11','','01:59:08 AM 01/31/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1076,'arfi','Quiz/Survey Status Has Been Updated','535','JLPT Test N1 #11','','02:58:02 AM 01/31/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1077,'arfi','New Quiz/Survey Has Been Created','536','JLPT Test N1 #13','','02:59:48 AM 01/31/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1078,'arfi','Quiz/Survey Status Has Been Updated','536','JLPT Test N1 #13','','08:51:32 AM 01/31/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1079,'arfi','New Quiz/Survey Has Been Created','537','JLPT Test N1 #15','','08:52:56 AM 01/31/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1080,'arfi','Quiz/Survey Status Has Been Updated','537','JLPT Test N1 #15','','11:27:13 AM 01/31/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1081,'arfi','New Quiz/Survey Has Been Created','538','JLPT Test N1 #17','','11:28:29 AM 01/31/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1082,'arfi','Quiz/Survey Status Has Been Updated','538','JLPT Test N1 #17','','12:28:02 PM 01/31/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1083,'arfi','New Quiz/Survey Has Been Created','539','JLPT Test N1 #19','','12:29:03 PM 01/31/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1084,'arfi','Quiz/Survey Status Has Been Updated','539','JLPT Test N1 #19','','02:38:37 PM 01/31/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1085,'arfi','New Quiz/Survey Has Been Created','540','JLPT Test N1 #21','','02:41:06 PM 01/31/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1086,'arfi','Quiz/Survey Status Has Been Updated','540','JLPT Test N1 #21','','03:34:52 PM 01/31/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1087,'arfi','New Quiz/Survey Has Been Created','541','JLPT Test N1 #23','','09:11:29 PM 01/31/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1088,'arfi','Quiz/Survey Status Has Been Updated','541','JLPT Test N1 #23','','07:13:04 AM 02/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1089,'arfi','New Quiz/Survey Has Been Created','542','JLPT Test N1 #25','','07:14:00 AM 02/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1090,'arfi','Quiz/Survey Status Has Been Updated','542','JLPT Test N1 #25','','08:00:09 AM 02/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1091,'arfi','New Quiz/Survey Has Been Created','543','JLPT Test N1 #27','','08:01:38 AM 02/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1092,'arfi','Quiz/Survey Status Has Been Updated','543','JLPT Test N1 #27','','01:58:10 PM 02/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1093,'arfi','New Quiz/Survey Has Been Created','544','JLPT Test N1 #29','','01:59:47 PM 02/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1094,'arfi','Quiz/Survey Status Has Been Updated','544','JLPT Test N1 #29','','03:03:23 PM 02/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1095,'arfi','New Quiz/Survey Has Been Created','545','Official Test Desember 2018 N3','','08:33:01 PM 02/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1096,'arfi','Quiz/Survey Status Has Been Updated','545','Official Test Desember 2018 N3','','09:17:01 PM 02/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1097,'arfi','New Quiz/Survey Has Been Created','546','Official Test Desember 2017 N3','','09:18:12 PM 02/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1098,'arfi','Quiz/Survey Status Has Been Updated','546','Official Test Desember 2017 N3','','10:14:58 PM 02/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1099,'arfi','New Quiz/Survey Has Been Created','547','Official Test Desember 2016 N3','','10:16:11 PM 02/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1100,'arfi','Quiz/Survey Status Has Been Updated','547','Official Test Desember 2016 N3','','11:09:16 PM 02/01/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1101,'arfi','New Quiz/Survey Has Been Created','548','Official Test Desember 2015 N3','','07:44:40 AM 02/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1102,'arfi','Quiz/Survey Status Has Been Updated','548','Official Test Desember 2015 N3','','08:54:28 AM 02/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1103,'arfi','New Quiz/Survey Has Been Created','549','Official Test Desember 2014 N3','','08:55:44 AM 02/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1104,'arfi','Quiz/Survey Status Has Been Updated','549','Official Test Desember 2014 N3','','12:56:30 PM 02/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1105,'arfi','New Quiz/Survey Has Been Created','550','Official Test Desember 2013 N3','','01:21:20 PM 02/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1106,'arfi','Quiz/Survey Status Has Been Updated','550','Official Test Desember 2013 N3','','02:40:29 PM 02/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1107,'arfi','New Quiz/Survey Has Been Created','551','Official Test Desember 2012 N3','','02:42:59 PM 02/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1108,'arfi','Quiz/Survey Status Has Been Updated','551','Official Test Desember 2012 N3','','03:37:53 PM 02/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1109,'arfi','New Quiz/Survey Has Been Created','552','Official Test Desember 2011 N3','','03:39:09 PM 02/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1110,'arfi','Quiz/Survey Status Has Been Updated','552','Official Test Desember 2011 N3','','04:26:36 PM 02/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1111,'arfi','New Quiz/Survey Has Been Created','553','Official Test Juli 2010 N3','','04:28:10 PM 02/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1112,'arfi','Quiz/Survey Status Has Been Updated','553','Official Test Juli 2010 N3','','05:13:10 PM 02/02/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1113,'arfi','New Quiz/Survey Has Been Created','554','Mock Test JLPT Test N3 #1','','08:49:00 AM 02/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1114,'arfi','Quiz/Survey Status Has Been Updated','554','Mock Test JLPT Test N3 #1','','09:30:09 AM 02/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1115,'arfi','New Quiz/Survey Has Been Created','555','Mock Test JLPT Test N3 #3','','09:31:33 AM 02/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1116,'arfi','Quiz/Survey Status Has Been Updated','555','Mock Test JLPT Test N3 #3','','08:38:02 PM 02/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1117,'arfi','New Quiz/Survey Has Been Created','556','Mock Test JLPT Test N3 #5','','08:39:43 PM 02/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1118,'arfi','Quiz/Survey Status Has Been Updated','556','Mock Test JLPT Test N3 #5','','09:46:17 PM 02/03/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1119,'arfi','New Quiz/Survey Has Been Created','557','Mock Test JLPT Test N3 #7','','09:21:36 AM 02/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1120,'arfi','Quiz/Survey Status Has Been Updated','557','Mock Test JLPT Test N3 #7','','10:14:26 AM 02/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1121,'arfi','New Quiz/Survey Has Been Created','558','Mock Test JLPT Test N3 #9','','10:15:28 AM 02/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1122,'arfi','Quiz/Survey Status Has Been Updated','558','Mock Test JLPT Test N3 #9','','12:39:31 PM 02/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1123,'arfi','New Quiz/Survey Has Been Created','559','Mock Test JLPT Test N3 #11','','12:40:50 PM 02/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1124,'arfi','Quiz/Survey Status Has Been Updated','559','Mock Test JLPT Test N3 #11','','02:09:02 PM 02/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1125,'arfi','New Quiz/Survey Has Been Created','560','Mock Test JLPT Test N3 #13','','02:10:25 PM 02/04/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1126,'arfi','Quiz/Survey Status Has Been Updated','560','Mock Test JLPT Test N3 #13','','07:48:56 AM 02/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1127,'arfi','New Quiz/Survey Has Been Created','561','Mock Test JLPT Test N3 #15','','07:50:07 AM 02/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1128,'arfi','Quiz/Survey Status Has Been Updated','561','Mock Test JLPT Test N3 #15','','08:28:40 AM 02/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1129,'arfi','Quiz/Survey Status Has Been Updated','561','Mock Test JLPT Test N3 #15','','08:28:40 AM 02/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1130,'arfi','New Quiz/Survey Has Been Created','562','Mock Test JLPT Test N3 #17','','08:30:19 AM 02/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1131,'arfi','Quiz/Survey Status Has Been Updated','562','Mock Test JLPT Test N3 #17','','09:14:20 AM 02/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1132,'arfi','New Quiz/Survey Has Been Created','563','Mock Test JLPT Test N3 #19','','09:16:08 AM 02/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1133,'arfi','Quiz/Survey Status Has Been Updated','563','Mock Test JLPT Test N3 #19','','12:51:54 PM 02/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1134,'arfi','New Quiz/Survey Has Been Created','564','Mock Test JLPT Test N3 #21','','12:52:58 PM 02/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1135,'arfi','Quiz/Survey Status Has Been Updated','564','Mock Test JLPT Test N3 #21','','02:33:47 PM 02/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1136,'arfi','New Quiz/Survey Has Been Created','565','Mock Test JLPT Test N3 #23','','02:37:17 PM 02/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1137,'arfi','Quiz/Survey Status Has Been Updated','565','Mock Test JLPT Test N3 #23','','03:27:19 PM 02/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1138,'arfi','New Quiz/Survey Has Been Created','566','Mock Test JLPT Test N3 #25','','07:30:06 PM 02/05/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1139,'arfi','Quiz/Survey Status Has Been Updated','566','Mock Test JLPT Test N3 #25','','05:40:54 AM 02/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1140,'arfi','New Quiz/Survey Has Been Created','567','Mock Test JLPT Test N3 #27','','05:41:56 AM 02/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1141,'arfi','Quiz/Survey Status Has Been Updated','567','Mock Test JLPT Test N3 #27','','06:34:52 AM 02/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1142,'arfi','New Quiz/Survey Has Been Created','568','Mock Test JLPT Test N3 #29','','06:36:44 AM 02/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1143,'arfi','Quiz/Survey Status Has Been Updated','568','Mock Test JLPT Test N3 #29','','07:36:43 AM 02/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1144,'arfi','New Quiz/Survey Has Been Created','569','Official Test Desember 2016 N2','','09:37:20 AM 02/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1145,'arfi','Quiz/Survey Status Has Been Updated','569','Official Test Desember 2016 N2','','11:33:18 AM 02/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1146,'arfi','New Quiz/Survey Has Been Created','570','Official Test Desember 2014 N2','','11:34:59 AM 02/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1147,'arfi','Quiz/Survey Status Has Been Updated','570','Official Test Desember 2014 N2','','06:10:11 PM 02/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1148,'arfi','New Quiz/Survey Has Been Created','571','Official Test Juli 2013 N2','','06:11:44 PM 02/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1149,'arfi','Quiz/Survey Status Has Been Updated','571','Official Test Juli 2013 N2','','07:21:47 PM 02/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1150,'arfi','New Quiz/Survey Has Been Created','572','Official Test Desember 2011 N2','','07:24:24 PM 02/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1151,'arfi','Quiz/Survey Status Has Been Updated','572','Official Test Desember 2011 N2','','08:23:11 PM 02/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1152,'arfi','New Quiz/Survey Has Been Created','573','Official Test Desember 2010 N2','','08:25:14 PM 02/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1153,'arfi','Quiz/Survey Status Has Been Updated','573','Official Test Desember 2010 N2','','09:09:22 PM 02/06/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1154,'arfi','New Quiz/Survey Has Been Created','574','Mock Test JLPT Test N2 #1','','07:18:42 AM 02/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1155,'arfi','Quiz/Survey Status Has Been Updated','574','Mock Test JLPT Test N2 #1','','08:22:12 AM 02/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1156,'arfi','New Quiz/Survey Has Been Created','575','Mock Test JLPT Test N2 #3','','08:24:23 AM 02/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1157,'arfi','Quiz/Survey Status Has Been Updated','575','Mock Test JLPT Test N2 #3','','09:08:48 AM 02/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1158,'arfi','New Quiz/Survey Has Been Created','576','Mock Test JLPT Test N2 #5','','09:10:33 AM 02/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1159,'arfi','Quiz/Survey Status Has Been Updated','576','Mock Test JLPT Test N2 #5','','10:31:17 AM 02/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1160,'arfi','New Quiz/Survey Has Been Created','577','Mock Test JLPT Test N2 #7','','12:23:57 PM 02/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1161,'arfi','Quiz/Survey Status Has Been Updated','577','Mock Test JLPT Test N2 #7','','02:58:50 PM 02/07/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1162,'arfi','New Quiz/Survey Has Been Created','578','Mock Test JLPT Test N2 #9','','09:28:43 AM 02/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1163,'arfi','Quiz/Survey Status Has Been Updated','578','Mock Test JLPT Test N2 #9','','10:20:54 AM 02/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1164,'arfi','New Quiz/Survey Has Been Created','579','Mock Test JLPT Test N2 #11','','10:21:46 AM 02/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1165,'arfi','Quiz/Survey Status Has Been Updated','579','Mock Test JLPT Test N2 #11','','12:52:46 PM 02/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1166,'arfi','New Quiz/Survey Has Been Created','580','Mock Test JLPT Test N2 #13','','12:54:01 PM 02/08/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1167,'arfi','Quiz/Survey Status Has Been Updated','580','Mock Test JLPT Test N2 #13','','06:57:18 AM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1168,'arfi','New Quiz/Survey Has Been Created','581','Mock Test JLPT Test N2 #15','','06:58:07 AM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1169,'arfi','Quiz/Survey Status Has Been Updated','581','Mock Test JLPT Test N2 #15','','07:52:48 AM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1170,'arfi','New Quiz/Survey Has Been Created','582','Mock Test JLPT Test N2 #17','','07:53:42 AM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1171,'arfi','Quiz/Survey Status Has Been Updated','582','Mock Test JLPT Test N2 #17','','08:29:20 AM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1172,'arfi','New Quiz/Survey Has Been Created','583','Mock Test JLPT Test N2 #19','','08:30:31 AM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1173,'arfi','Quiz/Survey Status Has Been Updated','583','Mock Test JLPT Test N2 #19','','09:03:50 AM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1174,'arfi','New Quiz/Survey Has Been Created','584','Mock Test JLPT Test N2 #21','','09:09:34 AM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1175,'arfi','Quiz/Survey Status Has Been Updated','584','Mock Test JLPT Test N2 #21','','09:46:55 AM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1176,'arfi','New Quiz/Survey Has Been Created','585','Mock Test JLPT Test N2 #23','','11:56:32 AM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1177,'arfi','Quiz/Survey Status Has Been Updated','585','Mock Test JLPT Test N2 #23','','12:34:38 PM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1178,'arfi','New Quiz/Survey Has Been Created','586','Mock Test JLPT Test N2 #25','','12:36:12 PM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1179,'arfi','Quiz/Survey Status Has Been Updated','586','Mock Test JLPT Test N2 #25','','01:47:31 PM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1180,'arfi','New Quiz/Survey Has Been Created','587','Mock Test JLPT Test N2 #27','','01:51:28 PM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1181,'arfi','Quiz/Survey Status Has Been Updated','587','Mock Test JLPT Test N2 #27','','02:46:12 PM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1182,'arfi','Quiz/Survey Status Has Been Updated','587','Mock Test JLPT Test N2 #27','','02:46:14 PM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1183,'arfi','New Quiz/Survey Has Been Created','588','Mock Test JLPT Test N2 #29','','02:47:27 PM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1184,'arfi','Quiz/Survey Status Has Been Updated','588','Mock Test JLPT Test N2 #29','','03:40:21 PM 02/09/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1185,'arfi','New Quiz/Survey Has Been Created','589','Official Test Juli 2017 N1','','06:12:43 PM 02/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1186,'arfi','Quiz/Survey Status Has Been Updated','589','Official Test Juli 2017 N1','','06:59:47 PM 02/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1187,'arfi','New Quiz/Survey Has Been Created','590','Official Test Juli 2016 N1','','07:04:24 PM 02/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1188,'arfi','Quiz/Survey Status Has Been Updated','590','Official Test Juli 2016 N1','','08:07:54 PM 02/11/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1189,'arfi','New Quiz/Survey Has Been Created','592','Official Test Desember 2015 N1','','05:57:52 AM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1190,'arfi','New Quiz/Survey Has Been Created','591','Official Test Desember 2015 N1','','05:57:52 AM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1191,'arfi','New Quiz/Survey Has Been Created','594','Official Test Desember 2015 N1','','05:59:22 AM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1192,'arfi','New Quiz/Survey Has Been Created','593','Official Test Desember 2015 N1','','05:59:22 AM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1193,'arfi','Quiz/Survey Has Been Deleted: Official Test Desember 2015 N1','592','','','06:01:26 AM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1194,'arfi','Quiz/Survey Has Been Deleted: Official Test Desember 2015 N1','594','','','06:02:11 AM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1195,'arfi','Quiz/Survey Has Been Deleted: Official Test Desember 2015 N1','593','','','06:02:11 AM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1196,'arfi','Quiz/Survey Has Been Deleted: Official Test Desember 2015 N1','594','','','06:03:46 AM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1197,'arfi','Quiz/Survey Has Been Deleted: Official Test Desember 2015 N1','591','Official Test Desember 2015 N1','','06:04:41 AM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1198,'arfi','New Quiz/Survey Has Been Created','595','Official Test Desember 2015 N1','','06:05:45 AM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1199,'arfi','Quiz/Survey Status Has Been Updated','595','Official Test Desember 2015 N1','','07:56:29 AM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1200,'arfi','New Quiz/Survey Has Been Created','596','Official Test Desember 2014 N1','','08:08:11 AM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1201,'arfi','Quiz/Survey Status Has Been Updated','596','Official Test Desember 2014 N1','','08:58:00 AM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1202,'arfi','New Quiz/Survey Has Been Created','597','Official Test Juli 2013 N1','','08:59:17 AM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1203,'arfi','Quiz/Survey Status Has Been Updated','597','Official Test Juli 2013 N1','','12:45:53 PM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1204,'arfi','New Quiz/Survey Has Been Created','598','Official Test Juli 2012 N1','','12:47:06 PM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1205,'arfi','Quiz/Survey Status Has Been Updated','598','Official Test Juli 2012 N1','','01:42:07 PM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1206,'arfi','New Quiz/Survey Has Been Created','599','Official Test Desember 2011 N1','','01:44:31 PM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1207,'arfi','Quiz/Survey Status Has Been Updated','599','Official Test Desember 2011 N1','','02:30:02 PM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1208,'arfi','New Quiz/Survey Has Been Created','600','Official Test Desember 2010 N1','','02:31:38 PM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1209,'arfi','Quiz/Survey Status Has Been Updated','600','Official Test Desember 2010 N1','','04:25:02 PM 02/12/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1210,'arfi','New Quiz/Survey Has Been Created','601','Mock Test JLPT Test N1 #1','','07:07:31 AM 02/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1211,'arfi','Quiz/Survey Status Has Been Updated','601','Mock Test JLPT Test N1 #1','','07:59:12 AM 02/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1212,'arfi','New Quiz/Survey Has Been Created','602','Mock Test JLPT Test N1 #3','','08:01:03 AM 02/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1213,'arfi','Quiz/Survey Status Has Been Updated','602','Mock Test JLPT Test N1 #3','','08:59:41 AM 02/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1214,'arfi','New Quiz/Survey Has Been Created','603','Mock Test JLPT Test N1 #5','','09:00:52 AM 02/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1215,'arfi','Quiz/Survey Status Has Been Updated','603','Mock Test JLPT Test N1 #5','','10:09:32 AM 02/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1216,'arfi','New Quiz/Survey Has Been Created','604','Mock Test JLPT Test N1 #7','','10:10:36 AM 02/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1217,'arfi','Quiz/Survey Status Has Been Updated','604','Mock Test JLPT Test N1 #7','','11:26:44 AM 02/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1218,'arfi','New Quiz/Survey Has Been Created','605','Mock Test JLPT Test N1 #9','','02:07:42 PM 02/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1219,'arfi','Quiz/Survey Status Has Been Updated','605','Mock Test JLPT Test N1 #9','','02:55:36 PM 02/13/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1220,'arfi','New Quiz/Survey Has Been Created','606','Mock Test JLPT Test N1 #11','','04:50:46 AM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1221,'arfi','Quiz/Survey Status Has Been Updated','606','Mock Test JLPT Test N1 #11','','05:31:26 AM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1222,'arfi','New Quiz/Survey Has Been Created','607','Mock Test JLPT Test N1 #13','','05:32:23 AM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1223,'arfi','Quiz/Survey Status Has Been Updated','607','Mock Test JLPT Test N1 #13','','06:26:39 AM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1224,'arfi','New Quiz/Survey Has Been Created','608','Mock Test JLPT Test N1 #15','','06:28:15 AM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1225,'arfi','Quiz/Survey Status Has Been Updated','608','Mock Test JLPT Test N1 #15','','07:16:49 AM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1226,'arfi','Quiz/Survey Status Has Been Updated','608','Mock Test JLPT Test N1 #15','','07:17:03 AM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1227,'arfi','New Quiz/Survey Has Been Created','609','Mock Test JLPT Test N1 #17','','07:18:22 AM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1228,'arfi','Quiz/Survey Status Has Been Updated','609','Mock Test JLPT Test N1 #17','','08:33:15 AM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1229,'arfi','New Quiz/Survey Has Been Created','610','Mock Test JLPT Test N1 #19','','08:34:03 AM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1230,'arfi','Quiz/Survey Status Has Been Updated','610','Mock Test JLPT Test N1 #19','','11:44:41 AM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1231,'arfi','New Quiz/Survey Has Been Created','611','Mock Test JLPT Test N1 #21','','11:45:33 AM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1232,'arfi','Quiz/Survey Status Has Been Updated','611','Mock Test JLPT Test N1 #21','','12:42:21 PM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1233,'arfi','New Quiz/Survey Has Been Created','612','Mock Test JLPT Test N1 #23','','12:44:10 PM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1234,'arfi','New Quiz/Survey Has Been Created','613','Mock Test JLPT Test N1 #23','','12:44:10 PM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1235,'arfi','Quiz/Survey Status Has Been Updated','613','Mock Test JLPT Test N1 #23','','01:23:02 PM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1236,'arfi','New Quiz/Survey Has Been Created','614','Mock Test JLPT Test N1 #25','','01:23:53 PM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1237,'arfi','Quiz/Survey Status Has Been Updated','614','Mock Test JLPT Test N1 #25','','02:02:35 PM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1238,'arfi','New Quiz/Survey Has Been Created','615','Mock Test JLPT Test N1 #27','','02:03:46 PM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1239,'arfi','Quiz/Survey Status Has Been Updated','615','Mock Test JLPT Test N1 #27','','02:45:20 PM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1240,'arfi','New Quiz/Survey Has Been Created','616','Mock Test JLPT Test N1 #29','','02:46:09 PM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1241,'arfi','Quiz/Survey Status Has Been Updated','616','Mock Test JLPT Test N1 #29','','03:27:33 PM 02/14/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1242,'arfi','Quiz/Survey Has Been Deleted: Mock Test JLPT Test N1 #23','612','Mock Test JLPT Test N1 #23','','12:15:48 PM 02/21/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1243,'arfi','New Quiz/Survey Has Been Created','617','Grammar - JLPT N4 #10','','12:18:54 PM 02/21/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1244,'arfi','Quiz/Survey Status Has Been Updated','617','Grammar - JLPT N4 #10','','12:45:15 PM 02/21/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1245,'arfi','New Quiz/Survey Has Been Created','618','Grammar - JLPT N5 #12','','12:46:38 PM 02/21/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1246,'arfi','Quiz/Survey Status Has Been Updated','618','Grammar - JLPT N5 #12','','01:11:26 PM 02/21/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1247,'arfi','New Quiz/Survey Has Been Created','619','Grammar - JLPT N4 #14','','01:12:05 PM 02/21/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1248,'arfi','Quiz/Survey Status Has Been Updated','619','Grammar - JLPT N4 #14','','01:45:37 PM 02/21/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1249,'arfi','New Quiz/Survey Has Been Created','620','Grammar - JLPT N4 #16','','01:46:09 PM 02/21/2025');
INSERT INTO `wpbl_mlw_qm_audit_trail` VALUES (1250,'arfi','Quiz/Survey Status Has Been Updated','620','Grammar - JLPT N4 #16','','02:19:30 PM 02/21/2025');
/*!40000 ALTER TABLE `wpbl_mlw_qm_audit_trail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_actionscheduler_actions`
--

DROP TABLE IF EXISTS `wpbl_actionscheduler_actions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=194 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_actionscheduler_actions`
--

LOCK TABLES `wpbl_actionscheduler_actions` WRITE;
/*!40000 ALTER TABLE `wpbl_actionscheduler_actions` DISABLE KEYS */;
INSERT INTO `wpbl_actionscheduler_actions` VALUES (193,'action_scheduler/migration_hook','complete','2024-11-20 21:25:31','2024-11-20 21:25:31','[]','O:30:"ActionScheduler_SimpleSchedule":2:{s:22:"\0*\0scheduled_timestamp";i:1732137931;s:41:"\0ActionScheduler_SimpleSchedule\0timestamp";i:1732137931;}',1,1,'2024-11-20 21:25:31','2024-11-20 21:25:31',0,NULL);
/*!40000 ALTER TABLE `wpbl_actionscheduler_actions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_e_notes`
--

DROP TABLE IF EXISTS `wpbl_e_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text DEFAULT NULL COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) NOT NULL DEFAULT 'publish',
  `position` text DEFAULT NULL COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_e_notes`
--

LOCK TABLES `wpbl_e_notes` WRITE;
/*!40000 ALTER TABLE `wpbl_e_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_e_notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_e_submissions`
--

DROP TABLE IF EXISTS `wpbl_e_submissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_e_submissions`
--

LOCK TABLES `wpbl_e_submissions` WRITE;
/*!40000 ALTER TABLE `wpbl_e_submissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `wpbl_e_submissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_mlw_results`
--

DROP TABLE IF EXISTS `wpbl_mlw_results`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_mlw_results` (
  `result_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `quiz_id` int(11) NOT NULL,
  `quiz_name` longtext NOT NULL,
  `quiz_system` int(11) NOT NULL,
  `point_score` float NOT NULL,
  `correct_score` int(11) NOT NULL,
  `correct` int(11) NOT NULL,
  `total` int(11) NOT NULL,
  `name` longtext NOT NULL,
  `business` longtext NOT NULL,
  `email` longtext NOT NULL,
  `phone` longtext NOT NULL,
  `user` int(11) NOT NULL,
  `user_ip` longtext NOT NULL,
  `time_taken` longtext NOT NULL,
  `time_taken_real` datetime NOT NULL,
  `quiz_results` longtext NOT NULL,
  `deleted` int(11) NOT NULL,
  `unique_id` varchar(100) NOT NULL,
  `form_type` int(11) NOT NULL,
  `page_name` varchar(255) NOT NULL,
  `page_url` varchar(255) NOT NULL,
  PRIMARY KEY (`result_id`),
  UNIQUE KEY `unique_id` (`unique_id`),
  UNIQUE KEY `unique_id_2` (`unique_id`),
  UNIQUE KEY `unique_id_3` (`unique_id`),
  UNIQUE KEY `unique_id_4` (`unique_id`),
  UNIQUE KEY `unique_id_5` (`unique_id`),
  UNIQUE KEY `unique_id_6` (`unique_id`),
  UNIQUE KEY `unique_id_7` (`unique_id`),
  UNIQUE KEY `unique_id_8` (`unique_id`),
  UNIQUE KEY `unique_id_9` (`unique_id`),
  UNIQUE KEY `unique_id_10` (`unique_id`),
  UNIQUE KEY `unique_id_11` (`unique_id`),
  UNIQUE KEY `unique_id_12` (`unique_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_mlw_results`
--

LOCK TABLES `wpbl_mlw_results` WRITE;
/*!40000 ALTER TABLE `wpbl_mlw_results` DISABLE KEYS */;
INSERT INTO `wpbl_mlw_results` VALUES (1,3,'jlpt n5 coba',3,1,25,1,4,'arfi','None','admin@kumabenkyou.com','None',1,'14.9.212.224','05:52:59 AM 11/21/2024','2024-11-21 05:52:59','a:11:{i:0;i:71;i:1;a:4:{i:0;a:15:{i:0;s:0:"";i:1;s:1:"1";i:2;s:1:"1";i:3;s:0:"";s:11:"user_answer";a:1:{i:0;s:1:"1";}s:14:"correct_answer";a:1:{i:0;s:1:"1";}s:7:"correct";s:7:"correct";s:2:"id";s:1:"7";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:1:"1";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:1;a:15:{i:0;s:0:"";i:1;s:1:"3";i:2;s:1:"2";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:1:"3";}s:14:"correct_answer";a:1:{i:0;s:1:"2";}s:7:"correct";s:9:"incorrect";s:2:"id";s:1:"8";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:1:"2";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:2;a:15:{i:0;s:93:"[audio wav=&quot;https://kumabenkyou.com/wp-content/uploads/2024/11/jiro-1.wav&quot;][/audio]";i:1;s:1:"w";i:2;s:1:"q";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:1:"w";}s:14:"correct_answer";a:1:{i:0;s:1:"q";}s:7:"correct";s:9:"incorrect";s:2:"id";s:1:"9";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:1:"q";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:3;a:15:{i:0;s:0:"";i:1;s:1:"e";i:2;s:1:"w";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:1:"e";}s:14:"correct_answer";a:1:{i:0;s:1:"w";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"10";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:1:"w";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}}i:2;s:0:"";s:7:"contact";a:0:{}s:8:"timer_ms";i:1732168343246;s:8:"pagetime";a:0:{}s:16:"hidden_questions";N;s:21:"total_possible_points";d:6;s:25:"total_attempted_questions";i:4;s:23:"minimum_possible_points";i:0;s:15:"quiz_start_date";s:22:"05:52:19 AM 11/21/2024";}',0,'673eca9563ea9',0,'jlpt n5 coba','https://kumabenkyou.com/?post_type=qsm_quiz&p=256');
INSERT INTO `wpbl_mlw_results` VALUES (2,5,'kanji n5 1',3,0,0,0,33,'arfi','None','admin@kumabenkyou.com','None',1,'14.9.212.224','07:24:28 AM 11/23/2024','2024-11-23 07:24:28','a:11:{i:0;i:13;i:1;a:33:{i:0;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"44";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:115:"問題: 1＿＿＿の言葉の読み方として最もよいものを、1・2・3・4から一つ選びなさい。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:1;a:15:{i:0;s:0:"";i:1;s:15:"1. きしゅう";i:2;s:18:"2. らいしゅう";i:3;s:0:"";s:11:"user_answer";a:1:{i:0;s:15:"1. きしゅう";}s:14:"correct_answer";a:1:{i:1;s:18:"2. らいしゅう";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"12";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:53:"1. ( 来週 ) は　いそがしく　なります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:2;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"3. そら";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:9:"3. そら";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"13";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:74:"2. きょうは　( 空 ) の　いろが　とても　きれいです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:3;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"2. ごにん";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:12:"2. ごにん";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"14";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:55:"3. おとこの　ひとが　( 五人 )　います。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:4;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"2. びょういん";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:18:"2. びょういん";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"15";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:56:"4. ( 病院 ) の　いりぐちは　どこですか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:5;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"4. かわ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:9:"4. かわ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"16";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:35:"5. ( 川 ) で　およぎます。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:6;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"4. ゆうがた";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:15:"4. ゆうがた";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"17";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:59:"6. ( 夕方 ) 、いぬの　さんぽに　いきます。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:7;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"1. ようか";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:12:"1. ようか";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"18";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:62:"7. らいげつの　( 八日 ) に　けっこんします。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:8;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"2. いっぽん";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:15:"2. いっぽん";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"19";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:67:"8. うちに　おおきな　きが　( 一本 )　あります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:9;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"2. いって";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:12:"2. いって";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"20";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:67:"9. わたしと　いっしょに　( 行って )　ください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:10;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"4. せんしゅう";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:18:"4. せんしゅう";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"21";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:60:"10. ( 先週 ) の　げつようびは　やすみでした";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:11;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"2. とし";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:9:"2. とし";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"22";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:54:"11. あたらしい　( 年 ) に　なりました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:12;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"2. きた";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:9:"2. きた";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"23";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:53:"12. この　みちを　( 北 )へ　いきます。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:13;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"3. こんげつ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:15:"3. こんげつ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"24";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:57:"13. ( 今月 ) なつやすみが　はじまります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:14;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"3. らいしゅう";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:18:"3. らいしゅう";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"25";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:41:"14. ( 来週 )、はたらきません。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:15;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"2. りょこう";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:15:"2. りょこう";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"26";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:33:"15. ( 旅行 ) したいです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:16;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"3. ふるい";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:12:"3. ふるい";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"27";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:48:"16. この　ホテルは　( 古い ) です。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:17;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"1. くに";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:9:"1. くに";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"28";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:63:"17. わたしの　( 国 ) は　ふゆが　ありません。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:18;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"1. きのう";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:12:"1. きのう";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"29";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:48:"18. ( 昨日 ) は  学校が  休みでした";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:19;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"1. なまえ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:12:"1. なまえ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"30";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:48:"19. ( 名前 ) を　おしえてください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:20;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"3. せいかつ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:15:"3. せいかつ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"31";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:51:"20. 日本の　( 生活 ) は　どうですか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:21;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"3. はいります";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:18:"3. はいります";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"32";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:50:"21. 今から　おふろに　( 入ります )。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:22;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:24:"2. いちじかんはん";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:24:"2. いちじかんはん";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"33";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:77:"22. うちから　がっこうまで　( １時間半 )　かかります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:23;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"2. ひだり";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:12:"2. ひだり";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"34";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:75:"23. その　しんごうを　( 左 ) に　まがって　ください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:24;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"4. あいだ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:12:"4. あいだ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"35";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:78:"24. えきと　コンビニの　( 間 ) に　はなやが　あります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:25;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"36";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:51:"25. この　( 大学 ) は　ゆうめいです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:26;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"1. いつか";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:12:"1. いつか";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"37";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:51:"26. まいつき　( 五日 ) は　休みです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:27;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"4. そと";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:9:"4. そと";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"38";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:54:"27. いえの　( 外 ) に　いぬが　います。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:28;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"2. はな";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:9:"2. はな";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"39";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:48:"28. あの　( 花 ) は　きれいですね。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:29;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"3. ごご";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:9:"3. ごご";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"40";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:53:"29. ( 午後 )　がっこうは　やすみです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:30;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"41";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:119:"問題: 2＿＿＿の言葉を漢字で書く時、最もよいものを、1・2・3・4から一つ 選びなさい。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:31;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"42";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:0:"";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:32;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"43";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:0:"";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}}i:2;s:0:"";s:7:"contact";a:0:{}s:8:"timer_ms";i:1732346652753;s:8:"pagetime";a:0:{}s:16:"hidden_questions";N;s:21:"total_possible_points";d:29;s:25:"total_attempted_questions";i:1;s:23:"minimum_possible_points";i:0;s:15:"quiz_start_date";s:22:"07:24:11 AM 11/23/2024";}',0,'6741831cf1886',0,'kanji n5 1','https://kumabenkyou.com/qsm_quiz/kanji-n5-1/');
INSERT INTO `wpbl_mlw_results` VALUES (3,5,'kanji n5 1',3,0,0,0,51,'arfi','None','admin@kumabenkyou.com','None',1,'14.9.212.224','08:21:44 AM 11/23/2024','2024-11-23 08:21:44','a:11:{i:0;i:20;i:1;a:51:{i:0;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"44";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:115:"問題: 1＿＿＿の言葉の読み方として最もよいものを、1・2・3・4から一つ選びなさい。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:1;a:15:{i:0;s:0:"";i:1;s:15:"1. きしゅう";i:2;s:18:"2. らいしゅう";i:3;s:0:"";s:11:"user_answer";a:1:{i:0;s:15:"1. きしゅう";}s:14:"correct_answer";a:1:{i:1;s:18:"2. らいしゅう";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"12";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:53:"1. ( 来週 ) は　いそがしく　なります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:2;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"3. そら";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:9:"3. そら";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"13";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:74:"2. きょうは　( 空 ) の　いろが　とても　きれいです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:3;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"2. ごにん";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:12:"2. ごにん";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"14";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:55:"3. おとこの　ひとが　( 五人 )　います。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:4;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"2. びょういん";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:18:"2. びょういん";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"15";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:56:"4. ( 病院 ) の　いりぐちは　どこですか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:5;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"4. かわ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:9:"4. かわ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"16";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:35:"5. ( 川 ) で　およぎます。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:6;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"4. ゆうがた";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:15:"4. ゆうがた";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"17";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:59:"6. ( 夕方 ) 、いぬの　さんぽに　いきます。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:7;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"1. ようか";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:12:"1. ようか";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"18";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:62:"7. らいげつの　( 八日 ) に　けっこんします。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:8;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"2. いっぽん";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:15:"2. いっぽん";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"19";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:67:"8. うちに　おおきな　きが　( 一本 )　あります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:9;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"2. いって";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:12:"2. いって";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"20";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:67:"9. わたしと　いっしょに　( 行って )　ください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:10;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"4. せんしゅう";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:18:"4. せんしゅう";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"21";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:60:"10. ( 先週 ) の　げつようびは　やすみでした";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:11;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"2. とし";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:9:"2. とし";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"22";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:54:"11. あたらしい　( 年 ) に　なりました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:12;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"2. きた";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:9:"2. きた";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"23";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:53:"12. この　みちを　( 北 )へ　いきます。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:13;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"3. こんげつ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:15:"3. こんげつ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"24";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:57:"13. ( 今月 ) なつやすみが　はじまります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:14;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"3. らいしゅう";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:18:"3. らいしゅう";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"25";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:41:"14. ( 来週 )、はたらきません。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:15;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"2. りょこう";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:15:"2. りょこう";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"26";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:33:"15. ( 旅行 ) したいです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:16;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"3. ふるい";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:12:"3. ふるい";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"27";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:48:"16. この　ホテルは　( 古い ) です。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:17;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"1. くに";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:9:"1. くに";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"28";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:63:"17. わたしの　( 国 ) は　ふゆが　ありません。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:18;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"1. きのう";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:12:"1. きのう";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"29";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:48:"18. ( 昨日 ) は  学校が  休みでした";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:19;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"1. なまえ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:12:"1. なまえ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"30";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:48:"19. ( 名前 ) を　おしえてください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:20;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"3. せいかつ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:15:"3. せいかつ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"31";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:51:"20. 日本の　( 生活 ) は　どうですか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:21;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"3. はいります";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:18:"3. はいります";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"32";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:50:"21. 今から　おふろに　( 入ります )。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:22;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:24:"2. いちじかんはん";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:24:"2. いちじかんはん";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"33";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:77:"22. うちから　がっこうまで　( １時間半 )　かかります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:23;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"2. ひだり";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:12:"2. ひだり";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"34";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:75:"23. その　しんごうを　( 左 ) に　まがって　ください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:24;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"4. あいだ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:12:"4. あいだ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"35";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:78:"24. えきと　コンビニの　( 間 ) に　はなやが　あります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:25;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"36";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:51:"25. この　( 大学 ) は　ゆうめいです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:26;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"1. いつか";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:12:"1. いつか";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"37";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:51:"26. まいつき　( 五日 ) は　休みです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:27;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"4. そと";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:9:"4. そと";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"38";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:54:"27. いえの　( 外 ) に　いぬが　います。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:28;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"2. はな";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:9:"2. はな";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"39";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:48:"28. あの　( 花 ) は　きれいですね。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:29;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"3. ごご";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:9:"3. ごご";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"40";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:53:"29. ( 午後 )　がっこうは　やすみです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:30;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"41";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:119:"問題: 2＿＿＿の言葉を漢字で書く時、最もよいものを、1・2・3・4から一つ 選びなさい。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:31;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"2. 少し";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:9:"2. 少し";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"42";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:58:"１．えいごは　（ すこし ) はなします１．";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:32;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:6:"1. 道";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:6:"1. 道";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"43";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:70:"2. この　( みち )を　まっすぐ　いって　ください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:33;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"2. タクシー";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:15:"2. タクシー";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"45";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:44:"3. ( たくしー ) で　かえります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:34;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"4. 買い物";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:12:"4. 買い物";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"46";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:59:"4. ともだちと　( かいもの ) を　しました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:35;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"3. 行きます";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:15:"3. 行きます";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"47";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:55:"5. これから　がっこうへ　( いきます )。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:36;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:6:"2. 書";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:6:"2. 書";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"48";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:52:"6. きょう、てがみを　( か )きました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:37;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"4. 先週";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:9:"4. 先週";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"49";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:61:"7. ( せんしゅう )　きょうとへ　いきました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:38;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"4. 出します";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:15:"4. 出します";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"50";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:70:"8. かばんの　なかから　のみものを　( だします )。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:39;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"1. 新しい";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:12:"1. 新しい";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"51";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:58:"9. ( あたらしい )　テレビを　かいました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:40;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"3. 高い";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:9:"3. 高い";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"52";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:65:"10. ふじさんは　いちばん　( たかい )　山です。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:41;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:21:"3. エレベーター";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:21:"3. エレベーター";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"53";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:54:"11. ( えれべーたー ) で　いきましょう。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:42;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"2. 日よう日";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:15:"2. 日よう日";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"54";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:57:"12. ( にちようび ) は　いつも　ひまです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:43;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"1. シャワー";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:15:"1. シャワー";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"55";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:57:"13. ( しゃわー ) の　そうじを　しました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:44;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:6:"2. 口";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:6:"2. 口";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"56";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:51:"14. ( くち ) を　おおきく　あけます。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:45;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"1. 長い";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:9:"1. 長い";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"57";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:45:"15. この　川は　( ながい ) です。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:46;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:6:"1. 西";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:6:"1. 西";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"58";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:75:"16. わたしの　うちは　東京の　( にし ) に　あります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:47;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"3. 聞きます";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:15:"3. 聞きます";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"59";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:53:"17. まいばん　ラジオを　( ききます )。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:48;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"2. 電車";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:9:"2. 電車";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"60";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:75:"18. あの　あかい　( でんしゃ ) に　のって　ください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:49;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"3. レストラン";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:18:"3. レストラン";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"61";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:59:"19. あの　( れすとらん )に　入りましょう。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:50;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:6:"2. 何";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:6:"2. 何";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"62";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:62:"20. この　かんじの　いみは　( なん )ですか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}}i:2;s:0:"";s:7:"contact";a:0:{}s:8:"timer_ms";i:1732350081712;s:8:"pagetime";a:0:{}s:16:"hidden_questions";N;s:21:"total_possible_points";d:49;s:25:"total_attempted_questions";i:1;s:23:"minimum_possible_points";i:0;s:15:"quiz_start_date";s:22:"08:21:18 AM 11/23/2024";}',0,'674190809813f',0,'kanji n5 1','https://kumabenkyou.com/qsm_quiz/kanji-n5-1/');
INSERT INTO `wpbl_mlw_results` VALUES (4,5,'kanji n5 1',3,41,78,40,51,'Rinn','None','None','None',0,'180.249.187.198','10:44:42 AM 11/23/2024','2024-11-23 10:44:42','a:11:{i:0;i:1330;i:1;a:51:{i:0;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"44";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:115:"問題: 1＿＿＿の言葉の読み方として最もよいものを、1・2・3・4から一つ選びなさい。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:1;a:15:{i:0;s:0:"";i:1;s:18:"2. らいしゅう";i:2;s:18:"2. らいしゅう";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:18:"2. らいしゅう";}s:14:"correct_answer";a:1:{i:1;s:18:"2. らいしゅう";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"12";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:53:"1. ( 来週 ) は　いそがしく　なります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:2;a:15:{i:0;s:0:"";i:1;s:9:"3. そら";i:2;s:9:"3. そら";i:3;s:0:"";s:11:"user_answer";a:1:{i:2;s:9:"3. そら";}s:14:"correct_answer";a:1:{i:2;s:9:"3. そら";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"13";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:74:"2. きょうは　( 空 ) の　いろが　とても　きれいです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:3;a:15:{i:0;s:0:"";i:1;s:12:"2. ごにん";i:2;s:12:"2. ごにん";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:12:"2. ごにん";}s:14:"correct_answer";a:1:{i:1;s:12:"2. ごにん";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"14";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:55:"3. おとこの　ひとが　( 五人 )　います。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:4;a:15:{i:0;s:0:"";i:1;s:18:"2. びょういん";i:2;s:18:"2. びょういん";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:18:"2. びょういん";}s:14:"correct_answer";a:1:{i:1;s:18:"2. びょういん";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"15";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:56:"4. ( 病院 ) の　いりぐちは　どこですか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:5;a:15:{i:0;s:0:"";i:1;s:9:"4. かわ";i:2;s:9:"4. かわ";i:3;s:0:"";s:11:"user_answer";a:1:{i:3;s:9:"4. かわ";}s:14:"correct_answer";a:1:{i:3;s:9:"4. かわ";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"16";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:35:"5. ( 川 ) で　およぎます。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:6;a:15:{i:0;s:0:"";i:1;s:15:"4. ゆうがた";i:2;s:15:"4. ゆうがた";i:3;s:0:"";s:11:"user_answer";a:1:{i:3;s:15:"4. ゆうがた";}s:14:"correct_answer";a:1:{i:3;s:15:"4. ゆうがた";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"17";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:59:"6. ( 夕方 ) 、いぬの　さんぽに　いきます。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:7;a:15:{i:0;s:0:"";i:1;s:12:"1. ようか";i:2;s:12:"1. ようか";i:3;s:0:"";s:11:"user_answer";a:1:{i:0;s:12:"1. ようか";}s:14:"correct_answer";a:1:{i:0;s:12:"1. ようか";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"18";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:62:"7. らいげつの　( 八日 ) に　けっこんします。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:8;a:15:{i:0;s:0:"";i:1;s:15:"2. いっぽん";i:2;s:15:"2. いっぽん";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:15:"2. いっぽん";}s:14:"correct_answer";a:1:{i:1;s:15:"2. いっぽん";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"19";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:67:"8. うちに　おおきな　きが　( 一本 )　あります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:9;a:15:{i:0;s:0:"";i:1;s:12:"2. いって";i:2;s:12:"2. いって";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:12:"2. いって";}s:14:"correct_answer";a:1:{i:1;s:12:"2. いって";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"20";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:67:"9. わたしと　いっしょに　( 行って )　ください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:10;a:15:{i:0;s:0:"";i:1;s:18:"2. せんしょう";i:2;s:18:"4. せんしゅう";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:18:"2. せんしょう";}s:14:"correct_answer";a:1:{i:3;s:18:"4. せんしゅう";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"21";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:60:"10. ( 先週 ) の　げつようびは　やすみでした";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:11;a:15:{i:0;s:0:"";i:1;s:9:"1. ねん";i:2;s:9:"2. とし";i:3;s:0:"";s:11:"user_answer";a:1:{i:0;s:9:"1. ねん";}s:14:"correct_answer";a:1:{i:1;s:9:"2. とし";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"22";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:54:"11. あたらしい　( 年 ) に　なりました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:12;a:15:{i:0;s:0:"";i:1;s:9:"2. きた";i:2;s:9:"2. きた";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:9:"2. きた";}s:14:"correct_answer";a:1:{i:1;s:9:"2. きた";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"23";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:53:"12. この　みちを　( 北 )へ　いきます。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:13;a:15:{i:0;s:0:"";i:1;s:15:"3. こんげつ";i:2;s:15:"3. こんげつ";i:3;s:0:"";s:11:"user_answer";a:1:{i:2;s:15:"3. こんげつ";}s:14:"correct_answer";a:1:{i:2;s:15:"3. こんげつ";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"24";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:57:"13. ( 今月 ) なつやすみが　はじまります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:14;a:15:{i:0;s:0:"";i:1;s:18:"3. らいしゅう";i:2;s:18:"3. らいしゅう";i:3;s:0:"";s:11:"user_answer";a:1:{i:2;s:18:"3. らいしゅう";}s:14:"correct_answer";a:1:{i:2;s:18:"3. らいしゅう";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"25";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:41:"14. ( 来週 )、はたらきません。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:15;a:15:{i:0;s:0:"";i:1;s:15:"2. りょこう";i:2;s:15:"2. りょこう";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:15:"2. りょこう";}s:14:"correct_answer";a:1:{i:1;s:15:"2. りょこう";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"26";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:33:"15. ( 旅行 ) したいです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:16;a:15:{i:0;s:0:"";i:1;s:12:"3. ふるい";i:2;s:12:"3. ふるい";i:3;s:0:"";s:11:"user_answer";a:1:{i:2;s:12:"3. ふるい";}s:14:"correct_answer";a:1:{i:2;s:12:"3. ふるい";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"27";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:48:"16. この　ホテルは　( 古い ) です。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:17;a:15:{i:0;s:0:"";i:1;s:9:"1. くに";i:2;s:9:"1. くに";i:3;s:0:"";s:11:"user_answer";a:1:{i:0;s:9:"1. くに";}s:14:"correct_answer";a:1:{i:0;s:9:"1. くに";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"28";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:63:"17. わたしの　( 国 ) は　ふゆが　ありません。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:18;a:15:{i:0;s:0:"";i:1;s:12:"1. きのう";i:2;s:12:"1. きのう";i:3;s:0:"";s:11:"user_answer";a:1:{i:0;s:12:"1. きのう";}s:14:"correct_answer";a:1:{i:0;s:12:"1. きのう";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"29";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:48:"18. ( 昨日 ) は  学校が  休みでした";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:19;a:15:{i:0;s:0:"";i:1;s:12:"1. なまえ";i:2;s:12:"1. なまえ";i:3;s:0:"";s:11:"user_answer";a:1:{i:0;s:12:"1. なまえ";}s:14:"correct_answer";a:1:{i:0;s:12:"1. なまえ";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"30";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:48:"19. ( 名前 ) を　おしえてください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:20;a:15:{i:0;s:0:"";i:1;s:15:"3. せいかつ";i:2;s:15:"3. せいかつ";i:3;s:0:"";s:11:"user_answer";a:1:{i:2;s:15:"3. せいかつ";}s:14:"correct_answer";a:1:{i:2;s:15:"3. せいかつ";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"31";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:51:"20. 日本の　( 生活 ) は　どうですか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:21;a:15:{i:0;s:0:"";i:1;s:18:"3. はいります";i:2;s:18:"3. はいります";i:3;s:0:"";s:11:"user_answer";a:1:{i:2;s:18:"3. はいります";}s:14:"correct_answer";a:1:{i:2;s:18:"3. はいります";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"32";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:50:"21. 今から　おふろに　( 入ります )。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:22;a:15:{i:0;s:0:"";i:1;s:24:"2. いちじかんはん";i:2;s:24:"2. いちじかんはん";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:24:"2. いちじかんはん";}s:14:"correct_answer";a:1:{i:1;s:24:"2. いちじかんはん";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"33";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:77:"22. うちから　がっこうまで　( １時間半 )　かかります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:23;a:15:{i:0;s:0:"";i:1;s:12:"2. ひだり";i:2;s:12:"2. ひだり";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:12:"2. ひだり";}s:14:"correct_answer";a:1:{i:1;s:12:"2. ひだり";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"34";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:75:"23. その　しんごうを　( 左 ) に　まがって　ください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:24;a:15:{i:0;s:0:"";i:1;s:6:"1. ま";i:2;s:12:"4. あいだ";i:3;s:0:"";s:11:"user_answer";a:1:{i:0;s:6:"1. ま";}s:14:"correct_answer";a:1:{i:3;s:12:"4. あいだ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"35";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:78:"24. えきと　コンビニの　( 間 ) に　はなやが　あります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:25;a:15:{i:0;s:0:"";i:1;s:15:"4. だいがく";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:1:{i:3;s:15:"4. だいがく";}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"36";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:51:"25. この　( 大学 ) は　ゆうめいです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:26;a:15:{i:0;s:0:"";i:1;s:12:"1. いつか";i:2;s:12:"1. いつか";i:3;s:0:"";s:11:"user_answer";a:1:{i:0;s:12:"1. いつか";}s:14:"correct_answer";a:1:{i:0;s:12:"1. いつか";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"37";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:51:"26. まいつき　( 五日 ) は　休みです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:27;a:15:{i:0;s:0:"";i:1;s:9:"3. なか";i:2;s:9:"4. そと";i:3;s:0:"";s:11:"user_answer";a:1:{i:2;s:9:"3. なか";}s:14:"correct_answer";a:1:{i:3;s:9:"4. そと";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"38";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:54:"27. いえの　( 外 ) に　いぬが　います。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:28;a:15:{i:0;s:0:"";i:1;s:9:"2. はな";i:2;s:9:"2. はな";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:9:"2. はな";}s:14:"correct_answer";a:1:{i:1;s:9:"2. はな";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"39";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:48:"28. あの　( 花 ) は　きれいですね。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:29;a:15:{i:0;s:0:"";i:1;s:9:"3. ごご";i:2;s:9:"3. ごご";i:3;s:0:"";s:11:"user_answer";a:1:{i:2;s:9:"3. ごご";}s:14:"correct_answer";a:1:{i:2;s:9:"3. ごご";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"40";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:53:"29. ( 午後 )　がっこうは　やすみです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:30;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"41";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:119:"問題: 2＿＿＿の言葉を漢字で書く時、最もよいものを、1・2・3・4から一つ 選びなさい。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:31;a:15:{i:0;s:0:"";i:1;s:9:"2. 少し";i:2;s:9:"2. 少し";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:9:"2. 少し";}s:14:"correct_answer";a:1:{i:1;s:9:"2. 少し";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"42";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:58:"１．えいごは　（ すこし ) はなします１．";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:32;a:15:{i:0;s:0:"";i:1;s:6:"1. 道";i:2;s:6:"1. 道";i:3;s:0:"";s:11:"user_answer";a:1:{i:0;s:6:"1. 道";}s:14:"correct_answer";a:1:{i:0;s:6:"1. 道";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"43";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:70:"2. この　( みち )を　まっすぐ　いって　ください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:33;a:15:{i:0;s:0:"";i:1;s:15:"1. タクツー";i:2;s:15:"2. タクシー";i:3;s:0:"";s:11:"user_answer";a:1:{i:0;s:15:"1. タクツー";}s:14:"correct_answer";a:1:{i:1;s:15:"2. タクシー";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"45";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:44:"3. ( たくしー ) で　かえります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:34;a:15:{i:0;s:0:"";i:1;s:12:"4. 買い物";i:2;s:12:"4. 買い物";i:3;s:0:"";s:11:"user_answer";a:1:{i:3;s:12:"4. 買い物";}s:14:"correct_answer";a:1:{i:3;s:12:"4. 買い物";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"46";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:59:"4. ともだちと　( かいもの ) を　しました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:35;a:15:{i:0;s:0:"";i:1;s:15:"3. 行きます";i:2;s:15:"3. 行きます";i:3;s:0:"";s:11:"user_answer";a:1:{i:2;s:15:"3. 行きます";}s:14:"correct_answer";a:1:{i:2;s:15:"3. 行きます";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"47";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:55:"5. これから　がっこうへ　( いきます )。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:36;a:15:{i:0;s:0:"";i:1;s:6:"2. 書";i:2;s:6:"2. 書";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:6:"2. 書";}s:14:"correct_answer";a:1:{i:1;s:6:"2. 書";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"48";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:52:"6. きょう、てがみを　( か )きました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:37;a:15:{i:0;s:0:"";i:1;s:9:"4. 先週";i:2;s:9:"4. 先週";i:3;s:0:"";s:11:"user_answer";a:1:{i:3;s:9:"4. 先週";}s:14:"correct_answer";a:1:{i:3;s:9:"4. 先週";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"49";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:61:"7. ( せんしゅう )　きょうとへ　いきました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:38;a:15:{i:0;s:0:"";i:1;s:15:"4. 出します";i:2;s:15:"4. 出します";i:3;s:0:"";s:11:"user_answer";a:1:{i:3;s:15:"4. 出します";}s:14:"correct_answer";a:1:{i:3;s:15:"4. 出します";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"50";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:70:"8. かばんの　なかから　のみものを　( だします )。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:39;a:15:{i:0;s:0:"";i:1;s:12:"1. 新しい";i:2;s:12:"1. 新しい";i:3;s:0:"";s:11:"user_answer";a:1:{i:0;s:12:"1. 新しい";}s:14:"correct_answer";a:1:{i:0;s:12:"1. 新しい";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"51";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:58:"9. ( あたらしい )　テレビを　かいました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:40;a:15:{i:0;s:0:"";i:1;s:9:"3. 高い";i:2;s:9:"3. 高い";i:3;s:0:"";s:11:"user_answer";a:1:{i:2;s:9:"3. 高い";}s:14:"correct_answer";a:1:{i:2;s:9:"3. 高い";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"52";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:65:"10. ふじさんは　いちばん　( たかい )　山です。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:41;a:15:{i:0;s:0:"";i:1;s:21:"3. エレベーター";i:2;s:21:"3. エレベーター";i:3;s:0:"";s:11:"user_answer";a:1:{i:2;s:21:"3. エレベーター";}s:14:"correct_answer";a:1:{i:2;s:21:"3. エレベーター";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"53";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:54:"11. ( えれべーたー ) で　いきましょう。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:42;a:15:{i:0;s:0:"";i:1;s:15:"2. 日よう日";i:2;s:15:"2. 日よう日";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:15:"2. 日よう日";}s:14:"correct_answer";a:1:{i:1;s:15:"2. 日よう日";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"54";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:57:"12. ( にちようび ) は　いつも　ひまです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:43;a:15:{i:0;s:0:"";i:1;s:15:"4. シャウー";i:2;s:15:"1. シャワー";i:3;s:0:"";s:11:"user_answer";a:1:{i:3;s:15:"4. シャウー";}s:14:"correct_answer";a:1:{i:0;s:15:"1. シャワー";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"55";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:57:"13. ( しゃわー ) の　そうじを　しました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:44;a:15:{i:0;s:0:"";i:1;s:6:"2. 口";i:2;s:6:"2. 口";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:6:"2. 口";}s:14:"correct_answer";a:1:{i:1;s:6:"2. 口";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"56";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:51:"14. ( くち ) を　おおきく　あけます。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:45;a:15:{i:0;s:0:"";i:1;s:9:"3. 多い";i:2;s:9:"1. 長い";i:3;s:0:"";s:11:"user_answer";a:1:{i:2;s:9:"3. 多い";}s:14:"correct_answer";a:1:{i:0;s:9:"1. 長い";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"57";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:45:"15. この　川は　( ながい ) です。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:46;a:15:{i:0;s:0:"";i:1;s:6:"1. 西";i:2;s:6:"1. 西";i:3;s:0:"";s:11:"user_answer";a:1:{i:0;s:6:"1. 西";}s:14:"correct_answer";a:1:{i:0;s:6:"1. 西";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"58";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:75:"16. わたしの　うちは　東京の　( にし ) に　あります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:47;a:15:{i:0;s:0:"";i:1;s:15:"1. 語きます";i:2;s:15:"3. 聞きます";i:3;s:0:"";s:11:"user_answer";a:1:{i:0;s:15:"1. 語きます";}s:14:"correct_answer";a:1:{i:2;s:15:"3. 聞きます";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"59";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:53:"17. まいばん　ラジオを　( ききます )。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:48;a:15:{i:0;s:0:"";i:1;s:9:"2. 電車";i:2;s:9:"2. 電車";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:9:"2. 電車";}s:14:"correct_answer";a:1:{i:1;s:9:"2. 電車";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"60";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:75:"18. あの　あかい　( でんしゃ ) に　のって　ください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:49;a:15:{i:0;s:0:"";i:1;s:18:"3. レストラン";i:2;s:18:"3. レストラン";i:3;s:0:"";s:11:"user_answer";a:1:{i:2;s:18:"3. レストラン";}s:14:"correct_answer";a:1:{i:2;s:18:"3. レストラン";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"61";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:59:"19. あの　( れすとらん )に　入りましょう。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:50;a:15:{i:0;s:0:"";i:1;s:6:"2. 何";i:2;s:6:"2. 何";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:6:"2. 何";}s:14:"correct_answer";a:1:{i:1;s:6:"2. 何";}s:7:"correct";s:7:"correct";s:2:"id";s:2:"62";s:6:"points";d:1;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:62:"20. この　かんじの　いみは　( なん )ですか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}}i:2;s:0:"";s:7:"contact";a:1:{i:0;a:4:{s:5:"label";s:4:"Nama";s:5:"value";s:4:"Rinn";s:3:"use";s:4:"name";s:4:"type";s:4:"text";}}s:8:"timer_ms";i:1732357350728;s:8:"pagetime";a:0:{}s:16:"hidden_questions";N;s:21:"total_possible_points";d:49;s:25:"total_attempted_questions";i:49;s:23:"minimum_possible_points";i:0;s:15:"quiz_start_date";s:22:"10:13:07 AM 11/23/2024";}',0,'6741acab9c03d',0,'kanji n5 1','https://kumabenkyou.com/qsm_quiz/kanji-n5-1/');
INSERT INTO `wpbl_mlw_results` VALUES (5,5,'kanji n5 1',3,0,0,0,51,'arfi','None','admin@kumabenkyou.com','None',1,'14.9.212.224','11:06:30 AM 11/23/2024','2024-11-23 11:06:30','a:11:{i:0;i:14;i:1;a:51:{i:0;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"44";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:115:"問題: 1＿＿＿の言葉の読み方として最もよいものを、1・2・3・4から一つ選びなさい。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:1;a:15:{i:0;s:0:"";i:1;s:15:"1. きしゅう";i:2;s:18:"2. らいしゅう";i:3;s:0:"";s:11:"user_answer";a:1:{i:0;s:15:"1. きしゅう";}s:14:"correct_answer";a:1:{i:1;s:18:"2. らいしゅう";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"12";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:53:"1. ( 来週 ) は　いそがしく　なります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:2;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"3. そら";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:9:"3. そら";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"13";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:74:"2. きょうは　( 空 ) の　いろが　とても　きれいです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:3;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"2. ごにん";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:12:"2. ごにん";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"14";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:55:"3. おとこの　ひとが　( 五人 )　います。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:4;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"2. びょういん";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:18:"2. びょういん";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"15";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:56:"4. ( 病院 ) の　いりぐちは　どこですか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:5;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"4. かわ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:9:"4. かわ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"16";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:35:"5. ( 川 ) で　およぎます。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:6;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"4. ゆうがた";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:15:"4. ゆうがた";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"17";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:59:"6. ( 夕方 ) 、いぬの　さんぽに　いきます。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:7;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"1. ようか";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:12:"1. ようか";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"18";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:62:"7. らいげつの　( 八日 ) に　けっこんします。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:8;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"2. いっぽん";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:15:"2. いっぽん";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"19";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:67:"8. うちに　おおきな　きが　( 一本 )　あります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:9;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"2. いって";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:12:"2. いって";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"20";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:67:"9. わたしと　いっしょに　( 行って )　ください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:10;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"4. せんしゅう";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:18:"4. せんしゅう";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"21";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:60:"10. ( 先週 ) の　げつようびは　やすみでした";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:11;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"2. とし";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:9:"2. とし";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"22";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:54:"11. あたらしい　( 年 ) に　なりました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:12;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"2. きた";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:9:"2. きた";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"23";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:53:"12. この　みちを　( 北 )へ　いきます。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:13;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"3. こんげつ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:15:"3. こんげつ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"24";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:57:"13. ( 今月 ) なつやすみが　はじまります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:14;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"3. らいしゅう";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:18:"3. らいしゅう";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"25";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:41:"14. ( 来週 )、はたらきません。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:15;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"2. りょこう";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:15:"2. りょこう";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"26";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:33:"15. ( 旅行 ) したいです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:16;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"3. ふるい";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:12:"3. ふるい";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"27";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:48:"16. この　ホテルは　( 古い ) です。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:17;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"1. くに";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:9:"1. くに";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"28";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:63:"17. わたしの　( 国 ) は　ふゆが　ありません。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:18;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"1. きのう";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:12:"1. きのう";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"29";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:48:"18. ( 昨日 ) は  学校が  休みでした";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:19;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"1. なまえ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:12:"1. なまえ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"30";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:48:"19. ( 名前 ) を　おしえてください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:20;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"3. せいかつ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:15:"3. せいかつ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"31";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:51:"20. 日本の　( 生活 ) は　どうですか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:21;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"3. はいります";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:18:"3. はいります";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"32";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:50:"21. 今から　おふろに　( 入ります )。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:22;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:24:"2. いちじかんはん";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:24:"2. いちじかんはん";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"33";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:77:"22. うちから　がっこうまで　( １時間半 )　かかります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:23;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"2. ひだり";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:12:"2. ひだり";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"34";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:75:"23. その　しんごうを　( 左 ) に　まがって　ください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:24;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"4. あいだ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:12:"4. あいだ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"35";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:78:"24. えきと　コンビニの　( 間 ) に　はなやが　あります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:25;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"4. だいがく";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:15:"4. だいがく";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"36";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:51:"25. この　( 大学 ) は　ゆうめいです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:26;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"1. いつか";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:12:"1. いつか";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"37";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:51:"26. まいつき　( 五日 ) は　休みです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:27;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"4. そと";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:9:"4. そと";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"38";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:54:"27. いえの　( 外 ) に　いぬが　います。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:28;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"2. はな";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:9:"2. はな";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"39";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:48:"28. あの　( 花 ) は　きれいですね。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:29;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"3. ごご";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:9:"3. ごご";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"40";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:53:"29. ( 午後 )　がっこうは　やすみです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:30;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"41";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:119:"問題: 2＿＿＿の言葉を漢字で書く時、最もよいものを、1・2・3・4から一つ 選びなさい。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:31;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"2. 少し";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:9:"2. 少し";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"42";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:58:"１．えいごは　（ すこし ) はなします１．";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:32;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:6:"1. 道";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:6:"1. 道";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"43";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:70:"2. この　( みち )を　まっすぐ　いって　ください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:33;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"2. タクシー";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:15:"2. タクシー";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"45";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:44:"3. ( たくしー ) で　かえります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:34;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"4. 買い物";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:12:"4. 買い物";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"46";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:59:"4. ともだちと　( かいもの ) を　しました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:35;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"3. 行きます";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:15:"3. 行きます";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"47";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:55:"5. これから　がっこうへ　( いきます )。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:36;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:6:"2. 書";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:6:"2. 書";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"48";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:52:"6. きょう、てがみを　( か )きました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:37;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"4. 先週";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:9:"4. 先週";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"49";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:61:"7. ( せんしゅう )　きょうとへ　いきました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:38;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"4. 出します";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:15:"4. 出します";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"50";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:70:"8. かばんの　なかから　のみものを　( だします )。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:39;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"1. 新しい";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:12:"1. 新しい";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"51";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:58:"9. ( あたらしい )　テレビを　かいました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:40;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"3. 高い";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:9:"3. 高い";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"52";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:65:"10. ふじさんは　いちばん　( たかい )　山です。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:41;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:21:"3. エレベーター";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:21:"3. エレベーター";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"53";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:54:"11. ( えれべーたー ) で　いきましょう。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:42;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"2. 日よう日";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:15:"2. 日よう日";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"54";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:57:"12. ( にちようび ) は　いつも　ひまです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:43;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"1. シャワー";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:15:"1. シャワー";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"55";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:57:"13. ( しゃわー ) の　そうじを　しました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:44;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:6:"2. 口";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:6:"2. 口";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"56";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:51:"14. ( くち ) を　おおきく　あけます。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:45;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"1. 長い";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:9:"1. 長い";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"57";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:45:"15. この　川は　( ながい ) です。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:46;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:6:"1. 西";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:6:"1. 西";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"58";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:75:"16. わたしの　うちは　東京の　( にし ) に　あります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:47;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"3. 聞きます";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:15:"3. 聞きます";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"59";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:53:"17. まいばん　ラジオを　( ききます )。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:48;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"2. 電車";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:9:"2. 電車";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"60";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:75:"18. あの　あかい　( でんしゃ ) に　のって　ください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:49;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"3. レストラン";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:18:"3. レストラン";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"61";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:59:"19. あの　( れすとらん )に　入りましょう。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:50;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:6:"2. 何";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:6:"2. 何";}s:7:"correct";s:9:"incorrect";s:2:"id";s:2:"62";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:62:"20. この　かんじの　いみは　( なん )ですか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}}i:2;s:0:"";s:7:"contact";a:1:{i:0;a:4:{s:5:"label";s:4:"Nama";s:5:"value";s:4:"arfi";s:3:"use";s:4:"name";s:4:"type";s:4:"text";}}s:8:"timer_ms";i:1732359974872;s:8:"pagetime";a:0:{}s:16:"hidden_questions";N;s:21:"total_possible_points";d:49;s:25:"total_attempted_questions";i:1;s:23:"minimum_possible_points";i:0;s:15:"quiz_start_date";s:22:"08:25:53 AM 11/23/2024";}',0,'6741b722ae324',0,'kanji n5 1','https://kumabenkyou.com/qsm_quiz/kanji-n5-1/');
INSERT INTO `wpbl_mlw_results` VALUES (6,454,'Vocabulary - JLPT N2 #10',3,0,0,0,50,'None','None','None','None',0,'42.118.136.56','02:10:09 PM 03/03/2025','2025-03-03 14:10:09','a:11:{i:0;i:11;i:1;a:50:{i:0;a:15:{i:0;s:0:"";i:1;s:93:"4. 酔っぱらったひきょうな姿を彼女に見られてしまって恥ずかしい。";i:2;s:96:"1. 彼なら途中で逃げ出すようなひきょうなことは絶対にしないはずだ。";i:3;s:0:"";s:11:"user_answer";a:1:{i:3;s:93:"4. 酔っぱらったひきょうな姿を彼女に見られてしまって恥ずかしい。";}s:14:"correct_answer";a:1:{i:0;s:96:"1. 彼なら途中で逃げ出すようなひきょうなことは絶対にしないはずだ。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17490";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:15:"1. ひきょう";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:1;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:60:"1. これはたいへん上等なお品でございます。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:60:"1. これはたいへん上等なお品でございます。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17491";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:9:"2. 上等";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:2;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:63:"2. この庭園は、日曜日だけ市民に開放される。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:63:"2. この庭園は、日曜日だけ市民に開放される。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17492";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:9:"3. 開放";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:3;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:63:"1. 仕事が忙しくて、ストレスがたまっている。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:63:"1. 仕事が忙しくて、ストレスがたまっている。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17493";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:12:"4. たまる";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:4;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:84:"1. この料理を作るときは、ときどき火の強さを加減しなさい。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:84:"1. この料理を作るときは、ときどき火の強さを加減しなさい。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17494";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:9:"5. 加減";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:5;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:68:"2. 1万円は要るだろうと思ったが、5千円で済んだ。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:68:"2. 1万円は要るだろうと思ったが、5千円で済んだ。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17495";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:9:"6. 済む";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:6;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:72:"2. 何度やってもできないので、くやしくてたまらい。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:72:"2. 何度やってもできないので、くやしくてたまらい。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17496";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:15:"7. くやしい";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:7;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:54:"1. イムさんは本当に頼りになる人です。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:54:"1. イムさんは本当に頼りになる人です。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17497";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:9:"8. 頼る";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:8;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:63:"2. そんなへたな言い訳は、私には通用しない。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:63:"2. そんなへたな言い訳は、私には通用しない。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17498";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:9:"9. 通用";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:9;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:57:"3. 彼は深刻な悩みをかかえているようだ。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:57:"3. 彼は深刻な悩みをかかえているようだ。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17499";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"10. 深刻";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:10;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:72:"1. 西洋の小説には、聖書から引用された言葉が多い。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:72:"1. 西洋の小説には、聖書から引用された言葉が多い。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17500";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"11. 引用";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:11;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:72:"3. そんなことで落ちこむなんて、だらしないやつだ。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:72:"3. そんなことで落ちこむなんて、だらしないやつだ。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17501";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:19:"12. だらしない";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:12;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:51:"1. 風船に空気を入れると、ふくらむ。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:51:"1. 風船に空気を入れると、ふくらむ。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17502";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:16:"13. ふくらむ";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:13;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:81:"3. 彼は単純な性格だから、細かいことは気にしないと思う。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:81:"3. 彼は単純な性格だから、細かいことは気にしないと思う。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17503";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"14. 単純";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:14;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:69:"3. 客の希望を反映して、配達のサービスを始めた。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:69:"3. 客の希望を反映して、配達のサービスを始めた。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17504";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"15. 反映";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:15;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:57:"3. 余分に用意しておいた方がいいだろう。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:57:"3. 余分に用意しておいた方がいいだろう。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17505";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"16. 余分";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:16;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:84:"2. 込んでいる電車の中で新聞を広げるのは、他の客に迷惑だ。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:84:"2. 込んでいる電車の中で新聞を広げるのは、他の客に迷惑だ。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17506";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"17. 迷惑";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:17;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:84:"1. 売り上げがよいせいか、社長は強気な発言ばかりしている。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:84:"1. 売り上げがよいせいか、社長は強気な発言ばかりしている。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17507";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:16:"18. 強気な　";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:18;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:69:"4. 自分の店を持つという夢が、とうとうかなった。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:69:"4. 自分の店を持つという夢が、とうとうかなった。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17508";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:13:"19. かなう";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:19;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:84:"4. 断りの理由は言わないが、彼の表情で大体の見当がついた。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:84:"4. 断りの理由は言わないが、彼の表情で大体の見当がついた。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17509";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"20. 見当";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:20;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:78:"3. 参加者の年齢や体力を考慮して、旅行プランを立てた。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:78:"3. 参加者の年齢や体力を考慮して、旅行プランを立てた。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17510";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"21. 考慮";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:21;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:66:"2. 昼と夜姉妹で交代しながら、母の看病をした。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:66:"2. 昼と夜姉妹で交代しながら、母の看病をした。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17511";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"22. 交代";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:22;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:63:"3. 今世界は、さまざまな問題をかかえている。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:63:"3. 今世界は、さまざまな問題をかかえている。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17512";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:16:"23. かかえる";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:23;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:54:"4. せめて名前だけでも教えてください。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:54:"4. せめて名前だけでも教えてください。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17513";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:13:"24. せめて";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:24;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:55:"3. 京都に行くなら、せめて1泊はしたい。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:55:"3. 京都に行くなら、せめて1泊はしたい。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17514";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:13:"25. せめて";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:25;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:69:"4. 地上を離れた飛行機は一気に加速度を増やした。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:69:"4. 地上を離れた飛行機は一気に加速度を増やした。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17515";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:13:"26. 加速度";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:26;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:72:"1. この祭りは自然の恩恵に浴する感謝を表している。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:72:"1. この祭りは自然の恩恵に浴する感謝を表している。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17516";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"27. 恩恵";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:27;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:73:"2. 2人の話し合いは焦点がずれていて、結論が出ない。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:73:"2. 2人の話し合いは焦点がずれていて、結論が出ない。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17517";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"28. 焦点";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:28;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:87:"3. せっかく楽しみにしていたのに、雨で中止になってしまった。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:87:"3. せっかく楽しみにしていたのに、雨で中止になってしまった。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17518";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:16:"29. せっかく";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:29;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:78:"1. 新しい法案は過半数の賛成を得たので国会で成立した。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:78:"1. 新しい法案は過半数の賛成を得たので国会で成立した。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17519";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:13:"30. 過半数";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:30;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:75:"2. だれがいちばん美人かだって？それはすきずきだよ。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:75:"2. だれがいちばん美人かだって？それはすきずきだよ。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17520";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:16:"31. すきずき";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:31;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:75:"3. この投票率の低さは、政治への無関心のあらわれだ。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:75:"3. この投票率の低さは、政治への無関心のあらわれだ。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17521";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:16:"32. あらわれ";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:32;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17522";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"33. 超過";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:33;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:60:"4. 静かな場所で作業すると、能率が上がる。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:60:"4. 静かな場所で作業すると、能率が上がる。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17523";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"34. 能率";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:34;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:90:"3. 雨がはげしくなる前に試合を中止したのは、妥当な判断だった。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:90:"3. 雨がはげしくなる前に試合を中止したのは、妥当な判断だった。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17524";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:16:"35. 妥当な　";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:35;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:81:"2. 泊めていただいた上にごちそうにまでなって、恐縮です。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:81:"2. 泊めていただいた上にごちそうにまでなって、恐縮です。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17525";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"36. 恐縮";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:36;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:48:"1. 予定を１日ずつスライドさせる。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:48:"1. 予定を１日ずつスライドさせる。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17526";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:16:"37. スライド";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:37;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:75:"1. 娘が帰ってこないので、心当たりに次々と電話した。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:75:"1. 娘が帰ってこないので、心当たりに次々と電話した。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17527";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:16:"38. 心当たり";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:38;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:66:"3. 新しい首相は、政策について国会で演説した。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:66:"3. 新しい首相は、政策について国会で演説した。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17528";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"39. 演説";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:39;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:75:"4. この小説のあらすじを４００字以内にまとめなさい。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:75:"4. この小説のあらすじを４００字以内にまとめなさい。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17529";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:16:"40. あらすじ";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:40;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:69:"2. 社長は、会社の代表だから、責任も重大である。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:69:"2. 社長は、会社の代表だから、責任も重大である。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17530";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"41. 重大";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:41;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:75:"2. 上司はその企画に対し、肯定的な意見を持っている。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:75:"2. 上司はその企画に対し、肯定的な意見を持っている。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17531";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:13:"42. 肯定的";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:42;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:75:"3. 論文には、その要旨を書いたものを付けてください。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:75:"3. 論文には、その要旨を書いたものを付けてください。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17532";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"43. 要旨";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:43;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:60:"1. 人を外見で判断するのはよくないことだ。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:60:"1. 人を外見で判断するのはよくないことだ。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17533";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"44. 外見";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:44;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:90:"1. 日本では、話すことより読む勉強に重点を置く学校がまだ多い。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:90:"1. 日本では、話すことより読む勉強に重点を置く学校がまだ多い。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17534";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"45. 重点";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:45;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:63:"4. その後、２人はさらに２人の子をもうける。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:63:"4. その後、２人はさらに２人の子をもうける。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17535";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:16:"46. もうける";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:46;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:81:"2. あいつの言うことはめちゃくちゃで、筋が通っていない。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:81:"2. あいつの言うことはめちゃくちゃで、筋が通っていない。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17536";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:7:"47. 筋";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:47;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:57:"4. 家と会社の間を往復するだけの毎日だ。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:57:"4. 家と会社の間を往復するだけの毎日だ。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17537";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:10:"48. 往復";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:48;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:57:"2. この魚は流れに逆らって川を泳ぎます。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:57:"2. この魚は流れに逆らって川を泳ぎます。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17538";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:13:"49. 逆らう";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:49;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:72:"3. 息子のひどい成績に母が思わずためいきをついた。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:72:"3. 息子のひどい成績に母が思わずためいきをついた。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"17539";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:16:"50. ためいき";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}}i:2;s:0:"";s:7:"contact";a:0:{}s:8:"timer_ms";i:1741010997733;s:8:"pagetime";a:0:{}s:16:"hidden_questions";N;s:21:"total_possible_points";d:100;s:25:"total_attempted_questions";i:1;s:23:"minimum_possible_points";i:0;s:15:"quiz_start_date";s:22:"02:09:16 PM 03/03/2025";}',0,'67c5b8377bf5a',0,'Vocabulary &#8211; JLPT N2 #10','https://kumabenkyou.com/qsm_quiz/vocabulary-jlpt-n2-10/');
INSERT INTO `wpbl_mlw_results` VALUES (7,345,'Reading - JLPT N3 #9',3,6,3,1,30,'None','None','None','None',0,'104.28.254.74','02:35:20 PM 03/16/2025','2025-03-16 14:35:20','a:11:{i:0;i:2595;i:1;a:30:{i:0;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13724";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:642:"子どものころのことを思い出してみてください。雲が動物の形に見えたり、壁　のしみや汚れが顔に見えたりしたことはありませんか。また、雨や風の音を聞いて、音楽のようだと感じたことがある人もいるかもしれません。では、大人になった今はどうでしよう。多くの人が、大人になると、そのように感じる「子どもの心」をなくしてしまいます。「子どもの心」を持ち続け、それによって感じたものを音楽や絵で表すことのできる人が、芸術家なのではないでしょうか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:1;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:93:"4. 大人になっても「子どもの心」で感じたものを音楽や絵で表せる人";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:93:"4. 大人になっても「子どもの心」で感じたものを音楽や絵で表せる人";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13725";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:89:"1. この文章を書いた人は、どんな人が芸術家だと考えているか？ ";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:2;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13726";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:612:"コートカードは毎年1 月1日に切り替えになるので、12月31日までにポイントを使わなければ、そのポイントは無効になってしまう。ミンスクさんは今持っいる12000ポイントをデパートの商品券と本屋の図書券にしたいと考えている。商品券は5000ポイントで5000円券、10000ポイントで10000円券に換えられる。図書券は1000ポイントにつき1000円券にできるが、3000ポイント以下の場合は送料を300円取られる。なるべく商品券がほしいが、余分なお金は使いたくない。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:3;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:77:"4. 5000ポイントを商品券に、7000ポイントを図書券にする。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:77:"4. 5000ポイントを商品券に、7000ポイントを図書券にする。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13727";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:48:"2. ポイントをどう使ったらいいか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:4;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13728";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:728:"部屋を片かた付づけるのが苦手な人は、物を持ちすぎていることが多い。 片付けるポイントは、 物に指し定てい席せき（＊1） を作ること。使ったらすぐ指定席に戻もどすようにすれば、あちこちに散ちらかることもなくなる。 また、指し定てい席せきのスペースを作るには、要いらない物を捨てることも必要だ。自分の部屋に入る分だけを、見やすく、出しやすくしまうこと。こうすれば、足りない物もすぐわかるし、同じような物を買ったりするむだな買い物も防ふせげるだろう。 （ ※ 1） 指し定てい席せき： 決められた場所のこと";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:5;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:73:"1. 要らない物を持たないで、 物を置く場所を決める。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:73:"1. 要らない物を持たないで、 物を置く場所を決める。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13729";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:84:"3. 部屋を片付けるためには、どうすればいいと言っているか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:6;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13730";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:553:"ある温泉地のホテルでは、冬になると面白いサービスを行っている。このホテルは、雪の多い山の中にあるのだが、到着日の午後3時から出発日の午前6時までの間の最低気温が0度より低くなったら、ホテル代が割引になる。例えば、0度より5度低くなったら5％、10度低くなったら10％安くなるのだ。このようなサービスがあるなら、寒いのが苦手な人でも、一度泊まってみようという気持ちになるかもしれない。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:7;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:64:"2. 決められた時間の間に、0度以下になった場合";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:64:"2. 決められた時間の間に、0度以下になった場合";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13731";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:81:"4. このホテルは、どのような場合にホテル代が安くなるか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:8;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13732";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:687:"前略　クラス会のお知らせありがとうございました。様々な計画を立てるのはとても大変なことと思います。毎年クラス会で皆様にお目にかかれるのを楽しみにしておりましたが、残念ながら今年は仕事の都合でどうしても出席できません。 当日深沢ふかざわ先生もご出席と伺っておりますのにとても残念です。次回は必ず出席したいと思いますので、またご連絡れんらくくださいますようお願ねがい申し上げます。先生やクラスの皆様によろしくとお伝えくださいませんか。 よろしくお願い致します。 草々";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:9;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:39:"1. クラス会に出席したかった";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:39:"1. クラス会に出席したかった";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13733";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:61:"5. 手紙でクラス会について何と言っているか?";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:10;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13734";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:506:"午前9時の天気予報をお知らせ致します。現在、東京地方の気温は20度、雲ひとつない言い天気です。しかしフィリピンで発生した台風15号が次第しだいに南から近づいてきます。そのため昼すぎから風が出て曇ってくるでしょう。夕方には風は更に強くなり、ところにより雨も降るでしょう。夜には風と雨がかなり強くなると予想されますのでお出かけの際はご注意ください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:11;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:27:"3. だんだん悪くなる";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:27:"3. だんだん悪くなる";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13735";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:40:"6. 天気はこれからどうなるか?";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:12;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13736";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:576:"最近ろうそくが一年中売れていて、その明かりを楽しむ人が増えている。なぜ今、ろうそくに人気が集まっているのだろうか。蛍光灯けいこうとうの白い光は、人を活動的にさせるが、緊張を解とくことはできないそうだ。ろうそくなどのオレンジ色の光は、心を落ち着かせ、ストレスや体の疲れを取ってくれるらしい。不安の多い社会の中で、こういう効果に期待きたいしてろうそくに火をつける人が増えているようである。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:13;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:105:"4. ろうそくの光によって、心や体を休ませようとする人が多くなっているから";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:105:"4. ろうそくの光によって、心や体を休ませようとする人が多くなっているから";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13737";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:108:"7. ろうそくに人気が集まっているとあるが、その理由は、何だと言っているか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:14;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13738";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:653:"交流会にご出席のみなさん こんにちは、田中です。 今週土曜日の交流会は、「ナポリ」というイタリア料理のレストツンにしました。12時からです。 「ナポリ」の場所ですが、地下鉄南北線の朝日駅から歩いて10分ぐらいのところにあります。わかりにくい場所にあるので、みんなで一緒に店に向かおうと思います。朝日駅の1番出口に11時45分に集合してください。車で直接行く人は、前日までにメールをください。 それでは、楽しみにしています。 寺前テニスクラブ代表田中真理子";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:15;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:84:"3. 車で行く場合は、今週の金曜日までに田中さんに連絡する。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:84:"3. 車で行く場合は、今週の金曜日までに田中さんに連絡する。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13739";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:99:"8. このメーを見て、交流会に出席する人はどうしなければならないか。　";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:16;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13740";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:803:"本屋で本を選ぶときに、面白いかどうかとか必要かどうかなどを調べるために、ちょっと中を見てみるのは普通の行動だ。しかしマンガなどの場合はこれができない。薄いビニールで包装されているので中が開けないのだ。マンガを立ち読みしただけで買わない人が増えすぎたためにこうなった。しかし、やはり本は中を見て価値があるかどうか確認してから買いたい。そこで、ある本屋が15ページぐらい読むことができる「ためほんくん」という名前のコンピューターを置くことにした。「ためほんくん」とは試しに読む本と言う意味である。売上げに効果があったかどうかはまだわからない。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:17;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:39:"4. どんなマンガか見せるため";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:39:"4. どんなマンガか見せるため";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13741";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:72:"9. どうして「ためほんくん」を置くことにしたのか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:18;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13742";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:677:"これは喫茶店のコーヒー教室の案内である コーヒー教室のご案内 コーヒーについて知識(豆の種類や特徴)と、おいしいコーヒーの入れ方を学びませんか。 プロの技術をお教えいたします。教室の最後にはご自分で入れたコーヒーと「ふかだ」自慢のケーキをお楽しみください。おかえりの際には、お土産にコーヒー豆(100 グラム) をお持ち帰りください。 日 時:7月15日(水) 13:00~15:00 場 所:コーヒー「ふかだ」 参加費:1,500 円 定 員:10名 参加ご希望の方は、レジでお申し込みください。 コーヒー「ふかだ」";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:19;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:90:"1. 上手なコーヒーの入れ方が学べ、コーヒー豆をもらって帰れる。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:90:"1. 上手なコーヒーの入れ方が学べ、コーヒー豆をもらって帰れる。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13743";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:58:"10. このコーヒー教室でできることは何か。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:20;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13744";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:799:"美術館のチケット売り場に、この案内がはってある。 山森市美術館「パスポートカード」のご案内 案内森市美術館では、1年に何回でも入館できる 「パスポートカード」を用意山森市しています。 価格：大人5,000　円高校生：3,000円　小中学生：1,000円 期限：お申し込み当日から1年間 必要書類：顔写真、申込書 カードができるまで多少時間がかかりますので、カードはお帰りの時にお渡しします。16時以降に申し込まれた場合は、翌日以降のお渡しになります。 カードが不要になっても、お金はお返しできません。 カードの作り直し（なくした場合など）には、もう一度料金がかかります。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:21;a:15:{i:0;s:0:"";i:1;s:92:"2. 16時までに申し込めば、その日にカードを受け取ることができる。";i:2;s:92:"2. 16時までに申し込めば、その日にカードを受け取ることができる。";i:3;s:0:"";s:11:"user_answer";a:1:{i:1;s:92:"2. 16時までに申し込めば、その日にカードを受け取ることができる。";}s:14:"correct_answer";a:1:{i:1;s:92:"2. 16時までに申し込めば、その日にカードを受け取ることができる。";}s:7:"correct";s:7:"correct";s:2:"id";s:5:"13745";s:6:"points";d:6;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:103:"11. この案内から、「パスポートカード」について、どんなことがわかるか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:22;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13746";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:538:"「夜ご飯」という言葉を初めて聞いた。最近、「夜ご飯」の代わりに使われるようになってきたらしい。食事の時間が「晩」から「夜」へとだんだん遅くなり、言葉も一緒に変化してきたそうだが、「夜ご飯」という言葉は変だと感じる。しかし、「晩ご飯」も「夕ご飯」の代わりに使われるようになった言葉だそうだ。「夕ご飯」が当たり前だった人たちも、 私と同じように感じたかもしれない。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:23;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:45:"2. 「晩ご飯」という言葉は変だ。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:45:"2. 「晩ご飯」という言葉は変だ。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13747";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:190:"12. 「夕ご飯」が当たり前だった人たちも、私と同じように感じたとあるが、「夕ご飯」が当たり前だった人たちは、どのように感じたのか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:24;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13748";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:535:"日本人にはくだものが好きな人が多いと言われている。日本で最もたくさんとれるくだものはミカンで、つぎにリンゴだ。それでは、日本でいちばん食べられているくだものは何だろう。実は、それはミカンではなく、日本ではほとんどとれないバナナだ。1年間に一人が食べるバナナは5.7キロと言われている。バナナは手でかんたんにむいて食べられるし、体にもいいことが人気の理由のようだ。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:25;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:99:"1. 日本では、ミカンがたくさんとれるが、人気があるのはバナナである。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:99:"1. 日本では、ミカンがたくさんとれるが、人気があるのはバナナである。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13749";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:49:"13. 文章の内容と同じものはどれか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:26;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13750";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:635:"「携帯電話は持っていないんです。」私がそう言うと、たいていの人は驚く。「あったら便利ですよ。」と言われるが、それは私もよくわかっている。 実は、私も以前、携帯電話を持っていた。しかし、いつどこにいても電話に出なければいけない気がして、それが嫌で持つのをやめてしまったのだ。すると、とても気持ちが楽になった。 最近は料金が安いものもあるようだし、携帯電話がない生活には不便なこともある。それでも、私は今のままでいいと思っている。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:27;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:114:"2. 便利だと思うが、いつも電話を気にする生活は嫌なので、今は持つつもりはない。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:114:"2. 便利だと思うが、いつも電話を気にする生活は嫌なので、今は持つつもりはない。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13751";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:79:"14. 携帯電話について、「私」はどのように考えているか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:28;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13752";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:449:"カクさんの学校のかみや服装の規則はとてもきびしいです。 １　かみを染めない。 ２　かみの長さは肩まで。それ以上の場合は黒いゴムを使って1つあるいは2つに結ぶ。 ３　前がみは眉が見える状態にする。 ４　リボンなどのかざりは禁止する。 ５　服はいつも全部のボタンをかける。 ６　スカートはひざが見えない長さにする。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:29;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:48:"3. 前がみを長くて分け耳にかける。";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:48:"3. 前がみを長くて分け耳にかける。";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"13753";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:64:"15. 次の中で規則に違反していないのはどれか。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}}i:2;s:0:"";s:7:"contact";a:0:{}s:8:"timer_ms";i:1742128747382;s:8:"pagetime";a:0:{}s:16:"hidden_questions";N;s:21:"total_possible_points";d:90;s:25:"total_attempted_questions";i:1;s:23:"minimum_possible_points";i:0;s:15:"quiz_start_date";s:22:"12:38:46 PM 03/16/2025";}',0,'67d6c66bbc918',0,'Reading &#8211; JLPT N3 #9','https://kumabenkyou.com/qsm_quiz/reading-jlpt-n3-9/');
INSERT INTO `wpbl_mlw_results` VALUES (8,280,'Grammar - JLPT N3 #7',3,0,0,0,39,'None','None','None','None',0,'114.5.147.249','03:03:39 AM 03/20/2025','2025-03-20 03:03:39','a:11:{i:0;i:20;i:1;a:39:{i:0;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"1. だけ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:9:"1. だけ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11454";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:149:"1. （電話で） 母「何か父さんに伝言はある？」 娘「じゃあ、体に気をつけてと（　　　）伝えておいてよ。」";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:1;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"2. 最中なので";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:18:"2. 最中なので";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11455";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:78:"2. 大事な会議の（　　　）、また後で電話してください。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:2;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"3. といっても";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:18:"3. といっても";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11456";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:133:"3. 母「手術が成功するか心配で･･･。」 娘「手術（　　　）すぐに終わるし、心配しないで。」";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:3;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"2. いくら";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:12:"2. いくら";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11457";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:92:"4. （　　　）説明しても、あの    人は    わかりませんでした。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:4;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"2. としても";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:15:"2. としても";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11458";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:111:"5. あした、もし雨が降った （　　　） 予定されているスポーツ大会は行います。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:5;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:6:"2. と";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:6:"2. と";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11459";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:85:"6. 確か先輩が、 今日の授業はない（　　　）言っていました。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:6;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:30:"3. 選ばれたこともある";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:30:"3. 選ばれたこともある";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11460";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:91:"7. 私の姉は、3歳から柔道を続けていて、県の代表選手に（　　　）";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:7;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"4. とか";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:9:"4. とか";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11461";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:75:"8. 台風が来て、昨日は沖縄では大雨だった（　　　）。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:8;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"3. はじめ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:12:"3. はじめ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11462";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:90:"9. 社長を（　　　）多くの社員が結婚式に出張してくれました。  ";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:9;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:30:"4. みたらどうでしょう";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:30:"4. みたらどうでしょう";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11463";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:183:"10. A：「昨日からずっと頭が痛いんですが、どこかいい病院をわか知りませんか。 B：「そうですねぇ。 ABC病院に行って（　　　） 。」";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:10;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"1. こんなに";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:15:"1. こんなに";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11464";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:244:"11. 田中「ぼく、チーズが苦手なんです。山下さん、よかったらどうぞ。」 山下「ありがとうございます。ああ、おいしい。（　　　） おいしいのに、どうして苦手なんですか。」";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:11;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"2. にかけて";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:15:"2. にかけて";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11465";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:77:"12. 夏から秋（　　　）、 いろいろな祭りがひらかれる。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:12;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:21:"4. 申しましたか";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:21:"4. 申しましたか";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11466";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:43:"13. 弟は先生に何と（　　　）。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:13;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:12:"2. だけで";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:12:"2. だけで";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11467";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:85:"14. 朝、牛乳を飲んだ（　　　）、今まで何も食べていません。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:14;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:33:"4. させていただきました";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:33:"4. させていただきました";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11468";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:124:"15. おかげさまで、とても楽しくこの仕事を（　　　）、またよろしくお願い申し上げます。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:15;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11469";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:1547:"下の文章は,　留学生のヤンさんが、「最近びっくりしたこと」についてスピードするために書いた作文です。 夜でも「おはよう」 ソン　ジフン 韓国で、日本語の「おはよう」は朝のあいさつだと習ったのですが、日本に留学して、日本人の先輩や友逮が朝以外でも使っているのを聞いて驚きました。先輩や友達が間違っているのでしょうか。[ 54 ]、わたしが習ったことがまちがっているのでしょか。 ある日の午後、学校で先輩に「おはよう。Jと [ 55 ]。起きてすぐに来たから、間違えて「おはよう。」と言ったのだと思いました。しかしその後で、昼でも夜でも「おはよう。」と言う人が、周りの友逮にもいることに気が [ 56 ]。友遠に理由を聞いたら、人が24時間働いているホテルやコンビ二では、出勤したとき、時間に関係なく「おはよう」を使うということを教えてくれました。確かに、 [ 57 ]先輩もコンビニで働いていています。そういう所で働いている人が、仕事で使う「おはようJを、学校でも使ってしまっているのでしょう。 先輩や友違がなぜ朝ではないのに「おはよう」を使っているのか、わかりました。そして．教窒で習ったのとは違う使い方もあるということを [ 58 ]。ほかにもこんな例はあるでしょうか、調べてみたいです。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:16;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"4. それとも";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:15:"4. それとも";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11470";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:6:"1. (1)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:17;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:21:"3. 言われました";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:21:"3. 言われました";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11471";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:6:"2. (2)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:18;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:21:"1. ついたのです";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:21:"1. ついたのです";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11472";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:6:"3. (3)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:19;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"2. その";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:9:"2. その";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11473";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:6:"4. (4)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:20;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"4. 知りました";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:18:"4. 知りました";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11474";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:6:"5. (5)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:21;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11475";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:1466:"下の作文は、留学生が書いた作文です。 日本人の天気の話 アルティカ　ミラ 日本へ来て、多くの人が天気の話をすることに気がつきました。アパートの管理人さんは朝会うと、「おはよう。」の後に「今日は暑いね。」とか「いい天気だね。」と言います。あちこちで、多くの人があいさつに続けて天気の話をしているのを聞きました。[ １ ]、私の国では天気の話をあまりしないので、なぜ天気の話をするのかわかりませんでした。私はしてもしなくてもいいと考え、自分からはしていませんでした。 ところが、ある冬の寒い朝、日本人の友達に会ったとき、「おはよう。」の後で自然に「寒いね」と[ ２ ]。友達は「本当だね」と答え、その後、寒い冬に食べるとおいしい食べ物や冬の服の話になりました。天気の話が天気に関係した話に[ ３ ]、おもしろいと思いました。 私の国は一年中暑いですが、日本は四季があって気温の変化が大きいし、天気もよく変わります。そのため、多くの人が天気に関心を[ ４ ]。 最近は管理人さんともよく天気の話をするようになって、天気の話は誰とでもしやすいことに気づきました。[ ５ ]も天気の話をする人が多い理由の一つだと思います。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:22;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"3. けれども";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:15:"3. けれども";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11476";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:6:"6. (1)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:23;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:30:"4. 言ってしまいました";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:30:"4. 言ってしまいました";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11477";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:6:"7. (2)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:24;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"1. 広がって";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:15:"1. 広がって";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11478";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:6:"8. (3)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:25;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:30:"3. 持つのかもしれせん";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:30:"3. 持つのかもしれせん";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11479";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:6:"9. (4)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:26;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"2. これ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:9:"2. これ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11480";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:7:"10. (5)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:27;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11481";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:1319:"以下の文章は、イタリアから来た留学生のビアンカさんが書いた作文である。 私が好きな日本の料理 ロマーノビアンカ 　私が好きな日本の料理は「納豆スパゲティJです。私は2年前に初めて納豆を見ましたイタリアの大学で日本語を勉強していたとき、先生がパーティーに納豆を [ 1 ]。けれど、そのときはにおいが強くて食べられませんでした。 　[ 2 ]、日本に来て友達とレトランに行ったとき、友達の納豆スパゲティを少し食べさせてもらって驚きました。ほとんどにおいがなく、とてもおいしかったからです。それから、週に3.4回そのレストランに行って納豆スパゲティを [ 3 ] 。しばらくすると、ほかのスパゲティがも気になり始めました。日本にはイタリアにない味のスパゲティがあります。梅を使ったものやしょうゆ味のものです。私は、[ 4 ] も食べてみました。でもやはり納豆スパゲティがいちばんおいしかったです。最近は納豆を買ってきて自分でも作って食べています。 帰国したら、友達や家族に納豆スパゲティを [ 5 ] 。みんなきっとびっくりするでしょう。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:28;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:42:"1. 持ってきてくださったのです";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:42:"1. 持ってきてくださったのです";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11482";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:7:"11. (1)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:29;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"3. ところが";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:15:"3. ところが";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11483";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:7:"12. (2)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:30;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:33:"2. 頼むようになりました";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:1;s:33:"2. 頼むようになりました";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11484";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:7:"13. (3)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:31;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:30:"4. そういうスパゲティ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:30:"4. そういうスパゲティ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11485";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:7:"14. (4)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:32;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:30:"4. 作ってあげたいです";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:30:"4. 作ってあげたいです";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11486";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:7:"15. (5)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:33;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:0:"";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:0:{}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11487";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:1287:"わたしの父 王暁丹 わたしの父は太っていて、丸い顔をしています。それに、あまり背が高くないので首も短く見えます。－度、父の誕生日に洋服をプレゼントしたことがありますが、父の体に合うサイズの服を見つけるのはとても大変でした。でも、この間、父の若いころの写真を見てびっくりしました。写真の父は今とは全然 違って、[ 1 ]のです。[ 2 ]、丸い顔だけは今と同じでした。母に聞いてみると、若いころの父はとてもかっこよくて、いつも女の人に食事に誘さそわれるので、母はずいぶん心配したそうです。わたしは今の、太くて背が低く、丸い顔の父が大好きなので、父の昔の写真は[ 3 ]。 父の職業は会社員で、貿易ぼうえき会社に勤めていますが、会社が遠いので毎朝7時には家を出ます。[ 4 ]がわたしはいつもかわいそうになります。でも、父が会社を休んだことはまだ一度もありません。わたしたち家族のために、父は今日もがんばっています。わたしも早く大学を卒業して、社会人になって親孝行おやこうこうができるように[ 5 ]。";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:34;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:18:"3. やせていた";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:18:"3. やせていた";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11488";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:7:"16. (1)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:35;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:9:"1. ただ";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:0;s:9:"1. ただ";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11489";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:7:"17. (2)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:36;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:39:"4. 見なかったことにしました";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:3;s:39:"4. 見なかったことにしました";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11490";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:7:"18. (3)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:37;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:15:"3. そんな父";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:15:"3. そんな父";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11491";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:7:"19. (4)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}i:38;a:15:{i:0;s:0:"";i:1;s:0:"";i:2;s:36:"3. なりたいと思っています";i:3;s:0:"";s:11:"user_answer";a:0:{}s:14:"correct_answer";a:1:{i:2;s:36:"3. なりたいと思っています";}s:7:"correct";s:9:"incorrect";s:2:"id";s:5:"11492";s:6:"points";i:0;s:8:"category";s:0:"";s:15:"multicategories";a:0:{}s:13:"question_type";s:1:"0";s:14:"question_title";s:7:"20. (5)";s:17:"user_compare_text";s:0:"";s:14:"case_sensitive";s:0:"";}}i:2;s:0:"";s:7:"contact";a:0:{}s:8:"timer_ms";i:1742439798525;s:8:"pagetime";a:0:{}s:16:"hidden_questions";N;s:21:"total_possible_points";d:75;s:25:"total_attempted_questions";i:0;s:23:"minimum_possible_points";i:0;s:15:"quiz_start_date";s:22:"03:02:57 AM 03/20/2025";}',0,'67db85687f663',0,'Grammar &#8211; JLPT N3 #7','https://kumabenkyou.com/qsm_quiz/grammar-jlpt-n3-7/');
/*!40000 ALTER TABLE `wpbl_mlw_results` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wpbl_options`
--

DROP TABLE IF EXISTS `wpbl_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wpbl_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=14109 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wpbl_options`
--

LOCK TABLES `wpbl_options` WRITE;
/*!40000 ALTER TABLE `wpbl_options` DISABLE KEYS */;
INSERT INTO `wpbl_options` VALUES (1,'cron','a:16:{i:1742766326;a:1:{s:28:"wpvivid_task_monitor_event_2";a:1:{s:32:"afed3d6a72c53f72626ba8e750c1c486";a:2:{s:8:"schedule";b:0;s:4:"args";a:1:{i:0;s:21:"wpvivid-c7ccdd69236ec";}}}}i:1742769269;a:1:{s:34:"wp_privacy_delete_old_export_files";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"hourly";s:4:"args";a:0:{}s:8:"interval";i:3600;}}}i:1742782252;a:1:{s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1742782255;a:2:{s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1742782265;a:1:{s:36:"check_plugin_updates-softaculous-pro";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1742782324;a:1:{s:21:"wp_update_user_counts";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1742825452;a:1:{s:32:"recovery_mode_clean_expired_keys";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1742825524;a:2:{s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:25:"delete_expired_transients";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1742841781;a:1:{s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1742841899;a:1:{s:28:"elementor/tracker/send_event";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1742851468;a:2:{s:16:"llms_backup_logs";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:16:"llms_cleanup_tmp";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1742851469;a:1:{s:30:"llms_helper_check_license_keys";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1743014627;a:1:{s:30:"wp_delete_temp_updater_backups";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}i:1743024033;a:1:{s:21:"ms_init_mixpanel_cron";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}i:1743084652;a:1:{s:30:"wp_site_health_scheduled_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}s:7:"version";i:2;}','on');
INSERT INTO `wpbl_options` VALUES (2,'siteurl','https://kumabenkyou.com','on');
INSERT INTO `wpbl_options` VALUES (3,'home','https://kumabenkyou.com','on');
INSERT INTO `wpbl_options` VALUES (4,'blogname','My Blog','on');
INSERT INTO `wpbl_options` VALUES (5,'blogdescription','My WordPress Blog','on');
INSERT INTO `wpbl_options` VALUES (6,'users_can_register','0','on');
INSERT INTO `wpbl_options` VALUES (7,'admin_email','admin@kumabenkyou.com','on');
INSERT INTO `wpbl_options` VALUES (8,'start_of_week','1','on');
INSERT INTO `wpbl_options` VALUES (9,'use_balanceTags','0','on');
INSERT INTO `wpbl_options` VALUES (10,'use_smilies','1','on');
INSERT INTO `wpbl_options` VALUES (11,'require_name_email','1','on');
INSERT INTO `wpbl_options` VALUES (12,'comments_notify','1','on');
INSERT INTO `wpbl_options` VALUES (13,'posts_per_rss','10','on');
INSERT INTO `wpbl_options` VALUES (14,'rss_use_excerpt','0','on');
INSERT INTO `wpbl_options` VALUES (15,'mailserver_url','mail.example.com','on');
INSERT INTO `wpbl_options` VALUES (16,'mailserver_login','login@example.com','on');
INSERT INTO `wpbl_options` VALUES (17,'mailserver_pass','','on');
INSERT INTO `wpbl_options` VALUES (18,'mailserver_port','110','on');
INSERT INTO `wpbl_options` VALUES (19,'default_category','1','on');
INSERT INTO `wpbl_options` VALUES (20,'default_comment_status','open','on');
INSERT INTO `wpbl_options` VALUES (21,'default_ping_status','open','on');
INSERT INTO `wpbl_options` VALUES (22,'default_pingback_flag','1','on');
INSERT INTO `wpbl_options` VALUES (23,'posts_per_page','10','on');
INSERT INTO `wpbl_options` VALUES (24,'date_format','F j, Y','on');
INSERT INTO `wpbl_options` VALUES (25,'time_format','g:i a','on');
INSERT INTO `wpbl_options` VALUES (26,'links_updated_date_format','F j, Y g:i a','on');
INSERT INTO `wpbl_options` VALUES (27,'comment_moderation','0','on');
INSERT INTO `wpbl_options` VALUES (28,'moderation_notify','1','on');
INSERT INTO `wpbl_options` VALUES (29,'permalink_structure','/%year%/%monthnum%/%day%/%postname%/','on');
INSERT INTO `wpbl_options` VALUES (30,'rewrite_rules','a:143:{s:11:"^wp-json/?$";s:22:"index.php?rest_route=/";s:14:"^wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:21:"^index.php/wp-json/?$";s:22:"index.php?rest_route=/";s:24:"^index.php/wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:17:"^wp-sitemap\\.xml$";s:23:"index.php?sitemap=index";s:17:"^wp-sitemap\\.xsl$";s:36:"index.php?sitemap-stylesheet=sitemap";s:23:"^wp-sitemap-index\\.xsl$";s:34:"index.php?sitemap-stylesheet=index";s:48:"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$";s:75:"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]";s:34:"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$";s:47:"index.php?sitemap=$matches[1]&paged=$matches[2]";s:11:"qsm_quiz/?$";s:28:"index.php?post_type=qsm_quiz";s:41:"qsm_quiz/feed/(feed|rdf|rss|rss2|atom)/?$";s:45:"index.php?post_type=qsm_quiz&feed=$matches[1]";s:36:"qsm_quiz/(feed|rdf|rss|rss2|atom)/?$";s:45:"index.php?post_type=qsm_quiz&feed=$matches[1]";s:28:"qsm_quiz/page/([0-9]{1,})/?$";s:46:"index.php?post_type=qsm_quiz&paged=$matches[1]";s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:23:"category/(.+?)/embed/?$";s:46:"index.php?category_name=$matches[1]&embed=true";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:20:"tag/([^/]+)/embed/?$";s:36:"index.php?tag=$matches[1]&embed=true";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:43:"index.php?tag=$matches[1]&paged=$matches[2]";s:14:"tag/([^/]+)/?$";s:25:"index.php?tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:21:"type/([^/]+)/embed/?$";s:44:"index.php?post_format=$matches[1]&embed=true";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:46:"e-floating-buttons/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:56:"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:76:"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:71:"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:71:"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:52:"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:35:"e-floating-buttons/([^/]+)/embed/?$";s:51:"index.php?e-floating-buttons=$matches[1]&embed=true";s:39:"e-floating-buttons/([^/]+)/trackback/?$";s:45:"index.php?e-floating-buttons=$matches[1]&tb=1";s:47:"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$";s:58:"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]";s:54:"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$";s:58:"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]";s:43:"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$";s:57:"index.php?e-floating-buttons=$matches[1]&page=$matches[2]";s:35:"e-floating-buttons/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:45:"e-floating-buttons/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:65:"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:60:"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:60:"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:41:"e-floating-buttons/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:53:"qmn_log_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:51:"index.php?qmn_log_type=$matches[1]&feed=$matches[2]";s:48:"qmn_log_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:51:"index.php?qmn_log_type=$matches[1]&feed=$matches[2]";s:29:"qmn_log_type/([^/]+)/embed/?$";s:45:"index.php?qmn_log_type=$matches[1]&embed=true";s:41:"qmn_log_type/([^/]+)/page/?([0-9]{1,})/?$";s:52:"index.php?qmn_log_type=$matches[1]&paged=$matches[2]";s:23:"qmn_log_type/([^/]+)/?$";s:34:"index.php?qmn_log_type=$matches[1]";s:36:"qsm_quiz/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:46:"qsm_quiz/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:66:"qsm_quiz/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:61:"qsm_quiz/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:61:"qsm_quiz/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:42:"qsm_quiz/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:25:"qsm_quiz/([^/]+)/embed/?$";s:41:"index.php?qsm_quiz=$matches[1]&embed=true";s:29:"qsm_quiz/([^/]+)/trackback/?$";s:35:"index.php?qsm_quiz=$matches[1]&tb=1";s:49:"qsm_quiz/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?qsm_quiz=$matches[1]&feed=$matches[2]";s:44:"qsm_quiz/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?qsm_quiz=$matches[1]&feed=$matches[2]";s:37:"qsm_quiz/([^/]+)/page/?([0-9]{1,})/?$";s:48:"index.php?qsm_quiz=$matches[1]&paged=$matches[2]";s:44:"qsm_quiz/([^/]+)/comment-page-([0-9]{1,})/?$";s:48:"index.php?qsm_quiz=$matches[1]&cpage=$matches[2]";s:33:"qsm_quiz/([^/]+)(?:/([0-9]+))?/?$";s:47:"index.php?qsm_quiz=$matches[1]&page=$matches[2]";s:25:"qsm_quiz/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:35:"qsm_quiz/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:55:"qsm_quiz/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:50:"qsm_quiz/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:50:"qsm_quiz/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:31:"qsm_quiz/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:12:"robots\\.txt$";s:18:"index.php?robots=1";s:13:"favicon\\.ico$";s:19:"index.php?favicon=1";s:12:"sitemap\\.xml";s:24:"index.php??sitemap=index";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:8:"embed/?$";s:21:"index.php?&embed=true";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:27:"comment-page-([0-9]{1,})/?$";s:39:"index.php?&page_id=88&cpage=$matches[1]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:17:"comments/embed/?$";s:21:"index.php?&embed=true";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:20:"search/(.+)/embed/?$";s:34:"index.php?s=$matches[1]&embed=true";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:23:"author/([^/]+)/embed/?$";s:44:"index.php?author_name=$matches[1]&embed=true";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:45:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$";s:74:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:32:"([0-9]{4})/([0-9]{1,2})/embed/?$";s:58:"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:19:"([0-9]{4})/embed/?$";s:37:"index.php?year=$matches[1]&embed=true";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:58:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:68:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:88:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:83:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:83:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:64:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:53:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$";s:91:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$";s:85:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1";s:77:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]";s:72:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]";s:65:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$";s:98:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]";s:72:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$";s:98:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]";s:61:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]";s:47:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:57:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:77:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:72:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:72:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:53:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]";s:51:"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]";s:38:"([0-9]{4})/comment-page-([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&cpage=$matches[2]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:".?.+?/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"(.?.+?)/embed/?$";s:41:"index.php?pagename=$matches[1]&embed=true";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:24:"(.?.+?)(?:/([0-9]+))?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";}','on');
INSERT INTO `wpbl_options` VALUES (31,'hack_file','0','on');
INSERT INTO `wpbl_options` VALUES (32,'blog_charset','UTF-8','on');
INSERT INTO `wpbl_options` VALUES (33,'moderation_keys','','off');
INSERT INTO `wpbl_options` VALUES (34,'active_plugins','a:9:{i:0;s:19:"akismet/akismet.php";i:1;s:31:"elementor-pro/elementor-pro.php";i:2;s:23:"elementor/elementor.php";i:3;s:29:"health-check/health-check.php";i:4;s:35:"qsm-certificate/qsm-certificate.php";i:5;s:38:"qsm-google-sheets/qsm-google-sheet.php";i:6;s:36:"quiz-master-next/mlw_quizmaster2.php";i:7;s:35:"softaculous-pro/softaculous-pro.php";i:8;s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";}','on');
INSERT INTO `wpbl_options` VALUES (35,'category_base','','on');
INSERT INTO `wpbl_options` VALUES (36,'ping_sites','http://rpc.pingomatic.com/','on');
INSERT INTO `wpbl_options` VALUES (37,'comment_max_links','2','on');
INSERT INTO `wpbl_options` VALUES (38,'gmt_offset','0','on');
INSERT INTO `wpbl_options` VALUES (39,'default_email_category','1','on');
INSERT INTO `wpbl_options` VALUES (40,'recently_edited','a:5:{i:0;s:85:"/home/kumabenk/public_html/wp-content/themes/dacnis/template-parts/content/single.php";i:2;s:83:"/home/kumabenk/public_html/wp-content/themes/dacnis/template-parts/content/page.php";i:3;s:60:"/home/kumabenk/public_html/wp-content/themes/dacnis/page.php";i:4;s:62:"/home/kumabenk/public_html/wp-content/themes/dacnis/footer.php";i:5;s:64:"/home/kumabenk/public_html/wp-content/themes/dacnis/comments.php";}','off');
INSERT INTO `wpbl_options` VALUES (41,'template','dacnis','on');
INSERT INTO `wpbl_options` VALUES (42,'stylesheet','dacnis','on');
INSERT INTO `wpbl_options` VALUES (43,'comment_registration','0','on');
INSERT INTO `wpbl_options` VALUES (44,'html_type','text/html','on');
INSERT INTO `wpbl_options` VALUES (45,'use_trackback','0','on');
INSERT INTO `wpbl_options` VALUES (46,'default_role','subscriber','on');
INSERT INTO `wpbl_options` VALUES (47,'db_version','58975','on');
INSERT INTO `wpbl_options` VALUES (48,'uploads_use_yearmonth_folders','1','on');
INSERT INTO `wpbl_options` VALUES (49,'upload_path','','on');
INSERT INTO `wpbl_options` VALUES (50,'blog_public','1','on');
INSERT INTO `wpbl_options` VALUES (51,'default_link_category','2','on');
INSERT INTO `wpbl_options` VALUES (52,'show_on_front','page','on');
INSERT INTO `wpbl_options` VALUES (53,'tag_base','','on');
INSERT INTO `wpbl_options` VALUES (54,'show_avatars','1','on');
INSERT INTO `wpbl_options` VALUES (55,'avatar_rating','G','on');
INSERT INTO `wpbl_options` VALUES (56,'upload_url_path','','on');
INSERT INTO `wpbl_options` VALUES (57,'thumbnail_size_w','150','on');
INSERT INTO `wpbl_options` VALUES (58,'thumbnail_size_h','150','on');
INSERT INTO `wpbl_options` VALUES (59,'thumbnail_crop','1','on');
INSERT INTO `wpbl_options` VALUES (60,'medium_size_w','300','on');
INSERT INTO `wpbl_options` VALUES (61,'medium_size_h','300','on');
INSERT INTO `wpbl_options` VALUES (62,'avatar_default','mystery','on');
INSERT INTO `wpbl_options` VALUES (63,'large_size_w','1024','on');
INSERT INTO `wpbl_options` VALUES (64,'large_size_h','1024','on');
INSERT INTO `wpbl_options` VALUES (65,'image_default_link_type','none','on');
INSERT INTO `wpbl_options` VALUES (66,'image_default_size','','on');
INSERT INTO `wpbl_options` VALUES (67,'image_default_align','','on');
INSERT INTO `wpbl_options` VALUES (68,'close_comments_for_old_posts','0','on');
INSERT INTO `wpbl_options` VALUES (69,'close_comments_days_old','14','on');
INSERT INTO `wpbl_options` VALUES (70,'thread_comments','1','on');
INSERT INTO `wpbl_options` VALUES (71,'thread_comments_depth','5','on');
INSERT INTO `wpbl_options` VALUES (72,'page_comments','0','on');
INSERT INTO `wpbl_options` VALUES (73,'comments_per_page','50','on');
INSERT INTO `wpbl_options` VALUES (74,'default_comments_page','newest','on');
INSERT INTO `wpbl_options` VALUES (75,'comment_order','asc','on');
INSERT INTO `wpbl_options` VALUES (76,'sticky_posts','a:0:{}','on');
INSERT INTO `wpbl_options` VALUES (77,'widget_categories','a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (78,'widget_text','a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (79,'widget_rss','a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (80,'uninstall_plugins','a:2:{s:35:"softaculous-pro/softaculous-pro.php";s:30:"softaculous_pro_uninstall_hook";s:23:"elementor/elementor.php";a:2:{i:0;s:21:"Elementor\\Maintenance";i:1;s:9:"uninstall";}}','off');
INSERT INTO `wpbl_options` VALUES (81,'timezone_string','','on');
INSERT INTO `wpbl_options` VALUES (82,'page_for_posts','0','on');
INSERT INTO `wpbl_options` VALUES (83,'page_on_front','88','on');
INSERT INTO `wpbl_options` VALUES (84,'default_post_format','0','on');
INSERT INTO `wpbl_options` VALUES (85,'link_manager_enabled','0','on');
INSERT INTO `wpbl_options` VALUES (86,'finished_splitting_shared_terms','1','on');
INSERT INTO `wpbl_options` VALUES (87,'site_icon','0','on');
INSERT INTO `wpbl_options` VALUES (88,'medium_large_size_w','768','on');
INSERT INTO `wpbl_options` VALUES (89,'medium_large_size_h','0','on');
INSERT INTO `wpbl_options` VALUES (90,'wp_page_for_privacy_policy','3','on');
INSERT INTO `wpbl_options` VALUES (91,'show_comments_cookies_opt_in','1','on');
INSERT INTO `wpbl_options` VALUES (92,'admin_email_lifespan','1747663852','on');
INSERT INTO `wpbl_options` VALUES (93,'disallowed_keys','','off');
INSERT INTO `wpbl_options` VALUES (94,'comment_previously_approved','1','on');
INSERT INTO `wpbl_options` VALUES (95,'auto_plugin_theme_update_emails','a:0:{}','off');
INSERT INTO `wpbl_options` VALUES (96,'auto_update_core_dev','enabled','on');
INSERT INTO `wpbl_options` VALUES (97,'auto_update_core_minor','enabled','on');
INSERT INTO `wpbl_options` VALUES (98,'auto_update_core_major','enabled','on');
INSERT INTO `wpbl_options` VALUES (99,'wp_force_deactivated_plugins','a:0:{}','on');
INSERT INTO `wpbl_options` VALUES (100,'wp_attachment_pages_enabled','0','on');
INSERT INTO `wpbl_options` VALUES (101,'initial_db_version','58975','on');
INSERT INTO `wpbl_options` VALUES (102,'wpbl_user_roles','a:10:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:210:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;s:26:"create_notes_elementor-pro";b:1;s:24:"edit_notes_elementor-pro";b:1;s:26:"delete_notes_elementor-pro";b:1;s:24:"read_notes_elementor-pro";b:1;s:31:"edit_others_notes_elementor-pro";b:1;s:33:"delete_others_notes_elementor-pro";b:1;s:39:"read_others_private_notes_elementor-pro";b:1;s:13:"read_qsm_quiz";b:1;s:13:"edit_qsm_quiz";b:1;s:16:"edit_qsm_quizzes";b:1;s:18:"create_qsm_quizzes";b:1;s:21:"publish_stm_lms_posts";b:1;s:20:"delete_stm_lms_posts";b:1;s:27:"delete_others_stm_lms_posts";b:1;s:28:"delete_private_stm_lms_posts";b:1;s:30:"delete_published_stm_lms_posts";b:1;s:18:"edit_stm_lms_posts";b:1;s:25:"edit_others_stm_lms_posts";b:1;s:26:"edit_private_stm_lms_posts";b:1;s:28:"edit_published_stm_lms_posts";b:1;s:26:"read_private_stm_lms_posts";b:1;s:20:"lifterlms_instructor";b:1;s:16:"manage_lifterlms";b:1;s:24:"manage_earned_engagement";b:1;s:22:"view_lifterlms_reports";b:1;s:29:"view_others_lifterlms_reports";b:1;s:6:"enroll";b:1;s:8:"unenroll";b:1;s:15:"create_students";b:1;s:11:"view_grades";b:1;s:13:"view_students";b:1;s:20:"view_others_students";b:1;s:13:"edit_students";b:1;s:20:"edit_others_students";b:1;s:15:"delete_students";b:1;s:22:"delete_others_students";b:1;s:11:"read_course";b:1;s:20:"read_private_courses";b:1;s:11:"edit_course";b:1;s:12:"edit_courses";b:1;s:19:"edit_others_courses";b:1;s:20:"edit_private_courses";b:1;s:22:"edit_published_courses";b:1;s:15:"publish_courses";b:1;s:13:"delete_course";b:1;s:14:"delete_courses";b:1;s:22:"delete_private_courses";b:1;s:24:"delete_published_courses";b:1;s:21:"delete_others_courses";b:1;s:14:"create_courses";b:1;s:11:"read_lesson";b:1;s:20:"read_private_lessons";b:1;s:11:"edit_lesson";b:1;s:12:"edit_lessons";b:1;s:19:"edit_others_lessons";b:1;s:20:"edit_private_lessons";b:1;s:22:"edit_published_lessons";b:1;s:15:"publish_lessons";b:1;s:13:"delete_lesson";b:1;s:14:"delete_lessons";b:1;s:22:"delete_private_lessons";b:1;s:24:"delete_published_lessons";b:1;s:21:"delete_others_lessons";b:1;s:14:"create_lessons";b:1;s:9:"read_quiz";b:1;s:20:"read_private_quizzes";b:1;s:9:"edit_quiz";b:1;s:12:"edit_quizzes";b:1;s:19:"edit_others_quizzes";b:1;s:20:"edit_private_quizzes";b:1;s:22:"edit_published_quizzes";b:1;s:15:"publish_quizzes";b:1;s:11:"delete_quiz";b:1;s:14:"delete_quizzes";b:1;s:22:"delete_private_quizzes";b:1;s:24:"delete_published_quizzes";b:1;s:21:"delete_others_quizzes";b:1;s:14:"create_quizzes";b:1;s:13:"read_question";b:1;s:22:"read_private_questions";b:1;s:13:"edit_question";b:1;s:14:"edit_questions";b:1;s:21:"edit_others_questions";b:1;s:22:"edit_private_questions";b:1;s:24:"edit_published_questions";b:1;s:17:"publish_questions";b:1;s:15:"delete_question";b:1;s:16:"delete_questions";b:1;s:24:"delete_private_questions";b:1;s:26:"delete_published_questions";b:1;s:23:"delete_others_questions";b:1;s:16:"create_questions";b:1;s:15:"read_membership";b:1;s:24:"read_private_memberships";b:1;s:15:"edit_membership";b:1;s:16:"edit_memberships";b:1;s:23:"edit_others_memberships";b:1;s:24:"edit_private_memberships";b:1;s:26:"edit_published_memberships";b:1;s:19:"publish_memberships";b:1;s:17:"delete_membership";b:1;s:18:"delete_memberships";b:1;s:26:"delete_private_memberships";b:1;s:28:"delete_published_memberships";b:1;s:25:"delete_others_memberships";b:1;s:18:"create_memberships";b:1;s:18:"manage_course_cats";b:1;s:16:"edit_course_cats";b:1;s:18:"delete_course_cats";b:1;s:18:"assign_course_cats";b:1;s:26:"manage_course_difficulties";b:1;s:24:"edit_course_difficulties";b:1;s:26:"delete_course_difficulties";b:1;s:26:"assign_course_difficulties";b:1;s:18:"manage_course_tags";b:1;s:16:"edit_course_tags";b:1;s:18:"delete_course_tags";b:1;s:18:"assign_course_tags";b:1;s:20:"manage_course_tracks";b:1;s:18:"edit_course_tracks";b:1;s:20:"delete_course_tracks";b:1;s:20:"assign_course_tracks";b:1;s:22:"manage_membership_cats";b:1;s:20:"edit_membership_cats";b:1;s:22:"delete_membership_cats";b:1;s:22:"assign_membership_cats";b:1;s:22:"manage_membership_tags";b:1;s:20:"edit_membership_tags";b:1;s:22:"delete_membership_tags";b:1;s:22:"assign_membership_tags";b:1;s:25:"manage_lifterlms_api_keys";b:1;s:25:"manage_lifterlms_webhooks";b:1;s:18:"duplicate_qsm_quiz";b:1;s:15:"delete_qsm_quiz";b:1;s:23:"edit_others_qsm_quizzes";b:1;s:19:"publish_qsm_quizzes";b:1;s:24:"read_private_qsm_quizzes";b:1;s:18:"delete_qsm_quizzes";b:1;s:26:"delete_private_qsm_quizzes";b:1;s:28:"delete_published_qsm_quizzes";b:1;s:25:"delete_others_qsm_quizzes";b:1;s:24:"edit_private_qsm_quizzes";b:1;s:26:"edit_published_qsm_quizzes";b:1;s:26:"manage_qsm_quiz_categories";b:1;s:28:"manage_qsm_quiz_answer_label";b:1;s:20:"view_qsm_quiz_result";b:1;s:24:"edit_qsm_quiz_categories";b:1;s:26:"assign_qsm_quiz_categories";b:1;s:26:"delete_qsm_quiz_categories";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:34:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:10:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:5:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}s:18:"stm_lms_instructor";a:2:{s:4:"name";s:10:"Instructor";s:12:"capabilities";a:13:{s:4:"read";b:1;s:12:"upload_files";b:1;s:21:"publish_stm_lms_posts";b:1;s:18:"edit_stm_lms_posts";b:1;s:20:"delete_stm_lms_posts";b:1;s:17:"edit_stm_lms_post";b:1;s:19:"delete_stm_lms_post";b:1;s:18:"read_stm_lms_posts";b:1;s:10:"list_users";b:1;s:27:"delete_others_stm_lms_posts";b:0;s:25:"edit_others_stm_lms_posts";b:0;s:26:"read_private_stm_lms_posts";b:0;s:10:"edit_posts";b:1;}}s:11:"lms_manager";a:2:{s:4:"name";s:11:"LMS Manager";s:12:"capabilities";a:143:{s:20:"lifterlms_instructor";b:1;s:16:"manage_lifterlms";b:1;s:24:"manage_earned_engagement";b:1;s:22:"view_lifterlms_reports";b:1;s:29:"view_others_lifterlms_reports";b:1;s:6:"enroll";b:1;s:8:"unenroll";b:1;s:15:"create_students";b:1;s:11:"view_grades";b:1;s:13:"view_students";b:1;s:20:"view_others_students";b:1;s:13:"edit_students";b:1;s:20:"edit_others_students";b:1;s:15:"delete_students";b:1;s:22:"delete_others_students";b:1;s:18:"read_private_pages";b:1;s:18:"read_private_posts";b:1;s:10:"edit_posts";b:1;s:10:"edit_pages";b:1;s:20:"edit_published_posts";b:1;s:20:"edit_published_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"edit_private_posts";b:1;s:17:"edit_others_posts";b:1;s:17:"edit_others_pages";b:1;s:13:"publish_posts";b:1;s:13:"publish_pages";b:1;s:12:"delete_posts";b:1;s:12:"delete_pages";b:1;s:20:"delete_private_pages";b:1;s:20:"delete_private_posts";b:1;s:22:"delete_published_pages";b:1;s:22:"delete_published_posts";b:1;s:19:"delete_others_posts";b:1;s:19:"delete_others_pages";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:17:"moderate_comments";b:1;s:12:"upload_files";b:1;s:6:"export";b:1;s:6:"import";b:1;s:10:"edit_users";b:1;s:12:"create_users";b:1;s:10:"list_users";b:1;s:13:"promote_users";b:1;s:12:"delete_users";b:1;s:4:"read";b:1;s:11:"read_course";b:1;s:20:"read_private_courses";b:1;s:11:"edit_course";b:1;s:12:"edit_courses";b:1;s:19:"edit_others_courses";b:1;s:20:"edit_private_courses";b:1;s:22:"edit_published_courses";b:1;s:15:"publish_courses";b:1;s:13:"delete_course";b:1;s:14:"delete_courses";b:1;s:22:"delete_private_courses";b:1;s:24:"delete_published_courses";b:1;s:21:"delete_others_courses";b:1;s:14:"create_courses";b:1;s:11:"read_lesson";b:1;s:20:"read_private_lessons";b:1;s:11:"edit_lesson";b:1;s:12:"edit_lessons";b:1;s:19:"edit_others_lessons";b:1;s:20:"edit_private_lessons";b:1;s:22:"edit_published_lessons";b:1;s:15:"publish_lessons";b:1;s:13:"delete_lesson";b:1;s:14:"delete_lessons";b:1;s:22:"delete_private_lessons";b:1;s:24:"delete_published_lessons";b:1;s:21:"delete_others_lessons";b:1;s:14:"create_lessons";b:1;s:9:"read_quiz";b:1;s:20:"read_private_quizzes";b:1;s:9:"edit_quiz";b:1;s:12:"edit_quizzes";b:1;s:19:"edit_others_quizzes";b:1;s:20:"edit_private_quizzes";b:1;s:22:"edit_published_quizzes";b:1;s:15:"publish_quizzes";b:1;s:11:"delete_quiz";b:1;s:14:"delete_quizzes";b:1;s:22:"delete_private_quizzes";b:1;s:24:"delete_published_quizzes";b:1;s:21:"delete_others_quizzes";b:1;s:14:"create_quizzes";b:1;s:13:"read_question";b:1;s:22:"read_private_questions";b:1;s:13:"edit_question";b:1;s:14:"edit_questions";b:1;s:21:"edit_others_questions";b:1;s:22:"edit_private_questions";b:1;s:24:"edit_published_questions";b:1;s:17:"publish_questions";b:1;s:15:"delete_question";b:1;s:16:"delete_questions";b:1;s:24:"delete_private_questions";b:1;s:26:"delete_published_questions";b:1;s:23:"delete_others_questions";b:1;s:16:"create_questions";b:1;s:15:"read_membership";b:1;s:24:"read_private_memberships";b:1;s:15:"edit_membership";b:1;s:16:"edit_memberships";b:1;s:23:"edit_others_memberships";b:1;s:24:"edit_private_memberships";b:1;s:26:"edit_published_memberships";b:1;s:19:"publish_memberships";b:1;s:17:"delete_membership";b:1;s:18:"delete_memberships";b:1;s:26:"delete_private_memberships";b:1;s:28:"delete_published_memberships";b:1;s:25:"delete_others_memberships";b:1;s:18:"create_memberships";b:1;s:18:"manage_course_cats";b:1;s:16:"edit_course_cats";b:1;s:18:"delete_course_cats";b:1;s:18:"assign_course_cats";b:1;s:26:"manage_course_difficulties";b:1;s:24:"edit_course_difficulties";b:1;s:26:"delete_course_difficulties";b:1;s:26:"assign_course_difficulties";b:1;s:18:"manage_course_tags";b:1;s:16:"edit_course_tags";b:1;s:18:"delete_course_tags";b:1;s:18:"assign_course_tags";b:1;s:20:"manage_course_tracks";b:1;s:18:"edit_course_tracks";b:1;s:20:"delete_course_tracks";b:1;s:20:"assign_course_tracks";b:1;s:22:"manage_membership_cats";b:1;s:20:"edit_membership_cats";b:1;s:22:"delete_membership_cats";b:1;s:22:"assign_membership_cats";b:1;s:22:"manage_membership_tags";b:1;s:20:"edit_membership_tags";b:1;s:22:"delete_membership_tags";b:1;s:22:"assign_membership_tags";b:1;s:25:"manage_lifterlms_api_keys";b:1;s:25:"manage_lifterlms_webhooks";b:1;}}s:10:"instructor";a:2:{s:4:"name";s:10:"Instructor";s:12:"capabilities";a:51:{s:20:"lifterlms_instructor";b:1;s:22:"view_lifterlms_reports";b:1;s:13:"view_students";b:1;s:12:"create_users";b:1;s:10:"edit_users";b:1;s:13:"promote_users";b:1;s:10:"list_users";b:1;s:4:"read";b:1;s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:11:"edit_course";b:1;s:12:"edit_courses";b:1;s:22:"edit_published_courses";b:1;s:15:"publish_courses";b:1;s:14:"delete_courses";b:1;s:24:"delete_published_courses";b:1;s:14:"create_courses";b:1;s:11:"edit_lesson";b:1;s:12:"edit_lessons";b:1;s:22:"edit_published_lessons";b:1;s:15:"publish_lessons";b:1;s:14:"delete_lessons";b:1;s:24:"delete_published_lessons";b:1;s:14:"create_lessons";b:1;s:9:"edit_quiz";b:1;s:12:"edit_quizzes";b:1;s:22:"edit_published_quizzes";b:1;s:15:"publish_quizzes";b:1;s:14:"delete_quizzes";b:1;s:24:"delete_published_quizzes";b:1;s:14:"create_quizzes";b:1;s:13:"edit_question";b:1;s:14:"edit_questions";b:1;s:24:"edit_published_questions";b:1;s:17:"publish_questions";b:1;s:16:"delete_questions";b:1;s:26:"delete_published_questions";b:1;s:16:"create_questions";b:1;s:15:"edit_membership";b:1;s:16:"edit_memberships";b:1;s:26:"edit_published_memberships";b:1;s:19:"publish_memberships";b:1;s:18:"delete_memberships";b:1;s:28:"delete_published_memberships";b:1;s:18:"create_memberships";b:1;s:18:"assign_course_cats";b:1;s:26:"assign_course_difficulties";b:1;s:18:"assign_course_tags";b:1;s:20:"assign_course_tracks";b:1;s:22:"assign_membership_cats";b:1;s:22:"assign_membership_tags";b:1;}}s:21:"instructors_assistant";a:2:{s:4:"name";s:22:"Instructor\'s Assistant";s:12:"capabilities";a:27:{s:20:"lifterlms_instructor";b:1;s:22:"view_lifterlms_reports";b:1;s:13:"view_students";b:1;s:4:"read";b:1;s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:11:"edit_course";b:1;s:12:"edit_courses";b:1;s:22:"edit_published_courses";b:1;s:11:"edit_lesson";b:1;s:12:"edit_lessons";b:1;s:22:"edit_published_lessons";b:1;s:9:"edit_quiz";b:1;s:12:"edit_quizzes";b:1;s:22:"edit_published_quizzes";b:1;s:13:"edit_question";b:1;s:14:"edit_questions";b:1;s:24:"edit_published_questions";b:1;s:15:"edit_membership";b:1;s:16:"edit_memberships";b:1;s:26:"edit_published_memberships";b:1;s:18:"assign_course_cats";b:1;s:26:"assign_course_difficulties";b:1;s:18:"assign_course_tags";b:1;s:20:"assign_course_tracks";b:1;s:22:"assign_membership_cats";b:1;s:22:"assign_membership_tags";b:1;}}s:7:"student";a:2:{s:4:"name";s:7:"Student";s:12:"capabilities";a:1:{s:4:"read";b:1;}}}','on');
INSERT INTO `wpbl_options` VALUES (103,'fresh_site','0','off');
INSERT INTO `wpbl_options` VALUES (104,'user_count','1','off');
INSERT INTO `wpbl_options` VALUES (105,'widget_block','a:6:{i:2;a:1:{s:7:"content";s:19:"<!-- wp:search /-->";}i:3;a:1:{s:7:"content";s:154:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->";}i:4;a:1:{s:7:"content";s:227:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {"displayAvatar":false,"displayDate":false,"displayExcerpt":false} /--></div><!-- /wp:group -->";}i:5;a:1:{s:7:"content";s:146:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->";}i:6;a:1:{s:7:"content";s:150:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->";}s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (106,'sidebars_widgets','a:2:{s:19:"wp_inactive_widgets";a:5:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";i:3;s:7:"block-5";i:4;s:7:"block-6";}s:13:"array_version";i:3;}','auto');
INSERT INTO `wpbl_options` VALUES (107,'widget_pages','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (108,'widget_calendar','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (109,'widget_archives','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (110,'widget_media_audio','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (111,'widget_media_image','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (112,'widget_media_gallery','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (113,'widget_media_video','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (114,'widget_meta','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (115,'widget_search','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (116,'widget_recent-posts','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (117,'widget_recent-comments','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (118,'widget_tag_cloud','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (119,'widget_nav_menu','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (120,'widget_custom_html','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wpbl_options` VALUES (121,'recovery_keys','a:0:{}','off');
INSERT INTO `wpbl_options` VALUES (122,'theme_mods_twentytwentyfive','a:1:{s:18:"custom_css_post_id";i:-1;}','auto');
INSERT INTO `wpbl_options` VALUES (123,'softaculous_pro_license','a:14:{s:7:"license";s:30:"SOFTWP-77092-93309-89183-17233";s:7:"expires";s:8:"20250326";s:4:"type";s:1:"1";s:8:"type_txt";s:7:"Premium";s:9:"num_sites";N;s:4:"plan";s:8:"personal";s:6:"active";i:1;s:10:"licexpired";N;s:4:"thid";N;s:6:"status";i:1;s:9:"last_edit";s:10:"1731985764";s:10:"status_txt";s:33:"<font color="green">Active</font>";s:8:"has_plid";i:1;s:11:"last_update";i:1742696954;}','yes');
INSERT INTO `wpbl_options` VALUES (124,'_transient_wp_core_block_css_files','a:2:{s:7:"version";s:3:"6.7";s:5:"files";a:540:{i:0;s:23:"archives/editor-rtl.css";i:1;s:27:"archives/editor-rtl.min.css";i:2;s:19:"archives/editor.css";i:3;s:23:"archives/editor.min.css";i:4;s:22:"archives/style-rtl.css";i:5;s:26:"archives/style-rtl.min.css";i:6;s:18:"archives/style.css";i:7;s:22:"archives/style.min.css";i:8;s:20:"audio/editor-rtl.css";i:9;s:24:"audio/editor-rtl.min.css";i:10;s:16:"audio/editor.css";i:11;s:20:"audio/editor.min.css";i:12;s:19:"audio/style-rtl.css";i:13;s:23:"audio/style-rtl.min.css";i:14;s:15:"audio/style.css";i:15;s:19:"audio/style.min.css";i:16;s:19:"audio/theme-rtl.css";i:17;s:23:"audio/theme-rtl.min.css";i:18;s:15:"audio/theme.css";i:19;s:19:"audio/theme.min.css";i:20;s:21:"avatar/editor-rtl.css";i:21;s:25:"avatar/editor-rtl.min.css";i:22;s:17:"avatar/editor.css";i:23;s:21:"avatar/editor.min.css";i:24;s:20:"avatar/style-rtl.css";i:25;s:24:"avatar/style-rtl.min.css";i:26;s:16:"avatar/style.css";i:27;s:20:"avatar/style.min.css";i:28;s:21:"button/editor-rtl.css";i:29;s:25:"button/editor-rtl.min.css";i:30;s:17:"button/editor.css";i:31;s:21:"button/editor.min.css";i:32;s:20:"button/style-rtl.css";i:33;s:24:"button/style-rtl.min.css";i:34;s:16:"button/style.css";i:35;s:20:"button/style.min.css";i:36;s:22:"buttons/editor-rtl.css";i:37;s:26:"buttons/editor-rtl.min.css";i:38;s:18:"buttons/editor.css";i:39;s:22:"buttons/editor.min.css";i:40;s:21:"buttons/style-rtl.css";i:41;s:25:"buttons/style-rtl.min.css";i:42;s:17:"buttons/style.css";i:43;s:21:"buttons/style.min.css";i:44;s:22:"calendar/style-rtl.css";i:45;s:26:"calendar/style-rtl.min.css";i:46;s:18:"calendar/style.css";i:47;s:22:"calendar/style.min.css";i:48;s:25:"categories/editor-rtl.css";i:49;s:29:"categories/editor-rtl.min.css";i:50;s:21:"categories/editor.css";i:51;s:25:"categories/editor.min.css";i:52;s:24:"categories/style-rtl.css";i:53;s:28:"categories/style-rtl.min.css";i:54;s:20:"categories/style.css";i:55;s:24:"categories/style.min.css";i:56;s:19:"code/editor-rtl.css";i:57;s:23:"code/editor-rtl.min.css";i:58;s:15:"code/editor.css";i:59;s:19:"code/editor.min.css";i:60;s:18:"code/style-rtl.css";i:61;s:22:"code/style-rtl.min.css";i:62;s:14:"code/style.css";i:63;s:18:"code/style.min.css";i:64;s:18:"code/theme-rtl.css";i:65;s:22:"code/theme-rtl.min.css";i:66;s:14:"code/theme.css";i:67;s:18:"code/theme.min.css";i:68;s:22:"columns/editor-rtl.css";i:69;s:26:"columns/editor-rtl.min.css";i:70;s:18:"columns/editor.css";i:71;s:22:"columns/editor.min.css";i:72;s:21:"columns/style-rtl.css";i:73;s:25:"columns/style-rtl.min.css";i:74;s:17:"columns/style.css";i:75;s:21:"columns/style.min.css";i:76;s:33:"comment-author-name/style-rtl.css";i:77;s:37:"comment-author-name/style-rtl.min.css";i:78;s:29:"comment-author-name/style.css";i:79;s:33:"comment-author-name/style.min.css";i:80;s:29:"comment-content/style-rtl.css";i:81;s:33:"comment-content/style-rtl.min.css";i:82;s:25:"comment-content/style.css";i:83;s:29:"comment-content/style.min.css";i:84;s:26:"comment-date/style-rtl.css";i:85;s:30:"comment-date/style-rtl.min.css";i:86;s:22:"comment-date/style.css";i:87;s:26:"comment-date/style.min.css";i:88;s:31:"comment-edit-link/style-rtl.css";i:89;s:35:"comment-edit-link/style-rtl.min.css";i:90;s:27:"comment-edit-link/style.css";i:91;s:31:"comment-edit-link/style.min.css";i:92;s:32:"comment-reply-link/style-rtl.css";i:93;s:36:"comment-reply-link/style-rtl.min.css";i:94;s:28:"comment-reply-link/style.css";i:95;s:32:"comment-reply-link/style.min.css";i:96;s:30:"comment-template/style-rtl.css";i:97;s:34:"comment-template/style-rtl.min.css";i:98;s:26:"comment-template/style.css";i:99;s:30:"comment-template/style.min.css";i:100;s:42:"comments-pagination-numbers/editor-rtl.css";i:101;s:46:"comments-pagination-numbers/editor-rtl.min.css";i:102;s:38:"comments-pagination-numbers/editor.css";i:103;s:42:"comments-pagination-numbers/editor.min.css";i:104;s:34:"comments-pagination/editor-rtl.css";i:105;s:38:"comments-pagination/editor-rtl.min.css";i:106;s:30:"comments-pagination/editor.css";i:107;s:34:"comments-pagination/editor.min.css";i:108;s:33:"comments-pagination/style-rtl.css";i:109;s:37:"comments-pagination/style-rtl.min.css";i:110;s:29:"comments-pagination/style.css";i:111;s:33:"comments-pagination/style.min.css";i:112;s:29:"comments-title/editor-rtl.css";i:113;s:33:"comments-title/editor-rtl.min.css";i:114;s:25:"comments-title/editor.css";i:115;s:29:"comments-title/editor.min.css";i:116;s:23:"comments/editor-rtl.css";i:117;s:27:"comments/editor-rtl.min.css";i:118;s:19:"comments/editor.css";i:119;s:23:"comments/editor.min.css";i:120;s:22:"comments/style-rtl.css";i:121;s:26:"comments/style-rtl.min.css";i:122;s:18:"comments/style.css";i:123;s:22:"comments/style.min.css";i:124;s:20:"cover/editor-rtl.css";i:125;s:24:"cover/editor-rtl.min.css";i:126;s:16:"cover/editor.css";i:127;s:20:"cover/editor.min.css";i:128;s:19:"cover/style-rtl.css";i:129;s:23:"cover/style-rtl.min.css";i:130;s:15:"cover/style.css";i:131;s:19:"cover/style.min.css";i:132;s:22:"details/editor-rtl.css";i:133;s:26:"details/editor-rtl.min.css";i:134;s:18:"details/editor.css";i:135;s:22:"details/editor.min.css";i:136;s:21:"details/style-rtl.css";i:137;s:25:"details/style-rtl.min.css";i:138;s:17:"details/style.css";i:139;s:21:"details/style.min.css";i:140;s:20:"embed/editor-rtl.css";i:141;s:24:"embed/editor-rtl.min.css";i:142;s:16:"embed/editor.css";i:143;s:20:"embed/editor.min.css";i:144;s:19:"embed/style-rtl.css";i:145;s:23:"embed/style-rtl.min.css";i:146;s:15:"embed/style.css";i:147;s:19:"embed/style.min.css";i:148;s:19:"embed/theme-rtl.css";i:149;s:23:"embed/theme-rtl.min.css";i:150;s:15:"embed/theme.css";i:151;s:19:"embed/theme.min.css";i:152;s:19:"file/editor-rtl.css";i:153;s:23:"file/editor-rtl.min.css";i:154;s:15:"file/editor.css";i:155;s:19:"file/editor.min.css";i:156;s:18:"file/style-rtl.css";i:157;s:22:"file/style-rtl.min.css";i:158;s:14:"file/style.css";i:159;s:18:"file/style.min.css";i:160;s:23:"footnotes/style-rtl.css";i:161;s:27:"footnotes/style-rtl.min.css";i:162;s:19:"footnotes/style.css";i:163;s:23:"footnotes/style.min.css";i:164;s:23:"freeform/editor-rtl.css";i:165;s:27:"freeform/editor-rtl.min.css";i:166;s:19:"freeform/editor.css";i:167;s:23:"freeform/editor.min.css";i:168;s:22:"gallery/editor-rtl.css";i:169;s:26:"gallery/editor-rtl.min.css";i:170;s:18:"gallery/editor.css";i:171;s:22:"gallery/editor.min.css";i:172;s:21:"gallery/style-rtl.css";i:173;s:25:"gallery/style-rtl.min.css";i:174;s:17:"gallery/style.css";i:175;s:21:"gallery/style.min.css";i:176;s:21:"gallery/theme-rtl.css";i:177;s:25:"gallery/theme-rtl.min.css";i:178;s:17:"gallery/theme.css";i:179;s:21:"gallery/theme.min.css";i:180;s:20:"group/editor-rtl.css";i:181;s:24:"group/editor-rtl.min.css";i:182;s:16:"group/editor.css";i:183;s:20:"group/editor.min.css";i:184;s:19:"group/style-rtl.css";i:185;s:23:"group/style-rtl.min.css";i:186;s:15:"group/style.css";i:187;s:19:"group/style.min.css";i:188;s:19:"group/theme-rtl.css";i:189;s:23:"group/theme-rtl.min.css";i:190;s:15:"group/theme.css";i:191;s:19:"group/theme.min.css";i:192;s:21:"heading/style-rtl.css";i:193;s:25:"heading/style-rtl.min.css";i:194;s:17:"heading/style.css";i:195;s:21:"heading/style.min.css";i:196;s:19:"html/editor-rtl.css";i:197;s:23:"html/editor-rtl.min.css";i:198;s:15:"html/editor.css";i:199;s:19:"html/editor.min.css";i:200;s:20:"image/editor-rtl.css";i:201;s:24:"image/editor-rtl.min.css";i:202;s:16:"image/editor.css";i:203;s:20:"image/editor.min.css";i:204;s:19:"image/style-rtl.css";i:205;s:23:"image/style-rtl.min.css";i:206;s:15:"image/style.css";i:207;s:19:"image/style.min.css";i:208;s:19:"image/theme-rtl.css";i:209;s:23:"image/theme-rtl.min.css";i:210;s:15:"image/theme.css";i:211;s:19:"image/theme.min.css";i:212;s:29:"latest-comments/style-rtl.css";i:213;s:33:"latest-comments/style-rtl.min.css";i:214;s:25:"latest-comments/style.css";i:215;s:29:"latest-comments/style.min.css";i:216;s:27:"latest-posts/editor-rtl.css";i:217;s:31:"latest-posts/editor-rtl.min.css";i:218;s:23:"latest-posts/editor.css";i:219;s:27:"latest-posts/editor.min.css";i:220;s:26:"latest-posts/style-rtl.css";i:221;s:30:"latest-posts/style-rtl.min.css";i:222;s:22:"latest-posts/style.css";i:223;s:26:"latest-posts/style.min.css";i:224;s:18:"list/style-rtl.css";i:225;s:22:"list/style-rtl.min.css";i:226;s:14:"list/style.css";i:227;s:18:"list/style.min.css";i:228;s:22:"loginout/style-rtl.css";i:229;s:26:"loginout/style-rtl.min.css";i:230;s:18:"loginout/style.css";i:231;s:22:"loginout/style.min.css";i:232;s:25:"media-text/editor-rtl.css";i:233;s:29:"media-text/editor-rtl.min.css";i:234;s:21:"media-text/editor.css";i:235;s:25:"media-text/editor.min.css";i:236;s:24:"media-text/style-rtl.css";i:237;s:28:"media-text/style-rtl.min.css";i:238;s:20:"media-text/style.css";i:239;s:24:"media-text/style.min.css";i:240;s:19:"more/editor-rtl.css";i:241;s:23:"more/editor-rtl.min.css";i:242;s:15:"more/editor.css";i:243;s:19:"more/editor.min.css";i:244;s:30:"navigation-link/editor-rtl.css";i:245;s:34:"navigation-link/editor-rtl.min.css";i:246;s:26:"navigation-link/editor.css";i:247;s:30:"navigation-link/editor.min.css";i:248;s:29:"navigation-link/style-rtl.css";i:249;s:33:"navigation-link/style-rtl.min.css";i:250;s:25:"navigation-link/style.css";i:251;s:29:"navigation-link/style.min.css";i:252;s:33:"navigation-submenu/editor-rtl.css";i:253;s:37:"navigation-submenu/editor-rtl.min.css";i:254;s:29:"navigation-submenu/editor.css";i:255;s:33:"navigation-submenu/editor.min.css";i:256;s:25:"navigation/editor-rtl.css";i:257;s:29:"navigation/editor-rtl.min.css";i:258;s:21:"navigation/editor.css";i:259;s:25:"navigation/editor.min.css";i:260;s:24:"navigation/style-rtl.css";i:261;s:28:"navigation/style-rtl.min.css";i:262;s:20:"navigation/style.css";i:263;s:24:"navigation/style.min.css";i:264;s:23:"nextpage/editor-rtl.css";i:265;s:27:"nextpage/editor-rtl.min.css";i:266;s:19:"nextpage/editor.css";i:267;s:23:"nextpage/editor.min.css";i:268;s:24:"page-list/editor-rtl.css";i:269;s:28:"page-list/editor-rtl.min.css";i:270;s:20:"page-list/editor.css";i:271;s:24:"page-list/editor.min.css";i:272;s:23:"page-list/style-rtl.css";i:273;s:27:"page-list/style-rtl.min.css";i:274;s:19:"page-list/style.css";i:275;s:23:"page-list/style.min.css";i:276;s:24:"paragraph/editor-rtl.css";i:277;s:28:"paragraph/editor-rtl.min.css";i:278;s:20:"paragraph/editor.css";i:279;s:24:"paragraph/editor.min.css";i:280;s:23:"paragraph/style-rtl.css";i:281;s:27:"paragraph/style-rtl.min.css";i:282;s:19:"paragraph/style.css";i:283;s:23:"paragraph/style.min.css";i:284;s:35:"post-author-biography/style-rtl.css";i:285;s:39:"post-author-biography/style-rtl.min.css";i:286;s:31:"post-author-biography/style.css";i:287;s:35:"post-author-biography/style.min.css";i:288;s:30:"post-author-name/style-rtl.css";i:289;s:34:"post-author-name/style-rtl.min.css";i:290;s:26:"post-author-name/style.css";i:291;s:30:"post-author-name/style.min.css";i:292;s:26:"post-author/editor-rtl.css";i:293;s:30:"post-author/editor-rtl.min.css";i:294;s:22:"post-author/editor.css";i:295;s:26:"post-author/editor.min.css";i:296;s:25:"post-author/style-rtl.css";i:297;s:29:"post-author/style-rtl.min.css";i:298;s:21:"post-author/style.css";i:299;s:25:"post-author/style.min.css";i:300;s:33:"post-comments-form/editor-rtl.css";i:301;s:37:"post-comments-form/editor-rtl.min.css";i:302;s:29:"post-comments-form/editor.css";i:303;s:33:"post-comments-form/editor.min.css";i:304;s:32:"post-comments-form/style-rtl.css";i:305;s:36:"post-comments-form/style-rtl.min.css";i:306;s:28:"post-comments-form/style.css";i:307;s:32:"post-comments-form/style.min.css";i:308;s:27:"post-content/editor-rtl.css";i:309;s:31:"post-content/editor-rtl.min.css";i:310;s:23:"post-content/editor.css";i:311;s:27:"post-content/editor.min.css";i:312;s:26:"post-content/style-rtl.css";i:313;s:30:"post-content/style-rtl.min.css";i:314;s:22:"post-content/style.css";i:315;s:26:"post-content/style.min.css";i:316;s:23:"post-date/style-rtl.css";i:317;s:27:"post-date/style-rtl.min.css";i:318;s:19:"post-date/style.css";i:319;s:23:"post-date/style.min.css";i:320;s:27:"post-excerpt/editor-rtl.css";i:321;s:31:"post-excerpt/editor-rtl.min.css";i:322;s:23:"post-excerpt/editor.css";i:323;s:27:"post-excerpt/editor.min.css";i:324;s:26:"post-excerpt/style-rtl.css";i:325;s:30:"post-excerpt/style-rtl.min.css";i:326;s:22:"post-excerpt/style.css";i:327;s:26:"post-excerpt/style.min.css";i:328;s:34:"post-featured-image/editor-rtl.css";i:329;s:38:"post-featured-image/editor-rtl.min.css";i:330;s:30:"post-featured-image/editor.css";i:331;s:34:"post-featured-image/editor.min.css";i:332;s:33:"post-featured-image/style-rtl.css";i:333;s:37:"post-featured-image/style-rtl.min.css";i:334;s:29:"post-featured-image/style.css";i:335;s:33:"post-featured-image/style.min.css";i:336;s:34:"post-navigation-link/style-rtl.css";i:337;s:38:"post-navigation-link/style-rtl.min.css";i:338;s:30:"post-navigation-link/style.css";i:339;s:34:"post-navigation-link/style.min.css";i:340;s:28:"post-template/editor-rtl.css";i:341;s:32:"post-template/editor-rtl.min.css";i:342;s:24:"post-template/editor.css";i:343;s:28:"post-template/editor.min.css";i:344;s:27:"post-template/style-rtl.css";i:345;s:31:"post-template/style-rtl.min.css";i:346;s:23:"post-template/style.css";i:347;s:27:"post-template/style.min.css";i:348;s:24:"post-terms/style-rtl.css";i:349;s:28:"post-terms/style-rtl.min.css";i:350;s:20:"post-terms/style.css";i:351;s:24:"post-terms/style.min.css";i:352;s:24:"post-title/style-rtl.css";i:353;s:28:"post-title/style-rtl.min.css";i:354;s:20:"post-title/style.css";i:355;s:24:"post-title/style.min.css";i:356;s:26:"preformatted/style-rtl.css";i:357;s:30:"preformatted/style-rtl.min.css";i:358;s:22:"preformatted/style.css";i:359;s:26:"preformatted/style.min.css";i:360;s:24:"pullquote/editor-rtl.css";i:361;s:28:"pullquote/editor-rtl.min.css";i:362;s:20:"pullquote/editor.css";i:363;s:24:"pullquote/editor.min.css";i:364;s:23:"pullquote/style-rtl.css";i:365;s:27:"pullquote/style-rtl.min.css";i:366;s:19:"pullquote/style.css";i:367;s:23:"pullquote/style.min.css";i:368;s:23:"pullquote/theme-rtl.css";i:369;s:27:"pullquote/theme-rtl.min.css";i:370;s:19:"pullquote/theme.css";i:371;s:23:"pullquote/theme.min.css";i:372;s:39:"query-pagination-numbers/editor-rtl.css";i:373;s:43:"query-pagination-numbers/editor-rtl.min.css";i:374;s:35:"query-pagination-numbers/editor.css";i:375;s:39:"query-pagination-numbers/editor.min.css";i:376;s:31:"query-pagination/editor-rtl.css";i:377;s:35:"query-pagination/editor-rtl.min.css";i:378;s:27:"query-pagination/editor.css";i:379;s:31:"query-pagination/editor.min.css";i:380;s:30:"query-pagination/style-rtl.css";i:381;s:34:"query-pagination/style-rtl.min.css";i:382;s:26:"query-pagination/style.css";i:383;s:30:"query-pagination/style.min.css";i:384;s:25:"query-title/style-rtl.css";i:385;s:29:"query-title/style-rtl.min.css";i:386;s:21:"query-title/style.css";i:387;s:25:"query-title/style.min.css";i:388;s:20:"query/editor-rtl.css";i:389;s:24:"query/editor-rtl.min.css";i:390;s:16:"query/editor.css";i:391;s:20:"query/editor.min.css";i:392;s:19:"quote/style-rtl.css";i:393;s:23:"quote/style-rtl.min.css";i:394;s:15:"quote/style.css";i:395;s:19:"quote/style.min.css";i:396;s:19:"quote/theme-rtl.css";i:397;s:23:"quote/theme-rtl.min.css";i:398;s:15:"quote/theme.css";i:399;s:19:"quote/theme.min.css";i:400;s:23:"read-more/style-rtl.css";i:401;s:27:"read-more/style-rtl.min.css";i:402;s:19:"read-more/style.css";i:403;s:23:"read-more/style.min.css";i:404;s:18:"rss/editor-rtl.css";i:405;s:22:"rss/editor-rtl.min.css";i:406;s:14:"rss/editor.css";i:407;s:18:"rss/editor.min.css";i:408;s:17:"rss/style-rtl.css";i:409;s:21:"rss/style-rtl.min.css";i:410;s:13:"rss/style.css";i:411;s:17:"rss/style.min.css";i:412;s:21:"search/editor-rtl.css";i:413;s:25:"search/editor-rtl.min.css";i:414;s:17:"search/editor.css";i:415;s:21:"search/editor.min.css";i:416;s:20:"search/style-rtl.css";i:417;s:24:"search/style-rtl.min.css";i:418;s:16:"search/style.css";i:419;s:20:"search/style.min.css";i:420;s:20:"search/theme-rtl.css";i:421;s:24:"search/theme-rtl.min.css";i:422;s:16:"search/theme.css";i:423;s:20:"search/theme.min.css";i:424;s:24:"separator/editor-rtl.css";i:425;s:28:"separator/editor-rtl.min.css";i:426;s:20:"separator/editor.css";i:427;s:24:"separator/editor.min.css";i:428;s:23:"separator/style-rtl.css";i:429;s:27:"separator/style-rtl.min.css";i:430;s:19:"separator/style.css";i:431;s:23:"separator/style.min.css";i:432;s:23:"separator/theme-rtl.css";i:433;s:27:"separator/theme-rtl.min.css";i:434;s:19:"separator/theme.css";i:435;s:23:"separator/theme.min.css";i:436;s:24:"shortcode/editor-rtl.css";i:437;s:28:"shortcode/editor-rtl.min.css";i:438;s:20:"shortcode/editor.css";i:439;s:24:"shortcode/editor.min.css";i:440;s:24:"site-logo/editor-rtl.css";i:441;s:28:"site-logo/editor-rtl.min.css";i:442;s:20:"site-logo/editor.css";i:443;s:24:"site-logo/editor.min.css";i:444;s:23:"site-logo/style-rtl.css";i:445;s:27:"site-logo/style-rtl.min.css";i:446;s:19:"site-logo/style.css";i:447;s:23:"site-logo/style.min.css";i:448;s:27:"site-tagline/editor-rtl.css";i:449;s:31:"site-tagline/editor-rtl.min.css";i:450;s:23:"site-tagline/editor.css";i:451;s:27:"site-tagline/editor.min.css";i:452;s:26:"site-tagline/style-rtl.css";i:453;s:30:"site-tagline/style-rtl.min.css";i:454;s:22:"site-tagline/style.css";i:455;s:26:"site-tagline/style.min.css";i:456;s:25:"site-title/editor-rtl.css";i:457;s:29:"site-title/editor-rtl.min.css";i:458;s:21:"site-title/editor.css";i:459;s:25:"site-title/editor.min.css";i:460;s:24:"site-title/style-rtl.css";i:461;s:28:"site-title/style-rtl.min.css";i:462;s:20:"site-title/style.css";i:463;s:24:"site-title/style.min.css";i:464;s:26:"social-link/editor-rtl.css";i:465;s:30:"social-link/editor-rtl.min.css";i:466;s:22:"social-link/editor.css";i:467;s:26:"social-link/editor.min.css";i:468;s:27:"social-links/editor-rtl.css";i:469;s:31:"social-links/editor-rtl.min.css";i:470;s:23:"social-links/editor.css";i:471;s:27:"social-links/editor.min.css";i:472;s:26:"social-links/style-rtl.css";i:473;s:30:"social-links/style-rtl.min.css";i:474;s:22:"social-links/style.css";i:475;s:26:"social-links/style.min.css";i:476;s:21:"spacer/editor-rtl.css";i:477;s:25:"spacer/editor-rtl.min.css";i:478;s:17:"spacer/editor.css";i:479;s:21:"spacer/editor.min.css";i:480;s:20:"spacer/style-rtl.css";i:481;s:24:"spacer/style-rtl.min.css";i:482;s:16:"spacer/style.css";i:483;s:20:"spacer/style.min.css";i:484;s:20:"table/editor-rtl.css";i:485;s:24:"table/editor-rtl.min.css";i:486;s:16:"table/editor.css";i:487;s:20:"table/editor.min.css";i:488;s:19:"table/style-rtl.css";i:489;s:23:"table/style-rtl.min.css";i:490;s:15:"table/style.css";i:491;s:19:"table/style.min.css";i:492;s:19:"table/theme-rtl.css";i:493;s:23:"table/theme-rtl.min.css";i:494;s:15:"table/theme.css";i:495;s:19:"table/theme.min.css";i:496;s:24:"tag-cloud/editor-rtl.css";i:497;s:28:"tag-cloud/editor-rtl.min.css";i:498;s:20:"tag-cloud/editor.css";i:499;s:24:"tag-cloud/editor.min.css";i:500;s:23:"tag-cloud/style-rtl.css";i:501;s:27:"tag-cloud/style-rtl.min.css";i:502;s:19:"tag-cloud/style.css";i:503;s:23:"tag-cloud/style.min.css";i:504;s:28:"template-part/editor-rtl.css";i:505;s:32:"template-part/editor-rtl.min.css";i:506;s:24:"template-part/editor.css";i:507;s:28:"template-part/editor.min.css";i:508;s:27:"template-part/theme-rtl.css";i:509;s:31:"template-part/theme-rtl.min.css";i:510;s:23:"template-part/theme.css";i:511;s:27:"template-part/theme.min.css";i:512;s:30:"term-description/style-rtl.css";i:513;s:34:"term-description/style-rtl.min.css";i:514;s:26:"term-description/style.css";i:515;s:30:"term-description/style.min.css";i:516;s:27:"text-columns/editor-rtl.css";i:517;s:31:"text-columns/editor-rtl.min.css";i:518;s:23:"text-columns/editor.css";i:519;s:27:"text-columns/editor.min.css";i:520;s:26:"text-columns/style-rtl.css";i:521;s:30:"text-columns/style-rtl.min.css";i:522;s:22:"text-columns/style.css";i:523;s:26:"text-columns/style.min.css";i:524;s:19:"verse/style-rtl.css";i:525;s:23:"verse/style-rtl.min.css";i:526;s:15:"verse/style.css";i:527;s:19:"verse/style.min.css";i:528;s:20:"video/editor-rtl.css";i:529;s:24:"video/editor-rtl.min.css";i:530;s:16:"video/editor.css";i:531;s:20:"video/editor.min.css";i:532;s:19:"video/style-rtl.css";i:533;s:23:"video/style-rtl.min.css";i:534;s:15:"video/style.css";i:535;s:19:"video/style.min.css";i:536;s:19:"video/theme-rtl.css";i:537;s:23:"video/theme-rtl.min.css";i:538;s:15:"video/theme.css";i:539;s:19:"video/theme.min.css";}}','on');
INSERT INTO `wpbl_options` VALUES (128,'softaculous_pro_version','2.1.4','auto');
INSERT INTO `wpbl_options` VALUES (132,'softaculous_pro_rebranding','a:4:{s:2:"sn";s:11:"Softaculous";s:8:"logo_url";s:0:"";s:13:"default_hf_bg";N;s:15:"default_hf_text";N;}','yes');
INSERT INTO `wpbl_options` VALUES (138,'external_updates-softaculous-pro','O:8:"stdClass":3:{s:9:"lastCheck";i:1742766273;s:14:"checkedVersion";s:5:"2.1.4";s:6:"update";O:8:"stdClass":9:{s:2:"id";i:0;s:4:"slug";s:15:"softaculous-pro";s:7:"version";s:5:"2.2.1";s:8:"homepage";s:19:"https://softwp.net/";s:6:"tested";s:5:"6.7.2";s:12:"download_url";s:129:"https://s8.softaculous.com/a/softwp/download.php?version=2.2.1&license=SOFTWP-77092-93309-89183-17233&url=https://kumabenkyou.com";s:14:"upgrade_notice";N;s:8:"filename";s:35:"softaculous-pro/softaculous-pro.php";s:12:"translations";a:0:{}}}','off');
INSERT INTO `wpbl_options` VALUES (139,'elementor_active_kit','7','auto');
INSERT INTO `wpbl_options` VALUES (140,'elementor_font_display','swap','auto');
INSERT INTO `wpbl_options` VALUES (143,'elementor_checklist','{"last_opened_timestamp":-1,"first_closed_checklist_in_editor":false,"is_popup_minimized":false,"editor_visit_count":0,"steps":{"add_logo":{"is_marked_completed":false,"is_immutable_completed":false},"set_fonts_and_colors":{"is_marked_completed":false,"is_immutable_completed":false},"create_pages":{"is_marked_completed":false,"is_immutable_completed":false},"setup_header":{"is_marked_completed":false,"is_immutable_completed":false},"assign_homepage":{"is_marked_completed":false,"is_immutable_completed":false},"setup_header_pro":{"is_marked_completed":false,"is_immutable_completed":false}}}','auto');
INSERT INTO `wpbl_options` VALUES (144,'elementor_version','3.26.3','auto');
INSERT INTO `wpbl_options` VALUES (145,'elementor_install_history','a:3:{s:6:"3.25.8";i:1732111921;s:6:"3.25.9";i:1732128299;s:6:"3.26.3";i:1735370514;}','auto');
INSERT INTO `wpbl_options` VALUES (148,'_transient_wp_styles_for_blocks','a:2:{s:4:"hash";s:32:"8c7d46a72d7d4591fc1dd9485bedb304";s:6:"blocks";a:5:{s:11:"core/button";s:0:"";s:14:"core/site-logo";s:0:"";s:18:"core/post-template";s:120:":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}";s:12:"core/columns";s:102:":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}";s:14:"core/pullquote";s:69:":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}";}}','on');
INSERT INTO `wpbl_options` VALUES (151,'elementor_events_db_version','1.0.0','off');
INSERT INTO `wpbl_options` VALUES (152,'downloaded_font_files','a:16:{s:75:"https://fonts.gstatic.com/s/epilogue/v17/O4ZXFGj5hxF0EhjimlIhggUyklmd.woff2";s:88:"/home/kumabenk/public_html/wp-content//fonts/epilogue/O4ZXFGj5hxF0EhjimlIhggUyklmd.woff2";s:75:"https://fonts.gstatic.com/s/epilogue/v17/O4ZXFGj5hxF0EhjimlIhggQyklmd.woff2";s:88:"/home/kumabenk/public_html/wp-content//fonts/epilogue/O4ZXFGj5hxF0EhjimlIhggQyklmd.woff2";s:73:"https://fonts.gstatic.com/s/epilogue/v17/O4ZXFGj5hxF0EhjimlIhggoykg.woff2";s:86:"/home/kumabenk/public_html/wp-content//fonts/epilogue/O4ZXFGj5hxF0EhjimlIhggoykg.woff2";s:73:"https://fonts.gstatic.com/s/epilogue/v17/O4ZRFGj5hxF0EhjimlIrsggqlg.woff2";s:86:"/home/kumabenk/public_html/wp-content//fonts/epilogue/O4ZRFGj5hxF0EhjimlIrsggqlg.woff2";s:73:"https://fonts.gstatic.com/s/epilogue/v17/O4ZRFGj5hxF0EhjimlIqsggqlg.woff2";s:86:"/home/kumabenk/public_html/wp-content//fonts/epilogue/O4ZRFGj5hxF0EhjimlIqsggqlg.woff2";s:70:"https://fonts.gstatic.com/s/epilogue/v17/O4ZRFGj5hxF0EhjimlIksgg.woff2";s:83:"/home/kumabenk/public_html/wp-content//fonts/epilogue/O4ZRFGj5hxF0EhjimlIksgg.woff2";s:73:"https://fonts.gstatic.com/s/raleway/v34/1Ptsg8zYS_SKggPNyCg4QIFqPfE.woff2";s:86:"/home/kumabenk/public_html/wp-content//fonts/raleway/1Ptsg8zYS_SKggPNyCg4QIFqPfE.woff2";s:73:"https://fonts.gstatic.com/s/raleway/v34/1Ptsg8zYS_SKggPNyCg4SYFqPfE.woff2";s:86:"/home/kumabenk/public_html/wp-content//fonts/raleway/1Ptsg8zYS_SKggPNyCg4SYFqPfE.woff2";s:73:"https://fonts.gstatic.com/s/raleway/v34/1Ptsg8zYS_SKggPNyCg4QoFqPfE.woff2";s:86:"/home/kumabenk/public_html/wp-content//fonts/raleway/1Ptsg8zYS_SKggPNyCg4QoFqPfE.woff2";s:73:"https://fonts.gstatic.com/s/raleway/v34/1Ptsg8zYS_SKggPNyCg4Q4FqPfE.woff2";s:86:"/home/kumabenk/public_html/wp-content//fonts/raleway/1Ptsg8zYS_SKggPNyCg4Q4FqPfE.woff2";s:70:"https://fonts.gstatic.com/s/raleway/v34/1Ptsg8zYS_SKggPNyCg4TYFq.woff2";s:83:"/home/kumabenk/public_html/wp-content//fonts/raleway/1Ptsg8zYS_SKggPNyCg4TYFq.woff2";s:70:"https://fonts.gstatic.com/s/raleway/v34/1Ptug8zYS_SKggPNyCAIT5lu.woff2";s:83:"/home/kumabenk/public_html/wp-content//fonts/raleway/1Ptug8zYS_SKggPNyCAIT5lu.woff2";s:70:"https://fonts.gstatic.com/s/raleway/v34/1Ptug8zYS_SKggPNyCkIT5lu.woff2";s:83:"/home/kumabenk/public_html/wp-content//fonts/raleway/1Ptug8zYS_SKggPNyCkIT5lu.woff2";s:70:"https://fonts.gstatic.com/s/raleway/v34/1Ptug8zYS_SKggPNyCIIT5lu.woff2";s:83:"/home/kumabenk/public_html/wp-content//fonts/raleway/1Ptug8zYS_SKggPNyCIIT5lu.woff2";s:70:"https://fonts.gstatic.com/s/raleway/v34/1Ptug8zYS_SKggPNyCMIT5lu.woff2";s:83:"/home/kumabenk/public_html/wp-content//fonts/raleway/1Ptug8zYS_SKggPNyCMIT5lu.woff2";s:68:"https://fonts.gstatic.com/s/raleway/v34/1Ptug8zYS_SKggPNyC0ITw.woff2";s:81:"/home/kumabenk/public_html/wp-content//fonts/raleway/1Ptug8zYS_SKggPNyC0ITw.woff2";}','off');
INSERT INTO `wpbl_options` VALUES (156,'softaculous_pro_onboarding_shown','1732111926','auto');
INSERT INTO `wpbl_options` VALUES (157,'can_compress_scripts','0','on');
INSERT INTO `wpbl_options` VALUES (158,'theme_mods_fitness-elementor','a:2:{s:18:"custom_css_post_id";i:-1;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1732128542;s:4:"data";a:3:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:3:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";}s:9:"sidebar-2";a:2:{i:0;s:7:"block-5";i:1;s:7:"block-6";}}}}','off');
INSERT INTO `wpbl_options` VALUES (159,'softaculous_pro_onboarding_dismiss','1732111939','auto');
INSERT INTO `wpbl_options` VALUES (160,'_site_transient_wp_plugin_dependencies_plugin_data','a:0:{}','off');
INSERT INTO `wpbl_options` VALUES (161,'recently_activated','a:0:{}','off');
INSERT INTO `wpbl_options` VALUES (162,'_elementor_installed_time','1732111946','auto');
INSERT INTO `wpbl_options` VALUES (163,'elementor_remote_info_library','a:3:{s:10:"types_data";a:4:{s:5:"block";a:2:{s:10:"categories";a:30:{i:0;s:8:"404 page";i:1;s:5:"about";i:2;s:7:"archive";i:3;s:8:"Benefits";i:4;s:14:"call to action";i:5;s:7:"clients";i:6;s:7:"contact";i:7;s:4:"Data";i:8;s:10:"ehp-footer";i:9;s:10:"ehp-header";i:10;s:3:"faq";i:11;s:8:"features";i:12;s:6:"footer";i:13;s:7:"Gallery";i:14;s:6:"header";i:15;s:4:"hero";i:16;s:11:"Link in Bio";i:17;s:9:"portfolio";i:18;s:7:"pricing";i:19;s:15:"product archive";i:20;s:5:"Quote";i:21;s:15:"Service Details";i:22;s:8:"services";i:23;s:11:"single page";i:24;s:11:"single post";i:25;s:14:"single product";i:26;s:5:"stats";i:27;s:9:"subscribe";i:28;s:4:"team";i:29;s:12:"testimonials";}s:4:"sets";a:5:{i:0;s:11:"Boxing Club";i:1;s:19:"Business Consultant";i:2;s:16:"Marketing Agency";i:3;s:9:"Wireframe";i:4;s:15:"Workshop Center";}}s:5:"popup";a:1:{s:10:"categories";a:6:{i:0;s:10:"bottom bar";i:1;s:7:"classic";i:2;s:6:"fly-in";i:3;s:11:"full screen";i:4;s:9:"hello bar";i:5;s:8:"slide-in";}}s:2:"lp";a:1:{s:10:"categories";a:15:{i:0;s:8:"Business";i:1;s:16:"Coming Soon Page";i:2;s:9:"eCommerce";i:3;s:9:"Education";i:4;s:6:"Events";i:5;s:18:"Health and Fitness";i:6;s:3:"NFT";i:7;s:14:"Online Service";i:8;s:7:"Product";i:9;s:11:"Real Estate";i:10;s:18:"Social Involvement";i:11;s:14:"Thank You Page";i:12;s:6:"Travel";i:13;s:18:"Under Construction";i:14;s:9:"Wireframe";}}s:2:"lb";a:1:{s:10:"categories";a:2:{i:0;s:4:"post";i:1;s:7:"product";}}}s:10:"categories";a:30:{i:0;s:8:"404 page";i:1;s:5:"about";i:2;s:7:"archive";i:3;s:8:"Benefits";i:4;s:14:"call to action";i:5;s:7:"clients";i:6;s:7:"contact";i:7;s:4:"Data";i:8;s:10:"ehp-footer";i:9;s:10:"ehp-header";i:10;s:3:"faq";i:11;s:8:"features";i:12;s:6:"footer";i:13;s:7:"Gallery";i:14;s:6:"header";i:15;s:4:"hero";i:16;s:11:"Link in Bio";i:17;s:9:"portfolio";i:18;s:7:"pricing";i:19;s:15:"product archive";i:20;s:5:"Quote";i:21;s:15:"Service Details";i:22;s:8:"services";i:23;s:11:"single page";i:24;s:11:"single post";i:25;s:14:"single product";i:26;s:5:"stats";i:27;s:9:"subscribe";i:28;s:4:"team";i:29;s:12:"testimonials";}s:9:"templates";a:823:{i:0;a:20:{s:4:"tmpl";i:1280;s:2:"id";i:22403;s:5:"title";s:40:"Hello Bar | Subscribe | Aesthetic Clinic";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg";s:12:"tmpl_created";i:1647354307;s:6:"author";s:9:"Elementor";s:3:"url";s:142:"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:48:"["Barbershop","Business","Discount","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:1;a:20:{s:4:"tmpl";i:1281;s:2:"id";i:22410;s:5:"title";s:32:"Fly-In | Discount | Hair Stylist";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg";s:12:"tmpl_created";i:1647354614;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:32:"["Barbershop","Discount","Hair"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:2;a:20:{s:4:"tmpl";i:1285;s:2:"id";i:22440;s:5:"title";s:32:"Classic | Subscribe | Shoe Store";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg";s:12:"tmpl_created";i:1647418620;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:37:"["Ecommerce","Marketing","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:3;a:20:{s:4:"tmpl";i:1286;s:2:"id";i:22446;s:5:"title";s:37:"Full Screen | Subscribe | Denim Store";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg";s:12:"tmpl_created";i:1647419614;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:35:"["Ecommerce","Fashion","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:4;a:20:{s:4:"tmpl";i:1287;s:2:"id";i:22452;s:5:"title";s:37:"Fly-In | Subscribe | Pizza Restaurant";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg";s:12:"tmpl_created";i:1647420733;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:19:"["Business","Food"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:5;a:20:{s:4:"tmpl";i:1288;s:2:"id";i:22458;s:5:"title";s:38:"Full Screen | Subscribe | Fashion Shop";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg";s:12:"tmpl_created";i:1647426379;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:31:"["Ecommerce","Fashion","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:6;a:20:{s:4:"tmpl";i:1289;s:2:"id";i:22464;s:5:"title";s:32:"Fly-In | Contact | Makeup Studio";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg";s:12:"tmpl_created";i:1647427026;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:22:"["Business","Contact"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:7;a:20:{s:4:"tmpl";i:1290;s:2:"id";i:22470;s:5:"title";s:32:"Fly-In | Contact | Design Studio";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg";s:12:"tmpl_created";i:1647428250;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:39:"["Business","Contact","Digital Agency"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:8;a:20:{s:4:"tmpl";i:1291;s:2:"id";i:22480;s:5:"title";s:27:"Classic | CTA | MasterClass";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg";s:12:"tmpl_created";i:1647428474;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:29:"["cta","Magazine","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:9;a:20:{s:4:"tmpl";i:1292;s:2:"id";i:22489;s:5:"title";s:29:"Classic | CTA | Music Concert";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg";s:12:"tmpl_created";i:1647429738;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:34:"["cta","Landing Pages","Magazine"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:10;a:20:{s:4:"tmpl";i:1293;s:2:"id";i:22495;s:5:"title";s:27:"Classic | CTA | Music Album";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg";s:12:"tmpl_created";i:1647430056;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:34:"["Ba","Landing Pages","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:11;a:20:{s:4:"tmpl";i:1294;s:2:"id";i:22501;s:5:"title";s:37:"Fly-In | CTA | Photography Exhibition";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg";s:12:"tmpl_created";i:1647430512;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:33:"["cta","Photography","Portfolio"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:12;a:20:{s:4:"tmpl";i:1295;s:2:"id";i:22507;s:5:"title";s:34:"Classic | CTA | Clothing Shop Sale";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg";s:12:"tmpl_created";i:1647430774;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:35:"["Ecommerce","Fashion","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:13;a:20:{s:4:"tmpl";i:1296;s:2:"id";i:22486;s:5:"title";s:30:"Classic | CTA | Shop Promotion";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg";s:12:"tmpl_created";i:1647430951;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:32:"["cta","Magazine","Photography"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:14;a:20:{s:4:"tmpl";i:1297;s:2:"id";i:22516;s:5:"title";s:32:"Fly-In | CTA | Glasses Shop Sale";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg";s:12:"tmpl_created";i:1647431136;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:30:"["Business","cta","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:15;a:20:{s:4:"tmpl";i:1298;s:2:"id";i:22522;s:5:"title";s:30:"Fly-In | Discount | Skate Shop";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg";s:12:"tmpl_created";i:1647434058;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:32:"["Discount","Ecommerce","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:16;a:20:{s:4:"tmpl";i:1299;s:2:"id";i:22532;s:5:"title";s:43:"Classic | Subscription | Basketball Academy";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg";s:12:"tmpl_created";i:1647434608;s:6:"author";s:9:"Elementor";s:3:"url";s:145:"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:33:"["Education","Marketing","Sport"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:17;a:20:{s:4:"tmpl";i:1300;s:2:"id";i:22543;s:5:"title";s:38:"Classic | Discount | Veterinary Clinic";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg";s:12:"tmpl_created";i:1647435581;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:19:"["Discount","Pets"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:18;a:20:{s:4:"tmpl";i:1301;s:2:"id";i:22553;s:5:"title";s:39:"Classic | Contact | Business Consulting";s:9:"thumbnail";s:94:"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg";s:12:"tmpl_created";i:1647439935;s:6:"author";s:9:"Elementor";s:3:"url";s:141:"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:22:"["Business","Contact"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:19;a:20:{s:4:"tmpl";i:1302;s:2:"id";i:22562;s:5:"title";s:28:"Classic | Contact | Handyman";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg";s:12:"tmpl_created";i:1647440333;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:33:"["Business","Contact","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:20;a:20:{s:4:"tmpl";i:1303;s:2:"id";i:22573;s:5:"title";s:40:"Classic | Discount | Online Fashion Shop";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg";s:12:"tmpl_created";i:1647462549;s:6:"author";s:9:"Elementor";s:3:"url";s:142:"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:32:"["Discount","Ecommerce","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:21;a:20:{s:4:"tmpl";i:1304;s:2:"id";i:22583;s:5:"title";s:36:"Fly-In | Discount | Personal Trainer";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg";s:12:"tmpl_created";i:1647503781;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:31:"["Discount","Sport","Training"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:22;a:20:{s:4:"tmpl";i:1305;s:2:"id";i:22592;s:5:"title";s:41:"Classic | Contact | Illustrator Portfolio";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg";s:12:"tmpl_created";i:1647504218;s:6:"author";s:9:"Elementor";s:3:"url";s:143:"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:49:"["Contact","Creative Portfolio","Digital Agency"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:23;a:20:{s:4:"tmpl";i:1306;s:2:"id";i:22602;s:5:"title";s:46:"Bottom Bar | Discount | Handmade Ceramics Shop";s:9:"thumbnail";s:91:"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg";s:12:"tmpl_created";i:1647507007;s:6:"author";s:9:"Elementor";s:3:"url";s:148:"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:10:"bottom bar";s:4:"tags";s:48:"["Business","cta","Ecommerce","Interior Design"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:24;a:20:{s:4:"tmpl";i:1307;s:2:"id";i:22612;s:5:"title";s:51:"Classic | Contact | Classic Car Restoration Company";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg";s:12:"tmpl_created";i:1647507310;s:6:"author";s:9:"Elementor";s:3:"url";s:153:"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:32:"["Booking","Contact","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:25;a:20:{s:4:"tmpl";i:1308;s:2:"id";i:22621;s:5:"title";s:30:"Classic | Booking | Life Coach";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg";s:12:"tmpl_created";i:1647508596;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:33:"["Booking","Business","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:26;a:20:{s:4:"tmpl";i:1309;s:2:"id";i:22632;s:5:"title";s:42:"Classic |  Subscription | Merchandise Shop";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg";s:12:"tmpl_created";i:1647509196;s:6:"author";s:9:"Elementor";s:3:"url";s:143:"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:32:"["Ecommerce","Marketing","Shop"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:27;a:20:{s:4:"tmpl";i:1310;s:2:"id";i:22643;s:5:"title";s:48:"Fly-In | Contact | Non-Governmental Organization";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg";s:12:"tmpl_created";i:1647509528;s:6:"author";s:9:"Elementor";s:3:"url";s:150:"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:28;a:20:{s:4:"tmpl";i:1311;s:2:"id";i:22654;s:5:"title";s:35:"Hello Bar | Contact | Family Doctor";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg";s:12:"tmpl_created";i:1647509732;s:6:"author";s:9:"Elementor";s:3:"url";s:137:"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:31:"["Contact","Health","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:29;a:20:{s:4:"tmpl";i:1312;s:2:"id";i:22663;s:5:"title";s:36:"Classic | Subscription | Sports Blog";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg";s:12:"tmpl_created";i:1647509908;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:16:"["Blog","Sport"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:30;a:20:{s:4:"tmpl";i:1313;s:2:"id";i:22673;s:5:"title";s:30:"Hello Bar | Booking | Event DJ";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg";s:12:"tmpl_created";i:1647510160;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:31:"["Booking","Events","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:31;a:20:{s:4:"tmpl";i:1314;s:2:"id";i:22684;s:5:"title";s:36:"Fly-In | Discount | Cleaning Company";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg";s:12:"tmpl_created";i:1647510546;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:31:"["Discount","Offer","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:32;a:20:{s:4:"tmpl";i:1315;s:2:"id";i:22693;s:5:"title";s:28:"Fly-In | Contact | Carpenter";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg";s:12:"tmpl_created";i:1647511972;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:22:"["Contact","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:33;a:20:{s:4:"tmpl";i:1316;s:2:"id";i:22703;s:5:"title";s:31:"Classic | Booking | Yoga Studio";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg";s:12:"tmpl_created";i:1647512209;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:30:"["Booking","Contact","Health"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:34;a:20:{s:4:"tmpl";i:1317;s:2:"id";i:22714;s:5:"title";s:37:"Classic | Discount | Pet Care Company";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg";s:12:"tmpl_created";i:1647513031;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:17:"["Offer","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:35;a:20:{s:4:"tmpl";i:1318;s:2:"id";i:22725;s:5:"title";s:38:"Fly-In | Discount | Online Coffee Shop";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg";s:12:"tmpl_created";i:1647513325;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:29:"["Food","Offer","Restaurant"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:36;a:20:{s:4:"tmpl";i:1319;s:2:"id";i:22737;s:5:"title";s:44:"Fly-In | CTA | Moving &#038; Storage Company";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg";s:12:"tmpl_created";i:1647520956;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:37;a:20:{s:4:"tmpl";i:1320;s:2:"id";i:22749;s:5:"title";s:47:"Classic | Contact | Industrial Design Portfolio";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg";s:12:"tmpl_created";i:1647528116;s:6:"author";s:9:"Elementor";s:3:"url";s:149:"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:40:"["Contact","Interior Design","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:38;a:20:{s:4:"tmpl";i:1321;s:2:"id";i:22759;s:5:"title";s:25:"Classic | Contact | Drone";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg";s:12:"tmpl_created";i:1647528899;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:22:"["Contact","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:39;a:20:{s:4:"tmpl";i:1322;s:2:"id";i:22768;s:5:"title";s:46:"Full Screen | Menu | Fashion Stylist Portfolio";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg";s:12:"tmpl_created";i:1647529434;s:6:"author";s:9:"Elementor";s:3:"url";s:148:"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:31:"["Fashion","Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:40;a:20:{s:4:"tmpl";i:1323;s:2:"id";i:22780;s:5:"title";s:31:"Fly-In | CTA | Landscape Design";s:9:"thumbnail";s:94:"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg";s:12:"tmpl_created";i:1647530337;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:18:"["cta","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:41;a:20:{s:4:"tmpl";i:1324;s:2:"id";i:22790;s:5:"title";s:48:"Bottom Bar  | Contact | Architecture Photography";s:9:"thumbnail";s:94:"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg";s:12:"tmpl_created";i:1647532358;s:6:"author";s:9:"Elementor";s:3:"url";s:149:"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:17:"essential-oct2023";s:7:"subtype";s:10:"bottom bar";s:4:"tags";s:26:"["Architecture","Contact"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:42;a:20:{s:4:"tmpl";i:1325;s:2:"id";i:22800;s:5:"title";s:41:"Fly-In  | CTA | Speech-Language Therapist";s:9:"thumbnail";s:103:"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg";s:12:"tmpl_created";i:1647532720;s:6:"author";s:9:"Elementor";s:3:"url";s:142:"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:25:"["cta","Psychotherapist"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:43;a:20:{s:4:"tmpl";i:1326;s:2:"id";i:22812;s:5:"title";s:35:"Full Screen | Verification | Winery";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg";s:12:"tmpl_created";i:1647761384;s:6:"author";s:9:"Elementor";s:3:"url";s:137:"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:24:"["Alert","Verification"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:44;a:20:{s:4:"tmpl";i:1327;s:2:"id";i:22822;s:5:"title";s:36:"Fly-In | Subscription | Nutritionist";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg";s:12:"tmpl_created";i:1647762620;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:28:"["Food","Health","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:45;a:20:{s:4:"tmpl";i:1328;s:2:"id";i:22833;s:5:"title";s:40:"Classic | Subscription | App &#038; SaaS";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg";s:12:"tmpl_created";i:1647762955;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:14:"["App","SaaS"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:46;a:20:{s:4:"tmpl";i:1329;s:2:"id";i:22844;s:5:"title";s:41:"Bottom Bar | Discount | Handmade Cupcakes";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg";s:12:"tmpl_created";i:1647763350;s:6:"author";s:9:"Elementor";s:3:"url";s:143:"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:10:"bottom bar";s:4:"tags";s:21:"["Food","Restaurant"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:47;a:20:{s:4:"tmpl";i:1330;s:2:"id";i:22855;s:5:"title";s:40:"Bottom Bar | Subscription | Fashion Blog";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg";s:12:"tmpl_created";i:1647763907;s:6:"author";s:9:"Elementor";s:3:"url";s:142:"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:10:"bottom bar";s:4:"tags";s:30:"["Blog","Fashion","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:48;a:20:{s:4:"tmpl";i:1331;s:2:"id";i:22866;s:5:"title";s:28:"Fly-In | CTA | Private Tutor";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg";s:12:"tmpl_created";i:1647764062;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:49;a:20:{s:4:"tmpl";i:1332;s:2:"id";i:22876;s:5:"title";s:30:"Classic | CTA | Tennis Academy";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg";s:12:"tmpl_created";i:1647765192;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:50;a:20:{s:4:"tmpl";i:1333;s:2:"id";i:22887;s:5:"title";s:31:"Fly-In | CTA | Shared Workspace";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg";s:12:"tmpl_created";i:1647765419;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:18:"["Business","cta"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:51;a:20:{s:4:"tmpl";i:1334;s:2:"id";i:22899;s:5:"title";s:30:"Bottom Bar | CTA | Art Gallery";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg";s:12:"tmpl_created";i:1647765652;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:10:"bottom bar";s:4:"tags";s:13:"["Art","cta"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:52;a:20:{s:4:"tmpl";i:1335;s:2:"id";i:22910;s:5:"title";s:44:"Fly-In | Subscription | Hiking Tours Company";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg";s:12:"tmpl_created";i:1647765835;s:6:"author";s:9:"Elementor";s:3:"url";s:146:"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:29:"["Subscribe","Travel","Trip"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:53;a:20:{s:4:"tmpl";i:1336;s:2:"id";i:22921;s:5:"title";s:26:"Classic | CTA | Music Band";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg";s:12:"tmpl_created";i:1647769462;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:21:"["Marketing","Music"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:54;a:20:{s:4:"tmpl";i:1337;s:2:"id";i:22935;s:5:"title";s:35:"Classic | CTA | Computer Technician";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg";s:12:"tmpl_created";i:1647769843;s:6:"author";s:9:"Elementor";s:3:"url";s:137:"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:18:"["cta","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:55;a:20:{s:4:"tmpl";i:1338;s:2:"id";i:22945;s:5:"title";s:37:"Classic | Discount | Delivery Company";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg";s:12:"tmpl_created";i:1647770834;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:23:"["Discount","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:56;a:20:{s:4:"tmpl";i:1339;s:2:"id";i:22959;s:5:"title";s:29:"Classic | Discount | Eco Shop";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg";s:12:"tmpl_created";i:1647771211;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:24:"["Discount","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:57;a:20:{s:4:"tmpl";i:1340;s:2:"id";i:22972;s:5:"title";s:54:"Fly-In | Subscription | Health &#038; Mindfulness Blog";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg";s:12:"tmpl_created";i:1647771461;s:6:"author";s:9:"Elementor";s:3:"url";s:149:"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:21:"["Health","Magazine"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:58;a:20:{s:4:"tmpl";i:1341;s:2:"id";i:22982;s:5:"title";s:31:"Full Screen | Menu | Art Museum";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg";s:12:"tmpl_created";i:1647771938;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:21:"["Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:59;a:20:{s:4:"tmpl";i:1342;s:2:"id";i:22992;s:5:"title";s:40:"Classic | Discount | Urban Clothing Shop";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg";s:12:"tmpl_created";i:1647773067;s:6:"author";s:9:"Elementor";s:3:"url";s:142:"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:34:"["Discount","Ecommerce","Fashion"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:60;a:20:{s:4:"tmpl";i:1343;s:2:"id";i:23004;s:5:"title";s:60:"Full Screen | Menu | Digital &#038; Technology Design School";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg";s:12:"tmpl_created";i:1647773366;s:6:"author";s:9:"Elementor";s:3:"url";s:155:"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:8:"["menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:61;a:20:{s:4:"tmpl";i:1344;s:2:"id";i:23015;s:5:"title";s:62:"Bottom Bar | Contact | Digital &#038; Technology Design School";s:9:"thumbnail";s:93:"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg";s:12:"tmpl_created";i:1647773492;s:6:"author";s:9:"Elementor";s:3:"url";s:157:"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:10:"bottom bar";s:4:"tags";s:23:"["Contact","Portfolio"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:62;a:20:{s:4:"tmpl";i:1345;s:2:"id";i:23025;s:5:"title";s:32:"Full Screen | Menu | Flower Shop";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg";s:12:"tmpl_created";i:1647773820;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:21:"["Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:63;a:20:{s:4:"tmpl";i:1346;s:2:"id";i:23037;s:5:"title";s:36:"Classic | Subscription | Flower Shop";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg";s:12:"tmpl_created";i:1647773949;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:24:"["Discount","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:64;a:20:{s:4:"tmpl";i:1347;s:2:"id";i:23056;s:5:"title";s:48:"Classic | Discount | Health &#038; Fitness eBook";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg";s:12:"tmpl_created";i:1647774468;s:6:"author";s:9:"Elementor";s:3:"url";s:143:"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:23:"["Contact","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:65;a:20:{s:4:"tmpl";i:1348;s:2:"id";i:23067;s:5:"title";s:37:"Fly-In | Menu | Baby Sleep Consultant";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg";s:12:"tmpl_created";i:1647778954;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:8:"["menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:66;a:20:{s:4:"tmpl";i:1349;s:2:"id";i:23077;s:5:"title";s:46:"Classic | Subscription | Baby Sleep Consultant";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg";s:12:"tmpl_created";i:1647779074;s:6:"author";s:9:"Elementor";s:3:"url";s:148:"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:12:"["Discount"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:67;a:20:{s:4:"tmpl";i:1350;s:2:"id";i:23090;s:5:"title";s:33:"Full Screen | Menu | Luxury Hotel";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg";s:12:"tmpl_created";i:1647779390;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:21:"["Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:68;a:20:{s:4:"tmpl";i:1351;s:2:"id";i:23100;s:5:"title";s:31:"Fly-In | Booking | Luxury Hotel";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg";s:12:"tmpl_created";i:1647779500;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:20:"["Booking","Travel"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:69;a:20:{s:4:"tmpl";i:1352;s:2:"id";i:23109;s:5:"title";s:38:"Full Screen | Menu | Design Conference";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg";s:12:"tmpl_created";i:1647779675;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:21:"["Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:70;a:20:{s:4:"tmpl";i:1353;s:2:"id";i:23120;s:5:"title";s:41:"Full Screen | Booking | Design Conference";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg";s:12:"tmpl_created";i:1647779793;s:6:"author";s:9:"Elementor";s:3:"url";s:143:"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:35:"["Booking","Conference","Creative"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:71;a:20:{s:4:"tmpl";i:1354;s:2:"id";i:23129;s:5:"title";s:29:"Slide-In | Menu | VR Headsets";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg";s:12:"tmpl_created";i:1647781211;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:8:"["menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:72;a:20:{s:4:"tmpl";i:1355;s:2:"id";i:23139;s:5:"title";s:31:"Classic | Contact | VR Headsets";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg";s:12:"tmpl_created";i:1647781384;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:73;a:20:{s:4:"tmpl";i:1356;s:2:"id";i:23149;s:5:"title";s:38:"Slide-In | Menu | Portrait Photography";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg";s:12:"tmpl_created";i:1647782336;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:8:"["menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:74;a:20:{s:4:"tmpl";i:1357;s:2:"id";i:23159;s:5:"title";s:47:"Hello Bar | Subscription | Portrait Photography";s:9:"thumbnail";s:97:"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg";s:12:"tmpl_created";i:1647782478;s:6:"author";s:9:"Elementor";s:3:"url";s:149:"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:34:"["Blog","Photography","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:75;a:20:{s:4:"tmpl";i:1358;s:2:"id";i:23169;s:5:"title";s:32:"Full Screen | Menu | English Pub";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg";s:12:"tmpl_created";i:1647782664;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:21:"["Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:76;a:20:{s:4:"tmpl";i:1359;s:2:"id";i:23179;s:5:"title";s:32:"Classic | Discount | English Pub";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg";s:12:"tmpl_created";i:1647782796;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:20:"["Discount","Offer"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:77;a:20:{s:4:"tmpl";i:1360;s:2:"id";i:23189;s:5:"title";s:27:"Full Screen | Menu | Singer";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg";s:12:"tmpl_created";i:1647783070;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:29:"["Fullscreen","menu","Music"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:78;a:20:{s:4:"tmpl";i:1361;s:2:"id";i:23200;s:5:"title";s:31:"Classic | Subscription | Singer";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg";s:12:"tmpl_created";i:1647783249;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:21:"["Music","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:79;a:20:{s:4:"tmpl";i:1362;s:2:"id";i:23210;s:5:"title";s:38:"Full Screen | Menu | Virtual Assistant";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg";s:12:"tmpl_created";i:1647784292;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:21:"["Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:80;a:20:{s:4:"tmpl";i:1363;s:2:"id";i:23223;s:5:"title";s:39:"Hello Bar | Contact | Virtual Assistant";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg";s:12:"tmpl_created";i:1647784616;s:6:"author";s:9:"Elementor";s:3:"url";s:141:"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:37:"["Contact","Psychologist","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:81;a:20:{s:4:"tmpl";i:1364;s:2:"id";i:23234;s:5:"title";s:32:"Slide-In  | Menu | Personal Chef";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg";s:12:"tmpl_created";i:1647798194;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:8:"["menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:82;a:20:{s:4:"tmpl";i:1365;s:2:"id";i:23244;s:5:"title";s:29:"Classic | CTA | Personal Chef";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg";s:12:"tmpl_created";i:1647798297;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:24:"["Booking","Chef","cta"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:83;a:20:{s:4:"tmpl";i:1366;s:2:"id";i:23254;s:5:"title";s:31:"Full Screen | Menu | Food Truck";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg";s:12:"tmpl_created";i:1647798447;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:21:"["Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:84;a:20:{s:4:"tmpl";i:1367;s:2:"id";i:23265;s:5:"title";s:30:"Fly-In | Discount | Food Truck";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg";s:12:"tmpl_created";i:1647798657;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:20:"["Discount","Offer"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:85;a:20:{s:4:"tmpl";i:1369;s:2:"id";i:23323;s:5:"title";s:28:"Classic | CTA | Black Friday";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg";s:12:"tmpl_created";i:1647855505;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:34:"["Black Friday","cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:86;a:20:{s:4:"tmpl";i:1370;s:2:"id";i:23329;s:5:"title";s:29:"Slide-In | CTA | Black Friday";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg";s:12:"tmpl_created";i:1647855865;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:34:"["Black Friday","cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:87;a:20:{s:4:"tmpl";i:1371;s:2:"id";i:23335;s:5:"title";s:31:"Slide-In | CTA | Black Friday 1";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg";s:12:"tmpl_created";i:1647856357;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:34:"["Black Friday","cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:88;a:20:{s:4:"tmpl";i:1372;s:2:"id";i:23341;s:5:"title";s:30:"Classic | CTA | Black Friday 2";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg";s:12:"tmpl_created";i:1647856493;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:34:"["Black Friday","cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:89;a:20:{s:4:"tmpl";i:1373;s:2:"id";i:23347;s:5:"title";s:30:"Classic | CTA | Black Friday 3";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg";s:12:"tmpl_created";i:1647856891;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:34:"["Black Friday","cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:90;a:20:{s:4:"tmpl";i:1374;s:2:"id";i:23354;s:5:"title";s:30:"Classic | CTA | Black Friday 4";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg";s:12:"tmpl_created";i:1647856996;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:34:"["Black Friday","cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:91;a:20:{s:4:"tmpl";i:1375;s:2:"id";i:23394;s:5:"title";s:27:"Classic | CTA | Halloween 1";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg";s:12:"tmpl_created";i:1647857351;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:31:"["cta","Ecommerce","Halloween"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:92;a:20:{s:4:"tmpl";i:1376;s:2:"id";i:23401;s:5:"title";s:33:"Slide-In | Discount | Halloween 2";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg";s:12:"tmpl_created";i:1647857567;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:36:"["Discount","Ecommerce","Halloween"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:93;a:20:{s:4:"tmpl";i:1377;s:2:"id";i:23407;s:5:"title";s:33:"Slide-In | Discount | Halloween 3";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg";s:12:"tmpl_created";i:1647857814;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:36:"["Discount","Ecommerce","Halloween"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:94;a:20:{s:4:"tmpl";i:1378;s:2:"id";i:23416;s:5:"title";s:31:"Fly-In | Discount | Halloween 4";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg";s:12:"tmpl_created";i:1647858024;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:44:"["Discount","Ecommerce","Halloween","Offer"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:95;a:20:{s:4:"tmpl";i:1379;s:2:"id";i:23422;s:5:"title";s:36:"Classic | Subscription | Halloween 5";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg";s:12:"tmpl_created";i:1647858246;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:48:"["Discount","Ecommerce","Halloween","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:96;a:20:{s:4:"tmpl";i:1380;s:2:"id";i:23471;s:5:"title";s:28:"Slide-In | CTA | Christmas 1";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg";s:12:"tmpl_created";i:1647859193;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:19:"["Christmas","cta"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:97;a:20:{s:4:"tmpl";i:1381;s:2:"id";i:23477;s:5:"title";s:28:"Slide-In | CTA | Christmas 2";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg";s:12:"tmpl_created";i:1647859838;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:19:"["Christmas","cta"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:98;a:20:{s:4:"tmpl";i:1382;s:2:"id";i:23483;s:5:"title";s:26:"Fly-In | CTA | Christmas 3";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg";s:12:"tmpl_created";i:1647860157;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:31:"["Christmas","cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:99;a:20:{s:4:"tmpl";i:1383;s:2:"id";i:23489;s:5:"title";s:33:"Slide-In | Discount | Christmas 4";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg";s:12:"tmpl_created";i:1647860302;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:31:"["Christmas","cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:100;a:20:{s:4:"tmpl";i:1384;s:2:"id";i:23496;s:5:"title";s:32:"Classic | Discount | Christmas 5";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg";s:12:"tmpl_created";i:1647860454;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:29:"["Christmas","Offer","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:101;a:20:{s:4:"tmpl";i:1385;s:2:"id";i:23523;s:5:"title";s:30:"Classic | CTA | Valentines Day";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg";s:12:"tmpl_created";i:1647860912;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:25:"["cta","Valentine\'s Day"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:102;a:20:{s:4:"tmpl";i:1386;s:2:"id";i:23529;s:5:"title";s:39:"Hello Bar | Discount | Valentines Day 2";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg";s:12:"tmpl_created";i:1647861064;s:6:"author";s:9:"Elementor";s:3:"url";s:141:"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:30:"["Discount","Valentine\'s Day"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:103;a:20:{s:4:"tmpl";i:1387;s:2:"id";i:23536;s:5:"title";s:32:"Classic | CTA | Valentines Day 3";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg";s:12:"tmpl_created";i:1647861536;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:25:"["cta","Valentine\'s Day"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:104;a:20:{s:4:"tmpl";i:1388;s:2:"id";i:23586;s:5:"title";s:51:"Fly-In | Subscribe | Health &#038; Wellness Company";s:9:"thumbnail";s:103:"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg";s:12:"tmpl_created";i:1647862008;s:6:"author";s:9:"Elementor";s:3:"url";s:146:"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:24:"["Business","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:105;a:20:{s:4:"tmpl";i:1389;s:2:"id";i:23592;s:5:"title";s:34:"Classic | Subscribe | Tech Company";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg";s:12:"tmpl_created";i:1647866706;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:25:"["Marketing","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:106;a:20:{s:4:"tmpl";i:1390;s:2:"id";i:23598;s:5:"title";s:36:"Classic | Contact Us | Fight Classes";s:9:"thumbnail";s:94:"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg";s:12:"tmpl_created";i:1647866869;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:23:"["Contact","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:107;a:20:{s:4:"tmpl";i:1391;s:2:"id";i:23611;s:5:"title";s:31:"Classic | CTA | Mochi Shop Sale";s:9:"thumbnail";s:99:"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg";s:12:"tmpl_created";i:1647867750;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:23:"["cta","Offer","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:108;a:20:{s:4:"tmpl";i:1392;s:2:"id";i:23618;s:5:"title";s:28:"Classic | CTA | Fashion Shop";s:9:"thumbnail";s:96:"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg";s:12:"tmpl_created";i:1647868251;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:19:"["cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:109;a:20:{s:4:"tmpl";i:1393;s:2:"id";i:23624;s:5:"title";s:29:"Fly-In | Login | Tech Company";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg";s:12:"tmpl_created";i:1647868704;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:9:"["Login"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:110;a:20:{s:4:"tmpl";i:1394;s:2:"id";i:23630;s:5:"title";s:36:"Fly-In | Verification | Liquor Store";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg";s:12:"tmpl_created";i:1647870308;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:16:"["Verification"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:111;a:20:{s:4:"tmpl";i:1395;s:2:"id";i:23636;s:5:"title";s:39:"Hello Bar | Subscribe | Online Magazine";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg";s:12:"tmpl_created";i:1647870465;s:6:"author";s:9:"Elementor";s:3:"url";s:141:"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:20:"["Blog","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:112;a:20:{s:4:"tmpl";i:1396;s:2:"id";i:23642;s:5:"title";s:27:"Fly-In | Login | Health Spa";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg";s:12:"tmpl_created";i:1647872427;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:20:"["Login","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:113;a:20:{s:4:"tmpl";i:1397;s:2:"id";i:23648;s:5:"title";s:33:"Fly-In | Verification | Wine Shop";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg";s:12:"tmpl_created";i:1647872627;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:16:"["Verification"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:114;a:20:{s:4:"tmpl";i:1421;s:2:"id";i:24235;s:5:"title";s:24:"Ladydog Club &#8211; NFT";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg";s:12:"tmpl_created";i:1651525072;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:3:"NFT";s:4:"tags";s:100:"["Art","Author","Business","Creative","Design","Gallery","Landing Pages","NFT","Products","Virtual"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:115;a:20:{s:4:"tmpl";i:1422;s:2:"id";i:24166;s:5:"title";s:15:"Dot &#8211; NFT";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg";s:12:"tmpl_created";i:1651525117;s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:3:"NFT";s:4:"tags";s:100:"["Art","Author","Business","Creative","Design","Gallery","Landing Pages","NFT","Products","Virtual"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:116;a:20:{s:4:"tmpl";i:1423;s:2:"id";i:24191;s:5:"title";s:28:"Cosmic Neighbors &#8211; NFT";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg";s:12:"tmpl_created";i:1651525124;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:3:"NFT";s:4:"tags";s:100:"["Art","Author","Business","Creative","Design","Gallery","Landing Pages","NFT","Products","Virtual"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:117;a:20:{s:4:"tmpl";i:1424;s:2:"id";i:24255;s:5:"title";s:30:"Happy Food Friends &#8211; NFT";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg";s:12:"tmpl_created";i:1651525475;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:3:"NFT";s:4:"tags";s:100:"["Art","Author","Business","Creative","Design","Gallery","Landing Pages","NFT","Products","Virtual"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:118;a:20:{s:4:"tmpl";i:1443;s:2:"id";i:24599;s:5:"title";s:27:"Wireframe &#8211; Courses 1";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg";s:12:"tmpl_created";i:1653989626;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"Wireframe";s:4:"tags";s:180:"["About","Academy","Booking","Business","Course Online","Features","Footer","Landing Pages","Online Service","Professional","School","Services","Subscribe","Teacher","Testimonial"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:119;a:20:{s:4:"tmpl";i:1444;s:2:"id";i:24614;s:5:"title";s:28:"Wireframe &#8211; Services 1";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg";s:12:"tmpl_created";i:1653990084;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Wireframe";s:4:"tags";s:139:"["About","Business","Contact","Features","Footer","Form","Header","Landing Pages","Online Service","Professional","Services","Testimonial"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:120;a:20:{s:4:"tmpl";i:1445;s:2:"id";i:24629;s:5:"title";s:28:"Wireframe &#8211; Services 2";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg";s:12:"tmpl_created";i:1653990132;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Wireframe";s:4:"tags";s:123:"["About","Business","Contact","Features","Footer","Form","Gallery","Landing Pages","Professional","Services","Testimonial"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:121;a:20:{s:4:"tmpl";i:1446;s:2:"id";i:24644;s:5:"title";s:27:"Wireframe &#8211; Webinar 1";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg";s:12:"tmpl_created";i:1653990164;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Wireframe";s:4:"tags";s:177:"["About","Academy","Booking","Conference","Course Online","Education","Features","Footer","Form","Landing Pages","Online Event","Online Service","Subscribe","Virtual","Webinar"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:122;a:20:{s:4:"tmpl";i:1447;s:2:"id";i:24655;s:5:"title";s:28:"Wireframe &#8211; Services 3";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg";s:12:"tmpl_created";i:1653990198;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Wireframe";s:4:"tags";s:143:"["About","Agency","Business","Contact","Footer","Form","Gallery","Landing Pages","Portfolio","Professional","Project","Services","Testimonial"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:123;a:20:{s:4:"tmpl";i:1448;s:2:"id";i:24677;s:5:"title";s:28:"Wireframe &#8211; Services 4";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg";s:12:"tmpl_created";i:1653990233;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Wireframe";s:4:"tags";s:102:"["About","Business","Contact","Footer","Form","Landing Pages","Professional","Services","Testimonial"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:124;a:20:{s:4:"tmpl";i:1449;s:2:"id";i:24687;s:5:"title";s:28:"Wireframe &#8211; Products 1";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg";s:12:"tmpl_created";i:1653990273;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"Wireframe";s:4:"tags";s:128:"["About","Booking","Business","Clients","Ecommerce","Features","Footer","Landing Pages","Products","Sales","Shop","Testimonial"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:125;a:20:{s:4:"tmpl";i:1450;s:2:"id";i:24706;s:5:"title";s:28:"Wireframe &#8211; Services 5";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg";s:12:"tmpl_created";i:1653990322;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Wireframe";s:4:"tags";s:149:"["About","Booking","Consulting","Contact","Doctor","Footer","Form","Header","Landing Pages","Online Service","Professional","Services","Testimonial"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:126;a:20:{s:4:"tmpl";i:1451;s:2:"id";i:23604;s:5:"title";s:38:"Classic | Subscribe | Nail Polish Shop";s:9:"thumbnail";s:96:"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg";s:12:"tmpl_created";i:1660205114;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:20:"["Blog","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:127;a:20:{s:4:"tmpl";i:1452;s:2:"id";i:23047;s:5:"title";s:46:"Fly-In | Contact | Health &#038; Fitness eBook";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg";s:12:"tmpl_created";i:1660205149;s:6:"author";s:9:"Elementor";s:3:"url";s:141:"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:28:"["Contact","Ebook","Health"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:128;a:20:{s:4:"tmpl";i:1199;s:2:"id";i:18839;s:5:"title";s:27:"Hello Bar | CTA | eCommerce";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png";s:12:"tmpl_created";i:1621870603;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:41:"["Ecommerce","Online Shop","Sale","Shop"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:129;a:20:{s:4:"tmpl";i:1247;s:2:"id";i:21907;s:5:"title";s:50:"Fly-In | Team Details  | Electronic Music Festival";s:9:"thumbnail";s:104:"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg";s:12:"tmpl_created";i:1646660881;s:6:"author";s:9:"Elementor";s:3:"url";s:157:"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:130;a:20:{s:4:"tmpl";i:1253;s:2:"id";i:22162;s:5:"title";s:46:"Full Screen | Menu | Electronic Music Festival";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg";s:12:"tmpl_created";i:1647272934;s:6:"author";s:9:"Elementor";s:3:"url";s:154:"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:21:"["Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:131;a:20:{s:4:"tmpl";i:1254;s:2:"id";i:22172;s:5:"title";s:45:"Classic | Discount | Health &#038; Beauty Spa";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg";s:12:"tmpl_created";i:1647273547;s:6:"author";s:9:"Elementor";s:3:"url";s:146:"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:36:"["Hair","Health","Sales","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:132;a:20:{s:4:"tmpl";i:1255;s:2:"id";i:22183;s:5:"title";s:44:"Hello Bar | CTA | Environmental Organization";s:9:"thumbnail";s:104:"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg";s:12:"tmpl_created";i:1647274384;s:6:"author";s:9:"Elementor";s:3:"url";s:152:"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:133;a:20:{s:4:"tmpl";i:1256;s:2:"id";i:22195;s:5:"title";s:39:"Classic | Discount | Italian Restaurant";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg";s:12:"tmpl_created";i:1647329432;s:6:"author";s:9:"Elementor";s:3:"url";s:147:"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:22:"["Restaurant","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:134;a:20:{s:4:"tmpl";i:1257;s:2:"id";i:22210;s:5:"title";s:45:"Bottom Bar | Discount | Technology Conference";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg";s:12:"tmpl_created";i:1647330423;s:6:"author";s:9:"Elementor";s:3:"url";s:153:"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:10:"bottom bar";s:4:"tags";s:38:"["Conference","Sales","Save the Date"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:135;a:20:{s:4:"tmpl";i:1258;s:2:"id";i:22221;s:5:"title";s:32:"Hello Bar | Menu | Tattoo Studio";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg";s:12:"tmpl_created";i:1647330705;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:17:"["Header","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:136;a:20:{s:4:"tmpl";i:1259;s:2:"id";i:22231;s:5:"title";s:37:"Full Screen | Booking | Tattoo Studio";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg";s:12:"tmpl_created";i:1647331823;s:6:"author";s:9:"Elementor";s:3:"url";s:145:"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:32:"["Booking","Contact","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:137;a:20:{s:4:"tmpl";i:1260;s:2:"id";i:22251;s:5:"title";s:34:"Classic | Discount | Dental Clinic";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg";s:12:"tmpl_created";i:1647332171;s:6:"author";s:9:"Elementor";s:3:"url";s:142:"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:30:"["Health","Marketing","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:138;a:20:{s:4:"tmpl";i:1261;s:2:"id";i:22261;s:5:"title";s:34:"Slide-In | Contact | Makeup Artist";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg";s:12:"tmpl_created";i:1647333946;s:6:"author";s:9:"Elementor";s:3:"url";s:142:"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:33:"["Business","Contact","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:139;a:20:{s:4:"tmpl";i:1262;s:2:"id";i:22271;s:5:"title";s:24:"Fly-In | CTA | Headphone";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg";s:12:"tmpl_created";i:1647334784;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:41:"["cta","Ecommerce","Marketing","Product"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:140;a:20:{s:4:"tmpl";i:1263;s:2:"id";i:22277;s:5:"title";s:29:"Classic | CTA | Online Course";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg";s:12:"tmpl_created";i:1647337110;s:6:"author";s:9:"Elementor";s:3:"url";s:137:"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:35:"["Course Online","cta","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:141;a:20:{s:4:"tmpl";i:1264;s:2:"id";i:22283;s:5:"title";s:40:"Bottom Bar | Contact | Virtual Assistant";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg";s:12:"tmpl_created";i:1647337517;s:6:"author";s:9:"Elementor";s:3:"url";s:148:"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:10:"bottom bar";s:4:"tags";s:33:"["Business","Contact","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:142;a:20:{s:4:"tmpl";i:1265;s:2:"id";i:22289;s:5:"title";s:32:"Fly-In | Contact | Private Tutor";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg";s:12:"tmpl_created";i:1647337676;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:4:"free";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:27:"["Contact","Course Online"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:143;a:20:{s:4:"tmpl";i:1266;s:2:"id";i:22295;s:5:"title";s:31:"Classic |  Login | Login Travel";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg";s:12:"tmpl_created";i:1647339467;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"classic";s:4:"tags";s:9:"["Login"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:144;a:20:{s:4:"tmpl";i:1267;s:2:"id";i:22301;s:5:"title";s:36:"Full Screen | Login | Login Business";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg";s:12:"tmpl_created";i:1647339782;s:6:"author";s:9:"Elementor";s:3:"url";s:144:"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:16:"["Login","SaaS"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:145;a:20:{s:4:"tmpl";i:1268;s:2:"id";i:22307;s:5:"title";s:28:"Classic | Login | Login Blog";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg";s:12:"tmpl_created";i:1647339986;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:16:"["Blog","Login"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:146;a:20:{s:4:"tmpl";i:1269;s:2:"id";i:22313;s:5:"title";s:31:"Classic | Login | Login Fashion";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg";s:12:"tmpl_created";i:1647340204;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:19:"["Fashion","Login"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:147;a:20:{s:4:"tmpl";i:1270;s:2:"id";i:22319;s:5:"title";s:40:"Classic |  Login | Login Design Platform";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg";s:12:"tmpl_created";i:1647340531;s:6:"author";s:9:"Elementor";s:3:"url";s:147:"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:25:"["Design","Login","SaaS"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:148;a:20:{s:4:"tmpl";i:1271;s:2:"id";i:22325;s:5:"title";s:36:"Fly-In | Contact | Digital Marketing";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg";s:12:"tmpl_created";i:1647340770;s:6:"author";s:9:"Elementor";s:3:"url";s:144:"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:51:"["Business","Contact","Digital Agency","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:149;a:20:{s:4:"tmpl";i:1272;s:2:"id";i:22331;s:5:"title";s:36:"Fly-In | CTA | Dog Cat Food Delivery";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg";s:12:"tmpl_created";i:1647341069;s:6:"author";s:9:"Elementor";s:3:"url";s:144:"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:33:"["cta","Delivery Service","Pets"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:150;a:20:{s:4:"tmpl";i:1273;s:2:"id";i:22337;s:5:"title";s:37:"Full Screen | Contact | Design Studio";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg";s:12:"tmpl_created";i:1647341370;s:6:"author";s:9:"Elementor";s:3:"url";s:145:"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:39:"["Business","Contact","Digital Agency"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:151;a:20:{s:4:"tmpl";i:1274;s:2:"id";i:22343;s:5:"title";s:44:"Classic | Contact | Support Product Platform";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg";s:12:"tmpl_created";i:1647341972;s:6:"author";s:9:"Elementor";s:3:"url";s:146:"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:21:"["Contact","Support"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:152;a:20:{s:4:"tmpl";i:1275;s:2:"id";i:22371;s:5:"title";s:38:"Full Screen | Contact | Small Business";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg";s:12:"tmpl_created";i:1647342508;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:40:"["Business","Contact","Interior Design"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:153;a:20:{s:4:"tmpl";i:1276;s:2:"id";i:22377;s:5:"title";s:31:"Classic | Contact | Online Shop";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg";s:12:"tmpl_created";i:1647352786;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:154;a:20:{s:4:"tmpl";i:1277;s:2:"id";i:22383;s:5:"title";s:40:"Classic | Booking | Children Optometrist";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg";s:12:"tmpl_created";i:1647352963;s:6:"author";s:9:"Elementor";s:3:"url";s:142:"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:53:"["Booking","Business","Contact","Education","Health"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:155;a:20:{s:4:"tmpl";i:1278;s:2:"id";i:22389;s:5:"title";s:28:"Fly-In | Contact | Open Week";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg";s:12:"tmpl_created";i:1647353281;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:34:"["Business","Contact","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:156;a:20:{s:4:"tmpl";i:1279;s:2:"id";i:22397;s:5:"title";s:43:"Full Screen | CTA | Plant Pots Online Store";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg";s:12:"tmpl_created";i:1647353429;s:6:"author";s:9:"Elementor";s:3:"url";s:145:"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:33:"["Ecommerce","Marketing","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:157;a:20:{s:4:"tmpl";i:1054;s:2:"id";i:15414;s:5:"title";s:32:"Classic | Contact | Dance Studio";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg";s:12:"tmpl_created";i:1603180596;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:16:"["Dance Studio"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:762;s:11:"trend_index";i:650;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:158;a:20:{s:4:"tmpl";i:1398;s:2:"id";i:23687;s:5:"title";s:32:"Pizza Promotion &#8211; Business";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg";s:12:"tmpl_created";i:1649670575;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"Business";s:4:"tags";s:92:"["Business","Cooking","Delivery","Discount","Fast Food","Food","Landing Pages","Restaurant"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:159;a:20:{s:4:"tmpl";i:1400;s:2:"id";i:23751;s:5:"title";s:33:"Baby Sleep Webinar &#8211; Events";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg";s:12:"tmpl_created";i:1649676065;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"Events";s:4:"tags";s:227:"["Baby","Booking","Business","Children","Course Online","Education","Events","Health","Landing Pages","Life Coach","Lifestyle","Online Event","Online Service","Parenting","Professional","Remote","Services","Training","Webinar"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:160;a:20:{s:4:"tmpl";i:1401;s:2:"id";i:23776;s:5:"title";s:34:"Ski Hotel Promotion &#8211; Travel";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg";s:12:"tmpl_created";i:1649691720;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"Travel";s:4:"tags";s:118:"["Accommodation","Booking","Discount. Landing Pages","Lifestyle","Luxury","Services","Spa","Travel","Trip","Vacation"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:161;a:20:{s:4:"tmpl";i:1402;s:2:"id";i:23804;s:5:"title";s:30:"Cake Delivery &#8211; Business";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg";s:12:"tmpl_created";i:1649692909;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:101:"["Bakery","Business","Cake","Cooking","Delivery","Discount","Food","Landing Pages","Products","Shop"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:162;a:20:{s:4:"tmpl";i:1403;s:2:"id";i:23832;s:5:"title";s:32:"Furniture Store &#8211; Business";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg";s:12:"tmpl_created";i:1649694812;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"Business";s:4:"tags";s:232:"["Architecture","Art","Business","Construction","Coupon","Creative","Decor","Designer","Discount","Fashion","Furniture Design","Home","House","Interior Design","Landing Pages","Lifestyle","Products","Professional","Services","Shop"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:163;a:20:{s:4:"tmpl";i:1404;s:2:"id";i:23746;s:5:"title";s:22:"Nails &#8211; Business";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg";s:12:"tmpl_created";i:1649704635;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:173:"["Art","Beauty","Business","Colorful","Cosmetics","Creative","Design","Discount","Fashion","Girly","Landing Pages","Lifestyle","Manicure","Modern","Professional","Services"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:164;a:20:{s:4:"tmpl";i:1405;s:2:"id";i:23846;s:5:"title";s:29:"Music Festival &#8211; Events";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg";s:12:"tmpl_created";i:1649707763;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:6:"Events";s:4:"tags";s:128:"["Author","Booking","Business","Creative","Discount","Events","Landing Pages","Music","Online","Online Event","Party","Virtual"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:165;a:20:{s:4:"tmpl";i:1406;s:2:"id";i:23872;s:5:"title";s:40:"Fashion Styling Course &#8211; Education";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg";s:12:"tmpl_created";i:1649708569;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Education";s:4:"tags";s:173:"["Aesthetic","Art","Beauty","Business","Course Online","Creative","Discount","Education","Fashion","Landing Pages","Lifestyle","Online","Online Service","Stylist","Virtual"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:166;a:20:{s:4:"tmpl";i:1407;s:2:"id";i:23897;s:5:"title";s:33:"Bags Online Shop &#8211; Business";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg";s:12:"tmpl_created";i:1649709513;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:170:"["Art","Bag","Business","Creative","Design","Discount","Fashion","Landing Pages","Lifestyle","Luxury","Modern","Online","Online Shop","Products","Sales","Shop","Stylist"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:167;a:20:{s:4:"tmpl";i:1408;s:2:"id";i:23932;s:5:"title";s:32:"Cooking Academy &#8211; Business";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg";s:12:"tmpl_created";i:1649710216;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:145:"["Academy","Booking","Business","Chef","Cooking","Education","Food","Free Trial","Landing Pages","Professional","School","Teacher","Testimonial"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:168;a:20:{s:4:"tmpl";i:1409;s:2:"id";i:23970;s:5:"title";s:45:"Ophthalmology Medical Clinic &#8211; Business";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg";s:12:"tmpl_created";i:1649711096;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:165:"["About","Business","Care","Consulting","Eye","Free Trial","Glasses","Health","Landing Pages","Lifestyle","Medical","Modern","Optometrist","Professional","Services"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:169;a:20:{s:4:"tmpl";i:1425;s:2:"id";i:24331;s:5:"title";s:24:"Wireframe &#8211; Home 1";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg";s:12:"tmpl_created";i:1653988363;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:102:"["Business","Contact","Features","Footer","Header","Homepage","Professional","Services","Testimonial"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:170;a:20:{s:4:"tmpl";i:1218;s:2:"id";i:20792;s:5:"title";s:26:"Luxury Car &#8211; Product";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg";s:12:"tmpl_created";i:1636903770;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"Product";s:4:"tags";s:54:"["car","Ecommerce","Landing Pages","Luxury","Product"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:171;a:20:{s:4:"tmpl";i:1428;s:2:"id";i:24398;s:5:"title";s:25:"Wireframe &#8211; About 1";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg";s:12:"tmpl_created";i:1653988534;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:83:"["About","Business","Contact","Features","Footer","Professional","Services","Team"]";s:10:"menu_order";i:2;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:172;a:20:{s:4:"tmpl";i:991;s:2:"id";i:13413;s:5:"title";s:33:"Classic | Contact | Online Course";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg";s:12:"tmpl_created";i:1587474761;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:2;s:16:"popularity_index";i:530;s:11:"trend_index";i:369;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:173;a:20:{s:4:"tmpl";i:1053;s:2:"id";i:15272;s:5:"title";s:32:"Classic | Contact | Psychologist";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png";s:12:"tmpl_created";i:1600170487;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:34:"["Psychologist","Psychotherapist"]";s:10:"menu_order";i:3;s:16:"popularity_index";i:578;s:11:"trend_index";i:312;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:174;a:20:{s:4:"tmpl";i:899;s:2:"id";i:11839;s:5:"title";s:9:"Portfolio";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png";s:12:"tmpl_created";i:1569430015;s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:43:"["creative portfolio","header","portfolio"]";s:10:"menu_order";i:3;s:16:"popularity_index";i:189;s:11:"trend_index";i:20;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:175;a:20:{s:4:"tmpl";i:1433;s:2:"id";i:24477;s:5:"title";s:27:"Wireframe &#8211; Gallery 2";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg";s:12:"tmpl_created";i:1653988835;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:82:"["Business","Contact","Design","Footer","Gallery","Header","Portfolio","Services"]";s:10:"menu_order";i:3;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:176;a:20:{s:4:"tmpl";i:1205;s:2:"id";i:20233;s:5:"title";s:32:"Art Magazine &#8211; Coming Soon";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg";s:12:"tmpl_created";i:1633881371;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:16:"Coming Soon Page";s:4:"tags";s:48:"["Art","Coming Soon","Landing Pages","Magazine"]";s:10:"menu_order";i:3;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:177;a:20:{s:4:"tmpl";i:1214;s:2:"id";i:20539;s:5:"title";s:31:"Design Blog &#8211; Coming Soon";s:9:"thumbnail";s:94:"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg";s:12:"tmpl_created";i:1634022706;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:16:"Coming Soon Page";s:4:"tags";s:47:"["Blog","Coming Soon","Design","Landing Pages"]";s:10:"menu_order";i:4;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:178;a:20:{s:4:"tmpl";i:1224;s:2:"id";i:21013;s:5:"title";s:24:"Restaurant &#8211; About";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg";s:12:"tmpl_created";i:1638795588;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:36:"["About","Chef","Food","Restaurant"]";s:10:"menu_order";i:4;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:179;a:20:{s:4:"tmpl";i:992;s:2:"id";i:13402;s:5:"title";s:29:"Classic | CTA | Online Course";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg";s:12:"tmpl_created";i:1587474772;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:4;s:16:"popularity_index";i:619;s:11:"trend_index";i:582;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:180;a:20:{s:4:"tmpl";i:1206;s:2:"id";i:20254;s:5:"title";s:41:"Digital Marketing Agency &#8211; Business";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg";s:12:"tmpl_created";i:1633882427;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:65:"["Agency","Business","Digital Agency","Landing Pages","Services"]";s:10:"menu_order";i:5;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:181;a:20:{s:4:"tmpl";i:1235;s:2:"id";i:21281;s:5:"title";s:25:"Law Firm &#8211; Services";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg";s:12:"tmpl_created";i:1638819128;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/law-firm-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:56:"["Consulting","Law","Law Firm","Services","Testimonial"]";s:10:"menu_order";i:5;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:182;a:20:{s:4:"tmpl";i:1017;s:2:"id";i:14111;s:5:"title";s:36:"Classic | Japanese restaurant | Sale";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg";s:12:"tmpl_created";i:1592300400;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:5;s:16:"popularity_index";i:717;s:11:"trend_index";i:697;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:183;a:20:{s:4:"tmpl";i:1213;s:2:"id";i:20509;s:5:"title";s:40:"Dogs Adoption &#8211; Social Involvement";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg";s:12:"tmpl_created";i:1634022353;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Social Involvement";s:4:"tags";s:49:"["Adoption","Involvement","Landing Pages","Pets"]";s:10:"menu_order";i:6;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:184;a:20:{s:4:"tmpl";i:1233;s:2:"id";i:21205;s:5:"title";s:29:"Photographer &#8211; Projects";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg";s:12:"tmpl_created";i:1638818372;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/photographer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:43:"["Black and white","Photography","Project"]";s:10:"menu_order";i:6;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:185;a:20:{s:4:"tmpl";i:993;s:2:"id";i:13422;s:5:"title";s:30:"Classic | Menu | Online Course";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg";s:12:"tmpl_created";i:1587474782;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"classic";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:6;s:16:"popularity_index";i:516;s:11:"trend_index";i:432;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:186;a:20:{s:4:"tmpl";i:925;s:2:"id";i:12540;s:5:"title";s:33:"Classic | Menu | Travel and tours";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png";s:12:"tmpl_created";i:1575960267;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:7;s:16:"popularity_index";i:690;s:11:"trend_index";i:714;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:187;a:20:{s:4:"tmpl";i:1208;s:2:"id";i:20361;s:5:"title";s:51:"Exercise &#038; Fitness Equipment &#8211; eCommerce";s:9:"thumbnail";s:97:"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg";s:12:"tmpl_created";i:1633883766;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:50:"["Fitness","Health","Landing Pages","Online Shop"]";s:10:"menu_order";i:7;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:188;a:20:{s:4:"tmpl";i:1239;s:2:"id";i:21373;s:5:"title";s:28:"Photographer &#8211; Gallery";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg";s:12:"tmpl_created";i:1638821177;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/photographer-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:56:"["Gallery","Photography","Portfolio","Project","Travel"]";s:10:"menu_order";i:7;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:189;a:20:{s:4:"tmpl";i:1426;s:2:"id";i:24348;s:5:"title";s:24:"Wireframe &#8211; Home 2";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-2.jpg";s:12:"tmpl_created";i:1653988444;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/wireframe-home-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:102:"["Business","Contact","Features","Footer","Header","Homepage","Professional","Services","Testimonial"]";s:10:"menu_order";i:8;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:190;a:20:{s:4:"tmpl";i:958;s:2:"id";i:13129;s:5:"title";s:28:"Classic | Menu | Photography";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png";s:12:"tmpl_created";i:1582092645;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/classic-menu-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:8;s:16:"popularity_index";i:646;s:11:"trend_index";i:521;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:191;a:20:{s:4:"tmpl";i:1427;s:2:"id";i:24366;s:5:"title";s:24:"Wireframe &#8211; Home 3";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-3.jpg";s:12:"tmpl_created";i:1653988491;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/wireframe-home-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:102:"["Business","Contact","Features","Footer","Header","Homepage","Professional","Services","Testimonial"]";s:10:"menu_order";i:9;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:192;a:20:{s:4:"tmpl";i:1207;s:2:"id";i:20299;s:5:"title";s:51:"Interior Design Consultation &#8211; Online Service";s:9:"thumbnail";s:99:"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg";s:12:"tmpl_created";i:1633882989;s:6:"author";s:9:"Elementor";s:3:"url";s:145:"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:65:"["Consulting","Interior Design","Landing Pages","Online Service"]";s:10:"menu_order";i:9;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:193;a:20:{s:4:"tmpl";i:952;s:2:"id";i:12726;s:5:"title";s:52:"Classic | Newsletter | Subscribe | Magazine and Blog";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png";s:12:"tmpl_created";i:1579061019;s:6:"author";s:9:"Elementor";s:3:"url";s:152:"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:9;s:16:"popularity_index";i:357;s:11:"trend_index";i:281;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:194;a:20:{s:4:"tmpl";i:883;s:2:"id";i:11468;s:5:"title";s:20:"Classic | Sale | Gym";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png";s:12:"tmpl_created";i:1567393182;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/popups/classic-sale-gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:2:"[]";s:10:"menu_order";i:10;s:16:"popularity_index";i:696;s:11:"trend_index";i:740;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:195;a:20:{s:4:"tmpl";i:1216;s:2:"id";i:20623;s:5:"title";s:57:"Luxurious Camping Accommodation For Events &#8211; Events";s:9:"thumbnail";s:113:"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg";s:12:"tmpl_created";i:1634041681;s:6:"author";s:9:"Elementor";s:3:"url";s:151:"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"Events";s:4:"tags";s:43:"["Event","Events","Landing Pages","Travel"]";s:10:"menu_order";i:10;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:196;a:20:{s:4:"tmpl";i:1219;s:2:"id";i:20886;s:5:"title";s:28:"Online Training &#8211; Home";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg";s:12:"tmpl_created";i:1638784769;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/online-training-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:39:"["Fitness","Online","Sport","Training"]";s:10:"menu_order";i:10;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:197;a:20:{s:4:"tmpl";i:1065;s:2:"id";i:15570;s:5:"title";s:33:"Classic | Subscribe | Travel Blog";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg";s:12:"tmpl_created";i:1606215555;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:17:"["Blog","Travel"]";s:10:"menu_order";i:11;s:16:"popularity_index";i:709;s:11:"trend_index";i:459;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:198;a:20:{s:4:"tmpl";i:1431;s:2:"id";i:24437;s:5:"title";s:25:"Wireframe &#8211; About 4";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-4.jpg";s:12:"tmpl_created";i:1653988733;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/wireframe-about-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:74:"["About","Business","Contact","Features","Footer","Header","Professional"]";s:10:"menu_order";i:11;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:199;a:20:{s:4:"tmpl";i:1210;s:2:"id";i:20414;s:5:"title";s:45:"Online English Courses &#8211; Online Service";s:9:"thumbnail";s:93:"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg";s:12:"tmpl_created";i:1633884482;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:50:"["Course Online","Landing Pages","Online Service"]";s:10:"menu_order";i:11;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:200;a:20:{s:4:"tmpl";i:1132;s:2:"id";i:16553;s:5:"title";s:31:"Fly-In | Contact | Beauty Salon";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg";s:12:"tmpl_created";i:1608622602;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:23:"["Beauty Salon","Hair"]";s:10:"menu_order";i:12;s:16:"popularity_index";i:691;s:11:"trend_index";i:428;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:201;a:20:{s:4:"tmpl";i:1441;s:2:"id";i:24574;s:5:"title";s:27:"Wireframe &#8211; Contact 5";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-5.jpg";s:12:"tmpl_created";i:1653989135;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/wireframe-contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:88:"["Business","Contact","Footer","Form","Google Maps","Header","Professional","Subscribe"]";s:10:"menu_order";i:12;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:202;a:20:{s:4:"tmpl";i:1217;s:2:"id";i:20333;s:5:"title";s:40:"Plant Pots Online Shop &#8211; eCommerce";s:9:"thumbnail";s:93:"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg";s:12:"tmpl_created";i:1634042184;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:50:"["Ecommerce","Landing Pages","Online Shop","Shop"]";s:10:"menu_order";i:12;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:203;a:20:{s:4:"tmpl";i:1211;s:2:"id";i:20447;s:5:"title";s:33:"Shared Workspace &#8211; Business";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg";s:12:"tmpl_created";i:1633884934;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/shared-workspace-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:28:"["Business","Landing Pages"]";s:10:"menu_order";i:13;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:204;a:20:{s:4:"tmpl";i:1237;s:2:"id";i:21313;s:5:"title";s:34:"Spa &#038; Beauty &#8211; Services";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg";s:12:"tmpl_created";i:1638819709;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/spa-beauty-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:55:"["Beauty","Hair","Health","Services","Spa","Treatment"]";s:10:"menu_order";i:13;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:205;a:20:{s:4:"tmpl";i:1004;s:2:"id";i:13538;s:5:"title";s:32:"Fly-In | Newsletter | Barbershop";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg";s:12:"tmpl_created";i:1589893364;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:28:"["Barber Shop","Barbershop"]";s:10:"menu_order";i:13;s:16:"popularity_index";i:710;s:11:"trend_index";i:667;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:206;a:20:{s:4:"tmpl";i:924;s:2:"id";i:12550;s:5:"title";s:32:"Fly-in | Sale | Travel and Tours";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png";s:12:"tmpl_created";i:1575960263;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:14;s:16:"popularity_index";i:754;s:11:"trend_index";i:791;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:207;a:20:{s:4:"tmpl";i:1212;s:2:"id";i:20479;s:5:"title";s:49:"Teeth Straightening &#8211; Health &#038; Fitness";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg";s:12:"tmpl_created";i:1633886115;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Health and Fitness";s:4:"tags";s:46:"["Business","Dental","Health","Landing Pages"]";s:10:"menu_order";i:14;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:208;a:20:{s:4:"tmpl";i:1234;s:2:"id";i:21234;s:5:"title";s:34:"Insurance Company &#8211; Services";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg";s:12:"tmpl_created";i:1638818688;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/insurance-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:51:"["Faq","Form","Insurance","Services","Testimonial"]";s:10:"menu_order";i:14;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:209;a:20:{s:4:"tmpl";i:1035;s:2:"id";i:15062;s:5:"title";s:35:"Fly-In | Sign up | Flooring Company";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png";s:12:"tmpl_created";i:1597739629;s:6:"author";s:9:"Elementor";s:3:"url";s:137:"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:15;s:16:"popularity_index";i:625;s:11:"trend_index";i:309;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:210;a:20:{s:4:"tmpl";i:1209;s:2:"id";i:20394;s:5:"title";s:30:"Time Management &#8211; Events";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg";s:12:"tmpl_created";i:1633884077;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/lp/time-management-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"Events";s:4:"tags";s:17:"["Landing Pages"]";s:10:"menu_order";i:15;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:211;a:20:{s:4:"tmpl";i:1229;s:2:"id";i:21118;s:5:"title";s:28:"Contact &#8211; Plants Store";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg";s:12:"tmpl_created";i:1638802472;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/contact-plants-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:40:"["Contact","Info","Plant","Testimonial"]";s:10:"menu_order";i:15;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:212;a:20:{s:4:"tmpl";i:893;s:2:"id";i:11822;s:5:"title";s:30:"Full Screen | Menu | Portfolio";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png";s:12:"tmpl_created";i:1569429896;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:2:"[]";s:10:"menu_order";i:16;s:16:"popularity_index";i:654;s:11:"trend_index";i:626;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:213;a:20:{s:4:"tmpl";i:1203;s:2:"id";i:18591;s:5:"title";s:28:"Coffee Sale &#8211; Business";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png";s:12:"tmpl_created";i:1633877319;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/coffee-sale-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:33:"["Coffee","Landing Pages","Sale"]";s:10:"menu_order";i:16;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:214;a:20:{s:4:"tmpl";i:1231;s:2:"id";i:21184;s:5:"title";s:28:"Dental Care &#8211; Services";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg";s:12:"tmpl_created";i:1638807148;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/dental-care-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:45:"["Dental","Medical","Services","Testimonial"]";s:10:"menu_order";i:16;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:215;a:20:{s:4:"tmpl";i:1064;s:2:"id";i:15580;s:5:"title";s:31:"Fullscreen | Menu | Travel Blog";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg";s:12:"tmpl_created";i:1606215358;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:17:"["Blog","Travel"]";s:10:"menu_order";i:17;s:16:"popularity_index";i:673;s:11:"trend_index";i:348;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:216;a:20:{s:4:"tmpl";i:1133;s:2:"id";i:16645;s:5:"title";s:28:"Headphones &#8211; eCommerce";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png";s:12:"tmpl_created";i:1609944115;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/lp/commerce-headphones/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:39:"["Ecommerce","Landing Pages","Product"]";s:10:"menu_order";i:17;s:16:"popularity_index";i:633;s:11:"trend_index";i:87;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:217;a:20:{s:4:"tmpl";i:1442;s:2:"id";i:24584;s:5:"title";s:27:"Wireframe &#8211; Pricing 1";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Pricing-1.jpg";s:12:"tmpl_created";i:1653989152;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/wireframe-pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:146:"["Booking","Business","Clients","Contact","Faq","Features","Footer","Online Service","Pricing","Products","Professional","Services","Testimonial"]";s:10:"menu_order";i:17;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:218;a:20:{s:4:"tmpl";i:1138;s:2:"id";i:16762;s:5:"title";s:25:"Conference &#8211; Events";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png";s:12:"tmpl_created";i:1610455119;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/lp/conference-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:6:"Events";s:4:"tags";s:60:"["Conference","Convention","Event","Events","Landing Pages"]";s:10:"menu_order";i:18;s:16:"popularity_index";i:705;s:11:"trend_index";i:216;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:219;a:20:{s:4:"tmpl";i:1438;s:2:"id";i:24539;s:5:"title";s:27:"Wireframe &#8211; Contact 2";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-2.jpg";s:12:"tmpl_created";i:1653989019;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/wireframe-contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:69:"["Business","Contact","Footer","Google Maps","Header","Professional"]";s:10:"menu_order";i:18;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:220;a:20:{s:4:"tmpl";i:981;s:2:"id";i:13281;s:5:"title";s:37:"Hello Bar | Contact | Interior Design";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png";s:12:"tmpl_created";i:1586148801;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:19:"["Interior Design"]";s:10:"menu_order";i:18;s:16:"popularity_index";i:763;s:11:"trend_index";i:679;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:221;a:20:{s:4:"tmpl";i:1052;s:2:"id";i:15259;s:5:"title";s:31:"Hello Bar | Menu | Psychologist";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png";s:12:"tmpl_created";i:1600170209;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:34:"["Psychologist","Psychotherapist"]";s:10:"menu_order";i:19;s:16:"popularity_index";i:739;s:11:"trend_index";i:583;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:222;a:20:{s:4:"tmpl";i:1434;s:2:"id";i:24494;s:5:"title";s:28:"Wireframe &#8211; Services 1";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1.jpg";s:12:"tmpl_created";i:1653988874;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:53:"["Business","Faq","Footer","Professional","Services"]";s:10:"menu_order";i:19;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:223;a:20:{s:4:"tmpl";i:1194;s:2:"id";i:18701;s:5:"title";s:32:"Digital Course &#8211; eCommerce";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg";s:12:"tmpl_created";i:1618995134;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:57:"["Course Online","Ecommerce","Landing Pages","Marketing"]";s:10:"menu_order";i:19;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:224;a:20:{s:4:"tmpl";i:1192;s:2:"id";i:18612;s:5:"title";s:34:"Bag Product Sale &#8211; eCommerce";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg";s:12:"tmpl_created";i:1618395406;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:61:"["Bag","Ecommerce","Landing Pages","Product","Sale","Travel"]";s:10:"menu_order";i:20;s:16:"popularity_index";i:875;s:11:"trend_index";i:605;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:225;a:20:{s:4:"tmpl";i:1227;s:2:"id";i:21083;s:5:"title";s:26:"Conference &#8211; Contact";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2021/12/10-Contact-Conference.jpg";s:12:"tmpl_created";i:1638799208;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/conference-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:44:"["Conference","Contact","Form","Info","Map"]";s:10:"menu_order";i:20;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:226;a:20:{s:4:"tmpl";i:1193;s:2:"id";i:18644;s:5:"title";s:37:"Camera Product Sale &#8211; eCommerce";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg";s:12:"tmpl_created";i:1618396388;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:59:"["Camera","Ecommerce","Landing Pages","Photography","Sale"]";s:10:"menu_order";i:21;s:16:"popularity_index";i:873;s:11:"trend_index";i:535;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:227;a:20:{s:4:"tmpl";i:951;s:2:"id";i:12736;s:5:"title";s:41:"Slide In | Contact Us | Magazine and Blog";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png";s:12:"tmpl_created";i:1579060978;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:21;s:16:"popularity_index";i:734;s:11:"trend_index";i:686;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:228;a:20:{s:4:"tmpl";i:1222;s:2:"id";i:20960;s:5:"title";s:26:"Travel Agency &#8211; Home";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2021/12/5-Home-Travel-Agency.jpg";s:12:"tmpl_created";i:1638788432;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/travel-agency-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:53:"["Adventures","Experience","Explore","Travel","Trip"]";s:10:"menu_order";i:21;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:229;a:20:{s:4:"tmpl";i:1196;s:2:"id";i:18815;s:5:"title";s:25:"Car Wash &#8211; Business";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png";s:12:"tmpl_created";i:1621336431;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/lp/car-wash-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:45:"["Business","car","Discount","Landing Pages"]";s:10:"menu_order";i:22;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:230;a:20:{s:4:"tmpl";i:1242;s:2:"id";i:21473;s:5:"title";s:40:"Architecture Photography &#8211; Gallery";s:9:"thumbnail";s:96:"https://library.elementor.com/wp-content/uploads/2021/12/20-Gallery-Architecture-Photography.jpg";s:12:"tmpl_created";i:1638822115;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/architecture-photography-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:52:"["Architecture","Gallery","Photography","Portfolio"]";s:10:"menu_order";i:22;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:231;a:20:{s:4:"tmpl";i:1015;s:2:"id";i:14067;s:5:"title";s:37:"Slide In | Japanese restaurant | Menu";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg";s:12:"tmpl_created";i:1592290352;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:22;s:16:"popularity_index";i:650;s:11:"trend_index";i:565;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:232;a:20:{s:4:"tmpl";i:923;s:2:"id";i:12229;s:5:"title";s:33:"Slide In | Law Firm | Information";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2019/11/popup.png";s:12:"tmpl_created";i:1572847842;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:23;s:16:"popularity_index";i:547;s:11:"trend_index";i:413;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:233;a:20:{s:4:"tmpl";i:1198;s:2:"id";i:18824;s:5:"title";s:33:"Design School &#8211; Coming Soon";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png";s:12:"tmpl_created";i:1621336756;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:16:"Coming Soon Page";s:4:"tags";s:49:"["Coming Soon","Design","Landing Pages","School"]";s:10:"menu_order";i:23;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:234;a:20:{s:4:"tmpl";i:1236;s:2:"id";i:21259;s:5:"title";s:28:"3D Designer &#8211; Projects";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/12/24-Projects-3D-Designer.jpg";s:12:"tmpl_created";i:1638819185;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/3d-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:69:"["3D","Creative Portfolio","Design","Designer","Portfolio","Project"]";s:10:"menu_order";i:23;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:235;a:20:{s:4:"tmpl";i:1028;s:2:"id";i:14827;s:5:"title";s:39:"Slide-In | Contact | Luxury Real Estate";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png";s:12:"tmpl_created";i:1595323523;s:6:"author";s:9:"Elementor";s:3:"url";s:141:"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:28:"["Real estate","Realestate"]";s:10:"menu_order";i:24;s:16:"popularity_index";i:559;s:11:"trend_index";i:284;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:236;a:20:{s:4:"tmpl";i:1197;s:2:"id";i:18819;s:5:"title";s:27:"Dog Walker &#8211; Business";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png";s:12:"tmpl_created";i:1621336601;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/lp/dog-walker-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:41:"["Business","Dog","Landing Pages","Pets"]";s:10:"menu_order";i:24;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:237;a:20:{s:4:"tmpl";i:1238;s:2:"id";i:21349;s:5:"title";s:29:"Architecture &#8211; Projects";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2021/12/23-Projects-Architecture.jpg";s:12:"tmpl_created";i:1638820870;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/architecture-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:70:"["Architecture","Creative","Creative Portfolio","Portfolio","Project"]";s:10:"menu_order";i:24;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:238;a:20:{s:4:"tmpl";i:1034;s:2:"id";i:15075;s:5:"title";s:34:"Slide-In | Menu | Flooring Company";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png";s:12:"tmpl_created";i:1597739605;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:25;s:16:"popularity_index";i:383;s:11:"trend_index";i:162;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:239;a:20:{s:4:"tmpl";i:1414;s:2:"id";i:24079;s:5:"title";s:32:"Fashion Shop &#8211; Coming Soon";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Fashion-Shop.jpg";s:12:"tmpl_created";i:1650988089;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/fashion-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:88:"["Aesthetic","Business","Coming Soon","Ecommerce","Girly","Lifestyle","Products","Shop"]";s:10:"menu_order";i:25;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:240;a:20:{s:4:"tmpl";i:1195;s:2:"id";i:18761;s:5:"title";s:33:"Fashion Store &#8211; Coming Soon";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png";s:12:"tmpl_created";i:1621336146;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:16:"Coming Soon Page";s:4:"tags";s:56:"["Coming Soon","Fashion","Landing Pages","Shop","store"]";s:10:"menu_order";i:25;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:241;a:20:{s:4:"tmpl";i:1153;s:2:"id";i:17060;s:5:"title";s:36:"Private Tutor &#8211; Online Service";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png";s:12:"tmpl_created";i:1610631042;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:64:"["Education","Landing Pages","Online Service","Teacher","Tutor"]";s:10:"menu_order";i:26;s:16:"popularity_index";i:780;s:11:"trend_index";i:628;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:242;a:20:{s:4:"tmpl";i:1430;s:2:"id";i:24434;s:5:"title";s:25:"Wireframe &#8211; About 3";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-3.jpg";s:12:"tmpl_created";i:1653988697;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/wireframe-about-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:76:"["About","Business","Contact","Faq","Footer","Header","Professional","Team"]";s:10:"menu_order";i:26;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:243;a:20:{s:4:"tmpl";i:1158;s:2:"id";i:17232;s:5:"title";s:33:"Life Coach &#8211; Online Service";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png";s:12:"tmpl_created";i:1610902793;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/life-coach-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:38:"["Coach","Landing Pages","Life Coach"]";s:10:"menu_order";i:27;s:16:"popularity_index";i:787;s:11:"trend_index";i:751;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:244;a:20:{s:4:"tmpl";i:1436;s:2:"id";i:24515;s:5:"title";s:28:"Wireframe &#8211; Services 3";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3.jpg";s:12:"tmpl_created";i:1653988946;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:66:"["Business","Contact","Footer","Header","Professional","Services"]";s:10:"menu_order";i:27;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:245;a:20:{s:4:"tmpl";i:875;s:2:"id";i:11241;s:5:"title";s:36:"Classic | Digital Agency | Marketing";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg";s:12:"tmpl_created";i:1564643043;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:2:"[]";s:10:"menu_order";i:28;s:16:"popularity_index";i:362;s:11:"trend_index";i:315;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:246;a:20:{s:4:"tmpl";i:1146;s:2:"id";i:16932;s:5:"title";s:35:"Finance Consulting &#8211; Business";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png";s:12:"tmpl_created";i:1610532170;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/lp/finance-consulting-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:80:"["Advisor","Business","Consulting","Finance","Investment","Landing Pages","Tax"]";s:10:"menu_order";i:28;s:16:"popularity_index";i:790;s:11:"trend_index";i:630;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:247;a:20:{s:4:"tmpl";i:1429;s:2:"id";i:24421;s:5:"title";s:25:"Wireframe &#8211; About 2";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-2.jpg";s:12:"tmpl_created";i:1653988579;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/wireframe-about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:87:"["About","Business","Contact","Faq","Features","Footer","Header","Professional","Team"]";s:10:"menu_order";i:28;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:248;a:20:{s:4:"tmpl";i:674;s:2:"id";i:8505;s:5:"title";s:11:"404 page 01";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg";s:12:"tmpl_created";i:1526415501;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:28;s:16:"popularity_index";i:533;s:11:"trend_index";i:222;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:249;a:20:{s:4:"tmpl";i:1136;s:2:"id";i:16721;s:5:"title";s:35:"Dental &#8211; Health &amp; Fitness";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg";s:12:"tmpl_created";i:1610448567;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/lp/dental-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Health and Fitness";s:4:"tags";s:44:"["Dental","Doctor","Health","Landing Pages"]";s:10:"menu_order";i:29;s:16:"popularity_index";i:801;s:11:"trend_index";i:655;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:250;a:20:{s:4:"tmpl";i:1417;s:2:"id";i:24116;s:5:"title";s:32:"Tech Company &#8211; Coming Soon";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Tech-Company.jpg";s:12:"tmpl_created";i:1650989265;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/tech-company-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:87:"["Business","Coding","Coming Soon","Computer","Developer","IT","Services","Technology"]";s:10:"menu_order";i:29;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:251;a:20:{s:4:"tmpl";i:675;s:2:"id";i:8511;s:5:"title";s:11:"404 page 02";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg";s:12:"tmpl_created";i:1526415528;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:29;s:16:"popularity_index";i:347;s:11:"trend_index";i:155;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:252;a:20:{s:4:"tmpl";i:1161;s:2:"id";i:17269;s:5:"title";s:34:"Electronics Sale &#8211; eCommerce";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png";s:12:"tmpl_created";i:1610903298;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:29:"["Ecommerce","Landing Pages"]";s:10:"menu_order";i:30;s:16:"popularity_index";i:800;s:11:"trend_index";i:556;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:253;a:20:{s:4:"tmpl";i:1220;s:2:"id";i:20908;s:5:"title";s:42:"Packing &#038; Moving Company &#8211; Home";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2021/12/3-Home-Packing-Moving-Company.jpg";s:12:"tmpl_created";i:1638786127;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/packing-moving-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Movers","Moving","Storge"]";s:10:"menu_order";i:30;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:254;a:20:{s:4:"tmpl";i:1152;s:2:"id";i:17032;s:5:"title";s:42:"Donate Computer &#8211; Social Involvement";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png";s:12:"tmpl_created";i:1610630585;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:18:"Social Involvement";s:4:"tags";s:67:"["Computer","Donate","Donation","Kids","Landing Pages","Nonprofit"]";s:10:"menu_order";i:31;s:16:"popularity_index";i:718;s:11:"trend_index";i:278;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:255;a:20:{s:4:"tmpl";i:672;s:2:"id";i:8512;s:5:"title";s:11:"404 page 03";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg";s:12:"tmpl_created";i:1526415449;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:31;s:16:"popularity_index";i:450;s:11:"trend_index";i:375;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:256;a:20:{s:4:"tmpl";i:1245;s:2:"id";i:21546;s:5:"title";s:28:"Interior Design &#8211; Home";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2021/12/1-Home-Interior-Design-1.jpg";s:12:"tmpl_created";i:1639046269;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/interior-design-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:68:"["Design","Form","Furniture Design","Interior Design","Testimonial"]";s:10:"menu_order";i:31;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:257;a:20:{s:4:"tmpl";i:1135;s:2:"id";i:16684;s:5:"title";s:34:"SaaS HR Management &#8211; Product";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png";s:12:"tmpl_created";i:1609945486;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"Product";s:4:"tags";s:39:"["HR","Landing Pages","Product","SaaS"]";s:10:"menu_order";i:32;s:16:"popularity_index";i:708;s:11:"trend_index";i:292;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:258;a:20:{s:4:"tmpl";i:671;s:2:"id";i:8513;s:5:"title";s:11:"404 page 04";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg";s:12:"tmpl_created";i:1526415417;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:32;s:16:"popularity_index";i:420;s:11:"trend_index";i:176;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:259;a:20:{s:4:"tmpl";i:1249;s:2:"id";i:22137;s:5:"title";s:31:"Design Blog &#8211; Coming Soon";s:9:"thumbnail";s:94:"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg";s:12:"tmpl_created";i:1647177194;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:47:"["Blog","Coming Soon","Design","Landing Pages"]";s:10:"menu_order";i:32;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:260;a:20:{s:4:"tmpl";i:1134;s:2:"id";i:16660;s:5:"title";s:37:"Medical center &#8211; Online service";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png";s:12:"tmpl_created";i:1609945122;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/lp/medical-center-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:44:"["Landing Pages","Medical","Online Service"]";s:10:"menu_order";i:33;s:16:"popularity_index";i:750;s:11:"trend_index";i:332;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:261;a:20:{s:4:"tmpl";i:1226;s:2:"id";i:21069;s:5:"title";s:21:"Hotel &#8211; Contact";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2021/12/9-Contact-Hotel.jpg";s:12:"tmpl_created";i:1638798545;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/hotel-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:36:"["Contact","from","Info","Vacation"]";s:10:"menu_order";i:33;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:262;a:20:{s:4:"tmpl";i:1150;s:2:"id";i:17001;s:5:"title";s:36:"Parental Counseling &#8211; Business";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png";s:12:"tmpl_created";i:1610534999;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/lp/parental-counseling-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:99:"["Advisor","Business","Coach","Counseling","Landing Pages","Online Service","Parental","Parenting"]";s:10:"menu_order";i:34;s:16:"popularity_index";i:817;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:263;a:20:{s:4:"tmpl";i:1432;s:2:"id";i:24461;s:5:"title";s:27:"Wireframe &#8211; Gallery 1";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-1.jpg";s:12:"tmpl_created";i:1653988784;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/wireframe-gallery-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:82:"["Business","Contact","Design","Footer","Gallery","Header","Portfolio","Services"]";s:10:"menu_order";i:34;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:264;a:20:{s:4:"tmpl";i:676;s:2:"id";i:8514;s:5:"title";s:11:"404 Page 05";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg";s:12:"tmpl_created";i:1526415558;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:34;s:16:"popularity_index";i:419;s:11:"trend_index";i:220;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:265;a:20:{s:4:"tmpl";i:1137;s:2:"id";i:16742;s:5:"title";s:31:"Online Course &#8211; Education";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png";s:12:"tmpl_created";i:1610454122;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/lp/online-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Education";s:4:"tags";s:55:"["Academy","Course Online","Education","Landing Pages"]";s:10:"menu_order";i:35;s:16:"popularity_index";i:777;s:11:"trend_index";i:776;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:266;a:20:{s:4:"tmpl";i:668;s:2:"id";i:8523;s:5:"title";s:11:"404 page 06";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg";s:12:"tmpl_created";i:1526415291;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:35;s:16:"popularity_index";i:298;s:11:"trend_index";i:268;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:267;a:20:{s:4:"tmpl";i:1440;s:2:"id";i:24563;s:5:"title";s:27:"Wireframe &#8211; Contact 4";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-4.jpg";s:12:"tmpl_created";i:1653989095;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/wireframe-contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:84:"["Business","Contact","Footer","Form","Gallery","Header","Professional","Subscribe"]";s:10:"menu_order";i:35;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:268;a:20:{s:4:"tmpl";i:1162;s:2:"id";i:17284;s:5:"title";s:38:"Dietitian &#8211; Health &amp; Fitness";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png";s:12:"tmpl_created";i:1610903484;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Health and Fitness";s:4:"tags";s:39:"["Fitness","Health","landscape design"]";s:10:"menu_order";i:36;s:16:"popularity_index";i:814;s:11:"trend_index";i:800;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:269;a:20:{s:4:"tmpl";i:1439;s:2:"id";i:24553;s:5:"title";s:27:"Wireframe &#8211; Contact 3";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-3.jpg";s:12:"tmpl_created";i:1653989057;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/wireframe-contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:67:"["Business","Contact","Footer","Form","Professional","Testimonial"]";s:10:"menu_order";i:36;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:270;a:20:{s:4:"tmpl";i:1144;s:2:"id";i:16897;s:5:"title";s:30:"Personal Chef &#8211; Business";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png";s:12:"tmpl_created";i:1610466247;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/lp/personal-chef-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:53:"["Business","Chef","Food","Landing Pages","Services"]";s:10:"menu_order";i:37;s:16:"popularity_index";i:795;s:11:"trend_index";i:617;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:271;a:20:{s:4:"tmpl";i:1435;s:2:"id";i:24504;s:5:"title";s:28:"Wireframe &#8211; Services 2";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2.jpg";s:12:"tmpl_created";i:1653988910;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:80:"["Business","Contact","Footer","Header","Professional","Services","Testimonial"]";s:10:"menu_order";i:37;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:272;a:20:{s:4:"tmpl";i:669;s:2:"id";i:8524;s:5:"title";s:11:"404 page 07";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg";s:12:"tmpl_created";i:1526415337;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:37;s:16:"popularity_index";i:303;s:11:"trend_index";i:171;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:273;a:20:{s:4:"tmpl";i:1147;s:2:"id";i:16946;s:5:"title";s:52:"Online Full-Stack Developer Course &#8211; Education";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png";s:12:"tmpl_created";i:1610532778;s:6:"author";s:9:"Elementor";s:3:"url";s:146:"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Education";s:4:"tags";s:76:"["Academy","Coding","Course Online","Developer","Education","Landing Pages"]";s:10:"menu_order";i:38;s:16:"popularity_index";i:805;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:274;a:20:{s:4:"tmpl";i:1437;s:2:"id";i:24528;s:5:"title";s:27:"Wireframe &#8211; Contact 1";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-1.jpg";s:12:"tmpl_created";i:1653988981;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/wireframe-contact-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:76:"["Business","Contact","Footer","Form","Google Maps","Header","Professional"]";s:10:"menu_order";i:38;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:275;a:20:{s:4:"tmpl";i:1143;s:2:"id";i:16868;s:5:"title";s:40:"Virtual Assistant &#8211; Online Service";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png";s:12:"tmpl_created";i:1610465656;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:46:"["Assistant","Landing Pages","Online Service"]";s:10:"menu_order";i:39;s:16:"popularity_index";i:793;s:11:"trend_index";i:757;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:276;a:20:{s:4:"tmpl";i:673;s:2:"id";i:8526;s:5:"title";s:11:"404 page 09";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg";s:12:"tmpl_created";i:1526415474;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:39;s:16:"popularity_index";i:477;s:11:"trend_index";i:285;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:277;a:20:{s:4:"tmpl";i:1228;s:2:"id";i:21104;s:5:"title";s:26:"Restaurant &#8211; Contact";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2021/12/11-Contact-Restaurant.jpg";s:12:"tmpl_created";i:1638800146;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/restaurant-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:60:"["Contact","Food","Form","Google Maps","Info","Testimonial"]";s:10:"menu_order";i:39;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:278;a:20:{s:4:"tmpl";i:1140;s:2:"id";i:16812;s:5:"title";s:40:"Construction Project &#8211; Real Estate";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2021/01/Construction-Project.png";s:12:"tmpl_created";i:1610463582;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/lp/construction-project-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"Real Estate";s:4:"tags";s:59:"["Construction","Landing Pages","Real estate","Realestate"]";s:10:"menu_order";i:40;s:16:"popularity_index";i:796;s:11:"trend_index";i:724;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:279;a:20:{s:4:"tmpl";i:1244;s:2:"id";i:21393;s:5:"title";s:34:"Interior Designer &#8211; Projects";s:9:"thumbnail";s:99:"https://library.elementor.com/wp-content/uploads/2021/12/big-22-Projects-Interior-Designer-New.jpeg";s:12:"tmpl_created";i:1638823945;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/interior-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:93:"["Creative","Creative Portfolio","Design","Designer","Interior Design","Portfolio","Project"]";s:10:"menu_order";i:40;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:280;a:20:{s:4:"tmpl";i:1148;s:2:"id";i:16960;s:5:"title";s:44:"Dog &amp; Cat Food Delivery &#8211; Business";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2021/01/Dog-Food.png";s:12:"tmpl_created";i:1610533581;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/lp/dog-cat-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"Business";s:4:"tags";s:71:"["Business","Cat","Delivery","Dog","Food","Landing Pages","Pet","Pets"]";s:10:"menu_order";i:41;s:16:"popularity_index";i:782;s:11:"trend_index";i:510;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:281;a:20:{s:4:"tmpl";i:670;s:2:"id";i:8525;s:5:"title";s:11:"404 page 08";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg";s:12:"tmpl_created";i:1526415374;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:41;s:16:"popularity_index";i:510;s:11:"trend_index";i:575;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:282;a:20:{s:4:"tmpl";i:1251;s:2:"id";i:22143;s:5:"title";s:33:"Fashion Store &#8211; Coming Soon";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png";s:12:"tmpl_created";i:1647177389;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:56:"["Coming Soon","Fashion","Landing Pages","Shop","store"]";s:10:"menu_order";i:41;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:283;a:20:{s:4:"tmpl";i:1155;s:2:"id";i:17095;s:5:"title";s:36:"Mobile Pet Grooming &#8211; Business";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2021/01/Mobile-Pet-Grooming.png";s:12:"tmpl_created";i:1610632115;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/lp/mobile-pet-grooming-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"Business";s:4:"tags";s:38:"["Dog","Groom","Landing Pages","Pets"]";s:10:"menu_order";i:42;s:16:"popularity_index";i:786;s:11:"trend_index";i:731;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:284;a:20:{s:4:"tmpl";i:1241;s:2:"id";i:21451;s:5:"title";s:26:"Exhibition &#8211; Gallery";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2021/12/21-Gallery-Exhibition.jpg";s:12:"tmpl_created";i:1638821855;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/exhibition-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:74:"["Art","Creative","Creative Portfolio","Exhibition","Gallery","Portfolio"]";s:10:"menu_order";i:42;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:285;a:20:{s:4:"tmpl";i:502;s:2:"id";i:5438;s:5:"title";s:7:"About 1";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png";s:12:"tmpl_created";i:1520443512;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:42;s:16:"popularity_index";i:147;s:11:"trend_index";i:9;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:286;a:20:{s:4:"tmpl";i:1159;s:2:"id";i:17245;s:5:"title";s:34:"Marketing Course &#8211; Education";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2021/01/PPC.png";s:12:"tmpl_created";i:1610902958;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/lp/marketing-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"Education";s:4:"tags";s:45:"["Course Online","Landing Pages","Marketing"]";s:10:"menu_order";i:43;s:16:"popularity_index";i:770;s:11:"trend_index";i:430;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:287;a:20:{s:4:"tmpl";i:1240;s:2:"id";i:21430;s:5:"title";s:30:"Travel Blogger &#8211; Gallery";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2021/12/19-Gallery-Travel-Blogger.jpg";s:12:"tmpl_created";i:1638821592;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/travel-blogger-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:43:"["Gallery","Photography","Slider","Travel"]";s:10:"menu_order";i:43;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:288;a:20:{s:4:"tmpl";i:1149;s:2:"id";i:16983;s:5:"title";s:41:"Pilates Instructor &#8211; Online Service";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2021/01/Pilates-Instructor.png";s:12:"tmpl_created";i:1610534138;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/lp/pilates-instructor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:70:"["Free Trial","Instructor","Landing Pages","Online Service","Pilates"]";s:10:"menu_order";i:44;s:16:"popularity_index";i:778;s:11:"trend_index";i:412;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:289;a:20:{s:4:"tmpl";i:1416;s:2:"id";i:24104;s:5:"title";s:33:"Ceramics Shop &#8211; Coming Soon";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Ceramics-Shop.jpg";s:12:"tmpl_created";i:1650988949;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/ceramics-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:115:"["Art","Business","Coming Soon","Creative","Decor","Design","Furniture Design","Interior Design","Products","Shop"]";s:10:"menu_order";i:44;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:290;a:20:{s:4:"tmpl";i:557;s:2:"id";i:6135;s:5:"title";s:8:"About 10";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png";s:12:"tmpl_created";i:1520443663;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:45;s:16:"popularity_index";i:77;s:11:"trend_index";i:47;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:291;a:20:{s:4:"tmpl";i:1412;s:2:"id";i:24033;s:5:"title";s:37:"Dance Studio &#8211; Maintenance Mode";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Dance-Studio.jpg";s:12:"tmpl_created";i:1649881344;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/dance-studio-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:113:"["Academy","Business","Dance Studio","Form","Pilates","School","Sport","Teacher","Training","Under Construction"]";s:10:"menu_order";i:45;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:292;a:20:{s:4:"tmpl";i:1190;s:2:"id";i:18568;s:5:"title";s:32:"Flower Delivery &#8211; Business";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2021/04/Flower-Delivery.png";s:12:"tmpl_created";i:1617546716;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/lp/flower-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:37:"["Delivery","Flower","Landing Pages"]";s:10:"menu_order";i:45;s:16:"popularity_index";i:874;s:11:"trend_index";i:763;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:293;a:20:{s:4:"tmpl";i:1145;s:2:"id";i:16917;s:5:"title";s:22:"Webinar &#8211; Events";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2021/01/Webinar-Library-Pic.jpg";s:12:"tmpl_created";i:1610466822;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/lp/webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"Events";s:4:"tags";s:36:"["Events","Landing Pages","Webinar"]";s:10:"menu_order";i:46;s:16:"popularity_index";i:821;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:294;a:20:{s:4:"tmpl";i:1413;s:2:"id";i:24049;s:5:"title";s:33:"ECO Shop &#8211; Maintenance Mode";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-ECO-Shop.jpg";s:12:"tmpl_created";i:1649882053;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/eco-shop-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:110:"["Aesthetic","Business","Creative","Decor","Health","Help","Lifestyle","Products","Shop","Under Construction"]";s:10:"menu_order";i:46;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:295;a:20:{s:4:"tmpl";i:497;s:2:"id";i:5397;s:5:"title";s:8:"About 11";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png";s:12:"tmpl_created";i:1520443503;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:46;s:16:"popularity_index";i:148;s:11:"trend_index";i:43;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:296;a:20:{s:4:"tmpl";i:1154;s:2:"id";i:17079;s:5:"title";s:42:"Calls Volunteer &#8211; Social Involvement";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2021/01/Calls-Volunteer.png";s:12:"tmpl_created";i:1610631774;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/lp/calls-volunteer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Social Involvement";s:4:"tags";s:68:"["Care","Covid-19","Help","Involvement","Landing Pages","Volunteer"]";s:10:"menu_order";i:47;s:16:"popularity_index";i:854;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:297;a:20:{s:4:"tmpl";i:1419;s:2:"id";i:24136;s:5:"title";s:29:"Food Blog &#8211; Coming Soon";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Food-Blog.jpg";s:12:"tmpl_created";i:1650990034;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:62:"["Blog","Business","Coming Soon","Cooking","Education","Food"]";s:10:"menu_order";i:47;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:298;a:20:{s:4:"tmpl";i:1142;s:2:"id";i:16836;s:5:"title";s:33:"Marketing Agency &#8211; Business";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2021/01/Marketing-Agency-Library-Pic.jpg";s:12:"tmpl_created";i:1610464490;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:74:"["Agency","Business","Landing Pages","Marketing","Marketing Landing Page"]";s:10:"menu_order";i:48;s:16:"popularity_index";i:816;s:11:"trend_index";i:787;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:299;a:20:{s:4:"tmpl";i:1411;s:2:"id";i:24020;s:5:"title";s:35:"Mobile App &#8211; Maintenance Mode";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Mobile-App.jpg";s:12:"tmpl_created";i:1649880955;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/mobile-app-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:77:"["App","Business","Coding","Computer","Launch","Mobile","Under Construction"]";s:10:"menu_order";i:48;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:300;a:20:{s:4:"tmpl";i:498;s:2:"id";i:5405;s:5:"title";s:8:"About 12";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png";s:12:"tmpl_created";i:1520443505;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:48;s:16:"popularity_index";i:216;s:11:"trend_index";i:50;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:301;a:20:{s:4:"tmpl";i:1139;s:2:"id";i:16785;s:5:"title";s:42:"Gym Promotion &#8211; Health &amp; Fitness";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2021/01/Gym-LP.jpg";s:12:"tmpl_created";i:1610455496;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/lp/gym-promotion-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Health and Fitness";s:4:"tags";s:42:"["Fitness","Gym","Health","Landing Pages"]";s:10:"menu_order";i:49;s:16:"popularity_index";i:820;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:302;a:20:{s:4:"tmpl";i:1420;s:2:"id";i:24152;s:5:"title";s:32:"Perfume Shop &#8211; Coming Soon";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Perfume-Shop.jpg";s:12:"tmpl_created";i:1650990353;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/perfume-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:68:"["Business","Coming Soon","Cosmetics","Lifestyle","Products","Shop"]";s:10:"menu_order";i:49;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:303;a:20:{s:4:"tmpl";i:1185;s:2:"id";i:18492;s:5:"title";s:34:"Bicycle Pre-Sale &#8211; eCommerce";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bike-Landing-Page.png";s:12:"tmpl_created";i:1617535552;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/lp/bicycle-pre-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:34:"["Bicycle","Landing Pages","Sale"]";s:10:"menu_order";i:50;s:16:"popularity_index";i:871;s:11:"trend_index";i:826;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:304;a:20:{s:4:"tmpl";i:1418;s:2:"id";i:24126;s:5:"title";s:28:"Skincare &#8211; Coming Soon";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Skincare.jpg";s:12:"tmpl_created";i:1650989585;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/skincare-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:128:"["Aesthetic","Beauty","Beauty Salon","Business","Coming Soon","Cosmetics","Girly","Lifestyle","Services","Skincare","Treatment"]";s:10:"menu_order";i:51;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:305;a:20:{s:4:"tmpl";i:1181;s:2:"id";i:18349;s:5:"title";s:39:"Virtual try-on glasses &#8211; Business";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/03/250x280-8.png";s:12:"tmpl_created";i:1614772569;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/lp/virtual-try-on-glasses-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:64:"["Fashion","Glasses","Landing Pages","Online Service","Virtual"]";s:10:"menu_order";i:51;s:16:"popularity_index";i:848;s:11:"trend_index";i:803;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:306;a:20:{s:4:"tmpl";i:500;s:2:"id";i:5421;s:5:"title";s:8:"About 13";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png";s:12:"tmpl_created";i:1520443509;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:51;s:16:"popularity_index";i:215;s:11:"trend_index";i:77;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:307;a:20:{s:4:"tmpl";i:513;s:2:"id";i:5533;s:5:"title";s:8:"About 15";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png";s:12:"tmpl_created";i:1520443534;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:52;s:16:"popularity_index";i:21;s:11:"trend_index";i:57;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:308;a:20:{s:4:"tmpl";i:1410;s:2:"id";i:24004;s:5:"title";s:33:"Skincare &#8211; Maintenance Mode";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Skincare.jpg";s:12:"tmpl_created";i:1649880534;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/skincare-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:144:"["Aesthetic","Beauty","Beauty Salon","Business","Cosmetics","Girly","Lifestyle","Makeup","Services","Skincare","Treatment","Under Construction"]";s:10:"menu_order";i:52;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:309;a:20:{s:4:"tmpl";i:1172;s:2:"id";i:17458;s:5:"title";s:31:"Moving Company &#8211; Business";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Moving-Company.png";s:12:"tmpl_created";i:1612727025;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/lp/moving-company-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:46:"["Business","Landing Pages","Movers","Moving"]";s:10:"menu_order";i:52;s:16:"popularity_index";i:826;s:11:"trend_index";i:767;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:310;a:20:{s:4:"tmpl";i:1415;s:2:"id";i:24092;s:5:"title";s:29:"Vase Shop &#8211; Coming Soon";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Vase-Shop.jpg";s:12:"tmpl_created";i:1650988613;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/vase-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:115:"["Art","Business","Coming Soon","Creative","Decor","Design","Furniture Design","Interior Design","Products","Shop"]";s:10:"menu_order";i:53;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:311;a:20:{s:4:"tmpl";i:1186;s:2:"id";i:18517;s:5:"title";s:29:"Food Blog &#8211; Coming Soon";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Food-Blog.png";s:12:"tmpl_created";i:1617539897;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/lp/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:16:"Coming Soon Page";s:4:"tags";s:45:"["Blog","Coming Soon","Food","Landing Pages"]";s:10:"menu_order";i:53;s:16:"popularity_index";i:844;s:11:"trend_index";i:672;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:312;a:20:{s:4:"tmpl";i:1167;s:2:"id";i:17379;s:5:"title";s:33:"IT Service &#8211; Online Service";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-IT-Service.png";s:12:"tmpl_created";i:1612713022;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/it-service-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:41:"["IT","Landing Pages","Remote","Support"]";s:10:"menu_order";i:54;s:16:"popularity_index";i:806;s:11:"trend_index";i:634;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:313;a:20:{s:4:"tmpl";i:1248;s:2:"id";i:22134;s:5:"title";s:32:"Art Magazine &#8211; Coming Soon";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg";s:12:"tmpl_created";i:1647176713;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:48:"["Art","Coming Soon","Landing Pages","Magazine"]";s:10:"menu_order";i:54;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:314;a:20:{s:4:"tmpl";i:512;s:2:"id";i:5525;s:5:"title";s:8:"About 14";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png";s:12:"tmpl_created";i:1520443532;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:55;s:16:"popularity_index";i:9;s:11:"trend_index";i:29;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:315;a:20:{s:4:"tmpl";i:1189;s:2:"id";i:18560;s:5:"title";s:52:"Finance Learning Platform &#8211; Under Construction";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png";s:12:"tmpl_created";i:1617542761;s:6:"author";s:9:"Elementor";s:3:"url";s:146:"https://library.elementor.com/lp/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Under Construction";s:4:"tags";s:27:"["Finance","Landing Pages"]";s:10:"menu_order";i:55;s:16:"popularity_index";i:843;s:11:"trend_index";i:561;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:316;a:20:{s:4:"tmpl";i:1225;s:2:"id";i:21041;s:5:"title";s:41:"Business Consulting Company &#8211; About";s:9:"thumbnail";s:96:"https://library.elementor.com/wp-content/uploads/2021/12/8-About-Business-Consulting-Company.jpg";s:12:"tmpl_created";i:1638797560;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/business-consulting-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:51:"["Coach","Collaboration","Consulting","Life Coach"]";s:10:"menu_order";i:55;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:317;a:20:{s:4:"tmpl";i:1187;s:2:"id";i:18528;s:5:"title";s:36:"Home Decor Store &#8211; Coming Soon";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png";s:12:"tmpl_created";i:1617541784;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/lp/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:16:"Coming Soon Page";s:4:"tags";s:57:"["Coming Soon","Decor","Interior Design","Landing Pages"]";s:10:"menu_order";i:56;s:16:"popularity_index";i:872;s:11:"trend_index";i:819;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:318;a:20:{s:4:"tmpl";i:1243;s:2:"id";i:21135;s:5:"title";s:28:"Construction &#8211; Service";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/12/13-Service-Construction.jpg";s:12:"tmpl_created";i:1638823202;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/construction-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:48:"["Architecture","Construction","Faq","Services"]";s:10:"menu_order";i:56;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:319;a:20:{s:4:"tmpl";i:501;s:2:"id";i:5429;s:5:"title";s:8:"About 16";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png";s:12:"tmpl_created";i:1520443510;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:56;s:16:"popularity_index";i:59;s:11:"trend_index";i:8;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:320;a:20:{s:4:"tmpl";i:1174;s:2:"id";i:17504;s:5:"title";s:29:"Hair Stylist &#8211; Business";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/02/250x280-3.png";s:12:"tmpl_created";i:1612883014;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/lp/hair-stylist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:59:"["Business","Hair","hairdresser","Landing Pages","Stylist"]";s:10:"menu_order";i:57;s:16:"popularity_index";i:840;s:11:"trend_index";i:806;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:321;a:20:{s:4:"tmpl";i:1223;s:2:"id";i:20981;s:5:"title";s:37:"Creative Digital Agency &#8211; About";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2021/12/6-About-Creative-Digital-Agency.jpg";s:12:"tmpl_created";i:1638789303;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/creative-digital-agency-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:51:"["About","Advisor","Creative","Creative Portfolio"]";s:10:"menu_order";i:57;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:322;a:20:{s:4:"tmpl";i:1184;s:2:"id";i:18449;s:5:"title";s:45:"Aesthetic Clinic &#8211; Health &amp; Fitness";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2021/03/Aesthetic-Clinic.png";s:12:"tmpl_created";i:1616682181;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/lp/aesthetic-clinic-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Health and Fitness";s:4:"tags";s:57:"["Aesthetic","Beauty","Fitness","Health","Landing Pages"]";s:10:"menu_order";i:58;s:16:"popularity_index";i:859;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:323;a:20:{s:4:"tmpl";i:1221;s:2:"id";i:20926;s:5:"title";s:33:"Doctors Online Consultation -Home";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2021/12/4-Home-Doctors-Online-Consultation.jpg";s:12:"tmpl_created";i:1638787371;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/doctors-online-consultation-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:35:"["App","Health","Medical","Online"]";s:10:"menu_order";i:58;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:324;a:20:{s:4:"tmpl";i:505;s:2:"id";i:5464;s:5:"title";s:8:"About 17";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png";s:12:"tmpl_created";i:1520443518;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:58;s:16:"popularity_index";i:220;s:11:"trend_index";i:142;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:325;a:20:{s:4:"tmpl";i:1165;s:2:"id";i:17353;s:5:"title";s:44:"Online Cooking Course &#8211; Online Service";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/02/250x280-2.png";s:12:"tmpl_created";i:1612705144;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/lp/online-cooking-course-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:50:"["Cooking","Course Online","Food","Landing Pages"]";s:10:"menu_order";i:59;s:16:"popularity_index";i:845;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:326;a:20:{s:4:"tmpl";i:1188;s:2:"id";i:18550;s:5:"title";s:39:"Online Store &#8211; Under Construction";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png";s:12:"tmpl_created";i:1617542506;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/lp/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:18:"Under Construction";s:4:"tags";s:59:"["Landing Pages","Online Shop","Shop","Under Construction"]";s:10:"menu_order";i:60;s:16:"popularity_index";i:832;s:11:"trend_index";i:600;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:327;a:20:{s:4:"tmpl";i:1250;s:2:"id";i:22140;s:5:"title";s:33:"Design School &#8211; Coming Soon";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png";s:12:"tmpl_created";i:1647177317;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:49:"["Coming Soon","Design","Landing Pages","School"]";s:10:"menu_order";i:60;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:328;a:20:{s:4:"tmpl";i:510;s:2:"id";i:5504;s:5:"title";s:8:"About 18";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png";s:12:"tmpl_created";i:1520443528;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:60;s:16:"popularity_index";i:104;s:11:"trend_index";i:46;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:329;a:20:{s:4:"tmpl";i:1191;s:2:"id";i:18539;s:5:"title";s:40:"Travel Agency &#8211; Under Construction";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png";s:12:"tmpl_created";i:1617610273;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/lp/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Under Construction";s:4:"tags";s:56:"["Agency","Landing Pages","Travel","Under Construction"]";s:10:"menu_order";i:61;s:16:"popularity_index";i:876;s:11:"trend_index";i:652;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:330;a:20:{s:4:"tmpl";i:1175;s:2:"id";i:18270;s:5:"title";s:24:"Open week &#8211; Events";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2021/03/250x280.png";s:12:"tmpl_created";i:1614767186;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/lp/open-week-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"Events";s:4:"tags";s:59:"["Education","Event","Events","Landing Pages","University"]";s:10:"menu_order";i:62;s:16:"popularity_index";i:831;s:11:"trend_index";i:673;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:331;a:20:{s:4:"tmpl";i:1177;s:2:"id";i:18300;s:5:"title";s:30:"Makeup Artist &#8211; Business";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/03/250x280-2.png";s:12:"tmpl_created";i:1614768608;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/lp/makeup-artist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:79:"["Beauty","Business","Course Online","Landing Pages","Makeup","Online Service"]";s:10:"menu_order";i:63;s:16:"popularity_index";i:861;s:11:"trend_index";i:783;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:332;a:20:{s:4:"tmpl";i:511;s:2:"id";i:5515;s:5:"title";s:8:"About 19";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png";s:12:"tmpl_created";i:1520443530;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:63;s:16:"popularity_index";i:268;s:11:"trend_index";i:161;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:333;a:20:{s:4:"tmpl";i:1179;s:2:"id";i:18329;s:5:"title";s:63:"Online Real Estate Investment Conference &#8211; Online Service";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/03/250x280-5.png";s:12:"tmpl_created";i:1614770404;s:6:"author";s:9:"Elementor";s:3:"url";s:157:"https://library.elementor.com/lp/online-real-estate-investment-conference-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:76:"["Conference","Event","Events","Landing Pages","Online Event","Real estate"]";s:10:"menu_order";i:64;s:16:"popularity_index";i:866;s:11:"trend_index";i:779;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:334;a:20:{s:4:"tmpl";i:506;s:2:"id";i:5472;s:5:"title";s:7:"About 2";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_7.png";s:12:"tmpl_created";i:1520443520;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:64;s:16:"popularity_index";i:210;s:11:"trend_index";i:116;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:335;a:20:{s:4:"tmpl";i:1183;s:2:"id";i:18391;s:5:"title";s:45:"Children&#8217;s Optometrist &#8211; Business";s:9:"thumbnail";s:94:"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Childrens-Optometrist.png";s:12:"tmpl_created";i:1614773564;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/lp/childrens-optometrist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:85:"["Business","Children","Eye","Glasses","Health","Kids","Landing Pages","Optometrist"]";s:10:"menu_order";i:65;s:16:"popularity_index";i:877;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:336;a:20:{s:4:"tmpl";i:1182;s:2:"id";i:18366;s:5:"title";s:30:"Car Insurance &#8211; Business";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Car-Insurance.png";s:12:"tmpl_created";i:1614773263;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/lp/car-insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:46:"["Business","car","Insurance","Landing Pages"]";s:10:"menu_order";i:66;s:16:"popularity_index";i:869;s:11:"trend_index";i:797;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:337;a:20:{s:4:"tmpl";i:1201;s:2:"id";i:19144;s:5:"title";s:25:"Birthday Party Invitation";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2021/06/250x280.png";s:12:"tmpl_created";i:1623848691;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/birthday-party-invitation/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:67:"["Birthday","Event","Landing Pages","Party","RSVD","Save the Date"]";s:10:"menu_order";i:66;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:338;a:20:{s:4:"tmpl";i:1124;s:2:"id";i:16473;s:5:"title";s:26:"Beauty Salon &#8211; About";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/12/about-1.jpg";s:12:"tmpl_created";i:1608622373;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/beauty-salon-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:23:"["Beauty Salon","Hair"]";s:10:"menu_order";i:67;s:16:"popularity_index";i:615;s:11:"trend_index";i:184;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:339;a:20:{s:4:"tmpl";i:1176;s:2:"id";i:18291;s:5:"title";s:47:"Grill Restaurant Food Delivery &#8211; Business";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Food-Delivery-LP.png";s:12:"tmpl_created";i:1614767830;s:6:"author";s:9:"Elementor";s:3:"url";s:141:"https://library.elementor.com/lp/grill-restaurant-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"Business";s:4:"tags";s:79:"["Delivery","Delivery Service","Fast Food","Food","Landing Pages","Restaurant"]";s:10:"menu_order";i:67;s:16:"popularity_index";i:819;s:11:"trend_index";i:685;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:340;a:20:{s:4:"tmpl";i:504;s:2:"id";i:5455;s:5:"title";s:8:"About 20";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_6.png";s:12:"tmpl_created";i:1520443516;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:67;s:16:"popularity_index";i:134;s:11:"trend_index";i:70;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:341;a:20:{s:4:"tmpl";i:1125;s:2:"id";i:16488;s:5:"title";s:28:"Beauty Salon &#8211; Contact";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/12/contact.jpg";s:12:"tmpl_created";i:1608622374;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/beauty-salon-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:23:"["Beauty Salon","Hair"]";s:10:"menu_order";i:68;s:16:"popularity_index";i:548;s:11:"trend_index";i:101;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:342;a:20:{s:4:"tmpl";i:1180;s:2:"id";i:18340;s:5:"title";s:30:"Restaurant &#8211; Coming Soon";s:9:"thumbnail";s:98:"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Restuarant-Coming-Soon-LP.png";s:12:"tmpl_created";i:1614772183;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/lp/restaurant-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:16:"Coming Soon Page";s:4:"tags";s:51:"["Coming Soon","Food","Landing Pages","Restaurant"]";s:10:"menu_order";i:68;s:16:"popularity_index";i:810;s:11:"trend_index";i:809;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:343;a:20:{s:4:"tmpl";i:499;s:2:"id";i:5413;s:5:"title";s:8:"About 21";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2.png";s:12:"tmpl_created";i:1520443507;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:68;s:16:"popularity_index";i:83;s:11:"trend_index";i:52;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:344;a:20:{s:4:"tmpl";i:1126;s:2:"id";i:16496;s:5:"title";s:28:"Beauty Salon &#8211; Gallery";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/12/gallery-1.jpg";s:12:"tmpl_created";i:1608622379;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/beauty-salon-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:23:"["Beauty Salon","Hair"]";s:10:"menu_order";i:69;s:16:"popularity_index";i:491;s:11:"trend_index";i:90;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:345;a:20:{s:4:"tmpl";i:1173;s:2:"id";i:17480;s:5:"title";s:42:"At-home Massage Therapist &#8211; Business";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2021/02/At-Home-Massage-Therapist.jpg";s:12:"tmpl_created";i:1612879264;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/lp/at-home-massage-therapist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:60:"["Business","Health","Landing Pages","Services","Therapist"]";s:10:"menu_order";i:69;s:16:"popularity_index";i:856;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:346;a:20:{s:4:"tmpl";i:1127;s:2:"id";i:16457;s:5:"title";s:25:"Beauty Salon &#8211; Home";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/12/home-1.jpg";s:12:"tmpl_created";i:1608622383;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/beauty-salon-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:23:"["Beauty Salon","Hair"]";s:10:"menu_order";i:70;s:16:"popularity_index";i:408;s:11:"trend_index";i:56;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:347;a:20:{s:4:"tmpl";i:1178;s:2:"id";i:18317;s:5:"title";s:26:"Insurance &#8211; Business";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Life-Insirance.png";s:12:"tmpl_created";i:1614769488;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/lp/insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:61:"["Business","Family","Financial","Insurance","Landing Pages"]";s:10:"menu_order";i:70;s:16:"popularity_index";i:870;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:348;a:20:{s:4:"tmpl";i:1128;s:2:"id";i:16518;s:5:"title";s:29:"Beauty Salon &#8211; Services";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/12/services-1.jpg";s:12:"tmpl_created";i:1608622386;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/beauty-salon-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:23:"["Beauty Salon","Hair"]";s:10:"menu_order";i:71;s:16:"popularity_index";i:664;s:11:"trend_index";i:261;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:349;a:20:{s:4:"tmpl";i:1168;s:2:"id";i:17401;s:5:"title";s:40:"Conference Thank You Page &#8211; Events";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2021/02/250x280.png";s:12:"tmpl_created";i:1612724753;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/lp/conference-thank-you-page-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"Thank You Page";s:4:"tags";s:59:"["Conference","Event","Events","Landing Pages","Thank You"]";s:10:"menu_order";i:71;s:16:"popularity_index";i:799;s:11:"trend_index";i:540;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:350;a:20:{s:4:"tmpl";i:503;s:2:"id";i:5447;s:5:"title";s:7:"About 3";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_5.png";s:12:"tmpl_created";i:1520443514;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/about-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:71;s:16:"popularity_index";i:48;s:11:"trend_index";i:12;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:351;a:20:{s:4:"tmpl";i:1073;s:2:"id";i:15486;s:5:"title";s:25:"Travel Blog &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/11/About.jpg";s:12:"tmpl_created";i:1606215720;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/travel-blog-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:17:"["Blog","Travel"]";s:10:"menu_order";i:72;s:16:"popularity_index";i:608;s:11:"trend_index";i:343;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:352;a:20:{s:4:"tmpl";i:1166;s:2:"id";i:17368;s:5:"title";s:38:"Real Estate Agency &#8211; Real-Estate";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Real-Estate.png";s:12:"tmpl_created";i:1612711814;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/lp/real-estate-agency-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"Real Estate";s:4:"tags";s:73:"["Landing Pages","listing","Real estate","Realestate","realtor","realty"]";s:10:"menu_order";i:72;s:16:"popularity_index";i:858;s:11:"trend_index";i:777;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:353;a:20:{s:4:"tmpl";i:1074;s:2:"id";i:15478;s:5:"title";s:27:"Travel Blog &#8211; Contact";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/11/Contact-Us.jpg";s:12:"tmpl_created";i:1606215735;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/travel-blog-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:17:"["Blog","Travel"]";s:10:"menu_order";i:73;s:16:"popularity_index";i:687;s:11:"trend_index";i:564;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:354;a:20:{s:4:"tmpl";i:1170;s:2:"id";i:17423;s:5:"title";s:57:"Volunteer Calls Thank You Page &#8211; Social Involvement";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2021/02/Volunteer-Calls-TYP.jpg";s:12:"tmpl_created";i:1612726058;s:6:"author";s:9:"Elementor";s:3:"url";s:151:"https://library.elementor.com/lp/volunteer-calls-thank-you-page-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Thank You Page";s:4:"tags";s:62:"["Care","Involvement","Landing Pages","Thank You","Volunteer"]";s:10:"menu_order";i:73;s:16:"popularity_index";i:857;s:11:"trend_index";i:818;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:355;a:20:{s:4:"tmpl";i:507;s:2:"id";i:5480;s:5:"title";s:7:"About 4";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_7-1.png";s:12:"tmpl_created";i:1520443522;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/about-4-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:73;s:16:"popularity_index";i:428;s:11:"trend_index";i:303;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:356;a:20:{s:4:"tmpl";i:1075;s:2:"id";i:15467;s:5:"title";s:24:"Travel Blog &#8211; Home";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/11/Home.jpg";s:12:"tmpl_created";i:1606215756;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/travel-blog-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:17:"["Blog","Travel"]";s:10:"menu_order";i:74;s:16:"popularity_index";i:567;s:11:"trend_index";i:224;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:357;a:20:{s:4:"tmpl";i:1169;s:2:"id";i:17409;s:5:"title";s:37:"Webinar Thank You Page &#8211; Events";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Webinar-TYP.png";s:12:"tmpl_created";i:1612725644;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/lp/webinar-thank-you-page-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Thank You Page";s:4:"tags";s:56:"["Event","Events","Landing Pages","Thank You","Webinar"]";s:10:"menu_order";i:74;s:16:"popularity_index";i:868;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:358;a:20:{s:4:"tmpl";i:1056;s:2:"id";i:15317;s:5:"title";s:25:"Dance Studio &#8211; Home";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/10/Home.jpg";s:12:"tmpl_created";i:1603181291;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/dance-studio-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:16:"["Dance Studio"]";s:10:"menu_order";i:75;s:16:"popularity_index";i:596;s:11:"trend_index";i:301;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:359;a:20:{s:4:"tmpl";i:545;s:2:"id";i:6027;s:5:"title";s:7:"About 5";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1-1.png";s:12:"tmpl_created";i:1520443639;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/about-5-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:75;s:16:"popularity_index";i:40;s:11:"trend_index";i:40;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:360;a:20:{s:4:"tmpl";i:1160;s:2:"id";i:17258;s:5:"title";s:32:"Beauty Product &#8211; eCommerce";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2021/01/Beauty-Product.png";s:12:"tmpl_created";i:1610903153;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/lp/beauty-product-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:38:"["Beauty","Ecommerce","Landing Pages"]";s:10:"menu_order";i:75;s:16:"popularity_index";i:797;s:11:"trend_index";i:703;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:361;a:20:{s:4:"tmpl";i:1057;s:2:"id";i:15334;s:5:"title";s:26:"Dance Studio &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/10/About.jpg";s:12:"tmpl_created";i:1603181364;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/dance-studio-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:16:"["Dance Studio"]";s:10:"menu_order";i:76;s:16:"popularity_index";i:626;s:11:"trend_index";i:373;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:362;a:20:{s:4:"tmpl";i:546;s:2:"id";i:6036;s:5:"title";s:7:"About 6";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1-1.png";s:12:"tmpl_created";i:1520443641;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/about-6-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:76;s:16:"popularity_index";i:90;s:11:"trend_index";i:123;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:363;a:20:{s:4:"tmpl";i:1171;s:2:"id";i:17435;s:5:"title";s:39:"Gym &#8211; App Service &#8211; Product";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/02/250x280-4.png";s:12:"tmpl_created";i:1612726462;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/lp/gym-app-service-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"Product";s:4:"tags";s:58:"["App","Fitness","Gym","Health","Landing Pages","Product"]";s:10:"menu_order";i:76;s:16:"popularity_index";i:767;s:11:"trend_index";i:577;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:364;a:20:{s:4:"tmpl";i:1058;s:2:"id";i:15349;s:5:"title";s:28:"Dance Studio &#8211; Classes";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/10/Classes.jpg";s:12:"tmpl_created";i:1603181425;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/dance-studio-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:16:"["Dance Studio"]";s:10:"menu_order";i:77;s:16:"popularity_index";i:629;s:11:"trend_index";i:458;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:365;a:20:{s:4:"tmpl";i:1156;s:2:"id";i:17111;s:5:"title";s:33:"Sunglasses Sale &#8211; eCommerce";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2021/01/Sunglasses-LP-Library-Pic.jpg";s:12:"tmpl_created";i:1610632408;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/sunglasses-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:59:"["Ecommerce","Fashion","Landing Pages","Sale","Sunglasses"]";s:10:"menu_order";i:77;s:16:"popularity_index";i:812;s:11:"trend_index";i:732;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:366;a:20:{s:4:"tmpl";i:1055;s:2:"id";i:15366;s:5:"title";s:29:"Dance Studio &#8211; Schedule";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2020/10/Classes-Schedule.jpg";s:12:"tmpl_created";i:1603181056;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/dance-studio-schedule/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:16:"["Dance Studio"]";s:10:"menu_order";i:78;s:16:"popularity_index";i:698;s:11:"trend_index";i:602;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:367;a:20:{s:4:"tmpl";i:1157;s:2:"id";i:17223;s:5:"title";s:25:"Fashion &#8211; eCommerce";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2021/01/Commerce-Fashion.png";s:12:"tmpl_created";i:1610902553;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/lp/fashion-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:29:"["Ecommerce","Landing Pages"]";s:10:"menu_order";i:78;s:16:"popularity_index";i:808;s:11:"trend_index";i:745;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:368;a:20:{s:4:"tmpl";i:1059;s:2:"id";i:15373;s:5:"title";s:28:"Dance Studio &#8211; Pricing";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/10/Pricing.jpg";s:12:"tmpl_created";i:1603181678;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/dance-studio-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:16:"["Dance Studio"]";s:10:"menu_order";i:79;s:16:"popularity_index";i:731;s:11:"trend_index";i:661;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:369;a:20:{s:4:"tmpl";i:1151;s:2:"id";i:17017;s:5:"title";s:28:"Shoes Sale &#8211; eCommerce";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2021/01/Shoes-LP-Library-Pic.jpg";s:12:"tmpl_created";i:1610535361;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/shoes-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:55:"["Discount","Ecommerce","Landing Pages","Sale","Shoes"]";s:10:"menu_order";i:79;s:16:"popularity_index";i:803;s:11:"trend_index";i:642;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:370;a:20:{s:4:"tmpl";i:508;s:2:"id";i:5488;s:5:"title";s:7:"About 7";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_8.png";s:12:"tmpl_created";i:1520443524;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/about-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:79;s:16:"popularity_index";i:307;s:11:"trend_index";i:169;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:371;a:20:{s:4:"tmpl";i:1060;s:2:"id";i:15384;s:5:"title";s:28:"Dance Studio &#8211; Contact";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/10/Contact-Us.jpg";s:12:"tmpl_created";i:1603181738;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/dance-studio-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:16:"["Dance Studio"]";s:10:"menu_order";i:80;s:16:"popularity_index";i:741;s:11:"trend_index";i:721;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:372;a:20:{s:4:"tmpl";i:556;s:2:"id";i:6122;s:5:"title";s:7:"About 8";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2-1.png";s:12:"tmpl_created";i:1520443661;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/about-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:80;s:16:"popularity_index";i:38;s:11:"trend_index";i:26;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:373;a:20:{s:4:"tmpl";i:1163;s:2:"id";i:17301;s:5:"title";s:53:"Personal Chef &#8211; Thank You Page &#8211; Business";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2021/01/TYP-Personal-Chef.jpg";s:12:"tmpl_created";i:1610903622;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/lp/personal-chef-thank-you-page-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Thank You Page";s:4:"tags";s:43:"["Chef","Food","Landing Pages","Thank You"]";s:10:"menu_order";i:80;s:16:"popularity_index";i:823;s:11:"trend_index";i:754;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:374;a:20:{s:4:"tmpl";i:1042;s:2:"id";i:15158;s:5:"title";s:26:"Psychologist &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/09/About.jpg";s:12:"tmpl_created";i:1600157561;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/psychologist-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Psychologist","Psychotherapist"]";s:10:"menu_order";i:81;s:16:"popularity_index";i:618;s:11:"trend_index";i:426;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:375;a:20:{s:4:"tmpl";i:1164;s:2:"id";i:17313;s:5:"title";s:60:"Development Course  &#8211; Thank You Page &#8211; Education";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2021/01/Dev-Course-TYP-.png";s:12:"tmpl_created";i:1610903776;s:6:"author";s:9:"Elementor";s:3:"url";s:145:"https://library.elementor.com/lp/development-course-thank-you-page-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Thank You Page";s:4:"tags";s:57:"["Course Online","Education","Landing Pages","Thank You"]";s:10:"menu_order";i:81;s:16:"popularity_index";i:834;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:376;a:20:{s:4:"tmpl";i:1045;s:2:"id";i:15197;s:5:"title";s:28:"Psychologist &#8211; Contact";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/09/Contact-Us.jpg";s:12:"tmpl_created";i:1600160499;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/psychologist-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Psychologist","Psychotherapist"]";s:10:"menu_order";i:82;s:16:"popularity_index";i:666;s:11:"trend_index";i:558;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:377;a:20:{s:4:"tmpl";i:509;s:2:"id";i:5496;s:5:"title";s:7:"About 9";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_8-1.png";s:12:"tmpl_created";i:1520443526;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/about-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:82;s:16:"popularity_index";i:523;s:11:"trend_index";i:453;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:378;a:20:{s:4:"tmpl";i:1041;s:2:"id";i:15142;s:5:"title";s:25:"Psychologist &#8211; Home";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/09/Home.jpg";s:12:"tmpl_created";i:1600156308;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/psychologist-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Psychologist","Psychotherapist"]";s:10:"menu_order";i:83;s:16:"popularity_index";i:464;s:11:"trend_index";i:297;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:379;a:20:{s:4:"tmpl";i:1044;s:2:"id";i:15188;s:5:"title";s:28:"Psychologist &#8211; Pricing";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/09/Pricing.jpg";s:12:"tmpl_created";i:1600159731;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/psychologist-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Psychologist","Psychotherapist"]";s:10:"menu_order";i:84;s:16:"popularity_index";i:732;s:11:"trend_index";i:537;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:380;a:20:{s:4:"tmpl";i:684;s:2:"id";i:8961;s:5:"title";s:9:"archive 1";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.1.jpg";s:12:"tmpl_created";i:1528639909;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:84;s:16:"popularity_index";i:79;s:11:"trend_index";i:15;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:381;a:20:{s:4:"tmpl";i:1043;s:2:"id";i:15167;s:5:"title";s:29:"Psychologist &#8211; Services";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/09/Services.jpg";s:12:"tmpl_created";i:1600158206;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/psychologist-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Psychologist","Psychotherapist"]";s:10:"menu_order";i:85;s:16:"popularity_index";i:606;s:11:"trend_index";i:379;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:382;a:20:{s:4:"tmpl";i:1036;s:2:"id";i:14932;s:5:"title";s:30:"Flooring Company &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/08/About.png";s:12:"tmpl_created";i:1597740110;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/flooring-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:86;s:16:"popularity_index";i:488;s:11:"trend_index";i:319;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:383;a:20:{s:4:"tmpl";i:685;s:2:"id";i:8969;s:5:"title";s:9:"archive 2";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.2.jpg";s:12:"tmpl_created";i:1528700014;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:86;s:16:"popularity_index";i:250;s:11:"trend_index";i:124;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:384;a:20:{s:4:"tmpl";i:1037;s:2:"id";i:14998;s:5:"title";s:32:"Flooring Company &#8211; Contact";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/08/Contact-Us.png";s:12:"tmpl_created";i:1597740222;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/flooring-company-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:87;s:16:"popularity_index";i:553;s:11:"trend_index";i:380;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:385;a:20:{s:4:"tmpl";i:1038;s:2:"id";i:14965;s:5:"title";s:32:"Flooring Company &#8211; Gallery";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/08/Gallery.png";s:12:"tmpl_created";i:1597740353;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/flooring-company-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:88;s:16:"popularity_index";i:371;s:11:"trend_index";i:291;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:386;a:20:{s:4:"tmpl";i:686;s:2:"id";i:8973;s:5:"title";s:9:"archive 3";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.3.jpg";s:12:"tmpl_created";i:1528700205;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:88;s:16:"popularity_index";i:176;s:11:"trend_index";i:54;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:387;a:20:{s:4:"tmpl";i:1282;s:2:"id";i:22417;s:5:"title";s:52:"Finance Learning Platform &#8211; Under Construction";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png";s:12:"tmpl_created";i:1647354987;s:6:"author";s:9:"Elementor";s:3:"url";s:143:"https://library.elementor.com/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Finance","Landing Pages"]";s:10:"menu_order";i:89;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:388;a:20:{s:4:"tmpl";i:1040;s:2:"id";i:14947;s:5:"title";s:33:"Flooring company &#8211; Services";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/08/Services.png";s:12:"tmpl_created";i:1597740551;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/flooring-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:90;s:16:"popularity_index";i:538;s:11:"trend_index";i:392;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:389;a:20:{s:4:"tmpl";i:1039;s:2:"id";i:14901;s:5:"title";s:29:"Flooring Company &#8211; Home";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/08/Home.png";s:12:"tmpl_created";i:1597740474;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/flooring-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:91;s:16:"popularity_index";i:387;s:11:"trend_index";i:185;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:390;a:20:{s:4:"tmpl";i:687;s:2:"id";i:8977;s:5:"title";s:9:"archive 4";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.4.jpg";s:12:"tmpl_created";i:1528700326;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:91;s:16:"popularity_index";i:354;s:11:"trend_index";i:396;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:391;a:20:{s:4:"tmpl";i:1252;s:2:"id";i:22146;s:5:"title";s:36:"Home Decor Store &#8211; Coming Soon";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png";s:12:"tmpl_created";i:1647177514;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:57:"["Coming Soon","Decor","Interior Design","Landing Pages"]";s:10:"menu_order";i:92;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:392;a:20:{s:4:"tmpl";i:688;s:2:"id";i:8981;s:5:"title";s:9:"archive 5";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.5.jpg";s:12:"tmpl_created";i:1528700484;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:93;s:16:"popularity_index";i:333;s:11:"trend_index";i:195;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:393;a:20:{s:4:"tmpl";i:1021;s:2:"id";i:14737;s:5:"title";s:32:"Luxury Real Estate &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/07/About.png";s:12:"tmpl_created";i:1595313527;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/luxury-real-estate-about-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Real estate","Realestate"]";s:10:"menu_order";i:93;s:16:"popularity_index";i:150;s:11:"trend_index";i:447;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:394;a:20:{s:4:"tmpl";i:689;s:2:"id";i:8985;s:5:"title";s:9:"archive 6";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.6.jpg";s:12:"tmpl_created";i:1528700612;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:94;s:16:"popularity_index";i:204;s:11:"trend_index";i:95;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:395;a:20:{s:4:"tmpl";i:1020;s:2:"id";i:14756;s:5:"title";s:34:"Luxury Real Estate &#8211; Contact";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/07/Contact-Us.png";s:12:"tmpl_created";i:1595313519;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/luxury-real-estate-contact-us-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Real estate","Realestate"]";s:10:"menu_order";i:94;s:16:"popularity_index";i:610;s:11:"trend_index";i:569;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:396;a:20:{s:4:"tmpl";i:1019;s:2:"id";i:14716;s:5:"title";s:31:"Luxury Real Estate &#8211; Home";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/07/Home.png";s:12:"tmpl_created";i:1595313512;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/luxury-real-estate-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Real estate","Realestate"]";s:10:"menu_order";i:95;s:16:"popularity_index";i:394;s:11:"trend_index";i:165;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:397;a:20:{s:4:"tmpl";i:690;s:2:"id";i:8989;s:5:"title";s:9:"archive 7";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.7.jpg";s:12:"tmpl_created";i:1528701063;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:96;s:16:"popularity_index";i:208;s:11:"trend_index";i:111;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:398;a:20:{s:4:"tmpl";i:1018;s:2:"id";i:14763;s:5:"title";s:31:"Luxury Real Estate &#8211; News";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2020/07/news-Archive.png";s:12:"tmpl_created";i:1595313273;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/luxury-real-estate-news-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Real estate","Realestate"]";s:10:"menu_order";i:96;s:16:"popularity_index";i:404;s:11:"trend_index";i:167;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:399;a:20:{s:4:"tmpl";i:1283;s:2:"id";i:22423;s:5:"title";s:39:"Online Store &#8211; Under Construction";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png";s:12:"tmpl_created";i:1647355154;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:59:"["Landing Pages","Online Shop","Shop","Under Construction"]";s:10:"menu_order";i:97;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:400;a:20:{s:4:"tmpl";i:691;s:2:"id";i:8996;s:5:"title";s:9:"archive 8";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.8.jpg";s:12:"tmpl_created";i:1528701290;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:98;s:16:"popularity_index";i:227;s:11:"trend_index";i:153;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:401;a:20:{s:4:"tmpl";i:1010;s:2:"id";i:13960;s:5:"title";s:32:"Japanese restaurant &#8211; Home";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/06/Home-Page.jpg";s:12:"tmpl_created";i:1592289775;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/japanese-restaurant-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:98;s:16:"popularity_index";i:537;s:11:"trend_index";i:287;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:402;a:20:{s:4:"tmpl";i:1284;s:2:"id";i:22428;s:5:"title";s:40:"Travel Agency &#8211; Under Construction";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png";s:12:"tmpl_created";i:1647355339;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:56:"["Agency","Landing Pages","Travel","Under Construction"]";s:10:"menu_order";i:99;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:403;a:20:{s:4:"tmpl";i:692;s:2:"id";i:9001;s:5:"title";s:9:"archive 9";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.9.jpg";s:12:"tmpl_created";i:1528701433;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:100;s:16:"popularity_index";i:265;s:11:"trend_index";i:208;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:404;a:20:{s:4:"tmpl";i:1007;s:2:"id";i:13993;s:5:"title";s:45:"Japanese restaurant &#8211; Chef&#8217;s Menu";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2020/06/Chef_s-Menu-Page.jpg";s:12:"tmpl_created";i:1592289691;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/japanese-restaurant-chefs-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:100;s:16:"popularity_index";i:651;s:11:"trend_index";i:675;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:405;a:20:{s:4:"tmpl";i:1006;s:2:"id";i:14012;s:5:"title";s:36:"Japanese restaurant &#8211; Bar Menu";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2020/06/Bar-Menu-Page.jpg";s:12:"tmpl_created";i:1592289665;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/japanese-restaurant-bar-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:101;s:16:"popularity_index";i:735;s:11:"trend_index";i:829;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:406;a:20:{s:4:"tmpl";i:1005;s:2:"id";i:13917;s:5:"title";s:33:"Japanese restaurant &#8211; About";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/06/About-Page.jpg";s:12:"tmpl_created";i:1592289629;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/japanese-restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:102;s:16:"popularity_index";i:640;s:11:"trend_index";i:389;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:407;a:20:{s:4:"tmpl";i:997;s:2:"id";i:13528;s:5:"title";s:22:"Barbershop &#8211; 404";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/05/404-Page.jpg";s:12:"tmpl_created";i:1589893152;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/barbershop-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:34:"["404","Barber Shop","Barbershop"]";s:10:"menu_order";i:103;s:16:"popularity_index";i:768;s:11:"trend_index";i:681;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:408;a:20:{s:4:"tmpl";i:1009;s:2:"id";i:13937;s:5:"title";s:35:"Japanese restaurant &#8211; Gallery";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2020/06/Gallery-Page.jpg";s:12:"tmpl_created";i:1592289748;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/japanese-restaurant-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:103;s:16:"popularity_index";i:648;s:11:"trend_index";i:551;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:409;a:20:{s:4:"tmpl";i:1008;s:2:"id";i:14030;s:5:"title";s:34:"Japanese restaurant &#8211; Events";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2020/06/Events-Page.jpg";s:12:"tmpl_created";i:1592289713;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/japanese-restaurant-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:104;s:16:"popularity_index";i:723;s:11:"trend_index";i:711;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:410;a:20:{s:4:"tmpl";i:998;s:2:"id";i:13518;s:5:"title";s:26:"Barbershop &#8211; Archive";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/05/Blog-Page.jpg";s:12:"tmpl_created";i:1589893157;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/blocks/barbershop-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:28:"["Barber Shop","Barbershop"]";s:10:"menu_order";i:105;s:16:"popularity_index";i:737;s:11:"trend_index";i:523;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:411;a:20:{s:4:"tmpl";i:1016;s:2:"id";i:13984;s:5:"title";s:40:"Japanese restaurant &#8211; Reservations";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2020/06/reservations.jpg";s:12:"tmpl_created";i:1592294757;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/japanese-restaurant-reservations/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:105;s:16:"popularity_index";i:715;s:11:"trend_index";i:727;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:412;a:20:{s:4:"tmpl";i:999;s:2:"id";i:13479;s:5:"title";s:23:"Barbershop &#8211; Home";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/05/Home-Page.jpg";s:12:"tmpl_created";i:1589893275;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/barbershop-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Barber Shop","Barbershop"]";s:10:"menu_order";i:106;s:16:"popularity_index";i:683;s:11:"trend_index";i:832;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:413;a:20:{s:4:"tmpl";i:996;s:2:"id";i:13604;s:5:"title";s:25:"Barbershop &#8211; Footer";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2020/05/Footer-Small.jpg";s:12:"tmpl_created";i:1589893147;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/blocks/barbershop-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:37:"["Barber Shop","Barbershop","Footer"]";s:10:"menu_order";i:107;s:16:"popularity_index";i:555;s:11:"trend_index";i:267;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:414;a:20:{s:4:"tmpl";i:1000;s:2:"id";i:13503;s:5:"title";s:24:"Barbershop &#8211; About";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/05/About-Page.jpg";s:12:"tmpl_created";i:1589893289;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/barbershop-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Barber Shop","Barbershop"]";s:10:"menu_order";i:107;s:16:"popularity_index";i:744;s:11:"trend_index";i:739;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:415;a:20:{s:4:"tmpl";i:995;s:2:"id";i:13612;s:5:"title";s:25:"Barbershop &#8211; Header";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2020/06/barber-shop-header.jpg";s:12:"tmpl_created";i:1589893142;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/blocks/barbershop-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:37:"["Barber Shop","Barbershop","Header"]";s:10:"menu_order";i:108;s:16:"popularity_index";i:343;s:11:"trend_index";i:137;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:416;a:20:{s:4:"tmpl";i:1001;s:2:"id";i:13548;s:5:"title";s:27:"Barbershop &#8211; Services";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2020/05/Services-Page.jpg";s:12:"tmpl_created";i:1589893298;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/barbershop-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Barber Shop","Barbershop"]";s:10:"menu_order";i:108;s:16:"popularity_index";i:761;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:417;a:20:{s:4:"tmpl";i:1002;s:2:"id";i:13560;s:5:"title";s:26:"Barbershop &#8211; Gallery";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2020/05/Gallery-Page.jpg";s:12:"tmpl_created";i:1589893307;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/barbershop-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Barber Shop","Barbershop"]";s:10:"menu_order";i:109;s:16:"popularity_index";i:756;s:11:"trend_index";i:822;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:418;a:20:{s:4:"tmpl";i:1003;s:2:"id";i:13587;s:5:"title";s:26:"Barbershop &#8211; Contact";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2020/05/Contact-Us-Page.jpg";s:12:"tmpl_created";i:1589893315;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/barbershop-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Barber Shop","Barbershop"]";s:10:"menu_order";i:110;s:16:"popularity_index";i:753;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:419;a:20:{s:4:"tmpl";i:982;s:2:"id";i:13307;s:5:"title";s:26:"Online Course &#8211; Home";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/04/Home.jpg";s:12:"tmpl_created";i:1587474541;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/online-course-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:111;s:16:"popularity_index";i:230;s:11:"trend_index";i:125;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:420;a:20:{s:4:"tmpl";i:994;s:2:"id";i:13621;s:5:"title";s:30:"Barbershop &#8211; Single Post";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2020/05/Single-Page.jpg";s:12:"tmpl_created";i:1589893137;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/blocks/barbershop-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:28:"["Barber Shop","Barbershop"]";s:10:"menu_order";i:111;s:16:"popularity_index";i:736;s:11:"trend_index";i:580;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:421;a:20:{s:4:"tmpl";i:1131;s:2:"id";i:16527;s:5:"title";s:24:"Beauty Salon &#8211; 404";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2020/12/404.jpg";s:12:"tmpl_created";i:1608622517;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/beauty-salon-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:29:"["404","Beauty Salon","Hair"]";s:10:"menu_order";i:112;s:16:"popularity_index";i:742;s:11:"trend_index";i:563;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:422;a:20:{s:4:"tmpl";i:983;s:2:"id";i:13328;s:5:"title";s:27:"Online Course &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/04/About.jpg";s:12:"tmpl_created";i:1587474558;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/online-course-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:112;s:16:"popularity_index";i:508;s:11:"trend_index";i:429;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:423;a:20:{s:4:"tmpl";i:984;s:2:"id";i:13338;s:5:"title";s:33:"Online Course &#8211; Course Page";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2020/04/Course-Page.png";s:12:"tmpl_created";i:1587474574;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/online-course-course-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:113;s:16:"popularity_index";i:337;s:11:"trend_index";i:310;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:424;a:20:{s:4:"tmpl";i:985;s:2:"id";i:13352;s:5:"title";s:29:"Online Course &#8211; Contact";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.jpg";s:12:"tmpl_created";i:1587474591;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/online-course-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:114;s:16:"popularity_index";i:565;s:11:"trend_index";i:533;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:425;a:20:{s:4:"tmpl";i:1130;s:2:"id";i:16535;s:5:"title";s:27:"Beauty Salon &#8211; Footer";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/12/Footer.jpg";s:12:"tmpl_created";i:1608622498;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/beauty-salon-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:32:"["Beauty Salon","Footer","Hair"]";s:10:"menu_order";i:115;s:16:"popularity_index";i:524;s:11:"trend_index";i:126;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:426;a:20:{s:4:"tmpl";i:971;s:2:"id";i:13187;s:5:"title";s:33:"Interior Design &#8211; Home Page";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/04/Home.png";s:12:"tmpl_created";i:1586148661;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/interior-design-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Business","Interior Design"]";s:10:"menu_order";i:115;s:16:"popularity_index";i:331;s:11:"trend_index";i:264;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:427;a:20:{s:4:"tmpl";i:1453;s:2:"id";i:16346;s:5:"title";s:33:"Your New Home &#8211; Real Estate";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2017/03/lp3-l.png";s:12:"tmpl_created";i:1660205402;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/your-new-home-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:11:"Real Estate";s:4:"tags";s:31:"["Landing Pages","Real estate"]";s:10:"menu_order";i:116;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:428;a:20:{s:4:"tmpl";i:972;s:2:"id";i:13199;s:5:"title";s:29:"Interior Design &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/04/About.png";s:12:"tmpl_created";i:1586148666;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/interior-design-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Business","Interior Design"]";s:10:"menu_order";i:116;s:16:"popularity_index";i:316;s:11:"trend_index";i:334;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:429;a:20:{s:4:"tmpl";i:1129;s:2:"id";i:16545;s:5:"title";s:27:"Beauty Salon &#8211; Header";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/12/Header.jpg";s:12:"tmpl_created";i:1608622495;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/beauty-salon-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:32:"["Beauty Salon","Hair","Header"]";s:10:"menu_order";i:117;s:16:"popularity_index";i:356;s:11:"trend_index";i:49;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:430;a:20:{s:4:"tmpl";i:973;s:2:"id";i:13214;s:5:"title";s:32:"Interior Design &#8211; Projects";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2020/04/portfolio_s.jpg";s:12:"tmpl_created";i:1586148672;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/interior-design-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Business","Interior Design"]";s:10:"menu_order";i:117;s:16:"popularity_index";i:367;s:11:"trend_index";i:323;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:431;a:20:{s:4:"tmpl";i:641;s:2:"id";i:7686;s:5:"title";s:12:"Blog Posts 1";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2018/03/blog_posts.png";s:12:"tmpl_created";i:1521558047;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/blog-posts-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:26:"["Archive","Blog","posts"]";s:10:"menu_order";i:118;s:16:"popularity_index";i:131;s:11:"trend_index";i:152;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:432;a:20:{s:4:"tmpl";i:974;s:2:"id";i:13229;s:5:"title";s:31:"Interior Design &#8211; Contact";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.png";s:12:"tmpl_created";i:1586148677;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/interior-design-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Business","Interior Design"]";s:10:"menu_order";i:118;s:16:"popularity_index";i:395;s:11:"trend_index";i:337;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:433;a:20:{s:4:"tmpl";i:959;s:2:"id";i:12948;s:5:"title";s:29:"Photography &#8211; Home Page";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/02/Home_s.png";s:12:"tmpl_created";i:1582093442;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/photography-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:119;s:16:"popularity_index";i:241;s:11:"trend_index";i:201;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:434;a:20:{s:4:"tmpl";i:960;s:2:"id";i:12798;s:5:"title";s:25:"Photography &#8211; About";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/02/About_s.png";s:12:"tmpl_created";i:1582093446;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/photography-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:120;s:16:"popularity_index";i:499;s:11:"trend_index";i:374;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:435;a:20:{s:4:"tmpl";i:484;s:2:"id";i:5283;s:5:"title";s:9:"Clients 1";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_2.png";s:12:"tmpl_created";i:1520443478;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/clients-1-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:120;s:16:"popularity_index";i:294;s:11:"trend_index";i:202;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:436;a:20:{s:4:"tmpl";i:961;s:2:"id";i:12868;s:5:"title";s:27:"Photography &#8211; Contact";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/02/Contact_s.png";s:12:"tmpl_created";i:1582093450;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/photography-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:121;s:16:"popularity_index";i:531;s:11:"trend_index";i:350;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:437;a:20:{s:4:"tmpl";i:962;s:2:"id";i:13056;s:5:"title";s:28:"Photography &#8211; Wildlife";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/02/Wildlife_s.png";s:12:"tmpl_created";i:1582093454;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/photography-wildlife/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:122;s:16:"popularity_index";i:579;s:11:"trend_index";i:656;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:438;a:20:{s:4:"tmpl";i:487;s:2:"id";i:5306;s:5:"title";s:10:"Clients 10";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_3.png";s:12:"tmpl_created";i:1520443484;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/clients-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:122;s:16:"popularity_index";i:657;s:11:"trend_index";i:581;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:439;a:20:{s:4:"tmpl";i:963;s:2:"id";i:12922;s:5:"title";s:37:"Photography &#8211; Glowing Jellyfish";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2020/02/Jellyfish_S.png";s:12:"tmpl_created";i:1582093457;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/photography-glowing-jellyfish/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:123;s:16:"popularity_index";i:628;s:11:"trend_index";i:532;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:440;a:20:{s:4:"tmpl";i:964;s:2:"id";i:12875;s:5:"title";s:36:"Photography &#8211; Fluttering Birds";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/02/Birds_s.png";s:12:"tmpl_created";i:1582093461;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/photography-fluttering-birds/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:124;s:16:"popularity_index";i:693;s:11:"trend_index";i:766;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:441;a:20:{s:4:"tmpl";i:965;s:2:"id";i:12962;s:5:"title";s:26:"Photography &#8211; Nature";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/02/Nature_s.png";s:12:"tmpl_created";i:1582093465;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/photography-nature/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:125;s:16:"popularity_index";i:592;s:11:"trend_index";i:778;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:442;a:20:{s:4:"tmpl";i:491;s:2:"id";i:5341;s:5:"title";s:10:"Clients 11";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_4.png";s:12:"tmpl_created";i:1520443491;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/clients-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:125;s:16:"popularity_index";i:603;s:11:"trend_index";i:633;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:443;a:20:{s:4:"tmpl";i:966;s:2:"id";i:12833;s:5:"title";s:38:"Photography &#8211; Blossoming Flowers";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/02/Flowers_s.png";s:12:"tmpl_created";i:1582093469;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/photography-blossoming-flowers/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:126;s:16:"popularity_index";i:597;s:11:"trend_index";i:750;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:444;a:20:{s:4:"tmpl";i:488;s:2:"id";i:5315;s:5:"title";s:10:"Clients 12";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4-1.png";s:12:"tmpl_created";i:1520443486;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/clients-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:126;s:16:"popularity_index";i:485;s:11:"trend_index";i:263;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:445;a:20:{s:4:"tmpl";i:967;s:2:"id";i:12898;s:5:"title";s:36:"Photography &#8211; Forest Mushrooms";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2020/02/Mushrooms_s.png";s:12:"tmpl_created";i:1582093473;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/photography-forest-mushrooms/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:127;s:16:"popularity_index";i:667;s:11:"trend_index";i:649;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:446;a:20:{s:4:"tmpl";i:968;s:2:"id";i:12994;s:5:"title";s:24:"Photography &#8211; Pets";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/02/Pets_s.png";s:12:"tmpl_created";i:1582093477;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/photography-pets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:128;s:16:"popularity_index";i:612;s:11:"trend_index";i:508;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:447;a:20:{s:4:"tmpl";i:969;s:2:"id";i:12805;s:5:"title";s:37:"Photography &#8211; B&amp;W Portraits";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/02/Black_s.png";s:12:"tmpl_created";i:1582093481;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/photography-bw-portraits/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:129;s:16:"popularity_index";i:695;s:11:"trend_index";i:735;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:448;a:20:{s:4:"tmpl";i:490;s:2:"id";i:5333;s:5:"title";s:10:"Clients 13";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_6.png";s:12:"tmpl_created";i:1520443489;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/clients-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:129;s:16:"popularity_index";i:234;s:11:"trend_index";i:128;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:449;a:20:{s:4:"tmpl";i:970;s:2:"id";i:13031;s:5:"title";s:33:"Photography &#8211; Vivid Parrots";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/02/Parrots_s.png";s:12:"tmpl_created";i:1582093484;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/photography-vivid-parrots/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:130;s:16:"popularity_index";i:660;s:11:"trend_index";i:643;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:450;a:20:{s:4:"tmpl";i:496;s:2:"id";i:5389;s:5:"title";s:10:"Clients 14";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_black_9.png";s:12:"tmpl_created";i:1520443501;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/clients-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:130;s:16:"popularity_index";i:407;s:11:"trend_index";i:307;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:451;a:20:{s:4:"tmpl";i:940;s:2:"id";i:12621;s:5:"title";s:26:"Magazine &#8211; Home Page";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/01/Home_s.png";s:12:"tmpl_created";i:1579060604;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/magazine-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:131;s:16:"popularity_index";i:167;s:11:"trend_index";i:121;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:452;a:20:{s:4:"tmpl";i:936;s:2:"id";i:12352;s:5:"title";s:24:"Travel &#8211; Home Page";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2019/12/Home_s.png";s:12:"tmpl_created";i:1575960464;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/travel-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:132;s:16:"popularity_index";i:291;s:11:"trend_index";i:194;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:453;a:20:{s:4:"tmpl";i:486;s:2:"id";i:5298;s:5:"title";s:10:"Clients 15";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_3.png";s:12:"tmpl_created";i:1520443482;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/clients-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:132;s:16:"popularity_index";i:465;s:11:"trend_index";i:520;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:454;a:20:{s:4:"tmpl";i:932;s:2:"id";i:12400;s:5:"title";s:20:"Travel &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2019/12/About.png";s:12:"tmpl_created";i:1575960441;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/travel-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:133;s:16:"popularity_index";i:444;s:11:"trend_index";i:445;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:455;a:20:{s:4:"tmpl";i:938;s:2:"id";i:12479;s:5:"title";s:20:"Travel &#8211; Tours";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2019/12/Tours_s.png";s:12:"tmpl_created";i:1575960474;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/travel-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:134;s:16:"popularity_index";i:539;s:11:"trend_index";i:726;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:456;a:20:{s:4:"tmpl";i:495;s:2:"id";i:5381;s:5:"title";s:10:"Clients 16";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_9.png";s:12:"tmpl_created";i:1520443499;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/clients-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:134;s:16:"popularity_index";i:198;s:11:"trend_index";i:168;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:457;a:20:{s:4:"tmpl";i:937;s:2:"id";i:12466;s:5:"title";s:27:"Travel &#8211; Testimonials";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2019/12/Testimonials.png";s:12:"tmpl_created";i:1575960469;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/travel-testimonials/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:135;s:16:"popularity_index";i:527;s:11:"trend_index";i:481;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:458;a:20:{s:4:"tmpl";i:935;s:2:"id";i:12443;s:5:"title";s:22:"Travel &#8211; Gallery";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2019/12/Gallery.png";s:12:"tmpl_created";i:1575960459;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/travel-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:136;s:16:"popularity_index";i:467;s:11:"trend_index";i:501;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:459;a:20:{s:4:"tmpl";i:934;s:2:"id";i:12431;s:5:"title";s:18:"Travel &#8211; FAQ";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2019/12/FAQ.png";s:12:"tmpl_created";i:1575960453;s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/travel-faq/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:137;s:16:"popularity_index";i:501;s:11:"trend_index";i:387;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:460;a:20:{s:4:"tmpl";i:493;s:2:"id";i:5357;s:5:"title";s:9:"Clients 2";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_7.png";s:12:"tmpl_created";i:1520443495;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/clients-2-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:137;s:16:"popularity_index";i:341;s:11:"trend_index";i:232;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:461;a:20:{s:4:"tmpl";i:933;s:2:"id";i:12421;s:5:"title";s:27:"Travel &#8211; Contact Page";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2019/12/Contsct-Us.png";s:12:"tmpl_created";i:1575960445;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/travel-contact-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:138;s:16:"popularity_index";i:571;s:11:"trend_index";i:536;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:462;a:20:{s:4:"tmpl";i:892;s:2:"id";i:11763;s:5:"title";s:27:"Portfolio &#8211; Home Page";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2019/09/Homepage_small.png";s:12:"tmpl_created";i:1569428959;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/portfolio-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:139;s:16:"popularity_index";i:280;s:11:"trend_index";i:241;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:463;a:20:{s:4:"tmpl";i:485;s:2:"id";i:5290;s:5:"title";s:9:"Clients 3";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_2.png";s:12:"tmpl_created";i:1520443480;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/clients-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:139;s:16:"popularity_index";i:545;s:11:"trend_index";i:502;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:464;a:20:{s:4:"tmpl";i:891;s:2:"id";i:11781;s:5:"title";s:23:"Portfolio &#8211; About";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2019/09/About_small.png";s:12:"tmpl_created";i:1569428955;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/portfolio-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:140;s:16:"popularity_index";i:349;s:11:"trend_index";i:290;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:465;a:20:{s:4:"tmpl";i:482;s:2:"id";i:5266;s:5:"title";s:9:"Clients 4";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_1.png";s:12:"tmpl_created";i:1520443474;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/clients-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:140;s:16:"popularity_index";i:95;s:11:"trend_index";i:134;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:466;a:20:{s:4:"tmpl";i:890;s:2:"id";i:11793;s:5:"title";s:26:"Portfolio &#8211; Projects";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2019/09/Projects_small.png";s:12:"tmpl_created";i:1569428951;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/portfolio-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:141;s:16:"popularity_index";i:448;s:11:"trend_index";i:467;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:467;a:20:{s:4:"tmpl";i:889;s:2:"id";i:11800;s:5:"title";s:25:"Portfolio &#8211; Contact";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/09/Contact_small.png";s:12:"tmpl_created";i:1569428946;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/portfolio-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:142;s:16:"popularity_index";i:494;s:11:"trend_index";i:449;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:468;a:20:{s:4:"tmpl";i:866;s:2:"id";i:11163;s:5:"title";s:32:"Digital Agency &#8211; Home Page";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2019/07/Home_small.png";s:12:"tmpl_created";i:1564641877;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/digital-agency-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Digital Agency","Marketing"]";s:10:"menu_order";i:143;s:16:"popularity_index";i:57;s:11:"trend_index";i:32;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:469;a:20:{s:4:"tmpl";i:483;s:2:"id";i:5275;s:5:"title";s:9:"Clients 5";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_1.png";s:12:"tmpl_created";i:1520443476;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/clients-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:143;s:16:"popularity_index";i:334;s:11:"trend_index";i:321;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:470;a:20:{s:4:"tmpl";i:492;s:2:"id";i:5349;s:5:"title";s:9:"Clients 7";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_7.png";s:12:"tmpl_created";i:1520443493;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/clients-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:144;s:16:"popularity_index";i:233;s:11:"trend_index";i:92;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:471;a:20:{s:4:"tmpl";i:916;s:2:"id";i:12143;s:5:"title";s:22:"Law Firm &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2019/11/about.png";s:12:"tmpl_created";i:1572847069;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/law-firm-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:146;s:16:"popularity_index";i:350;s:11:"trend_index";i:344;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:472;a:20:{s:4:"tmpl";i:489;s:2:"id";i:5324;s:5:"title";s:9:"Clients 8";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5-1.png";s:12:"tmpl_created";i:1520443488;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/clients-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:146;s:16:"popularity_index";i:526;s:11:"trend_index";i:381;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:473;a:20:{s:4:"tmpl";i:920;s:2:"id";i:12091;s:5:"title";s:21:"Law Firm &#8211; Team";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2019/11/team.png";s:12:"tmpl_created";i:1572847113;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/law-firm-team/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:147;s:16:"popularity_index";i:318;s:11:"trend_index";i:314;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:474;a:20:{s:4:"tmpl";i:869;s:2:"id";i:11129;s:5:"title";s:28:"Digital Agency &#8211; About";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2019/07/About_small.png";s:12:"tmpl_created";i:1564641889;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/digital-agency-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Digital Agency","Marketing"]";s:10:"menu_order";i:148;s:16:"popularity_index";i:182;s:11:"trend_index";i:166;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:475;a:20:{s:4:"tmpl";i:880;s:2:"id";i:11572;s:5:"title";s:19:"Gym &#8211; Trainer";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/08/Trainer_Small.png";s:12:"tmpl_created";i:1567392934;s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/gym-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:149;s:16:"popularity_index";i:521;s:11:"trend_index";i:590;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:476;a:20:{s:4:"tmpl";i:494;s:2:"id";i:5368;s:5:"title";s:9:"Clients 9";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_8.png";s:12:"tmpl_created";i:1520443497;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/clients-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:149;s:16:"popularity_index";i:253;s:11:"trend_index";i:273;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:477;a:20:{s:4:"tmpl";i:917;s:2:"id";i:12133;s:5:"title";s:24:"Law Firm &#8211; Careers";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2019/11/careers.png";s:12:"tmpl_created";i:1572847078;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/law-firm-careers/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:151;s:16:"popularity_index";i:583;s:11:"trend_index";i:640;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:478;a:20:{s:4:"tmpl";i:425;s:2:"id";i:4436;s:5:"title";s:11:"Contact  16";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/02/map_black_2.png";s:12:"tmpl_created";i:1520443293;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/contact-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:151;s:16:"popularity_index";i:161;s:11:"trend_index";i:68;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:479;a:20:{s:4:"tmpl";i:915;s:2:"id";i:12155;s:5:"title";s:26:"Law Firm &#8211; Home Page";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2019/11/home.png";s:12:"tmpl_created";i:1572847054;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/law-firm-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:152;s:16:"popularity_index";i:193;s:11:"trend_index";i:110;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:480;a:20:{s:4:"tmpl";i:423;s:2:"id";i:4420;s:5:"title";s:9:"Contact 1";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/02/map_black_1.png";s:12:"tmpl_created";i:1520443289;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/contact-1-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:152;s:16:"popularity_index";i:196;s:11:"trend_index";i:127;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:481;a:20:{s:4:"tmpl";i:921;s:2:"id";i:12080;s:5:"title";s:24:"Law Firm &#8211; Partner";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2019/11/partner-1.png";s:12:"tmpl_created";i:1572847120;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/law-firm-partner/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:153;s:16:"popularity_index";i:556;s:11:"trend_index";i:471;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:482;a:20:{s:4:"tmpl";i:534;s:2:"id";i:5836;s:5:"title";s:10:"Contact 10";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_2.png";s:12:"tmpl_created";i:1520443597;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/contact-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:154;s:16:"popularity_index";i:114;s:11:"trend_index";i:76;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:483;a:20:{s:4:"tmpl";i:865;s:2:"id";i:11074;s:5:"title";s:31:"Digital Agency &#8211; Services";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2019/07/Services_small.png";s:12:"tmpl_created";i:1564641872;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/digital-agency-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Digital Agency","Marketing"]";s:10:"menu_order";i:154;s:16:"popularity_index";i:163;s:11:"trend_index";i:170;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:484;a:20:{s:4:"tmpl";i:879;s:2:"id";i:11506;s:5:"title";s:19:"Gym &#8211; Classes";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/08/Classes_Small.png";s:12:"tmpl_created";i:1567392930;s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/gym-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:155;s:16:"popularity_index";i:514;s:11:"trend_index";i:554;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:485;a:20:{s:4:"tmpl";i:535;s:2:"id";i:5844;s:5:"title";s:10:"Contact 11";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_2.png";s:12:"tmpl_created";i:1520443599;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/contact-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:156;s:16:"popularity_index";i:289;s:11:"trend_index";i:313;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:486;a:20:{s:4:"tmpl";i:922;s:2:"id";i:12044;s:5:"title";s:24:"Law Firm &#8211; Contact";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2019/11/contsct_us.png";s:12:"tmpl_created";i:1572847130;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/law-firm-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:157;s:16:"popularity_index";i:437;s:11:"trend_index";i:304;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:487;a:20:{s:4:"tmpl";i:430;s:2:"id";i:4476;s:5:"title";s:10:"Contact 15";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_4.png";s:12:"tmpl_created";i:1520443303;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/contact-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:18:"["Contact","Form"]";s:10:"menu_order";i:157;s:16:"popularity_index";i:229;s:11:"trend_index";i:187;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:488;a:20:{s:4:"tmpl";i:918;s:2:"id";i:12124;s:5:"title";s:25:"Law Firm &#8211; Services";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2019/11/services.png";s:12:"tmpl_created";i:1572847096;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/law-firm-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:158;s:16:"popularity_index";i:433;s:11:"trend_index";i:296;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:489;a:20:{s:4:"tmpl";i:864;s:2:"id";i:11056;s:5:"title";s:35:"Digital Agency &#8211; Social Media";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2019/07/Social-Media_small.png";s:12:"tmpl_created";i:1564641867;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/digital-agency-social-media/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Digital Agency","Marketing"]";s:10:"menu_order";i:159;s:16:"popularity_index";i:297;s:11:"trend_index";i:361;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:490;a:20:{s:4:"tmpl";i:476;s:2:"id";i:5214;s:5:"title";s:10:"Contact 16";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_2.png";s:12:"tmpl_created";i:1520443462;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/contact-16-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:18:"["Contact","Form"]";s:10:"menu_order";i:159;s:16:"popularity_index";i:194;s:11:"trend_index";i:106;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:491;a:20:{s:4:"tmpl";i:878;s:2:"id";i:11536;s:5:"title";s:19:"Gym &#8211; Fitness";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/08/Fitness_Small.png";s:12:"tmpl_created";i:1567392927;s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/gym-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:160;s:16:"popularity_index";i:621;s:11:"trend_index";i:674;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:492;a:20:{s:4:"tmpl";i:882;s:2:"id";i:11545;s:5:"title";s:21:"Gym &#8211; Home Page";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2019/08/Home_Small.png";s:12:"tmpl_created";i:1567392943;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/gym-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:161;s:16:"popularity_index";i:310;s:11:"trend_index";i:229;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:493;a:20:{s:4:"tmpl";i:919;s:2:"id";i:12116;s:5:"title";s:24:"Law Firm &#8211; Service";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2019/11/family_law.png";s:12:"tmpl_created";i:1572847105;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/law-firm-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:162;s:16:"popularity_index";i:489;s:11:"trend_index";i:339;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:494;a:20:{s:4:"tmpl";i:478;s:2:"id";i:5230;s:5:"title";s:10:"Contact 17";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_3.png";s:12:"tmpl_created";i:1520443466;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/contact-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:18:"["Contact","Form"]";s:10:"menu_order";i:162;s:16:"popularity_index";i:339;s:11:"trend_index";i:335;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:495;a:20:{s:4:"tmpl";i:868;s:2:"id";i:11094;s:5:"title";s:30:"Digital Agency &#8211; Clients";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/07/Clients_small.png";s:12:"tmpl_created";i:1564641885;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/digital-agency-clients/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Digital Agency","Marketing"]";s:10:"menu_order";i:163;s:16:"popularity_index";i:424;s:11:"trend_index";i:424;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:496;a:20:{s:4:"tmpl";i:481;s:2:"id";i:5257;s:5:"title";s:10:"Contact 18";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5.png";s:12:"tmpl_created";i:1520443472;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/contact-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:8:"["Form"]";s:10:"menu_order";i:163;s:16:"popularity_index";i:438;s:11:"trend_index";i:490;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:497;a:20:{s:4:"tmpl";i:881;s:2:"id";i:11478;s:5:"title";s:17:"Gym &#8211; About";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2019/08/About_Small.png";s:12:"tmpl_created";i:1567392939;s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/gym-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:164;s:16:"popularity_index";i:481;s:11:"trend_index";i:579;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:498;a:20:{s:4:"tmpl";i:532;s:2:"id";i:5820;s:5:"title";s:9:"Contact 2";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_1.png";s:12:"tmpl_created";i:1520443593;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:166;s:16:"popularity_index";i:183;s:11:"trend_index";i:357;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:499;a:20:{s:4:"tmpl";i:877;s:2:"id";i:11563;s:5:"title";s:19:"Gym &#8211; Pricing";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/08/Pricing_Small.png";s:12:"tmpl_created";i:1567392923;s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/gym-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:166;s:16:"popularity_index";i:577;s:11:"trend_index";i:736;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:500;a:20:{s:4:"tmpl";i:422;s:2:"id";i:4411;s:5:"title";s:9:"Contact 3";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/02/map_white_1.png";s:12:"tmpl_created";i:1520443287;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/contact-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:167;s:16:"popularity_index";i:113;s:11:"trend_index";i:217;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:501;a:20:{s:4:"tmpl";i:867;s:2:"id";i:11034;s:5:"title";s:30:"Digital Agency &#8211; Contact";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2019/07/Contsct-Us_small.png";s:12:"tmpl_created";i:1564641881;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/contact-digital-agency/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Digital Agency","Marketing"]";s:10:"menu_order";i:168;s:16:"popularity_index";i:191;s:11:"trend_index";i:156;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:502;a:20:{s:4:"tmpl";i:533;s:2:"id";i:5828;s:5:"title";s:9:"Contact 3";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_1.png";s:12:"tmpl_created";i:1520443595;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:170;s:16:"popularity_index";i:312;s:11:"trend_index";i:495;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:503;a:20:{s:4:"tmpl";i:876;s:2:"id";i:11528;s:5:"title";s:19:"Gym &#8211; Contact";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/08/Contact_Small.png";s:12:"tmpl_created";i:1567392917;s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/gym-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:171;s:16:"popularity_index";i:505;s:11:"trend_index";i:624;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:504;a:20:{s:4:"tmpl";i:424;s:2:"id";i:4428;s:5:"title";s:9:"Contact 4";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/02/map_white_2.png";s:12:"tmpl_created";i:1520443291;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:171;s:16:"popularity_index";i:118;s:11:"trend_index";i:131;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:505;a:20:{s:4:"tmpl";i:426;s:2:"id";i:4444;s:5:"title";s:9:"Contact 5";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_1.png";s:12:"tmpl_created";i:1520443295;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:174;s:16:"popularity_index";i:84;s:11:"trend_index";i:93;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:506;a:20:{s:4:"tmpl";i:432;s:2:"id";i:4492;s:5:"title";s:9:"Contact 5";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/02/map_white_3.png";s:12:"tmpl_created";i:1520443307;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/contact-5-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:176;s:16:"popularity_index";i:37;s:11:"trend_index";i:31;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:507;a:20:{s:4:"tmpl";i:427;s:2:"id";i:4452;s:5:"title";s:9:"Contact 6";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_1.png";s:12:"tmpl_created";i:1520443296;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/contact-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:178;s:16:"popularity_index";i:139;s:11:"trend_index";i:150;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:508;a:20:{s:4:"tmpl";i:429;s:2:"id";i:4468;s:5:"title";s:9:"Contact 7";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_3.png";s:12:"tmpl_created";i:1520443301;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/contact-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:18:"["Contact","Form"]";s:10:"menu_order";i:179;s:16:"popularity_index";i:127;s:11:"trend_index";i:72;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:509;a:20:{s:4:"tmpl";i:431;s:2:"id";i:4484;s:5:"title";s:9:"Contact 8";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_3.png";s:12:"tmpl_created";i:1520443305;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/contact-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:18:"["Contact","Form"]";s:10:"menu_order";i:182;s:16:"popularity_index";i:328;s:11:"trend_index";i:260;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:510;a:20:{s:4:"tmpl";i:428;s:2:"id";i:4460;s:5:"title";s:9:"Contact 9";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_2.png";s:12:"tmpl_created";i:1520443298;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/contact-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:184;s:16:"popularity_index";i:99;s:11:"trend_index";i:80;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:511;a:20:{s:4:"tmpl";i:613;s:2:"id";i:5558;s:5:"title";s:5:"CTA 1";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_2.png";s:12:"tmpl_created";i:1520520684;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:185;s:16:"popularity_index";i:129;s:11:"trend_index";i:69;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:512;a:20:{s:4:"tmpl";i:634;s:2:"id";i:5939;s:5:"title";s:6:"CTA 10";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_13-1.png";s:12:"tmpl_created";i:1520520760;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:187;s:16:"popularity_index";i:190;s:11:"trend_index";i:118;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:513;a:20:{s:4:"tmpl";i:633;s:2:"id";i:5930;s:5:"title";s:6:"CTA 11";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_15.png";s:12:"tmpl_created";i:1520520758;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:190;s:16:"popularity_index";i:76;s:11:"trend_index";i:84;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:514;a:20:{s:4:"tmpl";i:632;s:2:"id";i:5921;s:5:"title";s:6:"CTA 12";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_14.png";s:12:"tmpl_created";i:1520520757;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:192;s:16:"popularity_index";i:278;s:11:"trend_index";i:234;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:515;a:20:{s:4:"tmpl";i:618;s:2:"id";i:5607;s:5:"title";s:6:"CTA 13";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_5.png";s:12:"tmpl_created";i:1520520695;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:194;s:16:"popularity_index";i:42;s:11:"trend_index";i:11;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:516;a:20:{s:4:"tmpl";i:574;s:2:"id";i:6017;s:5:"title";s:6:"CTA 14";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_14.png";s:12:"tmpl_created";i:1520520331;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:196;s:16:"popularity_index";i:152;s:11:"trend_index";i:122;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:517;a:20:{s:4:"tmpl";i:628;s:2:"id";i:5885;s:5:"title";s:6:"CTA 15";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_11.png";s:12:"tmpl_created";i:1520520751;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:197;s:16:"popularity_index";i:274;s:11:"trend_index";i:256;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:518;a:20:{s:4:"tmpl";i:627;s:2:"id";i:5877;s:5:"title";s:6:"CTA 16";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_10.png";s:12:"tmpl_created";i:1520520749;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:200;s:16:"popularity_index";i:564;s:11:"trend_index";i:677;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:519;a:20:{s:4:"tmpl";i:625;s:2:"id";i:5860;s:5:"title";s:6:"CTA 17";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_9.png";s:12:"tmpl_created";i:1520520746;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:201;s:16:"popularity_index";i:120;s:11:"trend_index";i:63;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:520;a:20:{s:4:"tmpl";i:626;s:2:"id";i:5869;s:5:"title";s:6:"CTA 18";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_10.png";s:12:"tmpl_created";i:1520520747;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:204;s:16:"popularity_index";i:345;s:11:"trend_index";i:486;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:521;a:20:{s:4:"tmpl";i:611;s:2:"id";i:5542;s:5:"title";s:6:"CTA 19";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_1.png";s:12:"tmpl_created";i:1520520681;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:205;s:16:"popularity_index";i:169;s:11:"trend_index";i:270;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:522;a:20:{s:4:"tmpl";i:614;s:2:"id";i:5567;s:5:"title";s:5:"CTA 2";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_2.png";s:12:"tmpl_created";i:1520520685;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:207;s:16:"popularity_index";i:143;s:11:"trend_index";i:225;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:523;a:20:{s:4:"tmpl";i:629;s:2:"id";i:5893;s:5:"title";s:6:"CTA 21";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_12.png";s:12:"tmpl_created";i:1520520752;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:210;s:16:"popularity_index";i:259;s:11:"trend_index";i:457;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:524;a:20:{s:4:"tmpl";i:619;s:2:"id";i:5634;s:5:"title";s:6:"CTA 24";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_6.png";s:12:"tmpl_created";i:1520520699;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-24/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:212;s:16:"popularity_index";i:188;s:11:"trend_index";i:255;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:525;a:20:{s:4:"tmpl";i:620;s:2:"id";i:5642;s:5:"title";s:6:"CTA 25";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_6.png";s:12:"tmpl_created";i:1520520701;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-25/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:214;s:16:"popularity_index";i:226;s:11:"trend_index";i:262;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:526;a:20:{s:4:"tmpl";i:615;s:2:"id";i:5583;s:5:"title";s:6:"CTA 26";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_3.png";s:12:"tmpl_created";i:1520520689;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-26/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:216;s:16:"popularity_index";i:117;s:11:"trend_index";i:117;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:527;a:20:{s:4:"tmpl";i:630;s:2:"id";i:5904;s:5:"title";s:6:"CTA 27";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_13.png";s:12:"tmpl_created";i:1520520754;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-27/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:217;s:16:"popularity_index";i:528;s:11:"trend_index";i:517;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:528;a:20:{s:4:"tmpl";i:631;s:2:"id";i:5912;s:5:"title";s:6:"CTA 28";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_11.png";s:12:"tmpl_created";i:1520520755;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-28/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:219;s:16:"popularity_index";i:665;s:11:"trend_index";i:702;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:529;a:20:{s:4:"tmpl";i:473;s:2:"id";i:5189;s:5:"title";s:6:"CTA 29";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_1.png";s:12:"tmpl_created";i:1520443456;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-29/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"call to action";s:4:"tags";s:8:"["Form"]";s:10:"menu_order";i:221;s:16:"popularity_index";i:472;s:11:"trend_index";i:631;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:530;a:20:{s:4:"tmpl";i:623;s:2:"id";i:5667;s:5:"title";s:5:"CTA 3";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_8.png";s:12:"tmpl_created";i:1520520705;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:222;s:16:"popularity_index";i:171;s:11:"trend_index";i:250;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:531;a:20:{s:4:"tmpl";i:474;s:2:"id";i:5198;s:5:"title";s:6:"CTA 30";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_black_1.png";s:12:"tmpl_created";i:1520443458;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-30/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"call to action";s:4:"tags";s:8:"["Form"]";s:10:"menu_order";i:225;s:16:"popularity_index";i:572;s:11:"trend_index";i:511;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:532;a:20:{s:4:"tmpl";i:475;s:2:"id";i:5206;s:5:"title";s:6:"CTA 31";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_black_2.png";s:12:"tmpl_created";i:1520443459;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-31/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"call to action";s:4:"tags";s:8:"["Form"]";s:10:"menu_order";i:226;s:16:"popularity_index";i:593;s:11:"trend_index";i:611;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:533;a:20:{s:4:"tmpl";i:480;s:2:"id";i:5249;s:5:"title";s:6:"CTA 32";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_black_4.png";s:12:"tmpl_created";i:1520443470;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-32/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"call to action";s:4:"tags";s:8:"["Form"]";s:10:"menu_order";i:228;s:16:"popularity_index";i:512;s:11:"trend_index";i:409;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:534;a:20:{s:4:"tmpl";i:612;s:2:"id";i:5550;s:5:"title";s:6:"CTA 33";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_1.png";s:12:"tmpl_created";i:1520520682;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-33/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:231;s:16:"popularity_index";i:260;s:11:"trend_index";i:562;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:535;a:20:{s:4:"tmpl";i:536;s:2:"id";i:5852;s:5:"title";s:6:"CTA 34";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2018/03/form_1.png";s:12:"tmpl_created";i:1520443600;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-34/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:8:"["Form"]";s:10:"menu_order";i:232;s:16:"popularity_index";i:563;s:11:"trend_index";i:828;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:536;a:20:{s:4:"tmpl";i:624;s:2:"id";i:5675;s:5:"title";s:5:"CTA 4";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_8.png";s:12:"tmpl_created";i:1520520707;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:235;s:16:"popularity_index";i:391;s:11:"trend_index";i:484;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:537;a:20:{s:4:"tmpl";i:616;s:2:"id";i:5591;s:5:"title";s:5:"CTA 5";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_4.png";s:12:"tmpl_created";i:1520520691;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:237;s:16:"popularity_index";i:133;s:11:"trend_index";i:130;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:538;a:20:{s:4:"tmpl";i:617;s:2:"id";i:5599;s:5:"title";s:5:"CTA 6";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_4.png";s:12:"tmpl_created";i:1520520693;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:239;s:16:"popularity_index";i:252;s:11:"trend_index";i:362;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:539;a:20:{s:4:"tmpl";i:514;s:2:"id";i:5575;s:5:"title";s:5:"CTA 7";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_3.png";s:12:"tmpl_created";i:1520443543;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:240;s:16:"popularity_index";i:13;s:11:"trend_index";i:586;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:540;a:20:{s:4:"tmpl";i:622;s:2:"id";i:5658;s:5:"title";s:5:"CTA 8";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_7.png";s:12:"tmpl_created";i:1520520704;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:243;s:16:"popularity_index";i:187;s:11:"trend_index";i:235;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:541;a:20:{s:4:"tmpl";i:621;s:2:"id";i:5650;s:5:"title";s:5:"CTA 9";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_7.png";s:12:"tmpl_created";i:1520520702;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:244;s:16:"popularity_index";i:94;s:11:"trend_index";i:148;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:542;a:20:{s:4:"tmpl";i:1061;s:2:"id";i:15407;s:5:"title";s:24:"Dance Studio &#8211; 404";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2020/10/404.jpg";s:12:"tmpl_created";i:1603181958;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/dance-studio-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:22:"["404","Dance Studio"]";s:10:"menu_order";i:246;s:16:"popularity_index";i:783;s:11:"trend_index";i:710;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:543;a:20:{s:4:"tmpl";i:1062;s:2:"id";i:15400;s:5:"title";s:27:"Dance Studio &#8211; Footer";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/10/Footer.jpg";s:12:"tmpl_created";i:1603181989;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/dance-studio-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:25:"["Dance Studio","Footer"]";s:10:"menu_order";i:247;s:16:"popularity_index";i:586;s:11:"trend_index";i:243;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:544;a:20:{s:4:"tmpl";i:1063;s:2:"id";i:15391;s:5:"title";s:27:"Dance Studio &#8211; Header";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/10/Header.jpg";s:12:"tmpl_created";i:1603182011;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/dance-studio-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:25:"["Dance Studio","Header"]";s:10:"menu_order";i:248;s:16:"popularity_index";i:352;s:11:"trend_index";i:67;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:545;a:20:{s:4:"tmpl";i:874;s:2:"id";i:11192;s:5:"title";s:14:"Digital Agency";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2019/07/Footer_small.jpg";s:12:"tmpl_created";i:1564642399;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/digital-agency-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:39:"["Digital Agency","Footer","Marketing"]";s:10:"menu_order";i:250;s:16:"popularity_index";i:172;s:11:"trend_index";i:105;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:546;a:20:{s:4:"tmpl";i:873;s:2:"id";i:11198;s:5:"title";s:14:"Digital Agency";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2020/06/Header-digital-marketing-agency.png";s:12:"tmpl_created";i:1564642395;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/digital-agency-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:39:"["Digital Agency","Header","Marketing"]";s:10:"menu_order";i:251;s:16:"popularity_index";i:34;s:11:"trend_index";i:10;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:547;a:20:{s:4:"tmpl";i:872;s:2:"id";i:11204;s:5:"title";s:14:"Digital Agency";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2019/07/404_small.jpg";s:12:"tmpl_created";i:1564642389;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/digital-agency-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:36:"["404","Digital Agency","Marketing"]";s:10:"menu_order";i:253;s:16:"popularity_index";i:301;s:11:"trend_index";i:239;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:548;a:20:{s:4:"tmpl";i:871;s:2:"id";i:11220;s:5:"title";s:14:"Digital Agency";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2019/08/Archive_small1.png";s:12:"tmpl_created";i:1564642385;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/digital-agency-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:30:"["Digital Agency","Marketing"]";s:10:"menu_order";i:255;s:16:"popularity_index";i:116;s:11:"trend_index";i:73;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:549;a:20:{s:4:"tmpl";i:870;s:2:"id";i:11231;s:5:"title";s:14:"Digital Agency";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2019/07/Post_small1.png";s:12:"tmpl_created";i:1564642380;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/digital-agency/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:30:"["Digital Agency","Marketing"]";s:10:"menu_order";i:257;s:16:"popularity_index";i:145;s:11:"trend_index";i:71;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:550;a:20:{s:4:"tmpl";i:520;s:2:"id";i:5711;s:5:"title";s:5:"FAQ 1";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_2.png";s:12:"tmpl_created";i:1520443571;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/faq-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:260;s:16:"popularity_index";i:200;s:11:"trend_index";i:231;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:551;a:20:{s:4:"tmpl";i:523;s:2:"id";i:5737;s:5:"title";s:6:"FAQ 10";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_4.png";s:12:"tmpl_created";i:1520443576;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/faq-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:261;s:16:"popularity_index";i:155;s:11:"trend_index";i:112;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:552;a:20:{s:4:"tmpl";i:524;s:2:"id";i:5746;s:5:"title";s:6:"FAQ 11";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_4.png";s:12:"tmpl_created";i:1520443578;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/faq-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:264;s:16:"popularity_index";i:212;s:11:"trend_index";i:305;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:553;a:20:{s:4:"tmpl";i:519;s:2:"id";i:5703;s:5:"title";s:6:"FAQ 13";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_2.png";s:12:"tmpl_created";i:1520443569;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/faq-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:265;s:16:"popularity_index";i:29;s:11:"trend_index";i:38;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:554;a:20:{s:4:"tmpl";i:521;s:2:"id";i:5719;s:5:"title";s:5:"FAQ 4";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_3.png";s:12:"tmpl_created";i:1520443573;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/faq-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:267;s:16:"popularity_index";i:125;s:11:"trend_index";i:251;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:555;a:20:{s:4:"tmpl";i:522;s:2:"id";i:5729;s:5:"title";s:5:"FAQ 5";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_3.png";s:12:"tmpl_created";i:1520443575;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/faq-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:269;s:16:"popularity_index";i:319;s:11:"trend_index";i:327;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:556;a:20:{s:4:"tmpl";i:525;s:2:"id";i:5755;s:5:"title";s:5:"FAQ 6";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_5.png";s:12:"tmpl_created";i:1520443580;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/faq-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:271;s:16:"popularity_index";i:112;s:11:"trend_index";i:180;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:557;a:20:{s:4:"tmpl";i:526;s:2:"id";i:5764;s:5:"title";s:5:"FAQ 7";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_5.png";s:12:"tmpl_created";i:1520443582;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/faq-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:273;s:16:"popularity_index";i:338;s:11:"trend_index";i:474;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:558;a:20:{s:4:"tmpl";i:517;s:2:"id";i:5684;s:5:"title";s:5:"FAQ 8";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_1.png";s:12:"tmpl_created";i:1520443565;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/faq-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:274;s:16:"popularity_index";i:74;s:11:"trend_index";i:193;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:559;a:20:{s:4:"tmpl";i:518;s:2:"id";i:5693;s:5:"title";s:5:"FAQ 9";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_1.png";s:12:"tmpl_created";i:1520443567;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/faq-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:276;s:16:"popularity_index";i:224;s:11:"trend_index";i:515;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:560;a:20:{s:4:"tmpl";i:548;s:2:"id";i:6053;s:5:"title";s:10:"Features 1";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_black_5.png";s:12:"tmpl_created";i:1520443645;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:277;s:16:"popularity_index";i:179;s:11:"trend_index";i:463;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:561;a:20:{s:4:"tmpl";i:542;s:2:"id";i:5991;s:5:"title";s:11:"Features 10";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_4.png";s:12:"tmpl_created";i:1520443632;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/features-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:279;s:16:"popularity_index";i:135;s:11:"trend_index";i:265;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:562;a:20:{s:4:"tmpl";i:547;s:2:"id";i:6044;s:5:"title";s:11:"Features 11";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_5.png";s:12:"tmpl_created";i:1520443643;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/features-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:280;s:16:"popularity_index";i:70;s:11:"trend_index";i:163;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:563;a:20:{s:4:"tmpl";i:566;s:2:"id";i:6212;s:5:"title";s:11:"Features 12";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_7.png";s:12:"tmpl_created";i:1520443684;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/features-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:281;s:16:"popularity_index";i:81;s:11:"trend_index";i:98;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:564;a:20:{s:4:"tmpl";i:567;s:2:"id";i:6220;s:5:"title";s:10:"Features 2";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_8.png";s:12:"tmpl_created";i:1520443685;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:282;s:16:"popularity_index";i:88;s:11:"trend_index";i:189;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:565;a:20:{s:4:"tmpl";i:541;s:2:"id";i:5983;s:5:"title";s:10:"Features 3";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_black_3.png";s:12:"tmpl_created";i:1520443630;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:2:"[]";s:10:"menu_order";i:283;s:16:"popularity_index";i:231;s:11:"trend_index";i:351;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:566;a:20:{s:4:"tmpl";i:540;s:2:"id";i:5974;s:5:"title";s:10:"Features 4";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_3.png";s:12:"tmpl_created";i:1520443629;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:286;s:16:"popularity_index";i:69;s:11:"trend_index";i:181;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:567;a:20:{s:4:"tmpl";i:516;s:2:"id";i:5624;s:5:"title";s:10:"Features 5";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_black_1.png";s:12:"tmpl_created";i:1520443553;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:287;s:16:"popularity_index";i:93;s:11:"trend_index";i:352;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:568;a:20:{s:4:"tmpl";i:515;s:2:"id";i:5615;s:5:"title";s:10:"Features 6";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_5.png";s:12:"tmpl_created";i:1520443551;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:290;s:16:"popularity_index";i:41;s:11:"trend_index";i:119;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:569;a:20:{s:4:"tmpl";i:539;s:2:"id";i:5963;s:5:"title";s:10:"Features 7";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_2.png";s:12:"tmpl_created";i:1520443626;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:291;s:16:"popularity_index";i:67;s:11:"trend_index";i:133;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:570;a:20:{s:4:"tmpl";i:565;s:2:"id";i:6204;s:5:"title";s:10:"Features 8";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_6.png";s:12:"tmpl_created";i:1520443681;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:292;s:16:"popularity_index";i:217;s:11:"trend_index";i:223;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:571;a:20:{s:4:"tmpl";i:564;s:2:"id";i:6196;s:5:"title";s:10:"Features 9";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_6.png";s:12:"tmpl_created";i:1520443680;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:294;s:16:"popularity_index";i:106;s:11:"trend_index";i:113;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:572;a:20:{s:4:"tmpl";i:1033;s:2:"id";i:15033;s:5:"title";s:28:"Flooring Company &#8211; 404";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2020/08/404.png";s:12:"tmpl_created";i:1597739459;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/blocks/flooring-company-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:45:"["404","Flooring company","Flooring website"]";s:10:"menu_order";i:296;s:16:"popularity_index";i:655;s:11:"trend_index";i:671;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:573;a:20:{s:4:"tmpl";i:1032;s:2:"id";i:15042;s:5:"title";s:32:"Flooring Company &#8211; Archive";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/08/Blog.png";s:12:"tmpl_created";i:1597739084;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/blocks/flooring-company-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:297;s:16:"popularity_index";i:320;s:11:"trend_index";i:275;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:574;a:20:{s:4:"tmpl";i:1031;s:2:"id";i:15017;s:5:"title";s:31:"Flooring Company &#8211; Footer";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/08/Footer.png";s:12:"tmpl_created";i:1597738933;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/blocks/flooring-company-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:48:"["Flooring company","Flooring website","Footer"]";s:10:"menu_order";i:299;s:16:"popularity_index";i:323;s:11:"trend_index";i:192;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:575;a:20:{s:4:"tmpl";i:1030;s:2:"id";i:15007;s:5:"title";s:31:"Flooring Company &#8211; Header";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/08/Header.png";s:12:"tmpl_created";i:1597738896;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/blocks/flooring-company-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:48:"["Flooring company","Flooring website","Header"]";s:10:"menu_order";i:302;s:16:"popularity_index";i:459;s:11:"trend_index";i:333;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:576;a:20:{s:4:"tmpl";i:1029;s:2:"id";i:15052;s:5:"title";s:36:"Flooring Company &#8211; Single post";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/08/Single.png";s:12:"tmpl_created";i:1597738858;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/blocks/flooring-company-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:303;s:16:"popularity_index";i:392;s:11:"trend_index";i:226;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:577;a:20:{s:4:"tmpl";i:651;s:2:"id";i:7837;s:5:"title";s:9:"footer 01";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.14.jpg";s:12:"tmpl_created";i:1524582852;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:305;s:16:"popularity_index";i:495;s:11:"trend_index";i:539;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:578;a:20:{s:4:"tmpl";i:647;s:2:"id";i:7937;s:5:"title";s:10:"footer 010";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.5.jpg";s:12:"tmpl_created";i:1524582665;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/footer-010/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:308;s:16:"popularity_index";i:185;s:11:"trend_index";i:115;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:579;a:20:{s:4:"tmpl";i:646;s:2:"id";i:7950;s:5:"title";s:10:"footer 011";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.4.jpg";s:12:"tmpl_created";i:1524582631;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/footer-011/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:310;s:16:"popularity_index";i:244;s:11:"trend_index";i:203;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:580;a:20:{s:4:"tmpl";i:645;s:2:"id";i:7959;s:5:"title";s:10:"footer 012";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.3.jpg";s:12:"tmpl_created";i:1524582605;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/footer-012/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:311;s:16:"popularity_index";i:177;s:11:"trend_index";i:140;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:581;a:20:{s:4:"tmpl";i:644;s:2:"id";i:7982;s:5:"title";s:10:"footer 013";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.2.jpg";s:12:"tmpl_created";i:1524582468;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/footer-013/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:314;s:16:"popularity_index";i:209;s:11:"trend_index";i:212;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:582;a:20:{s:4:"tmpl";i:643;s:2:"id";i:7997;s:5:"title";s:10:"footer 014";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.1.jpg";s:12:"tmpl_created";i:1524582343;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/footer-014/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:316;s:16:"popularity_index";i:64;s:11:"trend_index";i:41;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:583;a:20:{s:4:"tmpl";i:693;s:2:"id";i:9119;s:5:"title";s:10:"footer 015";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/07/Footer_GetStarted_350.png";s:12:"tmpl_created";i:1532428138;s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/blocks/demo/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:317;s:16:"popularity_index";i:240;s:11:"trend_index";i:154;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:584;a:20:{s:4:"tmpl";i:652;s:2:"id";i:7852;s:5:"title";s:9:"footer 02";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.13.jpg";s:12:"tmpl_created";i:1524582875;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:320;s:16:"popularity_index";i:199;s:11:"trend_index";i:96;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:585;a:20:{s:4:"tmpl";i:653;s:2:"id";i:7862;s:5:"title";s:9:"footer 03";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.12.jpg";s:12:"tmpl_created";i:1524582903;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:321;s:16:"popularity_index";i:137;s:11:"trend_index";i:91;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:586;a:20:{s:4:"tmpl";i:654;s:2:"id";i:7871;s:5:"title";s:9:"footer 04";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.11.jpg";s:12:"tmpl_created";i:1524582927;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:323;s:16:"popularity_index";i:97;s:11:"trend_index";i:55;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:587;a:20:{s:4:"tmpl";i:655;s:2:"id";i:7884;s:5:"title";s:9:"footer 05";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.10.jpg";s:12:"tmpl_created";i:1524582944;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:325;s:16:"popularity_index";i:92;s:11:"trend_index";i:109;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:588;a:20:{s:4:"tmpl";i:656;s:2:"id";i:7892;s:5:"title";s:9:"footer 06";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.9.jpg";s:12:"tmpl_created";i:1524583015;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:326;s:16:"popularity_index";i:132;s:11:"trend_index";i:146;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:589;a:20:{s:4:"tmpl";i:650;s:2:"id";i:7904;s:5:"title";s:9:"footer 07";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.8.jpg";s:12:"tmpl_created";i:1524582814;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:328;s:16:"popularity_index";i:203;s:11:"trend_index";i:186;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:590;a:20:{s:4:"tmpl";i:649;s:2:"id";i:7917;s:5:"title";s:9:"footer 08";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.7.jpg";s:12:"tmpl_created";i:1524582788;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:329;s:16:"popularity_index";i:89;s:11:"trend_index";i:144;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:591;a:20:{s:4:"tmpl";i:648;s:2:"id";i:7927;s:5:"title";s:9:"footer 09";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.6.jpg";s:12:"tmpl_created";i:1524582691;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:331;s:16:"popularity_index";i:178;s:11:"trend_index";i:100;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:592;a:20:{s:4:"tmpl";i:642;s:2:"id";i:4676;s:5:"title";s:8:"Footer 7";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/footer_7.png";s:12:"tmpl_created";i:1522014215;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/footer_7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:10:"["Footer"]";s:10:"menu_order";i:338;s:16:"popularity_index";i:237;s:11:"trend_index";i:346;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:593;a:20:{s:4:"tmpl";i:637;s:2:"id";i:7627;s:5:"title";s:8:"Footer 8";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_1.png";s:12:"tmpl_created";i:1521547332;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/footer-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:10:"["Footer"]";s:10:"menu_order";i:340;s:16:"popularity_index";i:100;s:11:"trend_index";i:83;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:594;a:20:{s:4:"tmpl";i:638;s:2:"id";i:7638;s:5:"title";s:8:"Footer 9";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_2.png";s:12:"tmpl_created";i:1521547502;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/footer-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:10:"["Footer"]";s:10:"menu_order";i:342;s:16:"popularity_index";i:124;s:11:"trend_index";i:147;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:595;a:20:{s:4:"tmpl";i:888;s:2:"id";i:11424;s:5:"title";s:3:"GYM";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2019/08/404_Small.png";s:12:"tmpl_created";i:1567393309;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/gym-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:13:"["404","Gym"]";s:10:"menu_order";i:344;s:16:"popularity_index";i:679;s:11:"trend_index";i:769;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:596;a:20:{s:4:"tmpl";i:887;s:2:"id";i:11435;s:5:"title";s:3:"GYM";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2019/08/Archiv_Small.png";s:12:"tmpl_created";i:1567393296;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/gym-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:346;s:16:"popularity_index";i:441;s:11:"trend_index";i:507;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:597;a:20:{s:4:"tmpl";i:886;s:2:"id";i:11445;s:5:"title";s:3:"GYM";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2019/08/Post_Small.png";s:12:"tmpl_created";i:1567393229;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/gym-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:349;s:16:"popularity_index";i:452;s:11:"trend_index";i:479;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:598;a:20:{s:4:"tmpl";i:885;s:2:"id";i:11453;s:5:"title";s:3:"GYM";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2019/08/Footer_Small.png";s:12:"tmpl_created";i:1567393224;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/gym-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:16:"["Footer","Gym"]";s:10:"menu_order";i:351;s:16:"popularity_index";i:270;s:11:"trend_index";i:331;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:599;a:20:{s:4:"tmpl";i:884;s:2:"id";i:11461;s:5:"title";s:3:"GYM";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2020/06/Header-gym-and-fitness.png";s:12:"tmpl_created";i:1567393219;s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/blocks/gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:16:"["Gym","Header"]";s:10:"menu_order";i:352;s:16:"popularity_index";i:201;s:11:"trend_index";i:135;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:600;a:20:{s:4:"tmpl";i:635;s:2:"id";i:7596;s:5:"title";s:8:"Header 1";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/header350.12.jpg";s:12:"tmpl_created";i:1521546999;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:10:"["Header"]";s:10:"menu_order";i:354;s:16:"popularity_index";i:33;s:11:"trend_index";i:17;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:601;a:20:{s:4:"tmpl";i:663;s:2:"id";i:7801;s:5:"title";s:9:"header 10";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.9.jpg";s:12:"tmpl_created";i:1524583659;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/header-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:356;s:16:"popularity_index";i:51;s:11:"trend_index";i:14;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:602;a:20:{s:4:"tmpl";i:658;s:2:"id";i:7812;s:5:"title";s:9:"header 11";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/header350.10.jpg";s:12:"tmpl_created";i:1524583298;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/header-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:358;s:16:"popularity_index";i:96;s:11:"trend_index";i:103;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:603;a:20:{s:4:"tmpl";i:657;s:2:"id";i:7825;s:5:"title";s:9:"header 12";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/header350.11.jpg";s:12:"tmpl_created";i:1524583273;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/header-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:360;s:16:"popularity_index";i:63;s:11:"trend_index";i:75;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:604;a:20:{s:4:"tmpl";i:694;s:2:"id";i:9127;s:5:"title";s:9:"header 13";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2018/07/Header_get_started_1200V3.png";s:12:"tmpl_created";i:1532428699;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/header-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:362;s:16:"popularity_index";i:61;s:11:"trend_index";i:58;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:605;a:20:{s:4:"tmpl";i:636;s:2:"id";i:7615;s:5:"title";s:8:"Header 2";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.1.jpg";s:12:"tmpl_created";i:1521547237;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:10:"["Header"]";s:10:"menu_order";i:365;s:16:"popularity_index";i:30;s:11:"trend_index";i:33;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:606;a:20:{s:4:"tmpl";i:665;s:2:"id";i:7713;s:5:"title";s:8:"header 3";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.2.jpg";s:12:"tmpl_created";i:1524584780;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:367;s:16:"popularity_index";i:43;s:11:"trend_index";i:28;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:607;a:20:{s:4:"tmpl";i:659;s:2:"id";i:7724;s:5:"title";s:8:"header 4";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.3.jpg";s:12:"tmpl_created";i:1524583367;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:369;s:16:"popularity_index";i:24;s:11:"trend_index";i:13;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:608;a:20:{s:4:"tmpl";i:660;s:2:"id";i:7734;s:5:"title";s:8:"header 5";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.4.jpg";s:12:"tmpl_created";i:1524583436;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:371;s:16:"popularity_index";i:36;s:11:"trend_index";i:18;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:609;a:20:{s:4:"tmpl";i:666;s:2:"id";i:7744;s:5:"title";s:8:"Header 6";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.5.jpg";s:12:"tmpl_created";i:1524584784;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:372;s:16:"popularity_index";i:65;s:11:"trend_index";i:94;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:610;a:20:{s:4:"tmpl";i:664;s:2:"id";i:7754;s:5:"title";s:8:"header 7";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.6.jpg";s:12:"tmpl_created";i:1524583712;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:375;s:16:"popularity_index";i:111;s:11:"trend_index";i:143;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:611;a:20:{s:4:"tmpl";i:661;s:2:"id";i:7771;s:5:"title";s:8:"header 8";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.7.jpg";s:12:"tmpl_created";i:1524583540;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:376;s:16:"popularity_index";i:91;s:11:"trend_index";i:60;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:612;a:20:{s:4:"tmpl";i:662;s:2:"id";i:7787;s:5:"title";s:8:"header 9";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.8.jpg";s:12:"tmpl_created";i:1524583598;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:379;s:16:"popularity_index";i:102;s:11:"trend_index";i:78;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:613;a:20:{s:4:"tmpl";i:572;s:2:"id";i:6266;s:5:"title";s:6:"Hero 1";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_4.png";s:12:"tmpl_created";i:1520443695;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";i:380;s:16:"popularity_index";i:52;s:11:"trend_index";i:35;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:614;a:20:{s:4:"tmpl";i:528;s:2:"id";i:5783;s:5:"title";s:7:"Hero 10";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/header_2.png";s:12:"tmpl_created";i:1520443586;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/hero-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"hero";s:4:"tags";s:2:"[]";s:10:"menu_order";i:383;s:16:"popularity_index";i:365;s:11:"trend_index";i:567;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:615;a:20:{s:4:"tmpl";i:527;s:2:"id";i:5773;s:5:"title";s:7:"Hero 11";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/header_1.png";s:12:"tmpl_created";i:1520443584;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/hero-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"hero";s:4:"tags";s:2:"[]";s:10:"menu_order";i:384;s:16:"popularity_index";i:39;s:11:"trend_index";i:179;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:616;a:20:{s:4:"tmpl";i:479;s:2:"id";i:5238;s:5:"title";s:7:"Hero 12";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4.png";s:12:"tmpl_created";i:1520443468;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/hero-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";i:386;s:16:"popularity_index";i:611;s:11:"trend_index";i:555;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:617;a:20:{s:4:"tmpl";i:573;s:2:"id";i:6274;s:5:"title";s:6:"Hero 2";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_5.png";s:12:"tmpl_created";i:1520443698;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";i:389;s:16:"popularity_index";i:87;s:11:"trend_index";i:88;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:618;a:20:{s:4:"tmpl";i:569;s:2:"id";i:6239;s:5:"title";s:6:"Hero 3";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_1.png";s:12:"tmpl_created";i:1520443689;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";i:391;s:16:"popularity_index";i:23;s:11:"trend_index";i:34;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:619;a:20:{s:4:"tmpl";i:571;s:2:"id";i:6258;s:5:"title";s:6:"Hero 4";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_3.png";s:12:"tmpl_created";i:1520443693;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";i:393;s:16:"popularity_index";i:479;s:11:"trend_index";i:470;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:620;a:20:{s:4:"tmpl";i:570;s:2:"id";i:6249;s:5:"title";s:6:"Hero 5";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_2.png";s:12:"tmpl_created";i:1520443691;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";i:395;s:16:"popularity_index";i:56;s:11:"trend_index";i:85;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:621;a:20:{s:4:"tmpl";i:568;s:2:"id";i:6230;s:5:"title";s:6:"Hero 6";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_white_1.png";s:12:"tmpl_created";i:1520443687;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";i:396;s:16:"popularity_index";i:406;s:11:"trend_index";i:542;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:622;a:20:{s:4:"tmpl";i:530;s:2:"id";i:5801;s:5:"title";s:6:"Hero 7";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/header_4.png";s:12:"tmpl_created";i:1520443589;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";i:398;s:16:"popularity_index";i:15;s:11:"trend_index";i:37;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:623;a:20:{s:4:"tmpl";i:531;s:2:"id";i:5811;s:5:"title";s:6:"Hero 8";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/header_5.png";s:12:"tmpl_created";i:1520443591;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"hero";s:4:"tags";s:2:"[]";s:10:"menu_order";i:400;s:16:"popularity_index";i:105;s:11:"trend_index";i:86;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:624;a:20:{s:4:"tmpl";i:529;s:2:"id";i:5792;s:5:"title";s:6:"Hero 9";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/header_3.png";s:12:"tmpl_created";i:1520443588;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"hero";s:4:"tags";s:2:"[]";s:10:"menu_order";i:403;s:16:"popularity_index";i:225;s:11:"trend_index";i:244;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:625;a:20:{s:4:"tmpl";i:978;s:2:"id";i:13251;s:5:"title";s:27:"Interior Design &#8211; 404";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2020/04/404.png";s:12:"tmpl_created";i:1586148737;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/interior-design-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:30:"["Business","Interior Design"]";s:10:"menu_order";i:405;s:16:"popularity_index";i:730;s:11:"trend_index";i:795;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:626;a:20:{s:4:"tmpl";i:979;s:2:"id";i:13244;s:5:"title";s:30:"Interior Design &#8211; Footer";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/04/Footer.png";s:12:"tmpl_created";i:1586148742;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/blocks/interior-design-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:39:"["Business","Footer","Interior Design"]";s:10:"menu_order";i:406;s:16:"popularity_index";i:322;s:11:"trend_index";i:178;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:627;a:20:{s:4:"tmpl";i:980;s:2:"id";i:13236;s:5:"title";s:30:"Interior Design &#8211; Header";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2020/06/Header-interior-design.png";s:12:"tmpl_created";i:1586148746;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/blocks/interior-design-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:39:"["Business","Header","Interior Design"]";s:10:"menu_order";i:408;s:16:"popularity_index";i:146;s:11:"trend_index";i:64;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:628;a:20:{s:4:"tmpl";i:977;s:2:"id";i:13259;s:5:"title";s:36:"Interior Design &#8211; News Archive";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2020/04/Archiv-Blog.png";s:12:"tmpl_created";i:1586148733;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/blocks/interior-design-news-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:30:"["Business","Interior Design"]";s:10:"menu_order";i:410;s:16:"popularity_index";i:436;s:11:"trend_index";i:132;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:629;a:20:{s:4:"tmpl";i:976;s:2:"id";i:13267;s:5:"title";s:35:"Interior Design &#8211; Single News";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/04/Post.png";s:12:"tmpl_created";i:1586148728;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/blocks/interior-design-single-news/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:30:"["Business","Interior Design"]";s:10:"menu_order";i:413;s:16:"popularity_index";i:402;s:11:"trend_index";i:108;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:630;a:20:{s:4:"tmpl";i:975;s:2:"id";i:13274;s:5:"title";s:38:"Interior Design &#8211; Single Project";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2020/04/Single-Project-.png";s:12:"tmpl_created";i:1586148723;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/blocks/interior-design-single-project/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:30:"["Business","Interior Design"]";s:10:"menu_order";i:414;s:16:"popularity_index";i:601;s:11:"trend_index";i:324;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:631;a:20:{s:4:"tmpl";i:1011;s:2:"id";i:14058;s:5:"title";s:36:"Japanese restaurant &#8211; 404 page";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/06/404-Page.jpg";s:12:"tmpl_created";i:1592290211;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/blocks/japanese-restaurant-404-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:38:"["404","Food","Japanese","Restaurant"]";s:10:"menu_order";i:416;s:16:"popularity_index";i:724;s:11:"trend_index";i:647;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:632;a:20:{s:4:"tmpl";i:1012;s:2:"id";i:14050;s:5:"title";s:34:"Japanese restaurant &#8211; Footer";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2020/06/Footer-Small.jpg";s:12:"tmpl_created";i:1592290247;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/blocks/japanese-restaurant-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:41:"["Food","Footer","Japanese","Restaurant"]";s:10:"menu_order";i:419;s:16:"popularity_index";i:317;s:11:"trend_index";i:238;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:633;a:20:{s:4:"tmpl";i:1013;s:2:"id";i:14042;s:5:"title";s:34:"Japanese Restaurant &#8211; Header";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2020/06/japanese-restaurant-header.jpg";s:12:"tmpl_created";i:1592290277;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/blocks/japanese-restaurant-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:41:"["Food","Header","Japanese","Restaurant"]";s:10:"menu_order";i:421;s:16:"popularity_index";i:411;s:11:"trend_index";i:274;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:634;a:20:{s:4:"tmpl";i:914;s:2:"id";i:12164;s:5:"title";s:20:"Law Firm &#8211; 404";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2019/11/404.png";s:12:"tmpl_created";i:1572846979;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/law-firm-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:24:"["404","Law","Law Firm"]";s:10:"menu_order";i:422;s:16:"popularity_index";i:704;s:11:"trend_index";i:716;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:635;a:20:{s:4:"tmpl";i:913;s:2:"id";i:12170;s:5:"title";s:23:"Law Firm &#8211; Archiv";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2019/11/archiv.png";s:12:"tmpl_created";i:1572846967;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/blocks/law-firm-archiv/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:424;s:16:"popularity_index";i:431;s:11:"trend_index";i:294;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:636;a:20:{s:4:"tmpl";i:912;s:2:"id";i:12179;s:5:"title";s:23:"Law Firm &#8211; Footer";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2019/11/footer.png";s:12:"tmpl_created";i:1572846958;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/blocks/law-firm-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:27:"["Footer","Law","Law Firm"]";s:10:"menu_order";i:425;s:16:"popularity_index";i:388;s:11:"trend_index";i:240;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:637;a:20:{s:4:"tmpl";i:911;s:2:"id";i:12194;s:5:"title";s:23:"Law Firm &#8211; Header";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2020/06/Header-law-firm.png";s:12:"tmpl_created";i:1572846935;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/blocks/law-firm-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:27:"["Header","Law","Law Firm"]";s:10:"menu_order";i:427;s:16:"popularity_index";i:80;s:11:"trend_index";i:39;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:638;a:20:{s:4:"tmpl";i:910;s:2:"id";i:12203;s:5:"title";s:30:"Law Firm &#8211; Search Archiv";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/11/search_result.png";s:12:"tmpl_created";i:1572846925;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/blocks/law-firm-search-archiv/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:430;s:16:"popularity_index";i:493;s:11:"trend_index";i:433;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:639;a:20:{s:4:"tmpl";i:909;s:2:"id";i:12212;s:5:"title";s:28:"Law Firm &#8211; Single Post";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2019/11/single.png";s:12:"tmpl_created";i:1572846914;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/blocks/law-firm-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:432;s:16:"popularity_index";i:326;s:11:"trend_index";i:214;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:640;a:20:{s:4:"tmpl";i:1022;s:2:"id";i:14772;s:5:"title";s:35:"Luxury Real Estate &#8211; 404 page";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2020/07/404.png";s:12:"tmpl_created";i:1595315728;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/blocks/luxury-real-estate-404-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:34:"["404","Real estate","Realestate"]";s:10:"menu_order";i:433;s:16:"popularity_index";i:759;s:11:"trend_index";i:720;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:641;a:20:{s:4:"tmpl";i:1023;s:2:"id";i:14779;s:5:"title";s:33:"Luxury Real Estate &#8211; Footer";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/07/Footer.png";s:12:"tmpl_created";i:1595315743;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/blocks/luxury-real-estate-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:37:"["Footer","Real estate","Realestate"]";s:10:"menu_order";i:434;s:16:"popularity_index";i:536;s:11:"trend_index";i:505;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:642;a:20:{s:4:"tmpl";i:1024;s:2:"id";i:14790;s:5:"title";s:33:"Luxury Real Estate &#8211; Header";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/07/Header.png";s:12:"tmpl_created";i:1595315760;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/blocks/luxury-real-estate-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:37:"["Header","Real estate","Realestate"]";s:10:"menu_order";i:436;s:16:"popularity_index";i:101;s:11:"trend_index";i:157;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:643;a:20:{s:4:"tmpl";i:1026;s:2:"id";i:14809;s:5:"title";s:45:"Luxury Real Estate &#8211; Properties Archive";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/07/Properties.png";s:12:"tmpl_created";i:1595315826;s:6:"author";s:9:"Elementor";s:3:"url";s:143:"https://library.elementor.com/blocks/luxury-real-estate-properties-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:28:"["Real estate","Realestate"]";s:10:"menu_order";i:438;s:16:"popularity_index";i:414;s:11:"trend_index";i:420;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:644;a:20:{s:4:"tmpl";i:1027;s:2:"id";i:14816;s:5:"title";s:47:"Luxury Real Estate &#8211; Property single post";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2020/07/Single-Property-.png";s:12:"tmpl_created";i:1595315847;s:6:"author";s:9:"Elementor";s:3:"url";s:145:"https://library.elementor.com/blocks/luxury-real-estate-property-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:28:"["Real estate","Realestate"]";s:10:"menu_order";i:441;s:16:"popularity_index";i:541;s:11:"trend_index";i:665;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:645;a:20:{s:4:"tmpl";i:1025;s:2:"id";i:14799;s:5:"title";s:38:"Luxury Real Estate &#8211; single post";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/07/Post.png";s:12:"tmpl_created";i:1595315792;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/blocks/luxury-real-estate-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:28:"["Real estate","Realestate"]";s:10:"menu_order";i:442;s:16:"popularity_index";i:369;s:11:"trend_index";i:441;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:646;a:20:{s:4:"tmpl";i:950;s:2:"id";i:12635;s:5:"title";s:20:"Magazine &#8211; 404";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/01/404_s.png";s:12:"tmpl_created";i:1579060746;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/magazine-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:25:"["404","Blog","Magazine"]";s:10:"menu_order";i:445;s:16:"popularity_index";i:645;s:11:"trend_index";i:734;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:647;a:20:{s:4:"tmpl";i:949;s:2:"id";i:12643;s:5:"title";s:24:"Magazine &#8211; Archiv1";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/01/Archiv1_s.png";s:12:"tmpl_created";i:1579060737;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/magazine-archiv1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:447;s:16:"popularity_index";i:346;s:11:"trend_index";i:272;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:648;a:20:{s:4:"tmpl";i:946;s:2:"id";i:12669;s:5:"title";s:23:"Magazine &#8211; Footer";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/01/Footer_s.png";s:12:"tmpl_created";i:1579060715;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/blocks/magazine-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:28:"["Blog","Footer","Magazine"]";s:10:"menu_order";i:448;s:16:"popularity_index";i:442;s:11:"trend_index";i:349;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:649;a:20:{s:4:"tmpl";i:945;s:2:"id";i:12678;s:5:"title";s:23:"Magazine &#8211; Header";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2020/06/Header-magazine.png";s:12:"tmpl_created";i:1579060701;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/blocks/magazine-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:28:"["Blog","Header","Magazine"]";s:10:"menu_order";i:450;s:16:"popularity_index";i:295;s:11:"trend_index";i:197;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:650;a:20:{s:4:"tmpl";i:947;s:2:"id";i:12661;s:5:"title";s:23:"Magazine &#8211; Search";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/01/Search_s.png";s:12:"tmpl_created";i:1579060722;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/blocks/magazine-search/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:452;s:16:"popularity_index";i:396;s:11:"trend_index";i:509;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:651;a:20:{s:4:"tmpl";i:944;s:2:"id";i:12688;s:5:"title";s:30:"Magazine &#8211; Single Post 1";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/01/Post2_s.png";s:12:"tmpl_created";i:1579060692;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/blocks/magazine-single-post-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:453;s:16:"popularity_index";i:342;s:11:"trend_index";i:175;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:652;a:20:{s:4:"tmpl";i:943;s:2:"id";i:12699;s:5:"title";s:30:"Magazine &#8211; Single Post 2";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/01/Post3_s.png";s:12:"tmpl_created";i:1579060680;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/blocks/magazine-single-post-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:454;s:16:"popularity_index";i:348;s:11:"trend_index";i:129;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:653;a:20:{s:4:"tmpl";i:942;s:2:"id";i:12707;s:5:"title";s:30:"Magazine &#8211; Single Post 3";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/01/Post1_s.png";s:12:"tmpl_created";i:1579060669;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/blocks/magazine-single-post-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:457;s:16:"popularity_index";i:476;s:11:"trend_index";i:246;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:654;a:20:{s:4:"tmpl";i:941;s:2:"id";i:12716;s:5:"title";s:30:"Magazine &#8211; Single Post 3";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/01/Post4_s.png";s:12:"tmpl_created";i:1579060659;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/blocks/magazine-single-post-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:459;s:16:"popularity_index";i:513;s:11:"trend_index";i:489;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:655;a:20:{s:4:"tmpl";i:948;s:2:"id";i:12652;s:5:"title";s:17:"Magazine- Archiv2";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/01/Archiv2_s.png";s:12:"tmpl_created";i:1579060730;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/magazine-archiv2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:461;s:16:"popularity_index";i:525;s:11:"trend_index";i:585;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:656;a:20:{s:4:"tmpl";i:990;s:2:"id";i:13361;s:5:"title";s:25:"Online Course &#8211; 404";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2020/04/404.jpg";s:12:"tmpl_created";i:1587474710;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/blocks/online-course-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:35:"["404","Course Online","Education"]";s:10:"menu_order";i:462;s:16:"popularity_index";i:682;s:11:"trend_index";i:498;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:657;a:20:{s:4:"tmpl";i:987;s:2:"id";i:13387;s:5:"title";s:32:"Online Course &#8211; End Lesson";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-End-.jpg";s:12:"tmpl_created";i:1587474682;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/blocks/online-course-end-lesson/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:464;s:16:"popularity_index";i:653;s:11:"trend_index";i:408;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:658;a:20:{s:4:"tmpl";i:989;s:2:"id";i:13369;s:5:"title";s:28:"Online Course &#8211; Footer";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/04/Footer.jpg";s:12:"tmpl_created";i:1587474701;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/blocks/online-course-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:38:"["Course Online","Education","Footer"]";s:10:"menu_order";i:466;s:16:"popularity_index";i:389;s:11:"trend_index";i:308;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:659;a:20:{s:4:"tmpl";i:988;s:2:"id";i:13378;s:5:"title";s:28:"Online Course &#8211; Header";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2020/06/Header-education-online-courses.jpg";s:12:"tmpl_created";i:1587474693;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/blocks/online-course-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:38:"["Course Online","Education","Header"]";s:10:"menu_order";i:469;s:16:"popularity_index";i:492;s:11:"trend_index";i:519;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:660;a:20:{s:4:"tmpl";i:986;s:2:"id";i:13395;s:5:"title";s:34:"Online Course &#8211; Start Lesson";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-Start.jpg";s:12:"tmpl_created";i:1587474673;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/blocks/online-course-start-lesson/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:471;s:16:"popularity_index";i:672;s:11:"trend_index";i:578;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:661;a:20:{s:4:"tmpl";i:953;s:2:"id";i:13089;s:5:"title";s:23:"Photography &#8211; 404";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/02/404_s.png";s:12:"tmpl_created";i:1582091623;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/blocks/photography-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:33:"["404","Photography","Portfolio"]";s:10:"menu_order";i:473;s:16:"popularity_index";i:702;s:11:"trend_index";i:706;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:662;a:20:{s:4:"tmpl";i:954;s:2:"id";i:13096;s:5:"title";s:32:"Photography &#8211; Archiv Media";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/02/Archiv_s.png";s:12:"tmpl_created";i:1582091742;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/blocks/photography-archiv-media/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:475;s:16:"popularity_index";i:631;s:11:"trend_index";i:405;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:663;a:20:{s:4:"tmpl";i:955;s:2:"id";i:13103;s:5:"title";s:26:"Photography &#8211; Footer";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/02/Footer_s.png";s:12:"tmpl_created";i:1582091903;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/blocks/photography-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:36:"["Footer","Photography","Portfolio"]";s:10:"menu_order";i:477;s:16:"popularity_index";i:422;s:11:"trend_index";i:230;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:664;a:20:{s:4:"tmpl";i:957;s:2:"id";i:13112;s:5:"title";s:26:"Photography &#8211; Header";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2020/06/Header-photography-portfolio.png";s:12:"tmpl_created";i:1582092483;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/blocks/photography-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:36:"["Header","Photography","Portfolio"]";s:10:"menu_order";i:478;s:16:"popularity_index";i:325;s:11:"trend_index";i:205;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:665;a:20:{s:4:"tmpl";i:956;s:2:"id";i:13120;s:5:"title";s:31:"Photography &#8211; Single Post";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/02/Post_s.png";s:12:"tmpl_created";i:1582092351;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/blocks/photography-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:480;s:16:"popularity_index";i:671;s:11:"trend_index";i:645;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:666;a:20:{s:4:"tmpl";i:901;s:2:"id";i:11807;s:5:"title";s:9:"Portfolio";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2019/09/404_small.png";s:12:"tmpl_created";i:1569430070;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/portfolio-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:40:"["404","Creative Portfolio","Portfolio"]";s:10:"menu_order";i:483;s:16:"popularity_index";i:480;s:11:"trend_index";i:497;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:667;a:20:{s:4:"tmpl";i:900;s:2:"id";i:11832;s:5:"title";s:9:"Portfolio";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2019/09/Footer_small.png";s:12:"tmpl_created";i:1569430019;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/portfolio-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:43:"["Creative Portfolio","Footer","Portfolio"]";s:10:"menu_order";i:484;s:16:"popularity_index";i:246;s:11:"trend_index";i:102;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:668;a:20:{s:4:"tmpl";i:898;s:2:"id";i:11847;s:5:"title";s:9:"Portfolio";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2019/09/Archiv_small.png";s:12:"tmpl_created";i:1569430010;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/portfolio-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:487;s:16:"popularity_index";i:336;s:11:"trend_index";i:455;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:669;a:20:{s:4:"tmpl";i:897;s:2:"id";i:11854;s:5:"title";s:9:"Portfolio";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2019/09/Post_small.png";s:12:"tmpl_created";i:1569429983;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:489;s:16:"popularity_index";i:482;s:11:"trend_index";i:609;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:670;a:20:{s:4:"tmpl";i:904;s:2:"id";i:11890;s:5:"title";s:9:"Portfolio";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2020/06/Header-design-portfolio.png";s:12:"tmpl_created";i:1571907344;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/portfolio-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:43:"["Creative Portfolio","Header","Portfolio"]";s:10:"menu_order";i:491;s:16:"popularity_index";i:306;s:11:"trend_index";i:364;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:671;a:20:{s:4:"tmpl";i:896;s:2:"id";i:11861;s:5:"title";s:27:"Portfolio &#8211; Project 1";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2019/09/Project1_small.png";s:12:"tmpl_created";i:1569429975;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/portfolio-project-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:493;s:16:"popularity_index";i:643;s:11:"trend_index";i:764;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:672;a:20:{s:4:"tmpl";i:895;s:2:"id";i:11870;s:5:"title";s:27:"Portfolio &#8211; Project 2";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png";s:12:"tmpl_created";i:1569429964;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/portfolio-project-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:495;s:16:"popularity_index";i:662;s:11:"trend_index";i:816;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:673;a:20:{s:4:"tmpl";i:903;s:2:"id";i:11897;s:5:"title";s:27:"Portfolio &#8211; Project 2";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png";s:12:"tmpl_created";i:1569494236;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/blocks/portfolio-project-2-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:496;s:16:"popularity_index";i:733;s:11:"trend_index";i:744;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:674;a:20:{s:4:"tmpl";i:894;s:2:"id";i:11877;s:5:"title";s:27:"Portfolio &#8211; Project 3";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2019/09/Project3_small.png";s:12:"tmpl_created";i:1569429954;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/portfolio-project-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:498;s:16:"popularity_index";i:692;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:675;a:20:{s:4:"tmpl";i:597;s:2:"id";i:5019;s:5:"title";s:11:"Portfolio 1";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_1.png";s:12:"tmpl_created";i:1520520580;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/portfolio-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:500;s:16:"popularity_index";i:170;s:11:"trend_index";i:236;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:676;a:20:{s:4:"tmpl";i:609;s:2:"id";i:5141;s:5:"title";s:12:"Portfolio 10";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_10.png";s:12:"tmpl_created";i:1520520601;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/portfolio-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:503;s:16:"popularity_index";i:416;s:11:"trend_index";i:478;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:677;a:20:{s:4:"tmpl";i:598;s:2:"id";i:5027;s:5:"title";s:12:"Portfolio 11";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_2.png";s:12:"tmpl_created";i:1520520581;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/portfolio-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:504;s:16:"popularity_index";i:304;s:11:"trend_index";i:421;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:678;a:20:{s:4:"tmpl";i:599;s:2:"id";i:5037;s:5:"title";s:12:"Portfolio 12";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_3.png";s:12:"tmpl_created";i:1520520583;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/portfolio-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:507;s:16:"popularity_index";i:279;s:11:"trend_index";i:399;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:8:"products";s:7:"regular";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:679;a:20:{s:4:"tmpl";i:600;s:2:"id";i:5057;s:5:"title";s:12:"Portfolio 13";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfol