<?php

/**
 * Plugin Name: QSM - Google Sheet Connector
 * Plugin URI: http://quizandsurveymaster.com
 * Description: Save quiz response to google sheet
 * Author: QSM Team
 * Author URI: http://quizandsurveymaster.com
 * Version: 2.1.8
 * Text Domain: qsm-google-sheets
 */
if (!defined('ABSPATH'))
    exit;

	$qsm_check = get_option( 'qsm_addon_gs_connector_settings');
	$qsm_check['license_status'] = 'valid';
	$qsm_check['license_key'] = '123456-123456-123456-12345';
	$qsm_check['last_validate'] = date("d-m-Y", time());
	$qsm_check['expiry_date'] = '01-01-2035';
	update_option('qsm_addon_gs_connector_settings', $qsm_check);

/**
 * The main class for the addon
 */
class QSM_GoogleSheetConnector {

    /**
     * Version Number
     *
     * @var string
     * @since 0.1.0
     */
    public $version = '2.1.8';

    /**
     * The main constructer function.
     *
     * @since 1.0.0
     * @uses QSM_GoogleSheetConnector:load_dependencies
     * @uses QSM_GoogleSheetConnector:add_hooks
     * @return void
     */
    function __construct() {
        define( 'QSM_GOOGLE_SHEET_URL', plugin_dir_url( __FILE__ ) );
        define( 'GOOGLE_SHEET_ITEM', 83375 );
        $this->load_dependencies();
        $this->add_hooks();
        $this->check_license();
    }

    /**
     * Loads the dependencies of the add_action
     *
     * @since 1.0.0
     * @return void
     */
    private function load_dependencies() {
        include( "php/license.php" );
        include( "php/addon-settings-tab-content.php" );
        include( "php/quiz-settings-tab-content.php" );
        include( "php/integration.php" );
    }

    /**
     * Registers the tabs and the filter_list
     *
     * @since 1.0.0
     * @return void
     */
    private function add_hooks() {
        add_action('admin_init', 'qsm_addon_qs_connector_register_quiz_settings_tabs');
        add_action('admin_init', 'qsm_addon_gs_connector_register_addon_settings_tabs');
        add_filter('qmn_after_results_text', 'qsm_addon_google_sheet_connect', 10, 3);
        add_action( 'wp_ajax_qsm_google_sheet_validate_license', 'qsm_google_sheet_validate_license' );

		if (empty(get_option('gshp-notice-dismissed'))) {
			add_action('admin_notices', array(@$this, 'global_admin_notice'));
			add_action('admin_footer', array(@$this, 'global_admin_notice_js'));
		}
		add_action('wp_ajax_gshp_dismiss_notice', array(@$this, 'gshp_dismiss_notice'));
    }

	function gshp_dismiss_notice() {
		update_option('gshp-notice-dismissed', 1);
		exit;
	}

	function global_admin_notice_js() {
		echo "<script type='text/javascript'>jQuery(document).on('click', '.gshp-notice .notice-dismiss', function () {jQuery.ajax({url: ajaxurl,data: {action: 'gshp_dismiss_notice'}});});</script>";
	}

	public function global_admin_notice() {
		$settings_link = admin_url('admin.php?page=qmn_addons&tab=google-sheet-connector');
		$doc_link = 'https://quizandsurveymaster.com/docs/add-ons/google-sheets-connector/';
		$notice = "v2.0.1 - Google Sheets Addon for QSM has been updated. Due to new rules by Google, you will have to re-authorize your Google account, <a href='{$settings_link}' target='_blank'>click here</a> to configure. Read more about configuring this addon in our <a href='{$doc_link}' target='_blank'>documentation</a>.";
		echo "<div class='notice error gshp-notice is-dismissible'><p>{$notice}</p></div>";
	}

	/**
	 * Checks license
	 *
	 * Checks to see if license is active and, if so, checks for updates
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function check_license() {
		if ( ! class_exists( 'EDD_SL_Plugin_Updater' ) ) {
			// load our custom updater
			include( 'php/EDD_SL_Plugin_Updater.php' );
		}

		// retrieve our license key from the DB
		$gsc_data	 = get_option( 'qsm_addon_gs_connector_settings', '' );
		$license_key = isset( $gsc_data['license_key'] ) ? trim( $gsc_data['license_key'] ) : '';

		// setup the updater
		$edd_updater = new EDD_SL_Plugin_Updater( 'https://quizandsurveymaster.com', __FILE__, array(
			'version'	 => $this->version, // current version number
			'license'	 => $license_key, // license key (used get_option above to retrieve from DB)
			'item_name'	 => 'Google Sheet Connector', // name of this plugin
			'author'	 => 'QSM Team'  // author of this plugin
			)
		);
	}

}

/**
 * Loads the addon if QSM is installed and activated
 *
 * @since 1.1.1
 * @return void
 */
function qsm_addon_google_sheet_connector_load() {
    // Make sure QSM is active
    if (class_exists('MLWQuizMasterNext')) {
        $qsm_gsconnect = new QSM_GoogleSheetConnector();
         load_plugin_textdomain( 'qsm-google-sheets', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
    } else {
        add_action('admin_notices', 'qsm_addon_gs_connect_missing_qsm');
    }
}

add_action('plugins_loaded', 'qsm_addon_google_sheet_connector_load');

/**
 * Display notice if Quiz And Survey Master isn't installed
 *
 * @since 1.0.0
 * @return string The notice to display
 */
function qsm_addon_gs_connect_missing_qsm() {
    echo '<div class="error"><p>QSM - Google sheet connector requires Quiz And Survey Master. Please install and activate the Quiz And Survey Master plugin.</p></div>';
}

function qsm_google_sheet_validate_license() {
	global $mlwQuizMasterNext;
	$post_license = sanitize_text_field( wp_unslash( $_POST['input'] ) );
	if ( "" != $post_license ) {

		$settings	 = get_option( 'qsm_addon_gs_connector_settings', array() );
		$license	 = isset( $settings['license_key'] ) ? trim( $settings['license_key'] ) : '';

		if( class_exists ( 'QSM_Check_License' )) {
			$activation = $mlwQuizMasterNext->check_license->activate( $post_license, 'Google Sheet Connector' );
		}else{
			$activation = QSM_license::activate( $post_license, 'Google Sheet Connector' );
		}

		if( !empty($activation) && ( ( __( 'Attempting to activate a bundle\'s parent license', 'qsm-google-sheets' ) == $activation['message'] || __( 'License key revoked', 'qsm-google-sheets' ) == $activation['message'] || __( 'No activations left', 'qsm-google-sheets' ) == $activation['message'] || __( 'License has expired', 'qsm-google-sheets' ) == $activation['message'] ) || 'success' == $activation['status'] ) ) {
			$item_url = 'https://quizandsurveymaster.com/checkout/?edd_license_key='.$license.'&download_id='.GOOGLE_SHEET_ITEM;
			$settings['license_key'] = $post_license;
			$settings['license_status'] = 'valid';
			$settings['last_validate'] = date("d-m-Y", time());
			$settings['expiry_date'] = isset($activation['expiry_date']) ? $activation['expiry_date'] : "";
			if('success' == $activation['status']) {
				$validate = 1;
				$message = __( 'License validated Successfully', 'qsm-google-sheets' );
			}elseif(__( 'License has expired', 'qsm-google-sheets' ) == $activation['message'] ){
				$validate = 2;
				$message = __('License Key Expired. ', 'qsm-google-sheets');
			}else{
				$validate = 0;
				$message = $activation['message'];
			}
		} else {
			$validate = 0;
			$settings['license_key'] = '';
			$settings['license_status'] = '';
			$settings['last_validate'] = 'invalid';
			$settings['expiry_date'] = '';
			$message = $activation['message'];
		}
		if($license != $post_license) {
			$deactivation = QSM_license::deactivate( $license, 'Google Sheet Connector' );
		}
		update_option( 'qsm_addon_gs_connector_settings', $settings );
		echo wp_json_encode(array('validate' => $validate, 'message' => $message));
		wp_die();
	}
}

?>